/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiReaderFactory;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStageInventoryReader;
import oracle.sysman.oii.oiii.OiiiStageXMLWriter;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarModifier;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceVariants;

public class OiiiStageInvModifier {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    private OiiiStageInventory m_stgInv;
    private OiivVerIndObjectRep m_verIndStgInv = null;
    private OiixJarModifier m_jModifier;
    private String m_stgJarLoc;
    private Hashtable m_oCachedJars;
    private OiixJarClassLoader m_jcLoader;
    private OiiiTargetAreaControl m_oAreaControl;

    public OiiiStageInvModifier(String jarLoc) throws IOException {
        this(jarLoc, null);
    }

    public OiiiStageInvModifier(String jarLoc, OiiiTargetAreaControl oAreaControl) throws IOException {
        this.m_oAreaControl = oAreaControl;
        try {
            this.m_stgJarLoc = OiixPathOps.getCanonicalPath(jarLoc);
        }
        catch (IOException ioe) {
            this.m_stgJarLoc = OiixPathOps.getStandardForm(jarLoc);
        }
        try {
            if (new File(jarLoc).exists()) {
                OiiiStageInventoryReader reader = OiiiReaderFactory.getStageInvReader(jarLoc);
                this.m_stgInv = reader.readInventory(jarLoc, null, this.m_oAreaControl);
            } else {
                this.m_stgInv = new OiiiStageInventory();
            }
        }
        catch (Exception e) {
            File f = new File(this.m_stgJarLoc);
            if (f.exists()) {
                throw new IOException(e.getMessage());
            }
            this.m_stgInv = new OiiiStageInventory();
        }
        if (!OiiiStageInventory.isXMLStage(jarLoc)) {
            this.m_jModifier = new OiixJarModifier(jarLoc);
        }
    }

    public OiiiStageInvModifier(OiiiStageInventory stageInv, String sJarLoc) {
        this.m_stgInv = stageInv;
        this.m_stgJarLoc = sJarLoc;
        if (!OiiiStageInventory.isXMLStage(sJarLoc)) {
            this.m_jModifier = new OiixJarModifier(this.m_stgJarLoc);
        }
    }

    public OiiiStageInventory getStageInventory() {
        return this.m_stgInv;
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie) {
        return this.getResourceBundle(ie, null);
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie, Locale loc) {
        ResourceBundle rb = null;
        if (ie instanceof OiiiStageCompInvEntry) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)ie;
            rb = scie.isMinInstVersionPreX("2.0") ? this.getCompIDResourceBundle(scie, this.m_jcLoader, loc) : this.getCompResourceBundle(scie, loc);
        }
        return rb;
    }

    private ResourceBundle getCompIDResourceBundle(OiiiStageCompInvEntry scie, OiixJarClassLoader jcLoader, Locale loc) {
        PropertyResourceBundle rb = null;
        String jarLoc = scie.getJarContentsLoc();
        String resourceBase = jarLoc + "resources/CompID";
        boolean foundResource = false;
        Enumeration vars = OiixResourceVariants.genResourceVariants(loc);
        while (vars.hasMoreElements()) {
            String resLoc = resourceBase + (String)vars.nextElement() + ".properties";
            InputStream is = jcLoader.getLocalResourceAsStream(resLoc);
            if (is != null) {
                try {
                    foundResource = true;
                    rb = new PropertyResourceBundle(is);
                    is.close();
                }
                catch (IOException e) {
                    System.out.println("Unable to load resource for " + is);
                    e.printStackTrace();
                }
            }
            if (!foundResource) continue;
            break;
        }
        return rb;
    }

    public ResourceBundle getCompResourceBundle(OiiiStageCompInvEntry scie, Locale loc) {
        ResourceBundle rb = null;
        String sSourceRoot = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(this.m_stgJarLoc));
        OiisCompProperties oCompProps = scie.getCompProperties();
        OiisCompJarInfo oCompJarInfo = oCompProps.getCompJarInfo();
        String resourceClassName = oCompJarInfo.getResourcesClass();
        String resourceBundleClassName = oCompJarInfo.getResourceBundleClass();
        try {
            String compLoc = scie.getInstallDefnLoc();
            compLoc = OiixPathOps.concatPath(sSourceRoot, compLoc);
            String sJarName = scie.getJarName();
            compLoc = OiixPathOps.concatPath(compLoc, sJarName);
            try {
                compLoc = OiixPathOps.getCanonicalPath(compLoc);
            }
            catch (IOException ioe) {
                compLoc = OiixPathOps.getStandardForm(compLoc);
            }
            OiixJarClassLoader oJarClassLoader = null;
            if (this.m_oCachedJars == null) {
                this.m_oCachedJars = new Hashtable();
            }
            oJarClassLoader = OiixJarClassLoader.createLoader(compLoc, true, true);
            this.m_oCachedJars.put(compLoc, oJarClassLoader);
            rb = OiixJarResourceBundle.extractLanguageBundle(oJarClassLoader, resourceBundleClassName, loc, resourceClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        return rb;
    }

    public void saveStageInventory() throws IOException, OiifbCancelException, OiixJarModifyException {
        boolean bJarLdrExists;
        if (OiiiStageInventory.isXMLStage(this.m_stgJarLoc)) {
            if (this.m_stgInv == null) {
                this.m_stgInv = new OiiiStageInventory();
            }
            Vector vComps = this.m_stgInv.getAllCompsVect(0);
            for (int i = 0; i < vComps.size(); ++i) {
                OiiiCompInvEntry invEntry = (OiiiCompInvEntry)vComps.elementAt(i);
                if (invEntry.getAreaControl() != null) continue;
                invEntry.setAreaControl(this.m_oAreaControl);
            }
            OiiiStageXMLWriter writer = new OiiiStageXMLWriter(this.m_stgInv, this.m_stgJarLoc);
            writer.writeAll();
            writer = null;
            return;
        }
        if (System.getProperty("osp.properties.file") != null) {
            throw new OiifbCancelException("Cannot save to binary inventory. Point to a new stage location or run the Convert utility.", false);
        }
        boolean bl = bJarLdrExists = this.m_jcLoader != null;
        if (bJarLdrExists) {
            this.m_jcLoader.closeJarFile();
            this.m_jcLoader = null;
        }
        this.m_verIndStgInv = this.m_verIndStgInv == null ? this.m_stgInv.getVerIndRep() : this.m_stgInv.mergeVerIndRep(this.m_verIndStgInv);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.m_verIndStgInv);
        oos.flush();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        this.m_jModifier.setState(1);
        if (this.m_jModifier.contains("stageInventory.ser")) {
            try {
                this.m_jModifier.removeEntry("stageInventory.ser");
            }
            catch (OiixJarModifyException e) {
                System.err.println(e.getMessage());
            }
        }
        this.m_jModifier.insertEntryFromStream(bais, "stageInventory.ser");
        this.removeDeletedCompsInfo();
        this.insertCompsInitInfo();
        this.m_jModifier.setState(2);
        if (bJarLdrExists) {
            this.m_jcLoader = OiixJarClassLoader.createLoader(this.m_stgJarLoc, false, true);
        }
    }

    private void removeDeletedCompsInfo() throws OiixJarModifyException {
        Vector allCurEntries = this.m_jModifier.getCurrentEntries();
        int numEntries = allCurEntries.size();
        Vector<String> dirsToCheck = new Vector<String>(10, 5);
        for (int i = 0; i < numEntries; ++i) {
            String compDir;
            String thisEntry = (String)allCurEntries.elementAt(i);
            int resPos = thisEntry.lastIndexOf("resources");
            if (resPos == -1 || dirsToCheck.contains(compDir = OiixPathOps.getStandardForm(thisEntry.substring(0, resPos)))) continue;
            dirsToCheck.addElement(compDir);
        }
        Vector allComps = this.m_stgInv.getAllCompsVect(0);
        int numComps = allComps.size();
        for (int i = 0; i < numComps; ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)allComps.elementAt(i);
            String compLoc = cie.getLocation();
            if (!dirsToCheck.contains(compLoc)) continue;
            dirsToCheck.removeElement(compLoc);
        }
        int numRem = dirsToCheck.size();
        for (int i = 0; i < numRem; ++i) {
            String resDirToRemove = (String)dirsToCheck.elementAt(i);
            this.m_jModifier.removeEntries(resDirToRemove);
        }
    }

    private void insertCompsInitInfo() throws IOException, OiixJarModifyException, OiifbCancelException {
        Enumeration enum_1 = this.m_stgInv.getAllComps(0);
        while (enum_1.hasMoreElements()) {
            String jarLoc;
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)enum_1.nextElement();
            if (!scie.isNewEntry()) continue;
            String inJarLoc = scie.getJarContentsLoc();
            String inEntryName = "resources/CompID";
            String dirName = "resources/";
            if (!scie.isMinInstVersionPreX("2.0")) {
                jarLoc = this.getAbsPath(OiixPathOps.concatPath(scie.getInstallDefnLoc(), scie.getJarName()));
                String sPackageDir = OiiiTargetAreaControl.genPackageNameDir(scie.getCompInstallID());
                inEntryName = OiixPathOps.concatPath(sPackageDir, inEntryName);
                dirName = OiixPathOps.concatPath(sPackageDir, dirName);
            } else {
                jarLoc = this.getAbsPath(OiixPathOps.concatPath(scie.getLocation(), "compIns.jar"));
            }
            this.insertCompInitInfo(jarLoc, inEntryName, dirName, inJarLoc);
        }
    }

    private void insertCompInitInfo(String compJarLoc, String inEntryName, String dirName, String inJarLoc) throws IOException, OiixJarModifyException, OiifbCancelException {
        this.m_jModifier.insertEntriesFromJar(compJarLoc, inEntryName, dirName, inJarLoc + "resources/");
    }

    private String getAbsPath(String entryPath) {
        return OiixPathOps.concatPath(OiixPathOps.getParentDir(this.m_stgJarLoc), OiixPathOps.getStandardForm(entryPath));
    }

    public void dispose() {
        this.m_stgInv = null;
        this.m_verIndStgInv = null;
        this.m_jModifier = null;
        this.m_stgJarLoc = null;
        if (this.m_jcLoader != null) {
            this.m_jcLoader.closeJarFile();
            this.m_jcLoader = null;
        }
        if (this.m_oCachedJars != null) {
            Enumeration enum_1 = this.m_oCachedJars.keys();
            while (enum_1.hasMoreElements()) {
                String sJarLoc = (String)enum_1.nextElement();
                OiixJarClassLoader.forgetLoader(sJarLoc);
            }
            this.m_oCachedJars.clear();
            this.m_oCachedJars = null;
        }
    }
}

