/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiShipHomeInfo;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiiiStageInventory
extends OiiiAreaInventory
implements Serializable {
    static final long serialVersionUID = -2721090424034334653L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    static final String LOC_IN_JAR = "stageInventory.ser";
    public static final String JAR_NAME = "products.xml";
    private boolean m_bLibCopied = false;
    private String s_SHPropXMLLoc;
    private transient int m_nDiskCount = 0;
    private boolean m_bCompsOrdered;
    private OiiiShipHomeInfo m_oShipHomePropObj = null;

    public OiiiStageInventory() {
    }

    public OiiiStageInventory(OiivVerIndObjectRep viObj) {
        super(viObj);
        Boolean oCompsOrdered = (Boolean)viObj.getObjectForName("compsOrdered");
        if (oCompsOrdered != null) {
            this.m_bCompsOrdered = oCompsOrdered;
        }
    }

    public void addStageCompInvEntry(OiiiStageCompInvEntry scie) {
        scie.setAsNewEntry();
        super.addCompInvEntry(scie, 0);
    }

    public void removeStageCompInvEntry(OiiiStageCompInvEntry scie) {
        Vector compsInfo = this.getAllCompsVect(0);
        compsInfo.removeElement(scie);
    }

    public OiiiStageCompInvEntry getStageCompInvEntry(OiiiCompInstallID cid) {
        return this.getStageCompInvEntry(cid, true);
    }

    public OiiiStageCompInvEntry getStageCompInvEntry(OiiiCompInstallID cid, boolean bIgnoreBuild) {
        return this.getStageCompInvEntry(cid, OiiiStageInventory.getCurPlatVect(), bIgnoreBuild);
    }

    public OiiiStageCompInvEntry getStageCompInvEntry(OiiiCompInstallID cid, Vector plats) {
        return this.getStageCompInvEntry(cid, plats, true);
    }

    public OiiiStageCompInvEntry getStageCompInvEntry(OiiiCompInstallID cid, Vector plats, boolean bIgnoreBuild) {
        return (OiiiStageCompInvEntry)this.getCompInvEntry(cid, 0, plats, bIgnoreBuild);
    }

    public OiiiStageCompInvEntry getMatchCompInvEntry(OiiiStageCompInvEntry scie) {
        Vector cIEs = this.getCompInvEntries(scie.getCompInstallID());
        int numCIEs = cIEs.size();
        OiiiStageCompInvEntry matchIE = null;
        for (int i = 0; i < numCIEs; ++i) {
            OiiiStageCompInvEntry iterIE = (OiiiStageCompInvEntry)cIEs.elementAt(i);
            if (!iterIE.equalTags(scie) || !iterIE.equalsIgnoringPlatsnTags(scie)) continue;
            matchIE = iterIE;
            break;
        }
        return matchIE;
    }

    public Vector getCompInvEntries(OiiiCompInstallID cid) {
        return this.getCompInvEntries(cid, true);
    }

    public Vector getCompInvEntries(OiiiCompInstallID cid, boolean idPlatsMatch) {
        Vector compsInfo = this.getAllCompsVect(0);
        return this.getInvElsMatchingID(compsInfo, cid, idPlatsMatch);
    }

    public Vector getConflCompEntries(OiiiStageCompInvEntry scie) {
        return this.getConflCompEntries(scie, false);
    }

    public Vector getConflCompEntries(OiiiStageCompInvEntry scie, boolean idPlatsMatch) {
        OiiiCompInstallID cid = scie.getCompInstallID();
        Vector compsInfo = this.getAllCompsVect(0);
        Vector matchComps = this.getInvElsMatchingID(compsInfo, cid, idPlatsMatch);
        Vector<OiiiStageCompInvEntry> conflComps = new Vector<OiiiStageCompInvEntry>();
        int numMatches = matchComps.size();
        for (int i = 0; i < numMatches; ++i) {
            OiiiStageCompInvEntry mcie = (OiiiStageCompInvEntry)matchComps.elementAt(i);
            if (!scie.conflicts(mcie, idPlatsMatch)) continue;
            conflComps.addElement(mcie);
        }
        return conflComps;
    }

    public Vector getReplTagCompEntries(OiiiStageCompInvEntry scie) {
        return this.getReplTagCompEntries(scie, false);
    }

    public Vector getReplTagCompEntries(OiiiStageCompInvEntry scie, boolean idPlatsMatch) {
        OiiiCompInstallID cid = scie.getCompInstallID();
        Vector compsInfo = this.getAllCompsVect(0);
        Vector matchComps = this.getInvElsMatchingID(compsInfo, cid, idPlatsMatch);
        Vector<OiiiStageCompInvEntry> replComps = new Vector<OiiiStageCompInvEntry>();
        int numMatches = matchComps.size();
        for (int i = 0; i < numMatches; ++i) {
            OiiiStageCompInvEntry mcie = (OiiiStageCompInvEntry)matchComps.elementAt(i);
            if (!scie.replaces(mcie, idPlatsMatch)) continue;
            replComps.addElement(mcie);
        }
        return replComps;
    }

    public int getDiskCount() {
        if (this.m_nDiskCount == 0) {
            this.m_nDiskCount = 1;
            Vector vComps = this.getAllCompsVect(0);
            for (int i = 0; i < vComps.size(); ++i) {
                OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vComps.elementAt(i);
                int nDisk = invEntry.getDiskNumber();
                if (nDisk <= this.m_nDiskCount) continue;
                this.m_nDiskCount = nDisk;
            }
        }
        return this.m_nDiskCount;
    }

    public boolean isMultiCDStage() {
        return this.getDiskCount() > 1;
    }

    public void setCompsOrdered(boolean bCompsOrdered) {
        this.m_bCompsOrdered = bCompsOrdered;
    }

    public boolean getCompsOrdered() {
        return this.m_bCompsOrdered;
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep verIndRep = super.getVerIndRep();
        verIndRep.addNVPair("compsOrdered", new Boolean(this.m_bCompsOrdered));
        return verIndRep;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep verIndRep = super.mergeVerIndRep(vIndObj);
        verIndRep.setNVPair("compsOrdered", new Boolean(this.m_bCompsOrdered));
        return verIndRep;
    }

    private Vector getInvElsMatchingID(Vector vect, OiiiCompInstallID cid, boolean sameIDPlats) {
        Vector<OiiiStageCompInvEntry> retVect = new Vector<OiiiStageCompInvEntry>();
        int vectSize = vect.size();
        for (int i = 0; i < vectSize; ++i) {
            boolean match;
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)vect.elementAt(i);
            OiiiCompInstallID ieid = scie.getCompInstallID();
            boolean bl = match = sameIDPlats ? ieid.equals(cid) : ieid.equalsWithPlatInt(cid);
            if (!match) continue;
            retVect.addElement(scie);
        }
        return retVect;
    }

    public void optimizeLocales() {
        Vector compsInfo = this.getAllCompsVect(0);
        int vectSize = compsInfo.size();
        for (int i = 0; i < vectSize; ++i) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)compsInfo.elementAt(i);
            scie.optimizeLangList();
        }
    }

    public void optimize() {
        Vector compsInfo = this.getAllCompsVect(0);
        int vectSize = compsInfo.size();
        for (int i = 0; i < vectSize; ++i) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)compsInfo.elementAt(i);
            scie.optimize();
        }
    }

    public void releaseDeps() {
        Vector compsInfo = this.getAllCompsVect(0);
        int vectSize = compsInfo.size();
        for (int i = 0; i < vectSize; ++i) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)compsInfo.elementAt(i);
            scie.releaseDeps();
        }
    }

    public Vector getAllPatches(int plat) {
        Vector<OiiiStageCompInvEntry> vPatches = new Vector<OiiiStageCompInvEntry>();
        Vector compsInfo = null;
        compsInfo = plat == 0 ? this.getAllCompsVect(0) : this.getAllCompsVect(0, plat);
        int vectSize = compsInfo.size();
        for (int i = 0; i < vectSize; ++i) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)compsInfo.elementAt(i);
            OiiiCompInstallID id = scie.getCompInstallID();
            if (id.getCompType() != 2) continue;
            vPatches.addElement(scie);
        }
        return vPatches;
    }

    public static boolean isXMLStage(String invLoc) {
        if (invLoc.endsWith(".xml")) {
            return true;
        }
        if (invLoc.endsWith("products.jar")) {
            return false;
        }
        String sParentDir = OiixPathOps.getParentDir(invLoc);
        String PATH_SEP = System.getProperty("path.separator");
        String sInvDetails = OiixPathOps.concatPath(sParentDir, "invDetails.properties");
        File fInvDetails = new File(sInvDetails);
        return fInvDetails.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readInvDetailsProps(String invDetailsLoc) {
        File fInvDetails = new File(OiixPathOps.concatPath(invDetailsLoc, "invDetails.properties"));
        Properties retProp = new Properties();
        if (fInvDetails.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fInvDetails);
                retProp.load(fis);
            }
            catch (IOException e) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return retProp;
    }

    public void setLibrariesCopied(boolean bLibCopied) {
        this.m_bLibCopied = bLibCopied;
    }

    public boolean isLibrariesCopied() {
        return this.m_bLibCopied;
    }

    public void setSHPropLoc(String sSHPropXMLLoc) {
        this.s_SHPropXMLLoc = sSHPropXMLLoc;
    }

    public String getSHPropLoc() {
        return this.s_SHPropXMLLoc;
    }

    public void setSHPropObj(OiiiShipHomeInfo oShipHomeInfo) {
        this.m_oShipHomePropObj = oShipHomeInfo;
    }

    public OiiiShipHomeInfo getSHPropObj() {
        return this.m_oShipHomePropObj;
    }
}

