/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompBaseElementHandler;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryXMLHandler41;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInvLoader;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDepRuleComp;
import oracle.sysman.oii.oiis.OiisDepRuleProperty;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisInvalidValueException;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisLibDeps;
import oracle.sysman.oii.oiis.OiisPatchDepObj;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiis.OiisSingleSize;
import oracle.sysman.oii.oiis.OiisSize;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiStageXMLHandler
extends OiiiInventoryXMLHandler41 {
    private OixsElementHandler m_handlerPrdList;
    private OixsElementHandler m_handlerTLList;
    private OixsElementHandler m_handlerCompList;
    private OixsElementHandler m_handlerOneoffList;
    private boolean m_bInTopLevelList = false;
    private int m_iLibType;
    private boolean m_bInLibList = false;
    private String m_sXMLVer;
    private OiiiTargetAreaControl m_areaControl;
    private boolean m_bHomeStageMode;

    OiiiStageXMLHandler(String stageLoc, OiiiTargetAreaControl areaCtrl) throws SAXException {
        this.m_inventory = new OiiiStageInventory();
        this.m_invLoc = stageLoc;
        this.m_bStageSession = true;
        this.m_areaControl = areaCtrl;
        if (areaCtrl instanceof OiiiStageInvLoader) {
            this.m_bHomeStageMode = ((OiiiStageInvLoader)areaCtrl).isHomeStageMode();
        }
    }

    OiisCompProperties getCompProperties(OiiiCompInvEntry invEntry) {
        return ((OiiiStageCompInvEntry)invEntry).getCompProperties();
    }

    protected OixsElementHandler createElementHandlers() {
        this.m_handlerPrdList = new OixsElementHandler("PRD_LIST"){

            public void onStart(String name, AttributeList atts) {
                boolean bCompsOrdered = false;
                String sCompsOrdered = atts.getValue("ORDERED");
                if (sCompsOrdered != null && sCompsOrdered.equals("T")) {
                    bCompsOrdered = true;
                }
                ((OiiiStageInventory)OiiiStageXMLHandler.this.m_inventory).setCompsOrdered(bCompsOrdered);
            }
        };
        this.m_handlerTLList = new OixsElementHandler("TL_LIST"){

            public void onStart(String name, AttributeList atts) {
                OiiiStageXMLHandler.this.m_bInTopLevelList = true;
            }

            public void onEnd(String name) {
                OiiiStageXMLHandler.this.m_bInTopLevelList = false;
            }
        };
        this.m_handlerCompList = new OixsElementHandler("COMP_LIST");
        OiiiCompElementHandler handlerComp = new OiiiCompElementHandler("COMP");
        OiiiPatchSetElementHandler handlerPatchSet = new OiiiPatchSetElementHandler();
        OiiiPatchElementHandler handlerPatch = new OiiiPatchElementHandler();
        this.m_handlerOneoffList = new OixsElementHandler("ONEOFF_LIST");
        this.m_handlerTLList.addChildHandler("COMP", handlerComp);
        this.m_handlerTLList.addChildHandler("PATCHSET", handlerPatchSet);
        this.m_handlerCompList.addChildHandler("COMP", handlerComp);
        this.m_handlerCompList.addChildHandler("PATCH", handlerPatch);
        this.m_handlerPrdList.addChildHandler("TL_LIST", this.m_handlerTLList);
        this.m_handlerPrdList.addChildHandler("COMP_LIST", this.m_handlerCompList);
        this.m_handlerPrdList.addChildHandler("ONEOFF_LIST", this.m_handlerOneoffList);
        return this.m_handlerPrdList;
    }

    boolean isHomeStageMode() {
        return this.m_bHomeStageMode;
    }

    private Vector getSessionPlats(String sPlats) {
        Vector vPlats = null;
        if (sPlats == null || sPlats.trim().equals("")) {
            if (this.isHomeStageMode()) {
                vPlats = OiixPlatform.getCurrentPlatformVector();
            }
        } else {
            vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
        }
        return vPlats;
    }

    private class OiiiPatchUpgradeHandler
    extends OixsElementHandler {
        public OiiiPatchUpgradeHandler() {
            super("UPGRD_DEP_ID");
        }

        public void onStart(String name, AttributeList atts) {
            if (!(OiiiStageXMLHandler.this.m_curEntry instanceof OiiiStagePatchInvEntry)) {
                return;
            }
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sPlats = atts.getValue("PLAT");
            if (sName == null || sVer == null || sPlats == null) {
                return;
            }
            OiiiVersion oVer = new OiiiVersion(sVer);
            Vector vPlats = OiiiStageXMLHandler.this.getSessionPlats(sPlats);
            OiiiCompInstallID curId = new OiiiCompInstallID(sName, oVer, vPlats);
            curId = OiiiCompIDPool.getInstance().get(curId);
            OiiiStagePatchInvEntry patEntry = (OiiiStagePatchInvEntry)OiiiStageXMLHandler.this.m_curEntry;
            OiisPatchDeps patchDeps = patEntry.getPatchDeps();
            OiisPatchDepObj pdo = patchDeps.getDepObj(sName);
            pdo.setCurDepId(curId);
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiPatchDepHandler
    extends OixsElementHandler {
        public OiiiPatchDepHandler() {
            super("DEP_ID");
        }

        public void onStart(String name, AttributeList atts) {
            if (!(OiiiStageXMLHandler.this.m_curEntry instanceof OiiiStagePatchInvEntry)) {
                return;
            }
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sPlats = atts.getValue("PLAT");
            if (sName == null || sVer == null || sPlats == null && !OiiiStageXMLHandler.this.isHomeStageMode()) {
                return;
            }
            OiiiVersion oVer = new OiiiVersion(sVer);
            Vector vPlats = OiiiStageXMLHandler.this.getSessionPlats(sPlats);
            OiiiCompInstallID cid = new OiiiCompInstallID(sName, oVer, vPlats);
            cid = OiiiCompIDPool.getInstance().get(cid);
            OiisPatchDepObj pdo = new OiisPatchDepObj(cid);
            OiiiStagePatchInvEntry patEntry = (OiiiStagePatchInvEntry)OiiiStageXMLHandler.this.m_curEntry;
            OiisPatchDeps patchDeps = patEntry.getPatchDeps();
            patchDeps.addDepObj(pdo);
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiLibDepHandler
    extends OixsElementHandler {
        public OiiiLibDepHandler() {
            super("LIB_DEP");
        }

        public void onStart(String name, AttributeList atts) {
            if (OiiiStageXMLHandler.this.m_bInLibList) {
                String sName = atts.getValue("NAME");
                String sVer = atts.getValue("VER");
                String sPlats = atts.getValue("PLAT");
                String sReplVer = atts.getValue("REP_VER");
                String sMinInstVer = atts.getValue("MIN_INST_VER");
                String sDepMap = atts.getValue("DEP_MAP");
                OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
                OiisCompProperties compProps = stgEntry.getCompProperties();
                Vector<OiisLibDeps> vLibs = compProps.getLibDeps()[OiiiStageXMLHandler.this.m_iLibType];
                if (vLibs == null) {
                    vLibs = new Vector<OiisLibDeps>();
                    compProps.setLibraryDeps(vLibs, OiiiStageXMLHandler.this.m_iLibType);
                }
                if (sVer == null || sReplVer == null || sName == null) {
                    return;
                }
                OiiiVersion oVer = new OiiiVersion(sVer);
                OiiiVersion oReplVer = new OiiiVersion(sReplVer);
                Vector vPlats = OiiiStageXMLHandler.this.getSessionPlats(sPlats);
                OiiiLibraryID lid = new OiiiLibraryID(sName, oVer, vPlats, oReplVer);
                if (sMinInstVer != null) {
                    lid.setInstVer(sMinInstVer);
                }
                if (sDepMap != null) {
                    try {
                        int depMap = Integer.valueOf(sDepMap);
                        OiisLibDeps libDep = new OiisLibDeps(lid, depMap);
                        vLibs.addElement(libDep);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiLibListHandler
    extends OixsElementHandler {
        public OiiiLibListHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            OiiiStageXMLHandler.this.m_bInLibList = true;
            if (name.equals("ACTION_LIST")) {
                OiiiStageXMLHandler.this.m_iLibType = 0;
            } else if (name.equals("QUERY_LIST")) {
                OiiiStageXMLHandler.this.m_iLibType = 1;
            } else {
                OiiiStageXMLHandler.this.m_iLibType = 2;
            }
        }

        public void onEnd(String name) {
            OiiiStageXMLHandler.this.m_bInLibList = false;
        }
    }

    private class OiiiOffsetHandler
    extends OixsElementHandler {
        public OiiiOffsetHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            int iType = name.equals("DST") ? 1 : (name.equals("NONINST") ? 4 : 2);
            String sDest = atts.getValue("DST");
            String sType = atts.getValue("TYPE");
            String sOffset = atts.getValue("VAL");
            OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
            OiisFileSizeInfo fileSizeInfo = stgEntry.getFileSizeInfoEx();
            if (fileSizeInfo == null) {
                OiisPlatIndexMapping pim = stgEntry.getPlatIndexMapping();
                OiisLangIndexMapping lim = stgEntry.getLangIndexMapping();
                OiisDestinationIndexMapping dim = stgEntry.getDestIndexMapping();
                if (pim != null && lim != null && dim != null) {
                    fileSizeInfo = new OiisFileSizeInfo(pim, lim, dim);
                    stgEntry.setFileSizeInfoEx(fileSizeInfo);
                }
            }
            if (sType.equals("NO")) {
                int iOffset = Integer.valueOf(sOffset);
                try {
                    fileSizeInfo.setOffset(sDest, iType, iOffset);
                }
                catch (OiisInvalidValueException e) {}
            } else {
                int varType = sType.equals("CONST") ? 2 : 6;
                try {
                    fileSizeInfo.setOffset(sDest, iType, sOffset, varType);
                }
                catch (OiisInvalidValueException e) {
                    // empty catch block
                }
            }
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiLargestJarHandler
    extends OixsElementHandler {
        private OiiiLargestJarHandler() {
        }

        public void onStart(String name, AttributeList atts) {
            String sPlat = atts.getValue("PLAT");
            String sSize = atts.getValue("SIZE");
            if (sPlat != null && sSize != null) {
                try {
                    int iPlat = Integer.valueOf(sPlat);
                    long lSize = Long.valueOf(sSize);
                    OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
                    OiisFileSizeInfo fileSizeInfo = stgEntry.getFileSizeInfoEx();
                    if (fileSizeInfo == null) {
                        OiisPlatIndexMapping pim = stgEntry.getPlatIndexMapping();
                        OiisLangIndexMapping lim = stgEntry.getLangIndexMapping();
                        OiisDestinationIndexMapping dim = stgEntry.getDestIndexMapping();
                        if (pim != null && lim != null && dim != null) {
                            fileSizeInfo = new OiisFileSizeInfo(pim, lim, dim);
                            stgEntry.setFileSizeInfoEx(fileSizeInfo);
                        }
                    }
                    fileSizeInfo.setLargestFileGroupJar(iPlat, lSize);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    private class OiiiDestLangPlatHandler
    extends OixsElementHandler {
        public OiiiDestLangPlatHandler() {
            super("ID");
        }

        public void onStart(String name, AttributeList atts) {
            String sLang = atts.getValue("LANG");
            String sPlat = atts.getValue("PLAT");
            String sDest = atts.getValue("DST");
            String sSize = atts.getValue("SIZE");
            if (sLang != null && sPlat != null && sDest != null && sSize != null) {
                int iLangPos = 0;
                int iPlatPos = 0;
                int iDestPos = 0;
                long lSize = 0L;
                try {
                    iLangPos = Integer.valueOf(sLang);
                    iPlatPos = Integer.valueOf(sPlat);
                    iDestPos = Integer.valueOf(sDest);
                    lSize = Long.valueOf(sSize);
                }
                catch (NumberFormatException ne) {
                    // empty catch block
                }
                OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
                OiisFileSizeInfo fileSizeInfo = stgEntry.getFileSizeInfoEx();
                if (fileSizeInfo == null) {
                    OiisPlatIndexMapping pim = stgEntry.getPlatIndexMapping();
                    OiisLangIndexMapping lim = stgEntry.getLangIndexMapping();
                    OiisDestinationIndexMapping dim = stgEntry.getDestIndexMapping();
                    if (pim != null && lim != null && dim != null) {
                        fileSizeInfo = new OiisFileSizeInfo(pim, lim, dim);
                        stgEntry.setFileSizeInfoEx(fileSizeInfo);
                    }
                }
                fileSizeInfo.updateSize(iLangPos, iPlatPos, iDestPos, lSize);
            }
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiInstallTypeElementHandler
    extends OixsElementHandler {
        OiisDepMode m_depMode;
        OixsElementHandler handlerDepGrpProps;
        OixsElementHandler handlerDepGroupComps;
        String m_sInstallTypeName;
        String m_sInstallTypeNameId;
        String m_sDescID;
        Vector m_vDepGrpProps;
        Vector m_vDepGrpComps;

        public OiiiInstallTypeElementHandler() {
            super("INST_TYPE");
            this.m_vDepGrpProps = new Vector();
            this.m_vDepGrpComps = new Vector();
            this.handlerDepGrpProps = new OiiiDepGrpPropsHandler();
            this.addChildHandler("DEP_GRP_PRPS", this.handlerDepGrpProps);
        }

        public void onStart(String name, AttributeList atts) {
            this.m_sInstallTypeName = atts.getValue("NAME");
            this.m_sInstallTypeNameId = atts.getValue("NAME_ID");
            this.m_sDescID = atts.getValue("DESC_ID");
        }

        public void onEnd(String name) {
            Vector<OiisDepMode> vDepModes;
            OiisDepMode depMode = new OiisDepMode(this.m_sInstallTypeName, this.m_sInstallTypeNameId, this.m_vDepGrpProps);
            depMode.setDescription(this.m_sDescID);
            OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
            OiisDeps deps = stgEntry.getDeps();
            if (deps == null) {
                vDepModes = new Vector<OiisDepMode>();
                Vector vDepRules = new Vector();
                deps = new OiisDeps(vDepRules, vDepModes);
                stgEntry.setDeps(deps);
            } else {
                vDepModes = deps.getDepModes();
                if (vDepModes == null) {
                    vDepModes = new Vector();
                    deps.setDepModes(vDepModes);
                }
            }
            depMode.setResourceBundle(new OiixJarResourceBundle(OiiiStageXMLHandler.this.m_curEntry.getResourceBundle()));
            vDepModes.add(depMode);
            this.m_vDepGrpProps = new Vector();
        }

        private class OiiiDepGrpCompsHandler
        extends OixsElementHandler {
            OiiiDepGrpCompsHandler() {
                super("DEP_GRP_CMP");
            }

            public void onStart(String name, AttributeList atts) {
                String sName = atts.getValue("NAME");
                String sVer = atts.getValue("VER");
                String sPlats = atts.getValue("PLAT");
                String sInstType = atts.getValue("INST_TYPE");
                String sSel = atts.getValue("SEL");
                if (sName != null && sVer != null) {
                    OiiiVersion oVer = new OiiiVersion(sVer);
                    Vector vPlats = OiiiStageXMLHandler.this.getSessionPlats(sPlats);
                    OiiiCompInstallID cid = new OiiiCompInstallID(sName, oVer, vPlats);
                    cid = OiiiCompIDPool.getInstance().get(cid);
                    boolean bSel = false;
                    if (sSel != null && sSel.equalsIgnoreCase("T")) {
                        bSel = true;
                    }
                    OiisDepRuleComp ruleComp = new OiisDepRuleComp(cid, bSel, OiiiInstallTypeElementHandler.this.m_sInstallTypeName);
                    if (sInstType != null) {
                        ruleComp.setDepModeName(sInstType);
                    }
                    if (OiiiInstallTypeElementHandler.this.m_vDepGrpComps == null) {
                        OiiiInstallTypeElementHandler.this.m_vDepGrpComps = new Vector();
                    }
                    OiiiInstallTypeElementHandler.this.m_vDepGrpComps.add(ruleComp);
                }
            }

            public void onEnd(String name) {
            }
        }

        private class OiiiDepGrpPropsHandler
        extends OixsElementHandler {
            private String m_sRuleName;
            private boolean m_bOpen;
            private boolean m_bAsk;
            private OixsElementHandler m_handlerDepGrpComps;

            public OiiiDepGrpPropsHandler() {
                super("DEP_GRP_PRPS");
                this.m_handlerDepGrpComps = new OiiiDepGrpCompsHandler();
                this.addChildHandler("DEP_GRP_CMP", this.m_handlerDepGrpComps);
            }

            public void onStart(String name, AttributeList atts) {
                this.m_sRuleName = atts.getValue("NAME");
                String sOpen = atts.getValue("OPEN");
                String sAsk = atts.getValue("ASK");
                if (sOpen != null) {
                    this.m_bOpen = sOpen.equalsIgnoreCase("T");
                }
                if (sAsk != null) {
                    this.m_bAsk = sAsk.equalsIgnoreCase("T");
                }
            }

            public void onEnd(String name) {
                OiisDepRuleProperty prop = new OiisDepRuleProperty(this.m_sRuleName, this.m_bAsk, OiiiInstallTypeElementHandler.this.m_vDepGrpComps);
                if (OiiiInstallTypeElementHandler.this.m_vDepGrpProps == null) {
                    OiiiInstallTypeElementHandler.this.m_vDepGrpProps = new Vector();
                }
                OiiiInstallTypeElementHandler.this.m_vDepGrpProps.add(prop);
                OiiiInstallTypeElementHandler.this.m_vDepGrpComps = new Vector();
            }
        }
    }

    private class OiiiDepGrpElementHandler
    extends OixsElementHandler {
        OixsElementHandler m_handlerDepList;
        OixsElementHandler m_handlerDep;
        String m_sName;
        int m_type;
        Vector m_vDeps;

        public OiiiDepGrpElementHandler() {
            super("DEP_GRP");
            this.m_vDeps = new Vector();
            this.m_handlerDepList = new OixsElementHandler("DEP_LIST");
            this.m_handlerDep = new OixsElementHandler("DEP"){

                public void onStart(String name, AttributeList atts) {
                    String sName = atts.getValue("NAME");
                    String sVer = atts.getValue("VER");
                    String sPlat = atts.getValue("PLAT");
                    String sHomeIdx = atts.getValue("HOME_IDX");
                    String sExtDep = atts.getValue("EXTERNAL_DEPENDEE");
                    String sDepHomeLoc = atts.getValue("DEPENDENT_HOME");
                    if (sVer != null && sName != null && sPlat != null) {
                        OiiiVersion oVer = new OiiiVersion(sVer);
                        Vector vPlats = OiiiStageXMLHandler.this.getSessionPlats(sPlat);
                        OiiiCompInstallID cid = new OiiiCompInstallID(sName, oVer, vPlats);
                        if (sExtDep != null && sExtDep.equalsIgnoreCase("T")) {
                            cid.setExtDep(true);
                            if (sDepHomeLoc != null) {
                                cid.setDepHome(sDepHomeLoc);
                            }
                        }
                        cid = OiiiCompIDPool.getInstance().get(cid);
                        OiiiDepGrpElementHandler.this.m_vDeps.addElement(cid);
                    }
                }

                public void onEnd(String name) {
                }
            };
            this.m_handlerDepList.addChildHandler("DEP", this.m_handlerDep);
            this.addChildHandler("DEP_LIST", this.m_handlerDepList);
        }

        public void onStart(String name, AttributeList atts) {
            this.m_sName = atts.getValue("NAME");
            String sType = atts.getValue("TYPE");
            if (sType != null) {
                this.m_type = OiisDepRule.getTypeFromString(sType);
            }
        }

        public void onEnd(String name) {
            Vector<OiisDepRule> vDepRules;
            OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
            OiisDeps deps = stgEntry.getDeps();
            if (deps == null) {
                vDepRules = new Vector<OiisDepRule>();
                Vector vDepModes = new Vector();
                deps = new OiisDeps(vDepRules, vDepModes);
                stgEntry.setDeps(deps);
            } else {
                vDepRules = deps.getDepRules();
            }
            OiisDepRule depRule = new OiisDepRule(this.m_sName, this.m_type, this.m_sName, this.m_vDeps);
            depRule.setResourceBundle(new OiixJarResourceBundle(OiiiStageXMLHandler.this.m_curEntry.getResourceBundle()));
            vDepRules.add(depRule);
            this.m_vDeps = new Vector();
        }
    }

    private class OiiiSingleSizeHandler
    extends OixsElementHandler {
        OiisSingleSize m_singleSize;
        OixsElementHandler m_handlerSizePerLang;
        Vector m_vLangIndex;
        Vector m_vSizePerLang;

        public OiiiSingleSizeHandler() {
            super("SZ");
            this.m_vLangIndex = new Vector();
            this.m_vSizePerLang = new Vector();
            this.m_handlerSizePerLang = new OixsElementHandler(){

                public void onStart(String name, AttributeList atts) {
                    String sIdx = atts.getValue("IDX");
                    String sSize = atts.getValue("SIZE");
                    if (sSize != null) {
                        try {
                            int nIdx = Integer.parseInt(sIdx);
                            if (nIdx >= OiiiSingleSizeHandler.this.m_vSizePerLang.size()) {
                                int prevSize = OiiiSingleSizeHandler.this.m_vSizePerLang.size();
                                OiiiSingleSizeHandler.this.m_vSizePerLang.ensureCapacity(nIdx + 1);
                                for (int i = prevSize; i < nIdx + 1; ++i) {
                                    OiiiSingleSizeHandler.this.m_vSizePerLang.add(new Long("0"));
                                }
                            }
                            OiiiSingleSizeHandler.this.m_vSizePerLang.setElementAt(Long.valueOf(sSize), nIdx);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }

                public void onEnd(String name) {
                }
            };
            this.addChildHandler("LANG_SZ", this.m_handlerSizePerLang);
        }

        public void onStart(String name, AttributeList atts) {
            String sInstallType = atts.getValue("INST_TYPE");
            String sPlatID = atts.getValue("PLAT");
            String sLargestJar = atts.getValue("LRG_JAR");
            String sSize = atts.getValue("SIZE");
            this.m_singleSize = new OiisSingleSize(new Integer(sPlatID), sInstallType, null);
            if (sSize != null) {
                try {
                    this.m_singleSize.setSize(new Long(sSize));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            int nLangSetSize = OiiiStageXMLHandler.this.m_curEntry.getLangIndexMapping().getLangSets().size() + 1;
            this.m_vSizePerLang = new Vector(nLangSetSize);
            for (int i = 0; i < nLangSetSize; ++i) {
                this.m_vSizePerLang.addElement(new Long("0"));
            }
        }

        public void onEnd(String name) {
            int nLangSetSize = this.m_vSizePerLang.size();
            if (nLangSetSize > 0) {
                long[] lSizePerLang = new long[nLangSetSize];
                long lastSize = 0L;
                int lastIdxSz = 0;
                for (int i = 0; i < nLangSetSize; ++i) {
                    lSizePerLang[i] = (Long)this.m_vSizePerLang.elementAt(i);
                    if (lSizePerLang[i] <= 0L) continue;
                    lastSize = lSizePerLang[i];
                    lastIdxSz = i;
                }
                if (lSizePerLang[nLangSetSize - 1] == 0L) {
                    lSizePerLang[nLangSetSize - 1] = lastSize;
                    lSizePerLang[lastIdxSz] = 0L;
                }
                this.m_singleSize.updateSize(lSizePerLang);
                OiisSize oSize = ((OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry).getSizeInfo();
                if (oSize == null) {
                    oSize = new OiisSize();
                    ((OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry).setSizeInfo(oSize);
                    oSize.setLangIndexMapping(OiiiStageXMLHandler.this.m_curEntry.getLangIndexMapping());
                }
                Vector vSizes = oSize.getSingleSizes();
                vSizes.add(this.m_singleSize);
            }
        }
    }

    private class OiiiStageInfoHandler
    extends OixsElementHandler {
        OixsElementHandler m_handlerInstVer;

        public OiiiStageInfoHandler() {
            super("STG_INFO");
            this.m_handlerInstVer = new OixsElementHandler(){

                public void onStart(String name, AttributeList atts) {
                    String platID = atts.getValue("PLAT");
                    String sVer = atts.getValue("VER");
                    int iPlatID = 0;
                    if (!platID.equals("ALL_PLATS")) {
                        iPlatID = Integer.parseInt(platID);
                        ((OiiiStageCompInvEntry)((OiiiStageInfoHandler)OiiiStageInfoHandler.this).OiiiStageXMLHandler.this.m_curEntry).setInstallerVersion(sVer, iPlatID);
                    } else {
                        int[] iaPlats = OiixPlatform.getPlatforms();
                        for (int i = 0; i < iaPlats.length; ++i) {
                            ((OiiiStageCompInvEntry)((OiiiStageInfoHandler)OiiiStageInfoHandler.this).OiiiStageXMLHandler.this.m_curEntry).setInstallerVersion(sVer, iaPlats[i]);
                        }
                    }
                }

                public void onEnd(String name) {
                }
            };
            this.addChildHandler("INST_VER", this.m_handlerInstVer);
        }

        public void onStart(String name, AttributeList atts) {
            String sVer = atts.getValue("OSP_VER");
            if (sVer != null) {
                OiiiVersion version = new OiiiVersion(sVer);
                OiiiStageCompInvEntry stgInv = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
                stgInv.setStageVersion(version);
            }
        }

        public void onEnd(String name) {
        }
    }

    private class OiiiDefaultifyInfoHandler
    extends OixsElementHandler {
        private OiiiDefaultifyInfoHandler() {
        }

        public void onStart(String name, AttributeList atts) {
            String sDefaultifyEnabled = atts.getValue("ENABLED");
            if (sDefaultifyEnabled != null) {
                OiiiStageCompInvEntry stgInv = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
                if (sDefaultifyEnabled.equals("F")) {
                    stgInv.setCanDefaultify(false);
                }
            }
        }

        public void onEnd(String name) {
        }
    }

    class OiiiPatchSetElementHandler
    extends OiiiCompElementHandler {
        private OixsElementHandler m_handlerPatchsetPatch;

        OiiiPatchSetElementHandler() {
            super("PATCHSET");
            this.m_handlerPatchsetPatch = new OiiiInventoryXMLHandler41.OiiiPatchsetPatchHandler();
            this.addChildHandler("PS_PAT", this.m_handlerPatchsetPatch);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            OiiiStageXMLHandler.this.m_curEntry = this.createInvEntry();
        }

        public void onEnd(String name) {
            super.onEnd(name);
        }

        OiiiStageCompInvEntry createInvEntry() {
            OiiiPatchSetInstallID pid = new OiiiPatchSetInstallID(this.getCompName(), this.getVersion());
            String jarContentsLoc = null;
            OiiiStageCompInvEntry stgEntry = new OiiiStageCompInvEntry((OiiiCompInstallID)pid, OiiiStageXMLHandler.this.m_invLoc, null, new Vector(), jarContentsLoc, null);
            this.setupProperties(stgEntry);
            return stgEntry;
        }
    }

    private class OiiiPatchElementHandler
    extends OiiiCompElementHandler {
        private OixsElementHandler m_handlerPatchDepList;
        private OixsElementHandler m_handlerPatchDep;
        private OixsElementHandler m_handlerDepID;
        private OixsElementHandler m_handlerUpgradedDepID;
        private OiiiVersion m_baseVersion;
        private Vector m_basePlats;
        private boolean m_bPatchAttsLoaded;

        OiiiPatchElementHandler() {
            super("PATCH");
            this.m_bPatchAttsLoaded = false;
            this.m_handlerPatchDepList = new OixsElementHandler("PAT_DEP_LIST");
            this.m_handlerPatchDep = new OixsElementHandler("PAT_DEP");
            this.m_handlerDepID = new OiiiPatchDepHandler();
            this.m_handlerUpgradedDepID = new OiiiPatchUpgradeHandler();
            this.m_handlerPatchDep.addChildHandler("DEP_ID", this.m_handlerDepID);
            this.m_handlerPatchDep.addChildHandler("UPGRD_DEP_ID", this.m_handlerUpgradedDepID);
            this.m_handlerPatchDepList.addChildHandler("PAT_DEP", this.m_handlerPatchDep);
            this.addChildHandler("PAT_DEP_LIST", this.m_handlerPatchDepList);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String baseVer = atts.getValue("BASE_VER");
            if (baseVer != null) {
                this.m_baseVersion = new OiiiVersion(baseVer);
            }
            String sPlats = atts.getValue("BASE_PLAT");
            this.m_basePlats = OiiiStageXMLHandler.this.getSessionPlats(sPlats);
            this.m_bPatchAttsLoaded = true;
            OiiiStageXMLHandler.this.m_curEntry = this.createInvEntry();
        }

        public void onEnd(String name) {
            super.onEnd(name);
        }

        OiiiStageCompInvEntry createInvEntry() {
            if (this.m_bPatchAttsLoaded) {
                OiiiCompInstallID baseCompID = new OiiiCompInstallID(this.getCompName(), this.getBaseVersion(), this.getBasePlats(), this.getReplaceVersion(), 1, this.getHomeType(), this.getReleaseLevel());
                baseCompID = OiiiCompIDPool.getInstance().get(baseCompID);
                OiiiPatchInstallID pid = new OiiiPatchInstallID(baseCompID, this.getVersion(), this.getPlats());
                pid = (OiiiPatchInstallID)OiiiCompIDPool.getInstance().get(pid);
                OiiiStagePatchInvEntry patEntry = new OiiiStagePatchInvEntry(pid, OiiiStageXMLHandler.this.m_invLoc, null, this.getLanguages(), this.getStagedPlats(), null, null);
                this.setupProperties(patEntry);
                return patEntry;
            }
            return null;
        }

        private OiiiVersion getBaseVersion() {
            return this.m_baseVersion;
        }

        private void setBaseVersion(OiiiVersion ver) {
            this.m_baseVersion = ver;
        }

        private Vector getBasePlats() {
            return this.m_basePlats;
        }

        private void setBasePlatforms(Vector plats) {
            this.m_basePlats = plats;
        }
    }

    private class OiiiCompElementHandler
    extends OiiiCompBaseElementHandler {
        private OixsElementHandler m_handlerStageInfo;
        private OixsElementHandler m_handlerDefaultifyInfo;
        private OixsElementHandler m_handlerLocationsInfo;
        private OixsElementHandler m_handlerCompJarInfo;
        private OixsElementHandler m_handlerInfo;
        private OixsElementHandler m_handlerSizes;
        private OixsElementHandler m_handlerSingleSize;
        private OixsElementHandler m_handlerDepGrpList;
        private OixsElementHandler m_handlerDepGrp;
        private OixsElementHandler m_handlerInstallTypeList;
        private OixsElementHandler m_handlerInstallType;
        private OixsElementHandler m_handlerFileSizeInfo;
        private OixsElementHandler m_handlerDestLangPlatMap;
        private OixsElementHandler m_handlerDestLangPlat;
        private OixsElementHandler m_handlerOffsets;
        private OixsElementHandler m_handletDestOffset;
        private OixsElementHandler m_handlerNonInstallOffset;
        private OixsElementHandler m_handlerTempOffset;
        private OixsElementHandler m_handlerPlatIndexMap;
        private OixsElementHandler m_handlerPlat;
        private OixsElementHandler m_handlerPlatSet;
        private OixsElementHandler m_handlerLangIndexMap;
        private OixsElementHandler m_handlerLang;
        private OixsElementHandler m_handlerLangSet;
        private OixsElementHandler m_handlerDestIndexMap;
        private OixsElementHandler m_handlerDest;
        private OixsElementHandler m_handlerLibDepList;
        private OixsElementHandler m_handlerActionList;
        private OixsElementHandler m_handlerQueryList;
        private OixsElementHandler m_handlerDialogList;
        private OixsElementHandler m_handlerLibDep;
        private OixsElementHandler m_handlerBook;
        private OixsElementHandler m_handlerPreReq;
        private OixsElementHandler m_handlerProdHome;
        private OixsElementHandler m_handlerLargestJar;
        private OixsElementHandler m_handlerJarSize;
        private Vector m_stagedPlats;
        private Vector m_compPlats;
        private int m_homeType;
        private boolean m_bMerged;
        private OiiiVersion m_mergedVers;
        private boolean m_bClonable;

        public OiiiCompElementHandler(String sName) {
            super(sName);
            this.m_handlerStageInfo = new OiiiStageInfoHandler();
            this.addChildHandler("STG_INFO", this.m_handlerStageInfo);
            this.m_handlerDefaultifyInfo = new OiiiDefaultifyInfoHandler();
            this.addChildHandler("DEFAULTIFY", this.m_handlerDefaultifyInfo);
            this.m_handlerLocationsInfo = new OiiiInventoryXMLHandler41.OiiiLocationsInfoHandler();
            this.addChildHandler("LOC_INFO", this.m_handlerLocationsInfo);
            this.m_handlerCompJarInfo = new OixsElementHandler("CMP_JAR_INFO");
            this.m_handlerInfo = new OiiiInventoryXMLHandler41.OiiiCompJarInfoHandler();
            this.m_handlerCompJarInfo.addChildHandler("INFO", this.m_handlerInfo);
            this.addChildHandler("CMP_JAR_INFO", this.m_handlerCompJarInfo);
            this.m_handlerSizes = new OixsElementHandler("SIZES");
            this.m_handlerSingleSize = new OiiiSingleSizeHandler();
            this.m_handlerSizes.addChildHandler("SZ", this.m_handlerSingleSize);
            this.addChildHandler("SIZES", this.m_handlerSizes);
            this.m_handlerDepGrpList = new OixsElementHandler("DEP_GRP_LIST");
            this.m_handlerDepGrp = new OiiiDepGrpElementHandler();
            this.m_handlerDepGrpList.addChildHandler("DEP_GRP", this.m_handlerDepGrp);
            this.addChildHandler("DEP_GRP_LIST", this.m_handlerDepGrpList);
            this.m_handlerInstallTypeList = new OixsElementHandler("INST_TYPE_LIST");
            this.m_handlerInstallType = new OiiiInstallTypeElementHandler();
            this.m_handlerInstallTypeList.addChildHandler("INST_TYPE", this.m_handlerInstallType);
            this.addChildHandler("INST_TYPE_LIST", this.m_handlerInstallTypeList);
            this.m_handlerFileSizeInfo = new OixsElementHandler("STG_FSI");
            this.m_handlerJarSize = new OixsElementHandler("JAR_SZ");
            this.m_handlerLargestJar = new OiiiLargestJarHandler();
            this.m_handlerJarSize.addChildHandler("LRG_JAR", this.m_handlerLargestJar);
            this.m_handlerFileSizeInfo.addChildHandler("JAR_SZ", this.m_handlerJarSize);
            this.m_handlerDestLangPlatMap = new OixsElementHandler("DST_LNG_PLT_MAP");
            this.m_handlerDestLangPlat = new OiiiDestLangPlatHandler();
            this.m_handlerDestLangPlatMap.addChildHandler("ID", this.m_handlerDestLangPlat);
            this.m_handlerFileSizeInfo.addChildHandler("DST_LNG_PLT_MAP", this.m_handlerDestLangPlatMap);
            this.addChildHandler("STG_FSI", this.m_handlerFileSizeInfo);
            this.m_handlerOffsets = new OixsElementHandler("OFFSETS");
            this.m_handletDestOffset = new OiiiOffsetHandler("DST");
            this.m_handlerNonInstallOffset = new OiiiOffsetHandler("NONINST");
            this.m_handlerTempOffset = new OiiiOffsetHandler("TMP");
            this.m_handlerOffsets.addChildHandler("DST", this.m_handletDestOffset);
            this.m_handlerOffsets.addChildHandler("NONINST", this.m_handlerNonInstallOffset);
            this.m_handlerOffsets.addChildHandler("TMP", this.m_handlerTempOffset);
            this.m_handlerFileSizeInfo.addChildHandler("OFFSETS", this.m_handlerOffsets);
            this.m_handlerPlatIndexMap = new OixsElementHandler("PLAT_IDX_MAP");
            this.m_handlerPlat = new OiiiInventoryXMLHandler41.OiiiPlatHandler();
            this.m_handlerPlatSet = new OiiiInventoryXMLHandler41.OiiiPlatSetHandler();
            this.m_handlerPlatIndexMap.addChildHandler("PLAT", this.m_handlerPlat);
            this.m_handlerPlatIndexMap.addChildHandler("PLATSET", this.m_handlerPlatSet);
            this.addChildHandler("PLAT_IDX_MAP", this.m_handlerPlatIndexMap);
            this.m_handlerLangIndexMap = new OixsElementHandler("LANG_IDX_MAP");
            this.m_handlerLang = new OiiiInventoryXMLHandler41.OiiiLangHandler();
            this.m_handlerLangSet = new OiiiInventoryXMLHandler41.OiiiLangSetHandler();
            this.m_handlerLangIndexMap.addChildHandler("LANG", this.m_handlerLang);
            this.m_handlerLangIndexMap.addChildHandler("LANGSET", this.m_handlerLangSet);
            this.addChildHandler("LANG_IDX_MAP", this.m_handlerLangIndexMap);
            this.m_handlerDestIndexMap = new OixsElementHandler("DST_IDX_MAP");
            this.m_handlerDest = new OiiiInventoryXMLHandler41.OiiiDestHandler();
            this.m_handlerDestIndexMap.addChildHandler("DST", this.m_handlerDest);
            this.addChildHandler("DST_IDX_MAP", this.m_handlerDestIndexMap);
            this.m_handlerLibDepList = new OixsElementHandler("LIB_DEP_LST");
            this.m_handlerActionList = new OiiiLibListHandler("ACTION_LIST");
            this.m_handlerQueryList = new OiiiLibListHandler("QUERY_LIST");
            this.m_handlerDialogList = new OiiiLibListHandler("DIALOG_LIST");
            this.m_handlerLibDep = new OiiiLibDepHandler();
            this.m_handlerActionList.addChildHandler("LIB_DEP", this.m_handlerLibDep);
            this.m_handlerQueryList.addChildHandler("LIB_DEP", this.m_handlerLibDep);
            this.m_handlerDialogList.addChildHandler("LIB_DEP", this.m_handlerLibDep);
            this.m_handlerLibDepList.addChildHandler("ACTION_LIST", this.m_handlerActionList);
            this.m_handlerLibDepList.addChildHandler("QUERY_LIST", this.m_handlerQueryList);
            this.m_handlerLibDepList.addChildHandler("DIALOG_LIST", this.m_handlerDialogList);
            this.addChildHandler("LIB_DEP_LST", this.m_handlerLibDepList);
            this.m_handlerBook = new OiiiInventoryXMLHandler41.OiiiBookHandler();
            this.addChildHandler("BOOK", this.m_handlerBook);
            this.m_handlerPreReq = new OiiiInventoryXMLHandler41.OiiiPreReqHandler();
            this.addChildHandler("PRE_REQ", this.m_handlerPreReq);
            this.m_handlerProdHome = new OiiiInventoryXMLHandler41.OiiiProdHomeHandler();
            this.addChildHandler("PROD_HOME", this.m_handlerProdHome);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String plats = atts.getValue("STG_PLAT");
            this.m_stagedPlats = OiiiStageXMLHandler.this.getSessionPlats(plats);
            plats = atts.getValue("PLAT");
            this.m_compPlats = OiiiStageXMLHandler.this.getSessionPlats(plats);
            String strOH = atts.getValue("TYPE");
            this.m_homeType = 1;
            if (strOH == null) {
                this.m_homeType = 2;
            } else if (strOH.equals("NOH")) {
                this.m_homeType = 0;
            }
            String strMerged = atts.getValue("MERGED");
            if (strMerged != null) {
                if (strMerged.equals("T")) {
                    this.m_bMerged = true;
                    String sVerMerged = atts.getValue("VER_MER");
                    if (sVerMerged != null) {
                        this.m_mergedVers = new OiiiVersion(sVerMerged);
                    }
                } else {
                    this.m_bMerged = false;
                }
            } else {
                this.m_bMerged = false;
            }
            String strClonable = atts.getValue("CLONABLE");
            this.m_bClonable = strClonable != null ? strClonable.equalsIgnoreCase("T") : true;
            OiiiStageXMLHandler.this.m_curEntry = this.createInvEntry();
        }

        public void onEnd(String name) {
            OiisDeps deps;
            OiiiStageXMLHandler.this.m_curEntry.setName(this.getExternalName());
            OiiiStageXMLHandler.this.m_curEntry.setDescResourceId(this.getDescriptionID());
            OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiStageXMLHandler.this.m_curEntry;
            OiisFileSizeInfo fileSizeInfo = stgEntry.getFileSizeInfoEx();
            if (fileSizeInfo == null) {
                OiisPlatIndexMapping pim = stgEntry.getPlatIndexMapping();
                OiisLangIndexMapping lim = stgEntry.getLangIndexMapping();
                OiisDestinationIndexMapping dim = stgEntry.getDestIndexMapping();
                if (pim != null && lim != null && dim != null) {
                    fileSizeInfo = new OiisFileSizeInfo(pim, lim, dim);
                    stgEntry.setFileSizeInfoEx(fileSizeInfo);
                }
            }
            if ((deps = stgEntry.getDeps()) == null) {
                deps = new OiisDeps(new Vector(), new Vector());
                stgEntry.setDeps(deps);
            }
            OiiiStageXMLHandler.this.m_inventory.addCompInvEntry(OiiiStageXMLHandler.this.m_curEntry);
        }

        protected boolean isClonable() {
            return this.m_bClonable;
        }

        protected void setClonable(boolean bClonable) {
            this.m_bClonable = bClonable;
        }

        protected Vector getStagedPlats() {
            return this.m_stagedPlats;
        }

        protected void setStagePlats(Vector vPlats) {
            this.m_stagedPlats = vPlats;
        }

        protected Vector getPlats() {
            return this.m_compPlats;
        }

        protected void setCompPlats(Vector vPlats) {
            this.m_compPlats = vPlats;
        }

        protected int getHomeType() {
            return this.m_homeType;
        }

        protected void setHomeType(int nOH) {
            this.m_homeType = nOH;
        }

        protected boolean isMerged() {
            return this.m_bMerged;
        }

        protected void setMerged(boolean bMerged) {
            this.m_bMerged = bMerged;
        }

        protected OiiiVersion getMergedVersion() {
            return this.m_mergedVers;
        }

        protected void setMergedVersion(boolean bMerged) {
            this.m_bMerged = bMerged;
        }

        OiiiStageCompInvEntry createInvEntry() {
            OiiiCompInstallID cid = new OiiiCompInstallID(this.getCompName(), this.getVersion(), this.getPlats(), this.getReplaceVersion(), 1, this.getHomeType(), this.getReleaseLevel());
            cid = OiiiCompIDPool.getInstance().get(cid);
            OiiiStageCompInvEntry stgEntry = new OiiiStageCompInvEntry(cid, OiiiStageXMLHandler.this.m_invLoc, null, this.getLanguages(), this.getStagedPlats(), null);
            this.setupProperties(stgEntry);
            return stgEntry;
        }

        protected void setupProperties(OiiiStageCompInvEntry stgEntry) {
            stgEntry.setTopLevel(OiiiStageXMLHandler.this.m_bInTopLevelList);
            OiisCompProperties props = new OiisCompProperties(stgEntry.getCompInstallID());
            props.setSupportedLangs(this.getLanguages());
            stgEntry.setCompProperties(props);
            stgEntry.setAreaControl(OiiiStageXMLHandler.this.m_areaControl);
            if (this.isMerged()) {
                stgEntry.setMerged(true);
                stgEntry.setMergedVersion(this.getMergedVersion());
            }
            stgEntry.setClonable(this.m_bClonable);
        }
    }
}

