/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiConfigXMLHandler;
import oracle.sysman.oii.oiii.OiiiLibrariesInfo;
import oracle.sysman.oii.oiii.OiiiLibsXMLHandler;
import oracle.sysman.oii.oiii.OiiiReleaseNotesXMLHandler;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStageInventoryReader;
import oracle.sysman.oii.oiii.OiiiStageXMLHandler;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixProgressRun;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiiStageXMLReader
implements OiiiStageInventoryReader {
    private static OiiiStageXMLReader m_reader;

    OiiiStageXMLReader() {
    }

    static OiiiStageXMLReader getReader() {
        if (m_reader == null) {
            m_reader = new OiiiStageXMLReader();
        }
        return m_reader;
    }

    public OiiiStageInventory readInventory(String sInvLoc, OiixProgressListener progressListener, OiiiTargetAreaControl areaCtrl) throws IOException {
        OiixProgressRun progRun = null;
        Thread progThread = null;
        if (progressListener != null) {
            progressListener.setStatus(OiixResourceBundle.getString("S_STGINV_PROG_MSG"));
            progressListener.setTotalBytes(100L);
            progRun = new OiixProgressRun(progressListener, 38, 1000);
            progThread = new Thread(progRun);
            progThread.start();
        }
        sInvLoc = OiixPathOps.getStandardForm(sInvLoc);
        Properties invDetails = OiiiStageInventory.readInvDetailsProps(OiixPathOps.getParentDir(sInvLoc));
        String parDir = OiixPathOps.getParentDir(sInvLoc);
        String sRelNotesXML = OiiiStageXMLReader.getReleaseNotesFileName(parDir);
        String sConfigXML = OiiiStageXMLReader.getConfigFileName(parDir);
        String sLibsXML = OiiiStageXMLReader.getLibsFileName(parDir);
        OiiiStageInventory retInv = this.readComps(sInvLoc, areaCtrl);
        this.readReleaseNotes(retInv, sRelNotesXML);
        this.readConfigTools(retInv, sConfigXML);
        Vector[] libs = this.readLibs(sLibsXML);
        OiiiLibrariesInfo libInfo = new OiiiLibrariesInfo(libs);
        retInv.setAllCompsLibsInfo(0, libInfo);
        retInv.setAllLibsInfoForType(0, libs[0]);
        retInv.setAllLibsInfoForType(1, libs[1]);
        retInv.setAllLibsInfoForType(2, libs[2]);
        if (progressListener != null) {
            try {
                progRun.setUpdateProgress(false);
                progThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retInv;
    }

    private OiiiStageInventory readComps(String sFileName, OiiiTargetAreaControl areaCtrl) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiStageXMLHandler handler = null;
        FileInputStream fReader = null;
        InputStreamReader iReader = null;
        BufferedReader bReader = null;
        try {
            Parser parser = OixsXMLOps.createSAXParser();
            handler = new OiiiStageXMLHandler(sFileName, areaCtrl);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                fReader = new FileInputStream(sFileName);
                iReader = new InputStreamReader((InputStream)fReader, "UTF-8");
                bReader = new BufferedReader(iReader);
            }
            catch (FileNotFoundException e) {
                Object[] sArgs = new String[]{sFileName};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
                return new OiiiStageInventory();
            }
            parser.parse(new InputSource(bReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception in parsing comps:" + e.getMessage());
        }
        bReader.close();
        iReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, Read Comps for Stage Inventory ", System.currentTimeMillis() - lTime);
        }
        return (OiiiStageInventory)handler.getInventory();
    }

    Vector[] readLibs(String sLibsFileLoc) throws IOException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiLibsXMLHandler handler = null;
        FileReader fReader = null;
        BufferedReader bReader = null;
        try {
            boolean bStageSession = true;
            handler = new OiiiLibsXMLHandler(bStageSession);
            Parser parser = OixsXMLOps.createSAXParser();
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                fReader = new FileReader(sLibsFileLoc);
                bReader = new BufferedReader(fReader);
            }
            catch (FileNotFoundException e) {
                Vector[] vLibs = new Vector[]{new Vector(), new Vector(), new Vector()};
                return vLibs;
            }
            parser.parse(new InputSource(bReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        bReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, Read Libs from StageInventory ", System.currentTimeMillis() - lTime);
        }
        return handler.getLibraries();
    }

    void readReleaseNotes(OiiiStageInventory inv, String sFileName) throws IOException {
        if (!new File(sFileName).exists()) {
            return;
        }
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiReleaseNotesXMLHandler handler = null;
        FileReader fReader = null;
        BufferedReader bReader = null;
        try {
            Parser parser = OixsXMLOps.createSAXParser();
            handler = new OiiiReleaseNotesXMLHandler(inv);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                fReader = new FileReader(sFileName);
                bReader = new BufferedReader(fReader);
            }
            catch (FileNotFoundException e) {
                Object[] sArgs = new String[]{sFileName};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
            }
            parser.parse(new InputSource(bReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        bReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, Relase notes for Stage Inventory ", System.currentTimeMillis() - lTime);
        }
    }

    void readConfigTools(OiiiStageInventory inv, String sFileName) throws IOException {
        if (!new File(sFileName).exists()) {
            return;
        }
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiiConfigXMLHandler handler = null;
        FileReader fReader = null;
        BufferedReader bReader = null;
        try {
            Parser parser = OixsXMLOps.createSAXParser();
            handler = new OiiiConfigXMLHandler(inv);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                fReader = new FileReader(sFileName);
                bReader = new BufferedReader(fReader);
            }
            catch (FileNotFoundException e) {
                Object[] sArgs = new String[]{sFileName};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
            }
            parser.parse(new InputSource(bReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        bReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, Relase notes for Stage Inventory ", System.currentTimeMillis() - lTime);
        }
    }

    private static String getFileName(String parDir, Properties invDetails, String keyInProp, String defFileName) {
        String sRetFileName = defFileName;
        if (invDetails != null) {
            String sNameInProp = invDetails.getProperty(keyInProp);
            if (sNameInProp != null) {
                sRetFileName = sNameInProp;
            }
            if (parDir != null) {
                sRetFileName = OiixPathOps.concatPath(parDir, sRetFileName);
            }
        }
        return sRetFileName;
    }

    static String getReleaseNotesFileName(String parDir) {
        Properties invDetails = OiiiStageInventory.readInvDetailsProps(parDir);
        String sRelNotesXML = OiiiStageXMLReader.getFileName(parDir, invDetails, "ReleaseNotesXML", "releaseNotes.xml");
        return sRelNotesXML;
    }

    static String getTopLevelUserActionsPropsName(String parDir) {
        Properties invDetails = OiiiStageInventory.readInvDetailsProps(parDir);
        String retLoc = OiiiStageXMLReader.getFileName(parDir, invDetails, "TLUserAction", "TopLevel_UserAction.properties");
        return retLoc;
    }

    static String getConfigFileName(String parDir) {
        Properties invDetails = OiiiStageInventory.readInvDetailsProps(parDir);
        String sConfigXML = OiiiStageXMLReader.getFileName(parDir, invDetails, "configXML", "config.xml");
        return sConfigXML;
    }

    static String getLibsFileName(String parDir) {
        Properties invDetails = OiiiStageInventory.readInvDetailsProps(parDir);
        String sLibsXML = OiiiStageXMLReader.getFileName(parDir, invDetails, "LibsXML", "libs.xml");
        return sLibsXML;
    }

    static String getOUIConfigVarFileName(String sParDir) {
        Properties invDetails = OiiiStageInventory.readInvDetailsProps(sParDir);
        String sOuiCfgVarXML = OiiiStageXMLReader.getFileName(sParDir, invDetails, "OUIConfigVarXML", "OuiConfigVariables.xml");
        return sOuiCfgVarXML;
    }

    static String getInvDetailsFileName(String parDir) {
        return OiixPathOps.concatPath(parDir, "invDetails.properties");
    }

    static String getShipHomeInfoPropertiesFileName(String parDir) {
        return OiixPathOps.concatPath(parDir, "shiphomeinfo.properties");
    }

    public static String getSHPropsFileName(String parDir) {
        Properties invDetails = OiiiStageInventory.readInvDetailsProps(parDir);
        String sSHPropsXML = OiiiStageXMLReader.getFileName(parDir, invDetails, "SHPropsXML", "shiphomeproperties.xml");
        return sSHPropsXML;
    }
}

