/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiStagingAreaInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiStagingAreasMaintainer {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    private String m_saInvLoc;
    private Vector m_saInfoList;

    private OiiiStagingAreasMaintainer(String saInvLoc) throws IOException {
        this.m_saInvLoc = saInvLoc;
        this.loadSAList();
    }

    public void loadSAList() throws IOException {
        String saiLoc = this.getSAInvLoc();
        try {
            FileInputStream fis = new FileInputStream(saiLoc);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.m_saInfoList = (Vector)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            this.m_saInfoList = new Vector();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.toString());
        }
        catch (OptionalDataException ode) {
            throw new IOException(ode.toString());
        }
    }

    public static OiiiStagingAreasMaintainer getStagingAreasMaintainer() throws IOException {
        OiipgPropertyLoader pg = new OiipgPropertyLoader();
        String invLoc = null;
        invLoc = pg.getLocationFileLoc();
        if (invLoc != null) {
            return new OiiiStagingAreasMaintainer(invLoc);
        }
        throw new IOException(OiixResourceBundle.getString("S_INV_NOTSET"));
    }

    public void saveSAList() throws IOException {
        String saiLoc = this.getSAInvLoc();
        FileOutputStream fos = new FileOutputStream(saiLoc);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.m_saInfoList);
        oos.flush();
        fos.close();
    }

    public Vector getAllStagingAreas() {
        return this.m_saInfoList;
    }

    public OiiiStagingAreaInfo getStagingAreaInfoFor(String stgAreaLoc) {
        OiiiStagingAreaInfo retSAInfo = null;
        int saInd = OiixVectorOps.vectIndexOf(this.m_saInfoList, (Object)stgAreaLoc);
        if (saInd != -1) {
            retSAInfo = (OiiiStagingAreaInfo)this.m_saInfoList.elementAt(saInd);
        }
        return retSAInfo;
    }

    public void addStagingAreaInfo(OiiiStagingAreaInfo saInfo) {
        int saInd = OiixVectorOps.vectIndexOf(this.m_saInfoList, (Object)saInfo);
        if (saInd != -1) {
            OiiiStagingAreaInfo exSAInfo = (OiiiStagingAreaInfo)this.m_saInfoList.elementAt(saInd);
            exSAInfo.setAdditionalInfoFrom(saInfo);
            this.m_saInfoList.setElementAt(exSAInfo, saInd);
        } else {
            this.m_saInfoList.addElement(saInfo);
        }
    }

    public void delStagingAreaInfo(String stgLoc) {
        int saInd = OiixVectorOps.vectIndexOf(this.m_saInfoList, (Object)stgLoc);
        if (saInd != -1) {
            this.m_saInfoList.removeElementAt(saInd);
        }
    }

    private String getSAInvLoc() {
        String stdPath = OiixPathOps.concatPath(OiixPathOps.getStandardForm(this.m_saInvLoc), "stagingAreasList.ser");
        return OiixPathOps.getNativeForm(stdPath);
    }
}

