/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCdLabel;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiii.OiiiIDiskValidator;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaMap;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiit.OiitDefaultConflictResolver;
import oracle.sysman.oii.oiit.OiitLockHeartbeat;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiit.OiitTargetLocker;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarModifier;
import oracle.sysman.oii.oiix.OiixJarModifierPool;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public abstract class OiiiTargetAreaControl {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    public static final String COMPONENTS_LOC = "Components";
    public static final String PATCHES_LOC = "Patches";
    public static final String PATCHSETS_LOC = "PatchSets";
    public static final String DATAFILES_LOC = "DataFiles";
    public static final String EXPANDED_LOC = "Expanded";
    public static final String DISK_LOC = "Disk";
    public static final String STAGE_LOC = "stage";
    public static final String HELP_LOC = "help";
    public static final String SCRIPTS_DIR = "Scripts";
    public static final String[] LIBS_LOC = new String[]{"Actions", "Queries", "Dialogs"};
    public static final int STAGE_COMP_INSTALL_LOC = 0;
    public static final int STAGE_INSTALL_JAR_NAME = 1;
    public static final int STAGE_COMP_PACKAGE_NAME = 2;
    public static final int STAGE_COMP_SCRIPT_LOC = 3;
    public static final int STAGE_COMP_DATAFILES_LOC = 4;
    public static final int STAGE_COMP_GROUPS_LOC = 5;
    public static final int STAGE_COMP_EXPANDED_LOC = 6;
    public static final int STAGE_COMP_SCRIPTS_BASE = 7;
    public static final int STAGE_COMP_DISK_NUM_STRING = 8;
    public static final int STAGE_LOCATIONS_COUNT = 9;
    public static final String INSTALL_JAR_PREFIX = "install";
    private OiiiAreaInventory m_areaInv;
    private String m_areaRoot;
    private OiitLockHeartbeat m_lockHb;
    private OiitLockHeartbeat m_readHb;
    public static final String COMPS_XML_FILENAME = "comps.xml";
    public static final String PRODUCTS_XML_FILENAME = "products.xml";
    public static final String REL_NOTES_XML_FILENAME = "releaseNotes.xml";
    public static final String LIBS_XML_FILENAME = "libs.xml";
    public static final String INV_DETAILS_FILENAME = "invDetails.properties";
    public static final String SHIPHOMEINFO_PROPERTIES_FILENAME = "shiphomeinfo.properties";
    public static final String CONFIG_XML_FILENAME = "config.xml";
    public static final String CONFIG_OUI_VAR_XML_FILENAME = "OuiConfigVariables.xml";
    public static final String TL_UA_FILENAME = "TopLevel_UserAction.properties";
    public static final String INSTANTIATE_XML_FILENAME = "instantiate.xml";
    public static final String SHINFO_XML_FILENAME = "shiphomeproperties.xml";
    public static final String OHINFO_XML_FILENAME = "oraclehomeproperties.xml";
    public static final String CHINFO_XML_FILENAME = "compositehomeproperties.xml";
    public static final String WINACTIONS_XML_FILENAME = "desktopactions.xml";

    public OiiiTargetAreaControl(String areaRoot) {
        this.m_areaRoot = areaRoot;
        this.m_areaInv = null;
        this.m_lockHb = null;
        this.m_readHb = null;
    }

    public void grabWriterLock() throws OiitTargetLockNotAvailableException, IOException {
        this.grabWriterLock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grabWriterLock(boolean bMonitor) throws OiitTargetLockNotAvailableException, IOException {
        try {
            OiitDefaultConflictResolver cl = new OiitDefaultConflictResolver();
            OiitTargetLocker tl = new OiitTargetLocker(this.m_areaRoot, cl);
            this.m_lockHb = tl.upgradeToWriterLock(this.m_readHb, false);
        }
        finally {
            this.m_readHb = null;
        }
    }

    public void releaseWriterLock() {
        try {
            if (this.m_lockHb != null) {
                OiitDefaultConflictResolver cl = new OiitDefaultConflictResolver();
                OiitTargetLocker tl = new OiitTargetLocker(this.m_areaRoot, cl);
                this.m_readHb = tl.downgradeToReaderLock(this.m_lockHb);
                this.m_lockHb = null;
            }
        }
        catch (Exception e) {
            this.m_lockHb = null;
        }
    }

    public void grabReaderLock() throws OiitTargetLockNotAvailableException, IOException {
        if (this.m_readHb == null) {
            OiitDefaultConflictResolver cl = new OiitDefaultConflictResolver();
            OiitTargetLocker tl = new OiitTargetLocker(this.m_areaRoot, cl);
            this.m_readHb = tl.getReaderLock();
        }
    }

    public void releaseReaderLock() {
        if (this.m_readHb != null) {
            this.m_readHb.releaseLock();
            this.m_readHb = null;
        }
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie, Locale loc) {
        return null;
    }

    public ResourceBundle getResourceBundle(OiiiCompInvEntry ie) {
        return this.getResourceBundle(ie, null);
    }

    protected void setAreaInventory(OiiiAreaInventory areaInv) {
        this.m_areaInv = areaInv;
    }

    public OiiiAreaInventory getAreaInventory() {
        return this.m_areaInv;
    }

    public String getAreaRoot() {
        return this.m_areaRoot;
    }

    public String genFileSysLoc(String relLoc) {
        return OiixPathOps.concatPath(this.m_areaRoot, relLoc);
    }

    public String genLogLoc(String relLoc) {
        Properties pp = System.getProperties();
        String logLoc = pp.getProperty("oracle.installer.log_loc", this.m_areaRoot);
        return OiixPathOps.concatPath(logLoc, relLoc);
    }

    public String genLibLoc(String relLoc) {
        Properties pp = System.getProperties();
        String libLoc = pp.getProperty("oracle.installer.lib_loc", this.m_areaRoot);
        return OiixPathOps.concatPath(libLoc, relLoc);
    }

    public void cleanUpInvDir() {
        this.cleanUpInvDir(true);
    }

    public void cleanUpInvDir(boolean bCleanComps) {
        OiiiTargetAreaMap tam = new OiiiTargetAreaMap();
        tam.setStageLoc(this.m_areaRoot);
        tam.buildInternal(this.m_areaInv, bCleanComps);
        if (bCleanComps) {
            tam.removeExtraCompDirs(this.genLogLoc(""));
            tam.removeExtraInstallDefnJars();
            tam.removeExtraLibDirs(this.genLibLoc(""));
            int nDisk = OiiiTargetAreaControl.getTotalDisks(this.m_areaInv);
            for (int i = 2; i <= nDisk; ++i) {
                String sDiskLoc = OiiiTargetAreaControl.getDefaultDiskLocation(this.m_areaRoot, i);
                tam.removeExtraCompDirs(sDiskLoc);
            }
            tam.removeScriptsDirs(OiixPathOps.concatPath(this.m_areaRoot, SCRIPTS_DIR));
        }
    }

    private String genLocation(String hierName) {
        return hierName;
    }

    public String genCompInstallLocation(OiiiCompInstallID cid) throws IOException {
        return this.genCompInstallLocation(cid, new Vector());
    }

    protected boolean genSeparateLoc(OiiiCompInvEntry cie, Vector platforms) {
        if (cie instanceof OiiiStageCompInvEntry) {
            Vector existPlats = ((OiiiStageCompInvEntry)cie).getPlatforms();
            return !OiixVectorOps.vectorSubset(existPlats, platforms);
        }
        return false;
    }

    public String[] genCompLocations(OiiiCompInstallID cid, Vector plats) throws IOException {
        String jarName = null;
        String compInstallLoc = null;
        Vector usedDirs = new Vector(5);
        Hashtable unUsableJars = new Hashtable(5);
        OiiiStageCompInvEntry cie = (OiiiStageCompInvEntry)this.findMatchingEntry(cid, plats, usedDirs, unUsableJars);
        if (cie != null) {
            if (cie.getJarName() != null) {
                jarName = cie.getJarName();
            }
            compInstallLoc = cie.getLocation();
        } else {
            compInstallLoc = this.getNextAvailableCompLoc(cid, usedDirs);
        }
        if (jarName == null) {
            jarName = this.getNextAvailableInstallJarName(unUsableJars);
        }
        String[] retLocs = new String[9];
        retLocs[0] = compInstallLoc;
        retLocs[1] = jarName;
        retLocs[2] = OiiiTargetAreaControl.genPackageName(cid);
        retLocs[3] = this.genScriptLocation(jarName, retLocs[2]);
        int diskNum = this.getDiskNumber(cid, plats);
        retLocs[4] = OiiiTargetAreaControl.genDataFilesLocation(compInstallLoc, diskNum);
        retLocs[5] = OiiiTargetAreaControl.genGropsLocation(compInstallLoc);
        retLocs[6] = OiiiTargetAreaControl.genExpandedDataFilesLocation(compInstallLoc, diskNum);
        retLocs[7] = this.genScriptBase(jarName);
        retLocs[8] = Integer.toString(diskNum);
        return retLocs;
    }

    private String getNextAvailableCompLoc(OiiiCompInstallID cid, Vector usedDirs) throws IOException {
        String compLoc;
        File dirFile;
        String initLoc = OiiiTargetAreaControl.getCollectionDir(cid.getCompType()) + '/' + this.genLocation(cid.getName()) + '/' + cid.getVersion().toString() + '/';
        int num = 1;
        while (usedDirs.contains(new Integer(num)) || (dirFile = new File(OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.m_areaRoot, compLoc = initLoc + num + '/')))).exists()) {
            ++num;
        }
        OiixFileOps.mkdirs(dirFile);
        if (!dirFile.exists()) {
            Object[] msgArr = new String[]{dirFile.getPath()};
            throw new IOException(MessageFormat.format(OiixResourceBundle.getString("S_ERROR_CREAT_DIR"), msgArr));
        }
        return compLoc;
    }

    public Hashtable getAllInstallJarNames() {
        Hashtable<String, String> usedJars = new Hashtable<String, String>(5);
        if (this.m_areaInv instanceof OiiiStageInventory) {
            OiiiStageInventory stageInv = (OiiiStageInventory)this.m_areaInv;
            Enumeration en = stageInv.getAllComps(0);
            while (en.hasMoreElements()) {
                OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)en.nextElement();
                String jarName = scie.getJarName();
                if (jarName == null) continue;
                usedJars.put(jarName, jarName);
            }
        }
        return usedJars;
    }

    private String getNextAvailableInstallJarName(Hashtable unusableJars) throws IOException {
        String installJar = null;
        String jarName = null;
        OiixJarModifierPool p = OiixJarModifierPool.getJarModifierPool();
        Hashtable usedJars = this.getAllInstallJarNames();
        Enumeration en = p.getJarModifiers();
        while (en.hasMoreElements()) {
            OiixJarModifier jm = (OiixJarModifier)en.nextElement();
            String sJarStdPath = OiixPathOps.getStandardForm(jm.getJarName());
            jarName = OiixPathOps.getFileName(sJarStdPath);
            if (unusableJars.containsKey(jarName)) continue;
            if (jarName.startsWith(INSTALL_JAR_PREFIX) && jm.getEntryCount() < 2000) {
                installJar = jarName;
                break;
            }
            unusableJars.put(jarName, jarName);
        }
        if (installJar == null) {
            String installJarPath = null;
            int runCount = 1;
            while (true) {
                installJar = INSTALL_JAR_PREFIX + runCount + ".jar";
                installJarPath = OiixPathOps.concatPath(this.m_areaRoot, installJar);
                if (!unusableJars.containsKey(installJar)) {
                    OiixJarModifier jm;
                    File f = new File(installJarPath);
                    if (usedJars.containsKey(installJar) ? (jm = p.get(installJarPath)).getEntryCount() < 2000 : !f.exists()) break;
                }
                ++runCount;
            }
        }
        return installJar;
    }

    public static String genPackageName(OiiiCompInstallID cid) {
        String compName = cid.getName();
        String versionString = cid.getVersion().toString();
        versionString = versionString.replace('.', '_');
        return OiiiTargetAreaControl.getCollectionDir(cid.getCompType()) + "." + compName + ".v" + versionString;
    }

    public static String genPackageNameDir(OiiiCompInstallID cid) {
        String packageName = OiiiTargetAreaControl.genPackageName(cid);
        return packageName.replace('.', '/');
    }

    public String genScriptLocation(String installJarName, String packageName) {
        int runCount = this.extractRunCount(installJarName);
        String compPath = packageName.replace('.', '/');
        String scriptLoc = "Scripts/" + runCount + "/" + compPath;
        return scriptLoc;
    }

    private String genScriptBase(String installJarName) {
        int runCount = this.extractRunCount(installJarName);
        return "Scripts/" + runCount;
    }

    private int extractRunCount(String installJarName) {
        int runCount = -1;
        int i = installJarName.lastIndexOf(46);
        String strNum = installJarName.substring(INSTALL_JAR_PREFIX.length(), i);
        try {
            runCount = Integer.parseInt(strNum);
        }
        catch (NumberFormatException e) {
            runCount = 0;
        }
        return runCount;
    }

    public String genScriptLocation(OiiiCompInstallID cid, Vector platforms) throws IOException {
        String installJarName = this.genInstallJarName(cid, platforms);
        int runCount = -1;
        int i = installJarName.lastIndexOf(46);
        String strNum = installJarName.substring(INSTALL_JAR_PREFIX.length(), i);
        try {
            runCount = Integer.parseInt(strNum);
        }
        catch (NumberFormatException e) {
            runCount = 0;
        }
        String compPath = OiiiTargetAreaControl.genPackageName(cid).replace('.', '/');
        String scriptLoc = SCRIPTS_DIR + runCount + "/" + compPath;
        return scriptLoc;
    }

    private String genInstallJarName(OiiiCompInstallID cid, Vector platforms) throws IOException {
        String jarPath;
        OiixJarModifier ip;
        String jarName;
        Vector usedDirs = new Vector();
        Hashtable unUsableJars = new Hashtable();
        OiixJarModifierPool p = OiixJarModifierPool.getJarModifierPool();
        OiiiStageCompInvEntry cie = (OiiiStageCompInvEntry)this.findMatchingEntry(cid, platforms, usedDirs, unUsableJars);
        if (cie != null && (jarName = cie.getJarName()) != null && (ip = p.get(jarPath = this.m_areaRoot + "/" + jarName)).getEntryCount() < 2000) {
            return jarName;
        }
        boolean startCount = true;
        String installJar = "";
        String installJarPrefix = INSTALL_JAR_PREFIX;
        String installJarPath = installJar;
        int runCount = 0;
        while (true) {
            OiixJarModifier ip2;
            File f;
            installJar = installJarPrefix + runCount + ".jar";
            installJarPath = this.m_areaRoot + "/" + installJar;
            if ((p.containsJar(installJarPath) || !(f = new File(installJarPath)).exists()) && (ip2 = p.get(installJarPath)).getEntryCount() < 2000) break;
            ++runCount;
        }
        return installJar;
    }

    private OiiiCompInvEntry findMatchingEntry(OiiiCompInstallID cid, Vector platforms, Vector usedDirs, Hashtable unUsableJars) {
        OiiiCompInvEntry matchingEntry = null;
        Vector compEntries = this.m_areaInv.getCompInvEntries(cid.getName(), cid.getVersion(), 0);
        Enumeration enum_1 = compEntries.elements();
        while (enum_1.hasMoreElements()) {
            int dirNum;
            String jarName;
            OiiiCompInvEntry cie = (OiiiCompInvEntry)enum_1.nextElement();
            String location = cie.getLocation();
            if (cie.getCompInstallID().equals(cid) && !this.genSeparateLoc(cie, platforms)) {
                matchingEntry = cie;
            }
            if (matchingEntry == null && cie instanceof OiiiStageCompInvEntry && (jarName = ((OiiiStageCompInvEntry)cie).getJarName()) != null) {
                unUsableJars.put(jarName, jarName);
            }
            String dir = OiixPathOps.getFileName(OiixPathOps.getParentDir(location));
            try {
                dirNum = Integer.parseInt(dir);
            }
            catch (NumberFormatException nfe) {
                dirNum = 0;
            }
            if (dirNum == 0) continue;
            usedDirs.addElement(new Integer(dirNum));
        }
        return matchingEntry;
    }

    public String genCompInstallLocation(OiiiCompInstallID cid, Vector platforms) throws IOException {
        return this.genCompInstallLocation(cid, platforms, true);
    }

    public String genCompInstallLocation(OiiiCompInstallID cid, Vector platforms, boolean bCreateDirs) throws IOException {
        String retLoc;
        File dirFile;
        String compName = cid.getName();
        OiiiVersion version = cid.getVersion();
        Vector compEntries = this.m_areaInv.getCompInvEntries(compName, version, 0);
        Vector<Integer> usedDirs = new Vector<Integer>();
        Enumeration enum_1 = compEntries.elements();
        while (enum_1.hasMoreElements()) {
            int dirNum;
            OiiiCompInvEntry cie = (OiiiCompInvEntry)enum_1.nextElement();
            String location = cie.getLocation();
            if (cie.getCompInstallID().equals(cid) && !this.genSeparateLoc(cie, platforms)) {
                return location;
            }
            String dir = OiixPathOps.getFileName(OiixPathOps.getParentDir(location));
            try {
                dirNum = Integer.parseInt(dir);
            }
            catch (NumberFormatException nfe) {
                dirNum = 0;
            }
            if (dirNum == 0) continue;
            usedDirs.addElement(new Integer(dirNum));
        }
        String initLoc = OiiiTargetAreaControl.getCollectionDir(cid.getCompType()) + '/' + this.genLocation(compName) + '/' + version.toString() + '/';
        int num = 1;
        while (usedDirs.contains(new Integer(num)) || (dirFile = new File(OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.m_areaRoot, retLoc = initLoc + num + '/')))).exists()) {
            ++num;
        }
        if (bCreateDirs) {
            OiixFileOps.mkdirs(dirFile);
        }
        if (bCreateDirs && !dirFile.exists()) {
            Object[] msgArr = new String[]{dirFile.getPath()};
            throw new IOException(MessageFormat.format(OiixResourceBundle.getString("S_ERROR_CREAT_DIR"), msgArr));
        }
        return retLoc;
    }

    protected static String getCollectionDir(int cidType) {
        switch (cidType) {
            case 1: {
                return COMPONENTS_LOC;
            }
            case 2: {
                return PATCHES_LOC;
            }
            case 4: {
                return PATCHSETS_LOC;
            }
        }
        return "Error";
    }

    public static String genCompHelpLocation(String sCompInsLocation) {
        sCompInsLocation = OiixPathOps.getStandardForm(sCompInsLocation);
        sCompInsLocation = OiixPathOps.directorify(sCompInsLocation);
        String helpLoc = sCompInsLocation + HELP_LOC + "/";
        return helpLoc;
    }

    public static String genGropsLocation(String sCompInsLocation) {
        String sCompLoc = sCompInsLocation;
        sCompLoc = OiixPathOps.getStandardForm(sCompLoc);
        sCompLoc = OiixPathOps.directorify(sCompLoc);
        String sLocation = sCompLoc + DATAFILES_LOC + '/';
        return sLocation;
    }

    public static String getDefaultDiskLocation(String pjarLocation, int nDisk) {
        String sJarLocation = OiixPathOps.getStandardForm(pjarLocation);
        if (nDisk > 1) {
            sJarLocation = OiixPathOps.concatPath(sJarLocation, "../../") + DISK_LOC + nDisk + '/' + STAGE_LOC + '/';
        }
        return sJarLocation;
    }

    public static String genDataFilesLocation(String sCompInsLocation, int nDisk) {
        String sCompLoc = sCompInsLocation;
        String sDisk = OiiiTargetAreaControl.getDefaultDiskLocation("", nDisk);
        sCompLoc = OiixPathOps.directorify(sCompLoc);
        String sLocation = sDisk + sCompLoc + DATAFILES_LOC + '/';
        return sLocation;
    }

    public static String genExpandedDataFilesLocation(String sCompInsLocation, int nDisk) {
        String sLocation = OiiiTargetAreaControl.genDataFilesLocation(sCompInsLocation, nDisk) + EXPANDED_LOC + '/';
        return sLocation;
    }

    public static String genStageLocation(String sCompRoot) {
        String sCompRootLocation = OiixPathOps.getStandardForm(sCompRoot);
        String sLocation = (sCompRootLocation = OiixPathOps.directorify(sCompRootLocation)) + DISK_LOC + 1 + '/' + STAGE_LOC + '/';
        String sProdJar = sLocation + PRODUCTS_XML_FILENAME;
        File f = new File(sProdJar);
        if (!f.exists() && (f = new File(sProdJar = sCompRootLocation + PRODUCTS_XML_FILENAME)).exists()) {
            sLocation = sCompRootLocation;
        }
        return sLocation;
    }

    public static int getTotalDisks(OiiiAreaInventory areaInv) {
        int nDisk = -1;
        if (areaInv instanceof OiiiStageInventory) {
            Vector vAllComps = areaInv.getAllCompsVect(0);
            int nSize = vAllComps.size();
            for (int i = 0; i < nSize; ++i) {
                OiiiStageCompInvEntry oComp = (OiiiStageCompInvEntry)vAllComps.elementAt(i);
                if (oComp.getDiskNumber() <= nDisk) continue;
                nDisk = oComp.getDiskNumber();
            }
        }
        return nDisk;
    }

    public int getDiskNumber(OiiiCompInstallID cid, Vector plat) {
        int nDisk = -1;
        if (this.m_areaInv instanceof OiiiStageInventory) {
            String compName = cid.getName();
            OiiiVersion version = cid.getVersion();
            Vector compEntries = this.m_areaInv.getCompInvEntries(compName, version, 0);
            int nComps = compEntries.size();
            for (int i = 0; i < nComps; ++i) {
                OiiiCompInvEntry oComp = (OiiiCompInvEntry)compEntries.elementAt(i);
                if (!oComp.getCompInstallID().equalsWithPlatInt(cid) || !OiixVectorOps.checkIntersection(oComp.getPlatforms(), plat)) continue;
                nDisk = ((OiiiStageCompInvEntry)oComp).getDiskNumber();
                break;
            }
            if (nDisk == -1) {
                nDisk = OiiiTargetAreaControl.getTotalDisks(this.m_areaInv);
            }
            if (nDisk == -1) {
                nDisk = 1;
            }
        }
        return nDisk;
    }

    public String genLibLocation(OiiiLibraryID lid, int libType) throws IOException {
        String retLoc;
        File dirFile;
        OiiiLibInvEntry lEntry = this.m_areaInv.getLibInvEntry(lid, libType);
        if (lEntry != null) {
            return OiixPathOps.getParentDir(lEntry.getLocation());
        }
        String libName = lid.getName();
        OiiiVersion version = lid.getVersion();
        Vector libEntries = this.m_areaInv.getLibInvEntries(libName, version, libType);
        int num = this.genLibDirNum(libEntries);
        String initLoc = LIBS_LOC[libType] + '/' + this.genLocation(libName) + '/' + version.toString() + '/';
        while ((dirFile = new File(OiixPathOps.getNativeForm(this.genLibLoc(retLoc = initLoc + num + '/')))).exists()) {
            ++num;
        }
        OiixFileOps.mkdirs(dirFile);
        if (!dirFile.exists()) {
            Object[] msgArr = new String[]{dirFile.getPath()};
            throw new IOException(MessageFormat.format(OiixResourceBundle.getString("S_ERROR_CREAT_DIR"), msgArr));
        }
        return retLoc;
    }

    private int genLibDirNum(Vector libEntries) {
        int num = 0;
        Enumeration enum_1 = libEntries.elements();
        while (enum_1.hasMoreElements()) {
            int dirNum;
            OiiiLibInvEntry lie = (OiiiLibInvEntry)enum_1.nextElement();
            String location = lie.getLocation();
            String dir = OiixPathOps.getFileName(location);
            try {
                dirNum = Integer.parseInt(dir);
            }
            catch (NumberFormatException nfe) {
                dirNum = 0;
            }
            if (num >= dirNum) continue;
            num = dirNum;
        }
        return ++num;
    }

    public static String getDiskLocation(String sRoot, String sLabel, int nDisk, OiiiIDiskValidator diskValidator) throws OiiiDiskNotFoundException {
        String sLocation = sRoot;
        if (sLabel != null) {
            sLocation = diskValidator.getDiskLocation(sRoot, sLabel, nDisk);
        }
        return sLocation;
    }

    public static boolean isValidDisk(String location, String sLabel, int nDiskNumber) {
        OiiiCdLabel labelFile = new OiiiCdLabel();
        try {
            labelFile.readLabelFile(location);
        }
        catch (Exception e) {
            boolean bl = false;
        }
        boolean retVal = labelFile.equals(sLabel, nDiskNumber);
        return retVal;
    }
}

