/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarModifier;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiTargetAreaMap {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    private Vector m_dirNames;
    private HashMap m_oJarMap;
    private String m_sStageLoc;
    private int m_nInstallUnits = 0;
    private Locale[] m_aoLocales;

    public OiiiTargetAreaMap() {
        this.init();
    }

    void setStageLoc(String sStageLoc) {
        this.m_sStageLoc = sStageLoc;
    }

    private void init() {
        if (this.m_dirNames == null) {
            this.m_dirNames = new Vector();
        } else {
            this.m_dirNames.removeAllElements();
        }
        if (this.m_oJarMap == null) {
            this.m_oJarMap = new HashMap();
        } else {
            this.m_oJarMap.clear();
        }
        this.m_aoLocales = OiixLanguage.getLanguages();
    }

    private void addDir(String name) {
        if (OiixVectorOps.vectIndexOf(this.m_dirNames, (Object)(name = OiixPathOps.directorify(name))) == -1) {
            this.m_dirNames.addElement(name);
        }
    }

    private boolean existsDir(String name) {
        String myname = OiixPathOps.directorify(name);
        return OiixVectorOps.vectIndexOf(this.m_dirNames, (Object)myname) != -1;
    }

    private boolean startsWithDir(String name) {
        String myName = OiixPathOps.directorify(name);
        int nSize = this.m_dirNames.size();
        for (int i = 0; i < nSize; ++i) {
            String dirName = (String)this.m_dirNames.elementAt(i);
            if (!dirName.startsWith(myName)) continue;
            return true;
        }
        return false;
    }

    private void removeDirsUsedByComp(OiiiCompInvEntry cie, String sJarPath) {
        HashMap oDirMap = (HashMap)this.m_oJarMap.get(sJarPath);
        String sPackageNameDir = OiiiTargetAreaControl.genPackageNameDir(cie.getCompInstallID());
        sPackageNameDir = OiixPathOps.directorify(sPackageNameDir);
        oDirMap.remove(sPackageNameDir);
        OiisCompProperties oProps = cie.getCompProperties();
        OiisCompJarInfo oCompJarInfo = oProps.getCompJarInfo();
        String sHelpDir = oCompJarInfo.getHelpDir();
        sHelpDir = OiixPathOps.directorify(sHelpDir);
        oDirMap.remove(sHelpDir);
        for (int i = 0; i < this.m_aoLocales.length; ++i) {
            String sDir = OiixPathOps.directorify(OiixPathOps.concatPath(sHelpDir, this.m_aoLocales[i].toString()));
            oDirMap.remove(sDir);
        }
        String sResourceClass = oCompJarInfo.getResourcesClass();
        String sResourceEntry = sResourceClass.replace('.', '/');
        int nLastPos = sResourceEntry.lastIndexOf(47);
        String sResourceDir = OiixPathOps.directorify(sResourceEntry.substring(0, nLastPos + 1));
        oDirMap.remove(sResourceDir);
    }

    private HashMap getJarMap(String sJarName) {
        if (!this.m_oJarMap.containsKey(sJarName)) {
            this.addJarToMap(sJarName);
        }
        return (HashMap)this.m_oJarMap.get(sJarName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addJarToMap(String sJarName) {
        HashMap<String, ArrayList> oDirMap = new HashMap<String, ArrayList>();
        ZipFile zf = null;
        try {
            try {
                zf = new ZipFile(sJarName);
                Enumeration<? extends ZipEntry> enum_1 = zf.entries();
                while (enum_1.hasMoreElements()) {
                    ZipEntry ze = enum_1.nextElement();
                    if (ze.isDirectory()) continue;
                    String sEntryName = ze.getName();
                    String sDir = OiixPathOps.getParentDir(sEntryName);
                    sDir = sDir == null ? "/" : OiixPathOps.directorify(sDir);
                    ArrayList vFiles = null;
                    if (!oDirMap.containsKey(sDir)) {
                        vFiles = new ArrayList();
                        oDirMap.put(sDir, vFiles);
                    } else {
                        vFiles = (ArrayList)oDirMap.get(sDir);
                    }
                    vFiles.add(sEntryName);
                }
                this.m_oJarMap.put(sJarName, oDirMap);
                Object var10_10 = null;
                if (zf == null) return;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (zf == null) throw throwable;
                zf.close();
                throw throwable;
            }
            zf.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void removeFilesUsedByComp(OiiiCompInvEntry cie, String sJarPath) {
        HashMap oDirMap = (HashMap)this.m_oJarMap.get(sJarPath);
        String[] asFiles = new String[2];
        OiisCompProperties oProps = cie.getCompProperties();
        OiisCompJarInfo oCompJarInfo = oProps.getCompJarInfo();
        String sResBundle = oCompJarInfo.getResourceBundleClass();
        if (sResBundle == null) {
            sResBundle = "oracle.sysman.oii.oiix.OiixBaseResourceBundle";
        }
        asFiles[0] = sResBundle = sResBundle.replace('.', '/') + ".class";
        asFiles[1] = "compHlp.class";
        for (int i = 0; i < asFiles.length; ++i) {
            String sDir = OiixPathOps.getParentDir(asFiles[i]);
            sDir = sDir == null ? "/" : OiixPathOps.directorify(sDir);
            ArrayList vFiles = (ArrayList)oDirMap.get(sDir);
            if (vFiles == null) continue;
            int index = vFiles.indexOf(asFiles[i]);
            if (index != -1) {
                vFiles.remove(index);
            }
            if (vFiles.size() != 0) continue;
            oDirMap.remove(sDir);
        }
    }

    public void buildInternal(OiiiAreaInventory areaInv, boolean bComps) {
        int i;
        this.init();
        if (bComps) {
            int numOhs = areaInv.getNumOHs();
            for (i = 0; i < numOhs; ++i) {
                Vector comps = areaInv.getAllCompsVect(i);
                this.m_nInstallUnits = comps.size();
                for (int j = 0; j < this.m_nInstallUnits; ++j) {
                    OiiiStageCompInvEntry scie;
                    OiiiCompInvEntry cie = (OiiiCompInvEntry)comps.elementAt(j);
                    this.addDir(OiixPathOps.getStandardForm(cie.getLocation()));
                    if (!(cie instanceof OiiiStageCompInvEntry) || (scie = (OiiiStageCompInvEntry)cie).isMinInstVersionPreX("2.0")) continue;
                    String sJarName = scie.getJarName();
                    String sJarPath = OiixPathOps.concatPath(this.m_sStageLoc, sJarName);
                    HashMap oDirMap = this.getJarMap(sJarPath);
                    this.removeFilesUsedByComp(scie, sJarPath);
                    this.removeDirsUsedByComp(scie, sJarPath);
                }
            }
        }
        String[] libDirs = OiiiTargetAreaControl.LIBS_LOC;
        for (i = 0; i < 3; ++i) {
            Vector libs = areaInv.getAllLibsVect(i);
            int numLibs = libs.size();
            for (int j = 0; j < numLibs; ++j) {
                OiiiLibInvEntry lie = (OiiiLibInvEntry)libs.elementAt(j);
                String addPath = OiixPathOps.getStandardForm(lie.getLocation());
                int pathStart = addPath.indexOf(libDirs[i]);
                this.addDir(addPath.substring(pathStart));
            }
        }
    }

    public void buildInternalHomeStage(List lstComps) {
        this.init();
        this.m_nInstallUnits = lstComps.size();
        for (int j = 0; j < this.m_nInstallUnits; ++j) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)lstComps.get(j);
            if (cie instanceof OiiiInstallPatchSetInvEntry) continue;
            this.addDir(OiixPathOps.getStandardForm(cie.getLocation()));
            String sJarName = cie.getJarName();
            String sJarPath = OiixPathOps.concatPath(this.m_sStageLoc, sJarName);
            HashMap oDirMap = this.getJarMap(sJarPath);
            this.removeFilesUsedByComp(cie, sJarPath);
            this.removeDirsUsedByComp(cie, sJarPath);
        }
    }

    public void removeExtraInstallDefnJars() {
        Vector vInstallJarList = this.getInstallJarsInStage(this.m_sStageLoc);
        int nInstallJarSize = vInstallJarList.size();
        for (int i = 0; i < nInstallJarSize; ++i) {
            File f;
            String sFileName = (String)vInstallJarList.elementAt(i);
            String sFilePath = OiixPathOps.concatPath(this.m_sStageLoc, sFileName);
            if (!this.m_oJarMap.containsKey(sFilePath) && !(f = new File(sFilePath = OiixPathOps.getNativeForm(sFilePath))).delete()) continue;
        }
        Set oJars = this.m_oJarMap.keySet();
        Object[] asJarNames = oJars.toArray();
        for (int k = 0; k < asJarNames.length; ++k) {
            String sJarName = (String)asJarNames[k];
            File f = new File(sJarName);
            if (!f.exists()) continue;
            f = null;
            OiixJarModifier oJarModifier = new OiixJarModifier(sJarName);
            try {
                oJarModifier.setState(1);
                HashMap oDirMap = (HashMap)this.m_oJarMap.get(sJarName);
                Collection collDirs = oDirMap.values();
                Object[] alFiles = collDirs.toArray();
                for (int i = 0; i < alFiles.length; ++i) {
                    ArrayList vFiles = (ArrayList)alFiles[i];
                    for (int j = 0; j < vFiles.size(); ++j) {
                        String sEntry = (String)vFiles.get(j);
                        try {
                            oJarModifier.removeEntry(sEntry);
                            continue;
                        }
                        catch (OiixJarModifyException e) {
                            System.err.println(e.getMessage());
                        }
                    }
                }
                oJarModifier.setState(2);
                continue;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                continue;
            }
            catch (OiifbCancelException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private Vector getInstallJarsInStage(String sAreaRoot) {
        Vector<String> vFiles = new Vector<String>();
        File f = new File(sAreaRoot);
        if (f.exists() && f.isDirectory()) {
            String[] sFiles = f.list();
            String sInstall = "install";
            String sJar = ".jar";
            for (int i = 0; i < sFiles.length; ++i) {
                if (!sFiles[i].startsWith(sInstall) || !sFiles[i].endsWith(sJar)) continue;
                String s = sFiles[i].substring(sInstall.length(), sFiles[i].length() - sJar.length());
                try {
                    new Integer(s);
                    vFiles.addElement(sFiles[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        f = null;
        return vFiles;
    }

    public void removeExtraCompDirs(String logLoc) {
        File areaDir = new File(OiixPathOps.getNativeForm(logLoc));
        String areaPath = areaDir.getPath();
        areaPath = OiixPathOps.directorify(areaPath);
        areaPath = OiixPathOps.getNativeForm(areaPath);
        int areaPathLen = areaPath.length();
        String[] dirs = new String[]{"Components", "Patches", "PatchSets"};
        for (int i = 0; i < dirs.length; ++i) {
            File invSubDir = new File(areaDir, dirs[i]);
            if (!invSubDir.exists()) continue;
            this.removeUnusedDirsBelow(areaPathLen, invSubDir);
        }
        if (this.m_nInstallUnits == 0) {
            File f = new File(OiixPathOps.concatPath(areaPath, "disk.label"));
            f.delete();
            f = new File(OiixPathOps.concatPath(areaPath, "products.xml"));
            f.delete();
        }
    }

    public void removeExtraCompDirsForHome(int homeIndex) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        Vector comps = instInv.getAllCompsVect(homeIndex);
        Vector<String> usedDirs = new Vector<String>(comps.size());
        for (int i = 0; i < comps.size(); ++i) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)comps.elementAt(i);
            String sXMLLoc = invEntry.getLocationInXMLInventory();
            sXMLLoc = OiixPathOps.directorify(sXMLLoc);
            sXMLLoc = OiixPathOps.getStandardForm(sXMLLoc);
            usedDirs.addElement(sXMLLoc);
            sXMLLoc = OiixPathOps.concatPath(sXMLLoc, "resources");
            sXMLLoc = OiixPathOps.directorify(sXMLLoc);
            sXMLLoc = OiixPathOps.getStandardForm(sXMLLoc);
            usedDirs.addElement(sXMLLoc);
        }
        this.m_dirNames = usedDirs;
        String[] dirs = new String[]{"Components21", "Patches21", "PatchSets21"};
        for (int i = 0; i < dirs.length; ++i) {
            String sHomeInvLoc = iac.getInventoryLocForHome(homeIndex);
            File fInvDir = new File(sHomeInvLoc);
            if (!fInvDir.exists()) {
                return;
            }
            sHomeInvLoc = OiixPathOps.directorify(sHomeInvLoc);
            File fCompsDir = new File(sHomeInvLoc = OiixPathOps.getNativeForm(sHomeInvLoc), dirs[i]);
            if (!fCompsDir.exists()) continue;
            this.removeUnusedDirsBelow(sHomeInvLoc.length(), fCompsDir);
        }
    }

    public void removeScriptsDirs(String scriptsLoc) {
        String sScriptsDir = OiixPathOps.getNativeForm(scriptsLoc);
        File f = new File(sScriptsDir);
        if (f.exists()) {
            OiiolTextLogger.appendText("recDelete: " + sScriptsDir);
            OiixFileOps.recdelete(f);
        }
    }

    public void removeExtraLibDirs(String libLoc) {
        File areaDir = new File(OiixPathOps.getNativeForm(libLoc));
        String areaPath = areaDir.getPath();
        areaPath = OiixPathOps.directorify(areaPath);
        areaPath = OiixPathOps.getNativeForm(areaPath);
        int areaPathLen = areaPath.length();
        String[] dirs = OiiiTargetAreaControl.LIBS_LOC;
        for (int i = 0; i < dirs.length; ++i) {
            File invSubDir = new File(areaDir, dirs[i]);
            if (!invSubDir.exists()) continue;
            this.removeUnusedDirsBelow(areaPathLen, invSubDir);
        }
    }

    public void removeUnusedDirsBelow(int areaPathLen, File invSubDir) {
        String[] dirConts = invSubDir.list();
        for (int i = 0; i < dirConts.length; ++i) {
            File subDir = new File(invSubDir, dirConts[i]);
            if (!subDir.isDirectory()) continue;
            String dirPath = subDir.getPath().substring(areaPathLen);
            if (this.existsDir(dirPath = OiixPathOps.getStandardForm(dirPath))) continue;
            if (!this.startsWithDir(dirPath)) {
                OiiolTextLogger.appendText("recDelete: " + subDir.getPath());
                OiixFileOps.recdelete(subDir);
                continue;
            }
            this.removeUnusedDirsBelow(areaPathLen, subDir);
        }
        if (invSubDir.list().length == 0) {
            invSubDir.delete();
        }
    }
}

