/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import oracle.sysman.oii.oiij.OiijDefaultJarListXMLHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiijDefaultJarListReader {
    private String m_sListLocation;
    private OiijDefaultJarListXMLHandler m_handler = null;

    public OiijDefaultJarListReader(String sListLocation) {
        this.m_sListLocation = sListLocation;
    }

    public void readList() throws IOException {
        try {
            FileReader fReader = new FileReader(this.m_sListLocation);
            BufferedReader bReader = new BufferedReader(fReader);
            Parser parser = OixsXMLOps.createSAXParser();
            try {
                this.m_handler = new OiijDefaultJarListXMLHandler();
                parser.setDocumentHandler(this.m_handler);
                parser.setErrorHandler(this.m_handler);
                parser.parse(new InputSource(bReader));
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            bReader.close();
            fReader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Iterator iterator() {
        return this.m_handler.iterator();
    }

    public int getListSize() {
        return this.m_handler.getListSize();
    }

    Iterator compIterator() {
        return this.m_handler.compIterator();
    }

    Iterator patchIterator() {
        return this.m_handler.patchIterator();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("List  Location :" + args[0]);
        OiijDefaultJarListReader ojr = new OiijDefaultJarListReader(args[0]);
        ojr.readList();
        Iterator itr = ojr.iterator();
        Object sJarLoc = null;
        while (itr.hasNext()) {
            System.out.println("Jar to extract is :" + (String)itr.next());
        }
    }
}

