/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiij.OiijFastCopyCompInfo;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OiijFastCopyExpandedFiles {
    private String m_sListLocation;
    private HashMap m_hmFiles;
    private LinkedList m_lCompInfo;
    private LinkedList m_lPatchInfo;

    public OiijFastCopyExpandedFiles(String sListLocation) {
        this.m_sListLocation = sListLocation;
        this.m_lCompInfo = new LinkedList();
        this.m_lPatchInfo = new LinkedList();
        this.processExpList();
    }

    private void processExpList() {
        boolean bError = false;
        try {
            int idx = 0;
            Document doc = OixdDOMReader.getDocument(this.m_sListLocation);
            XMLElement elFileList = (XMLElement)doc.getDocumentElement();
            NodeList nlComps = elFileList.getElementsByTagName("COMP");
            int nComps = nlComps.getLength();
            for (idx = 0; idx < nComps; ++idx) {
                XMLElement el = (XMLElement)nlComps.item(idx);
                this.processCompElement(el, true);
            }
            NodeList nlPatches = elFileList.getElementsByTagName("PATCH");
            int nPatches = nlPatches.getLength();
            for (idx = 0; idx < nPatches; ++idx) {
                XMLElement el = (XMLElement)nlPatches.item(idx);
                this.processCompElement(el, false);
            }
        }
        catch (IOException ioe) {
            bError = true;
        }
        catch (SAXException se) {
            bError = true;
        }
        catch (ParserConfigurationException pe) {
            bError = true;
        }
        catch (Exception e) {
            bError = true;
        }
        if (bError) {
            this.m_hmFiles = new HashMap();
        }
    }

    private void processCompElement(XMLElement el, boolean isComp) {
        NodeList nlFiles = el.getElementsByTagName("FILE");
        int nLen = nlFiles.getLength();
        String sName = el.getAttribute("NAME");
        String sVer = el.getAttribute("VERSION");
        OiijFastCopyCompInfo oCompInfo = new OiijFastCopyCompInfo(sName, sVer);
        for (int i = 0; i < nLen; ++i) {
            XMLElement elFile = (XMLElement)nlFiles.item(i);
            this.processFileElement(elFile, oCompInfo);
        }
        if (isComp) {
            this.m_lCompInfo.add(oCompInfo);
        } else {
            this.m_lPatchInfo.add(oCompInfo);
        }
    }

    private void processFileElement(XMLElement elFile, OiijFastCopyCompInfo oCompInfo) {
        XMLElement elSource = (XMLElement)elFile.getElementsByTagName("SOURCE").item(0);
        XMLElement elDest = (XMLElement)elFile.getElementsByTagName("DEST").item(0);
        String sSource = this.getElementValue(elSource);
        String sDest = this.getElementValue(elDest);
        oCompInfo.addExpandedFile(sSource, sDest);
    }

    private String getElementValue(XMLElement el) {
        return el.getText().trim();
    }

    HashMap getFiles() {
        return this.m_hmFiles;
    }

    void addCompInfo(OiijFastCopyCompInfo oCompInfo) {
        this.m_lCompInfo.add(oCompInfo);
    }

    void addPatchInfo(OiijFastCopyCompInfo oPatchInfo) {
        this.m_lPatchInfo.add(oPatchInfo);
    }

    Iterator compIterator() {
        return this.m_lCompInfo.iterator();
    }

    Iterator patchIterator() {
        return this.m_lPatchInfo.iterator();
    }
}

