/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InterruptedIOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;

public class OiijFastJarExtracter {
    private int m_nBuffSize;
    private byte[] _buffer = null;
    private String m_sJarLocation;
    private String m_sTargetLocation;
    private OiiofFileLoader m_oFileLoader;
    private OiixProgressListener m_progressListener;
    private boolean m_bCreateDirs;
    private static boolean m_bTraceMode = OiiolTextLogger.getLogLevel() == OiiolTextLogger.LOG_TRACE;

    public OiijFastJarExtracter(String sJarLocation, String sTargetLocation, boolean bCreateDirs) {
        this.m_sJarLocation = sJarLocation;
        this.m_sTargetLocation = sTargetLocation;
        this.m_bCreateDirs = bCreateDirs;
    }

    public void setBufferInfo(byte[] buffer, int nBuffSize) {
        this._buffer = buffer;
        this.m_nBuffSize = nBuffSize;
    }

    public void setProgressListener(OiixProgressListener progressListener) {
        this.m_progressListener = progressListener;
    }

    void extract() throws InterruptedIOException, ZipException {
        String sJarLocation = this.m_sJarLocation;
        sJarLocation = this.m_oFileLoader.fetchDefaultJarToLocal(this.m_sJarLocation);
        this.copyJarContents(sJarLocation);
        if (!sJarLocation.equals(this.m_sJarLocation)) {
            File f = new File(sJarLocation);
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJarContents(String sJarLocation) throws InterruptedIOException, ZipException {
        int nSize = 0;
        ZipInputStream zin = null;
        long lTime = System.currentTimeMillis();
        try {
            zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(sJarLocation), 8192));
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                String sourceFile = ze.getName();
                lTime = ze.getTime();
                String destFile = null;
                destFile = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.m_sTargetLocation, sourceFile));
                if (!ze.isDirectory()) {
                    int i;
                    if (this.m_bCreateDirs) {
                        this.createDirForDest(destFile);
                    }
                    if (OiixPlatform.getCurrentPlatform() == 2 || OiixPlatform.getCurrentPlatform() == 197) {
                        System.setProperty("oracle.installer.explicitLibPerms", "true");
                    }
                    String perms = OiixFileOps.getExplicitLibPerms();
                    String[] extns = OiixFileOps.getExplicitLibExtns();
                    if (Boolean.getBoolean("oracle.installer.explicitLibPerms") && extns != null && extns.length > 0 && perms != null && perms != "") {
                        for (i = 0; i < extns.length; ++i) {
                            if (destFile.indexOf(extns[i]) == -1) continue;
                            File f = new File(destFile);
                            if (f.exists()) {
                                f.delete();
                            }
                            f = null;
                            break;
                        }
                    }
                    this.copyFileFromJar(zin, destFile);
                    if (Boolean.getBoolean("oracle.installer.explicitLibPerms") && extns != null && extns.length > 0 && perms != null && perms != "") {
                        for (i = 0; i < extns.length; ++i) {
                            if (destFile.indexOf(extns[i]) == -1) continue;
                            OiixFileOps.changePermissions(destFile, perms);
                            break;
                        }
                    }
                    if (m_bTraceMode) {
                        OiiolTextLogger.appendText("Extracting " + sourceFile + " to " + destFile, OiiolTextLogger.LOG_TRACE);
                    }
                    nSize += (int)ze.getSize();
                    OiixFileOps.setFileTime(destFile, lTime);
                    zin.closeEntry();
                    continue;
                }
                File fDir = new File(destFile);
                OiixFileOps.mkdirs(fDir);
            }
            if (zin != null) {
                zin.close();
            }
        }
        catch (InterruptedIOException e1) {
            throw e1;
        }
        catch (ZipException e2) {
            throw e2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.m_progressListener != null) {
            OiixProgressListener oiixProgressListener = this.m_progressListener;
            synchronized (oiixProgressListener) {
                this.m_progressListener.addBytes(nSize);
            }
        }
    }

    private void copyFileFromJar(ZipInputStream zin, String destFile) throws InterruptedIOException, ZipException {
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(destFile));
            OiixFileOps.copyStream(zin, fos, destFile, false, null, true, this._buffer, this.m_nBuffSize);
            fos.close();
        }
        catch (InterruptedIOException e1) {
            throw e1;
        }
        catch (ZipException e2) {
            throw e2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createDirForDest(String filename) {
        File f = new File(filename);
        File ff = new File(f.getParent());
        OiixFileOps.mkdirs(ff);
    }

    public void setFileLoader(OiiofFileLoader oFileLoader) {
        this.m_oFileLoader = oFileLoader;
    }
}

