/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.sysman.oii.oiij.OiijFastCopyCompInfo;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsTextElementHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiijFileListXMLHandler
extends OixsDefaultHandler {
    private OixsElementHandler m_handlerFileList;
    private OixsElementHandler m_handlerFileGroup;
    private OiijFileListFileHandler m_handlerFile;
    private OiijCompFileListHandler m_handlerComp;
    private OiijPatchFileListHandler m_handlerPatch;
    private LinkedList m_queue;
    private boolean m_bUseFileGroup;
    private OiijFastCopyCompInfo m_curCompInfo;
    private LinkedList m_lCompInfo;
    private LinkedList m_lPatchInfo;

    public OiijFileListXMLHandler(boolean bUseFileGroup) throws SAXException {
        this.m_bUseFileGroup = bUseFileGroup;
        if (!bUseFileGroup) {
            this.m_lCompInfo = new LinkedList();
            this.m_lPatchInfo = new LinkedList();
        }
        this.addChildHandlers();
    }

    public void startDocument() throws SAXException {
        this.m_queue = new LinkedList();
    }

    private void addToFileList(String sLoc) {
        if (this.m_bUseFileGroup) {
            this.m_queue.addLast(sLoc.trim());
        } else {
            this.m_curCompInfo.addDefaultJar(sLoc.trim());
        }
    }

    public int getListSize() {
        return this.m_queue.size();
    }

    public Iterator iterator() {
        return this.m_queue.iterator();
    }

    protected OixsElementHandler createElementHandlers() {
        this.m_handlerFileList = new OixsElementHandler("FILE_LIST");
        return this.m_handlerFileList;
    }

    private void addChildHandlers() {
        if (this.m_bUseFileGroup) {
            this.m_handlerFileGroup = new OixsElementHandler("FILEGROUP");
        } else {
            this.m_handlerComp = new OiijCompFileListHandler("COMP");
            this.m_handlerPatch = new OiijPatchFileListHandler("PATCH");
        }
        this.m_handlerFile = new OiijFileListFileHandler("FILE");
        if (this.m_bUseFileGroup) {
            this.m_handlerFileGroup.addChildHandler("FILE", this.m_handlerFile);
            this.m_handlerFileList.addChildHandler("FILEGROUP", this.m_handlerFileGroup);
        } else {
            this.m_handlerComp.addChildHandler("FILE", this.m_handlerFile);
            this.m_handlerPatch.addChildHandler("FILE", this.m_handlerFile);
            this.m_handlerFileList.addChildHandler("COMP", this.m_handlerComp);
            this.m_handlerFileList.addChildHandler("PATCH", this.m_handlerPatch);
        }
    }

    public static OiijFileListXMLHandler createHandler(String sListLocation, boolean bUseFileGroup) {
        OiijFileListXMLHandler handler = null;
        try {
            FileReader fReader = new FileReader(sListLocation);
            BufferedReader bReader = new BufferedReader(fReader);
            Parser parser = OixsXMLOps.createSAXParser();
            try {
                handler = new OiijFileListXMLHandler(bUseFileGroup);
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(new InputSource(bReader));
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            bReader.close();
            fReader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return handler;
    }

    void addCompInfo(OiijFastCopyCompInfo oCompInfo) {
        this.m_lCompInfo.add(oCompInfo);
    }

    void addPatchInfo(OiijFastCopyCompInfo oPatchInfo) {
        this.m_lPatchInfo.add(oPatchInfo);
    }

    Iterator compIterator() {
        return this.m_lCompInfo.iterator();
    }

    Iterator patchIterator() {
        return this.m_lPatchInfo.iterator();
    }

    void setCurrentCompInfo(OiijFastCopyCompInfo compInfo) {
        this.m_curCompInfo = compInfo;
    }

    private class OiijPatchFileListHandler
    extends OixsElementHandler {
        private OiijFastCopyCompInfo m_patchInfo;

        public OiijPatchFileListHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sCompName = atts.getValue("NAME");
            String sCompVersion = atts.getValue("VERSION");
            this.m_patchInfo = new OiijFastCopyCompInfo(sCompName, sCompVersion);
            OiijFileListXMLHandler.this.setCurrentCompInfo(this.m_patchInfo);
        }

        public void onEnd(String name) {
            super.onEnd(name);
            OiijFileListXMLHandler.this.addPatchInfo(this.m_patchInfo);
        }
    }

    private class OiijCompFileListHandler
    extends OixsElementHandler {
        private OiijFastCopyCompInfo m_compInfo;

        OiijCompFileListHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
            String sCompName = atts.getValue("NAME");
            String sCompVersion = atts.getValue("VERSION");
            this.m_compInfo = new OiijFastCopyCompInfo(sCompName, sCompVersion);
            OiijFileListXMLHandler.this.setCurrentCompInfo(this.m_compInfo);
        }

        public void onEnd(String name) {
            super.onEnd(name);
            OiijFileListXMLHandler.this.addCompInfo(this.m_compInfo);
        }
    }

    private class OiijFileListFileHandler
    extends OixsTextElementHandler {
        public OiijFileListFileHandler(String name) {
            super(name);
        }

        public void onStart(String name, AttributeList atts) {
            super.onStart(name, atts);
        }

        public void onEnd(String name) {
            super.onEnd(name);
            String sLocation = this.getText();
            OiijFileListXMLHandler.this.addToFileList(sLocation);
        }
    }
}

