/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.MissingResourceException;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.xml.parser.v2.XMLElement;

public class OiilActionArg
implements Serializable {
    static final long serialVersionUID = 5934544505526475614L;
    public static int OiINT = 10;
    public static int OiSTRING = 11;
    public static int OiBOOLEAN = 12;
    public static int OiALL_PLATFORMS = 100;
    public static int OiTHESE_PLATFORMS = 101;
    public static int OiNOT_THESE_PLATFORMS = 102;
    public transient OiixJarResourceBundle m_resBundle;
    boolean m_implicit = false;
    String m_name;
    Class m_type;
    private boolean m_optional;
    int[] m_platforms;
    String m_descID;
    int m_supportedOnPlatforms = OiALL_PLATFORMS;
    String m_internalName;

    public OiilActionArg() {
    }

    public OiilActionArg(String intName, String name) {
        this();
        this.m_internalName = intName;
        this.m_name = name;
    }

    public OiilActionArg(String intName, Class type, String name, String descID, boolean optional) {
        this(intName, name);
        this.m_type = type;
        this.m_descID = descID;
        this.m_optional = optional;
    }

    public OiilActionArg(String intName, Class type, String name, String descID) {
        this(intName, type, name, descID, false);
    }

    public void setBundle(OiixJarResourceBundle rb) {
        this.m_resBundle = rb;
    }

    public void setImplicit(boolean im) {
        this.m_implicit = im;
    }

    public boolean isImplicit() {
        return this.m_implicit;
    }

    public void setOptional(boolean op) {
        this.m_optional = op;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public String getName() throws MissingResourceException {
        return this.m_resBundle.getString(this.m_name);
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public Class getType() {
        return this.m_type;
    }

    public String getDescription() throws MissingResourceException {
        return this.m_resBundle.getString(this.m_descID);
    }

    private int getSupportedOnPlatforms() {
        return this.m_supportedOnPlatforms;
    }

    public boolean isArgumentSupportedOnPlatform(int platform) {
        if (this.getSupportedOnPlatforms() == OiTHESE_PLATFORMS) {
            int size = this.m_platforms.length;
            for (int j = 0; j < size; ++j) {
                if (platform != this.m_platforms[j]) continue;
                return true;
            }
        } else if (this.getSupportedOnPlatforms() == OiALL_PLATFORMS) {
            return true;
        }
        return false;
    }

    public boolean isArgumentSupportedOnAllPlatforms() {
        return this.getSupportedOnPlatforms() == OiALL_PLATFORMS;
    }

    public int[] getPlatforms() {
        if (this.m_supportedOnPlatforms == OiALL_PLATFORMS) {
            return OiixPlatform.getPlatforms();
        }
        if (this.m_supportedOnPlatforms == OiTHESE_PLATFORMS) {
            return this.m_platforms;
        }
        return new int[0];
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setType(Class type) {
        this.m_type = type;
    }

    public void setDescription(String desc) {
        this.m_descID = desc;
    }

    public void setSupportedOnPlatforms(int pt) {
        this.m_supportedOnPlatforms = pt;
    }

    public void setPlatforms(int[] pts) {
        this.m_platforms = pts;
        this.m_supportedOnPlatforms = OiTHESE_PLATFORMS;
    }

    void writeXMLElement(PrintWriter out, boolean bGeneric, int[] actionPlats) throws IOException {
        XMLElement xmlArg = new XMLElement("ARGUMENT");
        xmlArg.setAttribute("NAME", this.m_internalName);
        xmlArg.setAttribute("DESC_ID", this.m_descID);
        xmlArg.setAttribute("EXT_NAME_ID", this.m_name);
        xmlArg.setAttribute("TYPE", this.getType().getName());
        if (!(bGeneric || this.isArgumentSupportedOnAllPlatforms() || OiilXMLHelper.arePlatsSame(actionPlats, this.m_platforms))) {
            xmlArg.setAttribute("PLATS", OiilXMLHelper.platArrToString(this.getPlatforms()));
        }
        xmlArg.setAttribute("IMPLICIT", this.isImplicit() ? "TRUE" : "FALSE");
        xmlArg.setAttribute("OPTIONAL", this.isOptional() ? "TRUE" : "FALSE");
        xmlArg.print(out);
    }
}

