/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;

public class OiilActionInputElement
implements Cloneable,
Serializable,
OixsXMLizable {
    static final long serialVersionUID = 363825610375944304L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 8192;
    private String m_paramName;
    private Object m_obj;
    private boolean m_implicit;
    private boolean m_bSecure;
    private String m_sLogValue;
    private boolean m_bDeinstallPrompt = false;

    public OiilActionInputElement(String paramName, Object obj, boolean bSecure, String sLogValue) {
        this.m_paramName = paramName;
        this.m_obj = obj;
        this.m_implicit = false;
        this.m_bSecure = bSecure;
        this.m_sLogValue = sLogValue;
        if (this.m_sLogValue != null && !this.m_sLogValue.equals("")) {
            this.m_bDeinstallPrompt = true;
        }
    }

    public OiilActionInputElement(String paramName, Object obj, boolean bSecure) {
        this(paramName, obj, bSecure, null);
    }

    public OiilActionInputElement(String paramName, Object obj) {
        this(paramName, obj, false);
    }

    public OiilActionInputElement(String paramName) {
        this(paramName, null);
        this.m_implicit = true;
    }

    public String getParamName() {
        return this.m_paramName;
    }

    public void setParamName(String name) {
        this.m_paramName = name;
    }

    public Object getObject() {
        return this.m_obj;
    }

    public void setObject(Object oVal) {
        this.m_obj = oVal;
    }

    public void setImplicitObject(Object toSet) {
        this.m_obj = toSet;
    }

    public void setImplicit(boolean bImpl) {
        this.m_implicit = bImpl;
    }

    public boolean isImplicit() {
        return this.m_implicit;
    }

    public boolean isSecure() {
        return this.m_bSecure;
    }

    public void setSecure(boolean secure) {
        this.m_bSecure = secure;
    }

    public void setLogValue(String sLogValue) {
        this.m_sLogValue = sLogValue;
    }

    public String getLogValue() {
        return this.m_sLogValue;
    }

    public void setDeinstallPrompt(boolean bDeinstallPrompt) {
        this.m_bDeinstallPrompt = bDeinstallPrompt;
    }

    public boolean isDeinstallPrompt() {
        return this.m_bDeinstallPrompt;
    }

    public boolean needsInputFromUser() {
        String sSecureVal;
        return this.isSecure() && this.m_bDeinstallPrompt && (sSecureVal = this.getLogValue()) != null && sSecureVal.startsWith("%") && sSecureVal.endsWith("%");
    }

    public boolean equals(String name) {
        return this.m_paramName.equals(name);
    }

    public boolean equals(OiilActionInputElement aie) {
        if (aie != null) {
            return this.m_paramName.equals(aie.getParamName()) && this.m_obj.equals(aie.getObject());
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            if (obj instanceof OiilActionInputElement) {
                return this.equals((OiilActionInputElement)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public static Object getNamedParam(Vector inputs, String paramName) {
        int pos = OiixVectorOps.vectIndexOf(inputs, (Object)paramName);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public static Vector addImplicitArg(Vector inputs, Object toSet, String name) {
        int numElems = inputs.size();
        int idx = -1;
        for (int i = 0; i < numElems; ++i) {
            OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(i);
            if (!aie.isImplicit() || !aie.getParamName().equalsIgnoreCase(name)) continue;
            aie.setImplicitObject(toSet);
            idx = i;
            break;
        }
        if (idx == -1) {
            OiilActionInputElement aie = new OiilActionInputElement(name, toSet);
            aie.setImplicit(true);
            inputs.addElement(aie);
        }
        return inputs;
    }

    public static Vector nullImplicitArg(Vector inputs) {
        int numElems = inputs.size();
        for (int i = 0; i < numElems; ++i) {
            OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(i);
            if (!aie.isImplicit()) continue;
            aie.setImplicitObject(null);
        }
        return inputs;
    }

    public String toString() {
        String m_sVal = "";
        if (this.m_obj != null) {
            m_sVal = this.m_obj.toString();
            if (this.m_bSecure) {
                m_sVal = OiixResourceBundle.getString("S_LOG_PROTECTED_VALUE");
            }
        }
        return "[" + this.m_paramName + "=" + m_sVal + "]";
    }

    public void writeXML(PrintWriter p) throws IOException {
        XMLElement elemArg = this.buildDomtree();
        elemArg.print(p);
    }

    public XMLElement toXML() {
        return this.buildDomtree();
    }

    private XMLElement buildDomtree() {
        XMLElement elemArg = new XMLElement("INPUT");
        elemArg.setAttribute("NAME", this.m_paramName);
        String sArgValue = "null";
        String sArgType = "";
        if (this.m_obj != null) {
            sArgType = this.getArgType(this.m_obj);
            sArgValue = this.isSecure() && this.m_sLogValue != null ? this.m_sLogValue : OiisDataTypes.getStringValue(this.m_obj, sArgType);
        }
        elemArg.setAttribute("VAL", sArgValue);
        elemArg.setAttribute("TYPE", sArgType);
        if (this.isSecure()) {
            elemArg.setAttribute("SECURE", "T");
        } else {
            elemArg.setAttribute("SECURE", "F");
        }
        return elemArg;
    }

    private String getArgType(Object obj) {
        if (obj instanceof String) {
            return OiisDataTypes.STRING.getName();
        }
        if (obj instanceof Boolean) {
            return OiisDataTypes.BOOL.getName();
        }
        if (obj instanceof Integer) {
            return OiisDataTypes.NUMBER.getName();
        }
        if (obj instanceof String[]) {
            return OiisDataTypes.STRINGLIST.getName();
        }
        return "Custom";
    }

    public Object clone() {
        OiilActionInputElement clonedElem = null;
        try {
            clonedElem = (OiilActionInputElement)super.clone();
        }
        catch (CloneNotSupportedException ce) {
            ce.printStackTrace();
        }
        return clonedElem;
    }
}

