/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilDlgPropertyInfo;
import oracle.sysman.oii.oiil.OiilLibElemInfo;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;

public class OiilDialogInfo
extends OiilLibElemInfo
implements Serializable {
    static final long serialVersionUID = -7102734261553304789L;
    String description;
    Vector propertyInfo = new Vector(2);
    String className;

    public OiilDialogInfo(String nm, String desc, String clName, OiilDlgPropertyInfo oi) {
        super(nm);
        this.description = desc;
        this.className = clName;
        this.addProperty(oi);
    }

    public OiilDialogInfo(String nm, String desc, String clName) {
        super(nm);
        this.description = desc;
        this.className = clName;
    }

    public void addProperty(OiilDlgPropertyInfo oi) {
        this.propertyInfo.addElement(oi);
    }

    public Enumeration getPropertyInfoList() {
        return this.propertyInfo.elements();
    }

    public int getNumberOfProperties() {
        return this.propertyInfo.size();
    }

    public OiilDlgPropertyInfo getProperty(String name) {
        Enumeration e = this.propertyInfo.elements();
        while (e.hasMoreElements()) {
            OiilDlgPropertyInfo a = (OiilDlgPropertyInfo)e.nextElement();
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public String getDescription() throws MissingResourceException {
        return this.getBundle().getString(this.description);
    }

    public String getDialogClassName() {
        return this.className;
    }

    public synchronized void setBundle(OiixJarResourceBundle rb) {
        super.setBundle(rb);
        int numProps = this.propertyInfo.size();
        for (int i = 0; i < numProps; ++i) {
            OiilDlgPropertyInfo propInfo = (OiilDlgPropertyInfo)this.propertyInfo.elementAt(i);
            propInfo.setBundle(rb);
        }
    }

    void writeXMLElement(PrintWriter out) throws IOException {
        XMLElement xmlDlgInfo = new XMLElement("DIALOG");
        xmlDlgInfo.setAttribute("EXT_NAME_ID", this.m_name);
        xmlDlgInfo.setAttribute("DESC_ID", this.description);
        xmlDlgInfo.setAttribute("ENTRY_POINT", this.className);
        if (this.isDeprecated()) {
            xmlDlgInfo.setAttribute("DEPR", "TRUE");
            if (this.getDeprecatedDescription() != null) {
                xmlDlgInfo.setAttribute("DEPR_ID", this.getDeprecatedDescription());
            }
        }
        int nPropSize = this.propertyInfo.size();
        out.println(OixsXMLOps.getStartTag(xmlDlgInfo));
        XMLElement xmlArgList = new XMLElement("ARGUMENT_LIST");
        out.println(OixsXMLOps.getStartTag(xmlArgList));
        for (int i = 0; i < nPropSize; ++i) {
            OiilDlgPropertyInfo pInfo = (OiilDlgPropertyInfo)this.propertyInfo.elementAt(i);
            pInfo.writeXMLElement(out);
        }
        out.println(OixsXMLOps.getEndTag(xmlArgList));
        out.println(OixsXMLOps.getEndTag(xmlDlgInfo));
    }
}

