/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.MissingResourceException;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.xml.parser.v2.XMLElement;

public class OiilExceptionInfo
implements Serializable {
    static final long serialVersionUID = 107292169794464908L;
    private String exceptionName;
    private String exceptionString;
    private String exceptionIntName;
    private int exceptionSeverity;
    public transient OiixJarResourceBundle resBundle;

    public OiilExceptionInfo(String name, String exString, int severity) {
        this.setExceptionName(name);
        this.setExceptionString(exString);
        this.setExceptionSeverity(severity);
        this.setExceptionIntName(name);
    }

    public OiilExceptionInfo(String name, String exString) {
        this.setExceptionName(name);
        this.setExceptionString(exString);
        this.setExceptionIntName(name);
    }

    public void setBundle(OiixJarResourceBundle rb) {
        this.resBundle = rb;
    }

    public String getExceptionName() throws MissingResourceException {
        return this.resBundle.getString(this.exceptionName);
    }

    public String getExceptionIntName() {
        return this.exceptionIntName;
    }

    public String getExceptionString() throws MissingResourceException {
        return this.resBundle.getString(this.exceptionString);
    }

    public int getExceptionSeverity() {
        return this.exceptionSeverity;
    }

    public void setExceptionSeverity(int i) {
        this.exceptionSeverity = i;
    }

    public void setExceptionString(String s) {
        this.exceptionString = new String(s);
    }

    public void setExceptionName(String s) {
        this.exceptionName = new String(s);
    }

    public void setExceptionIntName(String s) {
        this.exceptionIntName = new String(s);
    }

    void writeXMLElement(PrintWriter out) throws IOException {
        XMLElement xmlExc = new XMLElement("EXCEPTION");
        xmlExc.setAttribute("NAME", this.exceptionIntName);
        xmlExc.setAttribute("EXT_NAME_ID", this.exceptionName);
        xmlExc.setAttribute("DESC_ID", this.exceptionString);
        xmlExc.setAttribute("SEV", new Integer(this.exceptionSeverity).toString());
        xmlExc.print(out);
    }
}

