/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilLibElemTable;
import oracle.sysman.oii.oiil.OiilLibraryXMLHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiilLibraryXMLReader {
    private static boolean m_sbCheckingLibXML = false;
    private static Vector m_svErrs;

    public static OiilLibElemTable getLibraryTable(BufferedReader rFile) throws IOException {
        long lTime = 0L;
        Parser parser = OixsXMLOps.createSAXParser();
        OiilLibraryXMLHandler handler = null;
        OiilLibElemTable retTable = null;
        try {
            handler = new OiilLibraryXMLHandler();
            handler.setCheckingLibXML(m_sbCheckingLibXML);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(rFile));
            retTable = handler.getLibTable();
            if (m_sbCheckingLibXML) {
                m_svErrs = handler.getErrors();
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return retTable;
    }

    public static void main(String[] s) throws Exception {
        if (s.length == 0) {
            System.err.println("Usage: java oracle.sysman.oii.oiil.OiilLibraryXMLReader library.xml\n");
            return;
        }
        m_sbCheckingLibXML = true;
        BufferedReader buffreader = new BufferedReader(new FileReader(s[0]));
        OiilLibElemTable table = OiilLibraryXMLReader.getLibraryTable(buffreader);
        if (m_svErrs != null && m_svErrs.size() > 0) {
            for (int i = 0; i < m_svErrs.size(); ++i) {
                System.out.println(m_svErrs.elementAt(i).toString());
            }
        }
    }
}

