/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifd.OiifdDeinstallPromptDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiWinActionsXMLHandler;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilWinActionInputs;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class OiilWinActions {
    static final int S_PROGRAM_FOLDER = 0;
    static final int S_DESKTOP_FOLDER = 1;
    static final int S_STARTUP_FOLDER = 2;
    static final String S_FOLDER_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    static final String S_DESKTOP_FOLDER_VALUE = "Common Desktop";
    static final String S_STARTUP_FOLDER_VALUE = "Common Startup";
    static final String S_PROGRAM_FOLDER_VALUE = "Common Programs";
    static final String S_ACTION_SUCCESS = "success";
    protected boolean m_bInstall;
    protected boolean m_bCluster;
    protected static boolean m_bClone = false;
    protected static boolean m_bSilent = OiicPullSession.isSilentMode();

    public static void readWinActions(OiiiSourceAccess oAccess) {
        if (!OiixFunctionOps.isPlatformWindows().booleanValue()) {
            return;
        }
        String sInvLoc = OiixPathOps.getParentDir(oAccess.getLocalStgInvLoc());
        String sWinXmlFile = OiilWinActions.getWinActionsFileName(sInvLoc);
        OiiiStageInventory inv = oAccess.getStageInventory();
        try {
            OiilWinActions.readWinActionsXML(inv, sWinXmlFile, 0);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void readWinActions(OiiiInstallInventory inv, int homeIdx) {
        if (!OiixFunctionOps.isPlatformWindows().booleanValue()) {
            return;
        }
        String sInvLoc = OiixPathOps.getStandardForm(OiixPathOps.concatPath(inv.getHomeLocation(homeIdx), "inventory"));
        String sWinXmlFile = OiilWinActions.getWinActionsFileName(sInvLoc);
        try {
            OiilWinActions.readWinActionsXML(inv, sWinXmlFile, homeIdx);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    static void readWinActionsXML(OiiiAreaInventory inv, String sFileName, int homeIdx) throws IOException {
        if (!new File(sFileName).exists()) {
            return;
        }
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        OiiolTextLogger.appendText("Reading desktop actions xml: " + sFileName);
        OiiiWinActionsXMLHandler handler = null;
        FileReader fReader = null;
        BufferedReader bReader = null;
        try {
            Parser parser = OixsXMLOps.createSAXParser();
            handler = new OiiiWinActionsXMLHandler(inv, homeIdx);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                fReader = new FileReader(sFileName);
                bReader = new BufferedReader(fReader);
            }
            catch (FileNotFoundException e) {
                Object[] sArgs = new String[]{sFileName};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
            }
            parser.parse(new InputSource(bReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        bReader.close();
        fReader.close();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Reader, desktopactions.xml ", System.currentTimeMillis() - lTime);
        }
    }

    public void runActions(OiiiCompInstallID cid, OiisCompContext context) throws OiifbCancelException {
        if (null == cid) {
            return;
        }
        Vector vActions = OiilWinActionInputs.getCompAction(cid);
        this.runActions(vActions, context);
    }

    public void runActions(Vector vActions, OiisCompContext context) throws OiifbCancelException {
        if (null == vActions) {
            return;
        }
        if (!OiixFunctionOps.isPlatformWindows().booleanValue()) {
            return;
        }
        OiifrProgressActionListener oListener = null;
        if (!m_bSilent) {
            oListener = (OiifrProgressActionListener)((OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).getProgressListener();
            oListener.setStatus(this.getProgressMessage());
        }
        int size = vActions.size();
        int i = 0;
        int j = size - 1;
        while (i < size) {
            OiilWinActionInputs inputs = this.m_bInstall ? (OiilWinActionInputs)vActions.elementAt(i) : (OiilWinActionInputs)vActions.elementAt(j);
            if (null == inputs) {
                OiiolTextLogger.appendText("Internal error: Null inputs in win actions");
            } else if (this.isActionApplicable(inputs) && OiilWinActions.isConditionTrue(inputs, context)) {
                OiilWinActionInputs inputsTemp = this.parseInputs(inputs, context);
                this.logAction(inputs, context);
                boolean retry = false;
                boolean failure = true;
                do {
                    try {
                        switch (inputs.getType()) {
                            case 0: {
                                this.runRegAction(inputsTemp, context);
                                break;
                            }
                            case 1: {
                                this.runShortcutAction(inputsTemp, context);
                                break;
                            }
                            case 2: {
                                this.runServiceAction(inputsTemp, context);
                            }
                        }
                        failure = false;
                    }
                    catch (OiilActionException ae) {
                        String severity = String.valueOf(ae.getExceptionSeverity());
                        Object[] exargs = new String[]{inputsTemp.getName(), ae.getExceptionName(), ae.getExceptionString(), severity};
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35900", exargs));
                        OiiolTextLogger.appendException(ae);
                        if (m_bSilent) continue;
                        int button_ops = 0;
                        button_ops = 0;
                        button_ops |= 2;
                        if (ae.getExceptionSeverity() != -1) {
                            button_ops |= 4;
                        }
                        int userInput = 0;
                        try {
                            OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler("Error in action " + inputsTemp.getName(), "Exception Name:" + ae.getExceptionName() + OiiolTextLogger.NEW_LINE + "Exception String:" + ae.getExceptionString(), button_ops, 1, true);
                            userInput = actionDlg.doModal();
                            actionDlg = null;
                            Thread.yield();
                        }
                        catch (Exception e) {
                            OiiolTextLogger.appendException(e);
                        }
                        switch (userInput) {
                            case 2: {
                                retry = true;
                                break;
                            }
                            case 4: {
                                retry = false;
                                break;
                            }
                            case 32: {
                                throw new OiifbCancelException(ae.getMessage(), false);
                            }
                            case 16: {
                                throw new OiifbCancelException(ae.getMessage(), true);
                            }
                        }
                    }
                } while (retry);
                if (!m_bSilent) {
                    oListener.addBytes(OiifwActionsPhaseWCDE.getActionSize());
                }
                inputs.addInputElementImplicit(S_ACTION_SUCCESS, new Boolean(!failure));
            }
            ++i;
            --j;
        }
    }

    protected void runRegAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
    }

    protected void runShortcutAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
    }

    protected void runServiceAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
    }

    public static void setCloneMode(boolean isClone) {
        m_bClone = isClone;
    }

    protected static int getValueType(String type) {
        if (type.trim().equalsIgnoreCase("binary")) {
            return 1;
        }
        if (type.trim().equalsIgnoreCase("integer")) {
            return 2;
        }
        if (type.trim().equalsIgnoreCase("string")) {
            return 3;
        }
        if (type.trim().equalsIgnoreCase("multistring")) {
            return 4;
        }
        return -1;
    }

    protected static String removeBraces(String val) {
        if (val.startsWith("{") && val.endsWith("}")) {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    protected static String addQuotes(String val) {
        if (!val.startsWith("\"")) {
            val = "\"" + val;
        }
        if (!val.endsWith("\"")) {
            val = val + "\"";
        }
        return val;
    }

    protected boolean isActionApplicable(OiilWinActionInputs inputs) {
        String sAction = inputs.getValueAsString("ActionType");
        if (null == sAction || sAction.equals("")) {
            return true;
        }
        if (sAction.equalsIgnoreCase("both")) {
            return true;
        }
        if (sAction.equalsIgnoreCase("install")) {
            return this.m_bInstall;
        }
        if (sAction.equalsIgnoreCase("deinstall")) {
            return !this.m_bInstall;
        }
        return false;
    }

    protected static boolean isConditionTrue(OiilWinActionInputs inputs, OiisCompContext context) {
        boolean bReturn = false;
        String sCondition = inputs.getValueAsString("Condition");
        if ((sCondition = sCondition.trim()).equals("")) {
            bReturn = true;
        } else if (sCondition.equalsIgnoreCase("true")) {
            bReturn = true;
        } else if (sCondition.equalsIgnoreCase("false")) {
            bReturn = false;
        } else {
            OiisVariable oVar;
            if (sCondition.startsWith("%")) {
                sCondition = sCondition.substring(1);
            }
            if (sCondition.endsWith("%")) {
                sCondition = sCondition.substring(0, sCondition.length() - 1);
            }
            if ((oVar = context.getVariable(sCondition)) != null && oVar.getType() == OiisVariable.BOOL && oVar.getValue() != null) {
                bReturn = (Boolean)oVar.getValue();
            }
        }
        return bReturn;
    }

    protected static boolean isTrue(String val) {
        return val != null && val.equalsIgnoreCase("yes");
    }

    public static String getWinActionsFileName(String parDir) {
        return OiixPathOps.concatPath(parDir, "desktopactions.xml");
    }

    private OiilWinActionInputs parseInputs(OiilWinActionInputs inputs, OiisCompContext oContext) {
        OiilWinActionInputs temp = new OiilWinActionInputs(inputs.getType());
        for (int i = 0; i < inputs.getSize(); ++i) {
            String sVal;
            if (inputs.isImplicitElement(i) || (sVal = inputs.getElementValue(i)) == null) continue;
            sVal = this.instantiateString(sVal, oContext, inputs.getName(), false);
            String sName = inputs.getElementName(i);
            temp.addInputElement(sName, sVal);
        }
        return temp;
    }

    private void logAction(OiilWinActionInputs inputs, OiisCompContext oContext) {
        String logMsgHdr = "Executing Win Action";
        String logMsg = "";
        logMsgHdr = logMsgHdr + " " + inputs.getName();
        int size = inputs.getSize();
        for (int i = 0; i < size; ++i) {
            if (inputs.isImplicitElement(i)) continue;
            String name = inputs.getElementName(i);
            String val = inputs.getElementValue(i);
            val = null == val ? "null" : this.instantiateString(val, oContext, inputs.getName(), true);
            logMsg = logMsg + OiiolTextLogger.NEW_LINE + "\t" + name + "  =  " + val;
        }
        OiiolTextLogger.appendText(logMsgHdr + logMsg + OiiolTextLogger.NEW_LINE);
    }

    private String instantiateString(String sText, OiisCompContext oCompContext, String actionName, boolean bLog) {
        StringBuffer sbOutput = new StringBuffer();
        int VAR_SEPARATOR = 37;
        int idx1 = -1;
        int idx2 = -1;
        int i = 0;
        while (i < sText.length()) {
            idx1 = sText.indexOf(37, i);
            if (idx1 == -1) {
                sbOutput.append(sText.substring(i));
                break;
            }
            if (idx1 + 1 < sText.length() && sText.charAt(idx1 + 1) == '%') {
                sbOutput.append(sText.substring(i, idx1 + 2));
                i = idx1 + 2;
                continue;
            }
            sbOutput.append(sText.substring(i, idx1));
            idx2 = sText.indexOf(37, idx1 + 1);
            if (idx2 == -1) {
                sbOutput.append(sText.substring(idx1));
                break;
            }
            String sName = sText.substring(idx1 + 1, idx2);
            String sValue = "";
            OiisVariable oVar = oCompContext.getVariable(sName);
            if (oVar != null) {
                if (bLog && oVar.getLogValue() != null) {
                    sValue = oVar.getLogValue().toString();
                } else if (!(m_bSilent || this.m_bInstall && !m_bClone || !oVar.isSecure() || oVar.getAdvice())) {
                    sValue = this.getUserInput(oVar, actionName);
                } else if (!bLog && oVar.getValue() != null) {
                    sValue = oVar.getValue().toString();
                }
            } else {
                OiisCompConstants oCompConstants = oCompContext.getCompConstants();
                OiisGenericConstant oConst = oCompConstants.getConstant(sName);
                if (oConst != null && oConst.getValue() != null) {
                    sValue = oConst.getValue().toString();
                }
            }
            sbOutput.append(sValue);
            i = idx2 + 1;
        }
        String sOutput = OiixFunctionOps.replaceStr(sbOutput.toString(), "%%", "%");
        return sOutput;
    }

    private String getUserInput(OiisVariable oVar, String actionName) {
        block7: {
            OiiolTextLogger.appendText("Getting user input for variable: " + oVar.getName());
            String sPrompt = oVar.getDescription();
            String sVarType = OiisVariable.getTypeString(oVar.getType());
            InputDialog oDlg = new InputDialog(sVarType, sPrompt);
            try {
                SwingUtilities.invokeAndWait(oDlg);
                String sUserInput = oDlg.getUserInput();
                if (sUserInput == null || sUserInput.trim().equals("")) break block7;
                Object oValue = OiisDataTypes.getValueObject(sUserInput, sVarType);
                try {
                    oVar.setValue(oValue);
                    oVar.setAdvice(true);
                }
                catch (OiisVarSettingException ve) {
                    ve.printStackTrace();
                }
                catch (OiifbCancelException ve) {
                    ve.printStackTrace();
                }
                return sUserInput;
            }
            catch (InterruptedException ie) {
                Object[] exargs = new String[]{actionName};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35901", exargs));
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendException(ie);
                }
            }
            catch (InvocationTargetException ie) {
                Object[] exargs = new String[]{actionName};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35901", exargs));
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) break block7;
                OiiolTextLogger.appendException(ie);
            }
        }
        return "";
    }

    public static void saveWinActionsXml(OiiiCompInstallID[] cidArr, String sSrc, String sDest, boolean isCloneMode) {
        if (isCloneMode || !new File(sDest).exists()) {
            boolean fail = false;
            for (int i = 0; i < cidArr.length; ++i) {
                OiiiCompInstallID cid = cidArr[i];
                Vector vActions = OiilWinActionInputs.getCompAction(cid);
                if (null == vActions) continue;
                for (int j = 0; j < vActions.size(); ++j) {
                    OiilWinActionInputs inputs = (OiilWinActionInputs)vActions.elementAt(j);
                    Boolean bWrite = (Boolean)inputs.getValue(S_ACTION_SUCCESS);
                    if (bWrite == null || bWrite.booleanValue()) continue;
                    fail = true;
                }
            }
            if (!fail) {
                if (isCloneMode) {
                    return;
                }
                try {
                    OiixFileOps.copyFile(sSrc, sDest, true, true);
                }
                catch (IOException ioe) {
                    OiiolTextLogger.appendException(ioe);
                }
                catch (OiifbCancelException ce) {
                    OiiolTextLogger.appendException(ce);
                }
                return;
            }
        }
        try {
            OiilWinActions.writeToXml(cidArr, sDest, isCloneMode);
        }
        catch (ParserConfigurationException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (SAXException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    private static void writeToXml(OiiiCompInstallID[] cidArr, String sTargetFile, boolean isCloneMode) throws ParserConfigurationException, IOException, SAXException {
        Element root;
        Document oDoc;
        if (!isCloneMode && new File(sTargetFile).exists()) {
            oDoc = OixdDOMReader.getDocument(sTargetFile);
            root = oDoc.getDocumentElement();
        } else {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            oDoc = builder.newDocument();
            root = oDoc.createElement("DESKTOP_ACTIONS");
            oDoc.appendChild(root);
        }
        for (int i = 0; i < cidArr.length; ++i) {
            int size;
            OiiiCompInstallID cid = cidArr[i];
            Vector vActions = OiilWinActionInputs.getCompAction(cid);
            if (null == vActions || 0 == (size = vActions.size())) continue;
            Element compElem = OiilWinActions.getComponentElement(cid, oDoc);
            root.appendChild(compElem);
            for (int j = 0; j < size; ++j) {
                OiilWinActionInputs inputs = (OiilWinActionInputs)vActions.elementAt(j);
                Boolean bWrite = (Boolean)inputs.getValue(S_ACTION_SUCCESS);
                if (bWrite != null && !bWrite.booleanValue()) continue;
                compElem.appendChild(OiilWinActions.getActionElement(inputs, oDoc));
            }
        }
        try {
            DOMSource source = new DOMSource(oDoc);
            File outFile = new File(sTargetFile);
            if (outFile.exists()) {
                outFile.delete();
            }
            StreamResult result = new StreamResult(outFile);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private static Element getActionElement(OiilWinActionInputs inputs, Document oDoc) {
        Element elem;
        switch (inputs.getType()) {
            case 0: {
                elem = oDoc.createElement("Registry");
                break;
            }
            case 1: {
                elem = oDoc.createElement("Shortcut");
                break;
            }
            case 2: {
                elem = oDoc.createElement("Service");
                break;
            }
            default: {
                return null;
            }
        }
        for (int i = 0; i < inputs.getSize(); ++i) {
            String val;
            if (inputs.isImplicitElement(i) || null == (val = inputs.getElementValue(i))) continue;
            String name = inputs.getElementName(i);
            elem.setAttribute(name, val);
        }
        return elem;
    }

    private static Element getComponentElement(OiiiCompInstallID cid, Document oDoc) {
        Element elem = oDoc.createElement("Component");
        elem.setAttribute("NAME", cid.getName());
        elem.setAttribute("VERSION", cid.getVersion().getVerString());
        Vector vPlats = cid.getPlatforms();
        String[] platNames = OiixPlatform.platIDsToCommonNameArray(vPlats);
        String sPlats = OiixFunctionOps.implodeList(platNames, " ");
        elem.setAttribute("PLATFORMS", sPlats);
        return elem;
    }

    private String getProgressMessage() {
        if (this.m_bInstall && !this.m_bCluster) {
            return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WIN_ACTIONS_INSTALL_BEGIN");
        }
        if (!this.m_bInstall && !this.m_bCluster) {
            return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WIN_ACTIONS_DEINSTALL_BEGIN");
        }
        if (this.m_bInstall && this.m_bCluster) {
            return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WIN_ACTIONS_CLUSTER_INSTALL_BEGIN");
        }
        if (!this.m_bInstall && this.m_bCluster) {
            return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WIN_ACTIONS_CLUSTER_DEINSTALL_BEGIN");
        }
        return "";
    }

    private static class InputDialog
    implements Runnable {
        private String m_sInput;
        private Frame m_oFrame = ((OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).getMainFrame();
        private String m_sType;
        private String m_sDesc;

        public InputDialog(String sType, String sDesc) {
            this.m_sType = sType;
            this.m_sDesc = sDesc;
        }

        public void run() {
            OiifdDeinstallPromptDlg oDlg = new OiifdDeinstallPromptDlg(this.m_oFrame, this.m_sType, this.m_sDesc);
            int nRet = oDlg.runDialog();
            this.m_sInput = nRet == 1 ? oDlg.getTextValue() : "";
        }

        public String getUserInput() {
            return this.m_sInput;
        }
    }
}

