/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiil.OiilWinActionInputs;
import oracle.sysman.oii.oiil.OiilWinActionsClusterInstall;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiix.OiixRegistryOps;

public class OiilWinActionsClusterDeinstall
extends OiilWinActionsClusterInstall {
    public OiilWinActionsClusterDeinstall(String[] nodes) {
        super(nodes);
        this.m_bInstall = false;
    }

    protected void runRegAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        String sRoot = inputs.getRegRootValue();
        String sKey = inputs.getValueAsString("Key");
        if (sAction.equalsIgnoreCase("createKey")) {
            try {
                OiipwClusterWindowsOps.registryDeleteKey(sRoot, sKey, this.m_selectedNodesArr);
            }
            catch (OiipgRemoteOpsException oce) {
                throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
            }
        }
        if (sAction.equalsIgnoreCase("setvalue")) {
            try {
                String sType = inputs.getValueAsString("Type");
                String sName = inputs.getValueAsString("Name");
                switch (OiilWinActionsClusterDeinstall.getValueType(sType)) {
                    case 1: 
                    case 2: 
                    case 4: {
                        OiipwClusterWindowsOps.registryDeleteValue(sRoot, sKey, sName, this.m_selectedNodesArr);
                        break;
                    }
                    case 3: {
                        if (OiixRegistryOps.RegValueExists(sRoot, sKey, sName)) {
                            OiipwClusterWindowsOps.registrySetValue(sRoot, sKey, sName, OiixRegistryOps.RegGetStringValuew32(sRoot, sKey, sName), this.m_selectedNodesArr);
                            break;
                        }
                        OiipwClusterWindowsOps.registryDeleteValue(sRoot, sKey, sName, this.m_selectedNodesArr);
                    }
                }
            }
            catch (OiipgRemoteOpsException oce) {
                throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
            }
        }
    }

    protected void runShortcutAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction == null || sAction.equalsIgnoreCase("create")) {
            this.removeItem(inputs);
        }
    }

    protected void runServiceAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction.equalsIgnoreCase("create")) {
            this.deleteService(inputs);
        } else if (!sAction.equalsIgnoreCase("remove")) {
            if (sAction.equalsIgnoreCase("start")) {
                this.stopService(inputs);
            } else if (sAction.equalsIgnoreCase("stop")) {
                this.startService(inputs);
            }
        }
    }
}

