/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiil.OiilWinActionInputs;
import oracle.sysman.oii.oiil.OiilWinActions;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgPlatformNotSupportedException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiix.OiixFolderOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixServiceOps;

public class OiilWinActionsClusterInstall
extends OiilWinActions {
    protected String[] m_selectedNodesArr;
    protected String m_sSelectedNodes;

    public OiilWinActionsClusterInstall(String[] nodes) {
        this.m_bInstall = true;
        this.m_bCluster = true;
        this.setSelectedNodes(nodes);
    }

    protected void setSelectedNodes(String[] nodes) {
        this.m_selectedNodesArr = nodes;
        this.m_sSelectedNodes = OiixFunctionOps.implodeList(this.m_selectedNodesArr, "|");
        this.m_sSelectedNodes = this.m_sSelectedNodes.concat("|");
    }

    protected void runRegAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        String sRoot = inputs.getRegRootValue();
        String sKey = inputs.getValueAsString("Key");
        if (sAction.equalsIgnoreCase("createKey")) {
            try {
                OiipwClusterWindowsOps.registryCreateKey(sRoot, sKey, this.m_selectedNodesArr);
            }
            catch (OiipgRemoteOpsException oce) {
                throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
            }
        }
        if (sAction.equalsIgnoreCase("setvalue")) {
            try {
                String sType = inputs.getValueAsString("Type");
                String sName = inputs.getValueAsString("Name");
                String sVal = inputs.getValueAsString("Value");
                String sUpdateType = inputs.getValueAsString("UpdateType");
                switch (OiilWinActionsClusterInstall.getValueType(sType)) {
                    case 1: {
                        OiipwClusterWindowsOps.registrySetValue(sRoot, sKey, sName, sVal, this.m_selectedNodesArr);
                        break;
                    }
                    case 2: {
                        OiipwClusterWindowsOps.registrySetValue(sRoot, sKey, sName, Integer.getInteger(sVal), this.m_selectedNodesArr);
                        break;
                    }
                    case 3: {
                        OiipwClusterWindowsOps.registrySetValue(sRoot, sKey, sName, sVal, this.m_selectedNodesArr);
                        break;
                    }
                    case 4: {
                        String[] saVal = OiixFunctionOps.explodeString(OiilWinActionsClusterInstall.removeBraces(sVal), ",");
                        OiipwClusterWindowsOps.registrySetValue(sRoot, sKey, sName, saVal, this.m_selectedNodesArr);
                        break;
                    }
                }
            }
            catch (OiipgRemoteOpsException oce) {
                throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
            }
        }
    }

    protected void runShortcutAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction.equals("") || sAction.equalsIgnoreCase("create")) {
            this.createItem(inputs);
        } else if (sAction.equalsIgnoreCase("remove")) {
            this.removeItem(inputs);
        }
    }

    protected void runServiceAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction.equalsIgnoreCase("create")) {
            this.createService(inputs);
        } else if (sAction.equalsIgnoreCase("remove")) {
            this.deleteService(inputs);
        } else if (sAction.equalsIgnoreCase("start")) {
            this.startService(inputs);
        } else if (sAction.equalsIgnoreCase("stop")) {
            this.stopService(inputs);
        }
    }

    protected void createItem(OiilWinActionInputs inputs) throws OiilActionException {
        String sStartupItem = inputs.getValueAsString("StartupItem");
        String sDesktopItem = inputs.getValueAsString("DesktopItem");
        this.createItem(inputs, 0, "Common Programs");
        if (OiilWinActionsClusterInstall.isTrue(sDesktopItem)) {
            this.createItem(inputs, 1, "Common Desktop");
        }
        if (OiilWinActionsClusterInstall.isTrue(sStartupItem)) {
            this.createItem(inputs, 2, "Common Startup");
        }
    }

    protected void removeItem(OiilWinActionInputs inputs) throws OiilActionException {
        String sStartupItem = inputs.getValueAsString("StartupItem");
        String sDesktopItem = inputs.getValueAsString("DesktopItem");
        this.removeItem(inputs, "Common Programs");
        if (OiilWinActionsClusterInstall.isTrue(sDesktopItem)) {
            this.removeItem(inputs, "Common Desktop");
        }
        if (OiilWinActionsClusterInstall.isTrue(sStartupItem)) {
            this.removeItem(inputs, "Common Startup");
        }
    }

    protected void createItem(OiilWinActionInputs inputs, int nItemType, String sItemValue) throws OiilActionException {
        String sFolderName = inputs.getValueAsNativePath("FolderName");
        String sItemName = inputs.getValueAsString("ItemName");
        String sFolderLocation = "";
        int nUser = 0;
        if (OiixPlatform.getCurrentPlatform() == 912 || OiixPlatform.getCurrentPlatform() == 208 || OiixPlatform.getCurrentPlatform() == 233) {
            String sFolderLocationLocal = "";
            for (int i = 0; i < this.m_selectedNodesArr.length; ++i) {
                try {
                    sFolderLocationLocal = OiixFolderOps.GetNativeFolderLocationLocal(nItemType, nUser);
                    try {
                        sFolderLocation = OiipwClusterWindowsOps.getRegStringDataOnNode("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", sItemValue, this.m_selectedNodesArr[i]);
                    }
                    catch (OiipgRemoteOpsException oce) {
                        throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
                    }
                }
                catch (OiipgPlatformNotSupportedException oe) {
                }
                catch (OiilNativeException ne) {
                    throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
                }
                String sItemLocationLocal = sFolderLocationLocal + "\\" + sFolderName + "\\" + sItemName + ".lnk";
                String sItemLocationRemote = sFolderLocation + "\\" + sFolderName + "\\" + sItemName + ".lnk";
                String sfLocation = sFolderLocation + "\\" + sFolderName;
                try {
                    OiipgClusterOps.createDirOnNode(this.m_selectedNodesArr[i], sfLocation);
                    OiipgClusterOps.transferFileToNode(sItemLocationLocal, this.m_selectedNodesArr[i], sItemLocationRemote);
                    continue;
                }
                catch (OiipgRemoteOpsException oce) {
                    throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
                }
            }
        } else {
            nUser = 0;
            String sFolderLocationLocalGeneral = "";
            try {
                sFolderLocationLocalGeneral = OiixFolderOps.GetNativeFolderLocationLocal(nItemType, nUser);
            }
            catch (OiipgPlatformNotSupportedException oe) {
            }
            catch (OiilNativeException ne) {
                throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
            }
            nUser = 1;
            String sFolderLocationLocalCurrent = "";
            try {
                sFolderLocationLocalCurrent = OiixFolderOps.GetNativeFolderLocationLocal(nItemType, nUser);
            }
            catch (OiipgPlatformNotSupportedException oe) {
            }
            catch (OiilNativeException ne) {
                throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
            }
            String sItemLocationLocalGeneral = sFolderLocationLocalGeneral + "\\" + sFolderName + "\\" + sItemName + ".lnk";
            String sItemLocationLocalCurrent = sFolderLocationLocalCurrent + "\\" + sFolderName + "\\" + sItemName + ".lnk";
            for (int i = 0; i < this.m_selectedNodesArr.length; ++i) {
                try {
                    sFolderLocation = OiipwClusterWindowsOps.getRegStringDataOnNode("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", sItemValue, this.m_selectedNodesArr[i]);
                }
                catch (OiipgRemoteOpsException oce) {
                    throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
                }
                String sItemLocation = sFolderLocation + "\\" + sFolderName + "\\" + sItemName + ".lnk";
                try {
                    OiipgClusterOps.createDirOnNode(sFolderLocationLocalGeneral, this.m_selectedNodesArr[i]);
                    OiipgClusterOps.transferFileToNode(sItemLocationLocalGeneral, this.m_selectedNodesArr[i], sItemLocation);
                    OiipgClusterOps.createDirOnNode(sFolderLocationLocalGeneral, this.m_selectedNodesArr[i]);
                    OiipgClusterOps.transferFileToNode(sItemLocationLocalCurrent, this.m_selectedNodesArr[i], sItemLocation);
                    continue;
                }
                catch (OiipgRemoteOpsException oce) {
                    throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
                }
            }
        }
    }

    protected void removeItem(OiilWinActionInputs inputs, String sItemValue) throws OiilActionException {
        String sFolderName = inputs.getValueAsNativePath("FolderName");
        String sItemName = inputs.getValueAsString("ItemName");
        String sFolderLocation = "";
        for (int i = 0; i < this.m_selectedNodesArr.length; ++i) {
            try {
                sFolderLocation = OiipwClusterWindowsOps.getRegStringDataOnNode("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", sItemValue, this.m_selectedNodesArr[i]);
            }
            catch (OiipgRemoteOpsException oce) {
                throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
            }
            String sItemLocation = sFolderLocation + "\\" + sFolderName + "\\" + sItemName + ".lnk";
            String sfLocation = sFolderLocation + "\\" + sFolderName;
            try {
                OiipgClusterOps.removeFileOnNode(this.m_selectedNodesArr[i], sItemLocation);
                if (OiipgClusterOps.listDirectory(this.m_selectedNodesArr[i], sfLocation).length != 0) continue;
                OiipgClusterOps.removeDirOnNode(this.m_selectedNodesArr[i], sfLocation);
                continue;
            }
            catch (OiipgRemoteOpsException oce) {
                throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
            }
        }
    }

    protected void createService(OiilWinActionInputs inputs) throws OiilActionException {
        String sExeName = inputs.getValueAsString("ExeName");
        String sServiceName = inputs.getValueAsString("ServiceName");
        String sDisplayName = inputs.getValueAsString("DisplayName");
        String sDepName = inputs.getValueAsString("DependencyNames");
        String sAccName = inputs.getValueAsString("AccountName");
        String sPassword = inputs.getValueAsString("Password");
        int nAccess = inputs.getValueAsInt("Access");
        int nType = inputs.getValueAsInt("Type");
        int nStartType = inputs.getValueAsInt("StartType");
        int nErrCtrl = inputs.getValueAsInt("ErrorControl");
        try {
            OiixServiceOps.ntCreateServiceAdvanced(sExeName, sServiceName, nAccess, nStartType, nType, nErrCtrl, sDepName, sDisplayName, sPassword, sDisplayName, this.m_sSelectedNodes);
        }
        catch (OiipgPlatformNotSupportedException oe) {
        }
        catch (OiilNativeException ne) {
            throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
        }
    }

    protected void deleteService(OiilWinActionInputs inputs) throws OiilActionException {
        String sServiceName = inputs.getValueAsString("ServiceName");
        try {
            OiipwClusterWindowsOps.deleteServiceOnNodes(sServiceName, this.m_selectedNodesArr);
        }
        catch (OiipgRemoteOpsException oce) {
            throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
        }
    }

    protected void startService(OiilWinActionInputs inputs) throws OiilActionException {
        String sServiceName = inputs.getValueAsString("ServiceName");
        try {
            OiipwClusterWindowsOps.startServiceOnNodes(sServiceName, this.m_selectedNodesArr);
        }
        catch (OiipgRemoteOpsException oce) {
            throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
        }
    }

    protected void stopService(OiilWinActionInputs inputs) throws OiilActionException {
        String sServiceName = inputs.getValueAsString("ServiceName");
        try {
            OiipwClusterWindowsOps.stopServiceOnNodes(sServiceName, this.m_selectedNodesArr);
        }
        catch (OiipgRemoteOpsException oce) {
            throw new OiilActionException("Cluster Exception", oce.getErrorMessage());
        }
    }
}

