/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import java.sql.Timestamp;
import java.util.ArrayList;

public class OiimARUPatchData {
    private long m_aruId = 0L;
    private String m_status = null;
    private String m_type = null;
    private long m_bugNo = 0L;
    private long m_family = 0L;
    private long m_product = 0L;
    private long m_platform = 0L;
    private long m_language = 0L;
    private String m_release = null;
    private String m_abstract = null;
    private String m_readmeUrl = null;
    private String m_patchUrl = null;
    private String m_comments = null;
    private long m_size = 0L;
    private String m_automation = null;
    private String m_aruPassword = null;
    private String m_manuallyPosted = null;
    private long m_fileLength = 0L;
    private Timestamp m_lastReferenced;
    private Timestamp m_date;
    private ArrayList m_fixesBugs = new ArrayList();
    private String m_Digest = null;

    public OiimARUPatchData() {
    }

    public OiimARUPatchData(long aruId, String status, String type, long bugNo, long product, long platform, long language, String release, String abs, Timestamp date, String readmeUrl, String patchUrl, String comments, long size, String automation, String manuallyPosted, Timestamp lastReferenced, long fileLength) {
        this.m_aruId = aruId;
        this.m_status = status;
        this.m_type = type;
        this.m_bugNo = bugNo;
        this.m_product = product;
        this.m_platform = platform;
        this.m_release = OiimARUPatchData.stripPrefix(release);
        this.m_abstract = abs;
        this.m_date = date;
        this.m_readmeUrl = readmeUrl;
        this.m_patchUrl = patchUrl;
        this.m_comments = comments;
        this.m_size = size;
        this.m_automation = automation;
        this.m_aruPassword = null;
        this.m_manuallyPosted = manuallyPosted;
        this.m_lastReferenced = lastReferenced;
        this.m_fileLength = fileLength;
    }

    public long getAruId() {
        return this.m_aruId;
    }

    public void setAruId(long aruId) {
        this.m_aruId = aruId;
    }

    public String getStatus() {
        return this.m_status;
    }

    public String getType() {
        return this.m_type;
    }

    public long getBugNo() {
        return this.m_bugNo;
    }

    public void setBugNo(long bugNo) {
        this.m_bugNo = bugNo;
    }

    public long getFamily() {
        return this.m_family;
    }

    public void setFamily(long familyId) {
        this.m_family = familyId;
    }

    public long getProduct() {
        return this.m_product;
    }

    public void setProduct(long productId) {
        this.m_product = productId;
    }

    public long getPlatform() {
        return this.m_platform;
    }

    public void setPlatform(long platformId) {
        this.m_platform = platformId;
    }

    public String getRelease() {
        return this.m_release;
    }

    public long getLanguage() {
        return this.m_language;
    }

    public void setLanguage(long languageId) {
        this.m_language = languageId;
    }

    public String getAbstract() {
        return this.m_abstract;
    }

    public Timestamp getPatchDate() {
        return this.m_date;
    }

    public void setPatchDate(Timestamp createdDt) {
        this.m_date = createdDt;
    }

    public String getReadmeUrl() {
        return this.m_readmeUrl;
    }

    public String getPatchUrl() {
        return this.m_patchUrl;
    }

    public void setARUPassword(String aruPW) {
        if (aruPW != null) {
            this.m_aruPassword = aruPW;
        }
    }

    public String getARUPassword() {
        return this.m_aruPassword;
    }

    public String getComments() {
        return this.m_comments;
    }

    public String getAutomated() {
        return this.m_automation;
    }

    public long getSize() {
        return this.m_size;
    }

    public long getPatchSize() {
        long size = 0L;
        if (this.getFileDownloaded()) {
            size = this.m_size / 1024L + (long)(this.m_size % 1024L > 0L ? 1 : 0);
        }
        return size;
    }

    public void setSize(long size) {
        this.m_size = size;
    }

    public String getManuallyPosted() {
        return this.m_manuallyPosted;
    }

    public Timestamp getLastReferenced() {
        return this.m_lastReferenced;
    }

    public void setFixesBugs(ArrayList fixesBugs) {
        this.m_fixesBugs = fixesBugs;
    }

    public void setFileLength(long fileLength) {
        this.m_fileLength = fileLength;
    }

    public boolean getFileDownloaded() {
        return this.m_size == this.m_fileLength;
    }

    public String getDigest() {
        return this.m_Digest;
    }

    public void setDigest(String digest) {
        this.m_Digest = digest;
    }

    public void dump() {
        System.out.println("<patch>");
        System.out.println("  <status>" + this.m_status + "</status>");
        System.out.println("  <id>" + this.m_aruId + "</id>");
        System.out.println("  <type>" + this.m_type + "</type>");
        System.out.println("  <bug>" + this.m_bugNo + "</bug>");
        System.out.println("  <product>" + this.m_product + "</product>");
        System.out.println("  <platform>" + this.m_platform + "</platform>");
        System.out.println("  <language>" + this.m_language + "</language>");
        System.out.println("  <release>" + this.m_release + "</release>");
        System.out.println("  <abstract>" + this.m_abstract + "</abstract>");
        System.out.println("  <date>" + this.m_date + "</date>");
        System.out.println("  <readme_url>" + this.m_readmeUrl + "</readme_url>");
        System.out.println("  <patch_url>" + this.m_patchUrl + "</patch_url>");
        System.out.println("  <comments>" + this.m_comments + "</comments>");
        System.out.println("  <size>" + this.m_size + "</size>");
        System.out.println("  <automated>" + this.m_automation + "</automated>");
        System.out.println("</patch>");
    }

    public static String stripPrefix(String releaseName) {
        if (releaseName == null || releaseName.trim().length() <= 0) {
            return releaseName;
        }
        String stripName = releaseName.trim();
        int idx = stripName.lastIndexOf(" ");
        if (idx > 0) {
            stripName = stripName.substring(idx + 1);
        }
        return stripName;
    }
}

