/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OiimHTMLHelper {
    private static final Logger LOGGER = Logger.getLogger(OiimHTMLHelper.class.getName());
    private static final Level VERBOSE_LOG_LEVEL = Level.FINE;
    public static final String ELEMENT_NAME_FORM = "form";
    public static final String ELEMENT_NAME_INPUT = "input";
    public static final String ELEMENT_NAME_IMAGE = "img";
    private static final Map ATTR_POSITIONS_MAP = new HashMap();
    private static final String REGEX_SPACES = " *?";
    private static final String REGEX_ANY_CHARACTER = ".*?";
    private static final String HTML_ATTR_DELIMITER = "[\"']";
    private static final String REGEX_ATTR_VALUE = " *?= *?[\"'](.*?)[\"']";
    private static final String TAG_START_FORM = "<form";
    private static final String TAG_END_FORM = "</form>";
    private static final String REGEX_FORM = "<form.*?(method|action) *?= *?[\"'](.*?)[\"'].*?(action|method) *?= *?[\"'](.*?)[\"'].*?</form>";
    private static final Pattern PATTERN_FORM = Pattern.compile("<form.*?(method|action) *?= *?[\"'](.*?)[\"'].*?(action|method) *?= *?[\"'](.*?)[\"'].*?</form>", 34);
    public static final String ATTR_NAME_FORM_METHOD = "method";
    public static final String ATTR_NAME_FORM_ACTION = "action";
    public static final int ATTR_FORM_COUNT = 2;
    public static final int ATTR_POS_FORM_METHOD = 1;
    public static final int ATTR_POS_FORM_ACTION = 2;
    private static final String TAG_START_INPUT = "<Input";
    private static final String REGEX_INPUT = "<Input.*?(name|type|value) *?= *?[\"'](.*?)[\"'].*?(name|type|value) *?= *?[\"'](.*?)[\"'].*?(name|type|value) *?= *?[\"'](.*?)[\"'].*?>";
    private static final Pattern PATTERN_INPUT;
    public static final String ATTR_NAME_INPUT_TYPE = "type";
    public static final String ATTR_NAME_INPUT_NAME = "name";
    public static final String ATTR_NAME_INPUT_VALUE = "value";
    public static final int ATTR_INPUT_COUNT = 3;
    public static final int ATTR_POS_INPUT_TYPE = 1;
    public static final int ATTR_POS_INPUT_NAME = 2;
    public static final int ATTR_POS_INPUT_VALUE = 3;
    private static final String REGEX_IMAGE = "<img.*?>";
    private static final Pattern PATTERN_IMAGE;
    public static final int ATTR_IMAGE_COUNT = 0;
    private static String testString;

    private OiimHTMLHelper() {
    }

    public static List extractFormElements(String inputText) {
        Matcher matcher = PATTERN_FORM.matcher(inputText);
        List elementList = OiimHTMLHelper.extractElements(inputText, ELEMENT_NAME_FORM, matcher, 2);
        return elementList;
    }

    public static List extractInputElements(String inputText) {
        Matcher matcher = PATTERN_INPUT.matcher(inputText);
        List elementList = OiimHTMLHelper.extractElements(inputText, ELEMENT_NAME_INPUT, matcher, 3);
        return elementList;
    }

    public static List extractImageElements(String inputText) {
        Matcher matcher = PATTERN_IMAGE.matcher(inputText);
        List elementList = OiimHTMLHelper.extractElements(inputText, ELEMENT_NAME_IMAGE, matcher, 0);
        return elementList;
    }

    private static List extractElements(String inputText, String elementName, Matcher matcher, int attributeCount) {
        ArrayList<String[]> elementList = new ArrayList<String[]>();
        if (LOGGER.isLoggable(VERBOSE_LOG_LEVEL)) {
            LOGGER.log(VERBOSE_LOG_LEVEL, "Searching for " + elementName + " Element in: " + inputText);
            LOGGER.log(VERBOSE_LOG_LEVEL, "Using Pattern: " + matcher.pattern().pattern());
        }
        while (matcher.find()) {
            String[] matchingStrings = new String[attributeCount + 1];
            matchingStrings[0] = matcher.group();
            if (LOGGER.isLoggable(VERBOSE_LOG_LEVEL)) {
                LOGGER.log(VERBOSE_LOG_LEVEL, "Found Element: " + matchingStrings[0] + ", Group Count: " + matcher.groupCount());
            }
            StringBuffer logBuffer = null;
            if (LOGGER.isLoggable(VERBOSE_LOG_LEVEL)) {
                logBuffer = new StringBuffer("Attributes: ");
            }
            for (int i = 1; i < attributeCount + 1; ++i) {
                String value;
                int attrNamePos = i * 2 - 1;
                int attrValuePos = i * 2;
                String attrName = matcher.group(attrNamePos);
                int attrPos = OiimHTMLHelper.locateAttributePosition(elementName, attrName);
                matchingStrings[attrPos] = value = matcher.group(attrValuePos);
                if (!LOGGER.isLoggable(VERBOSE_LOG_LEVEL)) continue;
                logBuffer.append(":Name=" + attrName + ", Value='" + value + "':");
            }
            if (LOGGER.isLoggable(VERBOSE_LOG_LEVEL)) {
                LOGGER.log(VERBOSE_LOG_LEVEL, logBuffer.toString());
            }
            elementList.add(matchingStrings);
        }
        return elementList;
    }

    private static int locateAttributePosition(String elementType, String attributeName) {
        Integer pos = (Integer)ATTR_POSITIONS_MAP.get(elementType + attributeName.toLowerCase());
        if (pos != null) {
            return pos;
        }
        return -1;
    }

    public static Map extractTagAttributes(String text, String tagName) {
        Pattern pattern = Pattern.compile("<(" + tagName + ").*?>", 34);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String tag = matcher.group();
            String actualTagName = matcher.group(1);
            tag = tag.replaceAll("<" + actualTagName, "");
            tag = tag.replaceAll(">", "");
            tag = tag.trim();
            return OiimHTMLHelper.extractTagAttributes(tag);
        }
        return new HashMap();
    }

    private static Map extractTagAttributes(String attributeFragment) {
        attributeFragment = attributeFragment.trim() + " ";
        HashMap<String, String> attribsMap = new HashMap<String, String>();
        StringBuffer nameBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        boolean nameScan = true;
        boolean inQuote = false;
        int quoteChar = 32;
        boolean firstCharFound = false;
        boolean movingThroSpaces = false;
        for (int i = 0; i < attributeFragment.length(); ++i) {
            int c = attributeFragment.charAt(i);
            if (c == 61) {
                movingThroSpaces = false;
                if (!nameScan) continue;
                nameScan = false;
                movingThroSpaces = true;
                firstCharFound = false;
                continue;
            }
            if (c == 39 || c == 34) {
                if (nameScan) {
                    nameBuffer.append((char)c);
                } else {
                    valueBuffer.append((char)c);
                }
                if (!firstCharFound) {
                    inQuote = true;
                    movingThroSpaces = false;
                    quoteChar = c;
                } else if (c == quoteChar) {
                    inQuote = false;
                    quoteChar = 32;
                }
                firstCharFound = true;
                continue;
            }
            if (c != 32) {
                movingThroSpaces = false;
                firstCharFound = true;
                if (nameScan) {
                    nameBuffer.append((char)c);
                    continue;
                }
                valueBuffer.append((char)c);
                continue;
            }
            if (inQuote) {
                if (nameScan) {
                    nameBuffer.append((char)c);
                    continue;
                }
                valueBuffer.append((char)c);
                continue;
            }
            if (movingThroSpaces) continue;
            movingThroSpaces = true;
            if (nameScan) continue;
            String attrName = nameBuffer.toString().toLowerCase().trim();
            String attrValue = valueBuffer.toString();
            attrValue = OiimHTMLHelper.removeQuotes(attrValue);
            attribsMap.put(attrName, attrValue);
            nameBuffer = new StringBuffer();
            valueBuffer = new StringBuffer();
            nameScan = true;
            inQuote = false;
            firstCharFound = false;
        }
        return attribsMap;
    }

    private static String removeQuotes(String inString) {
        String quote = "";
        if (inString.charAt(0) == '\'') {
            quote = "'";
        } else if (inString.charAt(0) == '\"') {
            quote = "\"";
        }
        if (!quote.equals("")) {
            inString = inString.replaceAll(quote, "");
        }
        return inString;
    }

    public static Map createHttpParamsMap(String[] formData) {
        List inputList = OiimHTMLHelper.extractInputElements(formData[0]);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (int i = 0; i < inputList.size(); ++i) {
            String[] inputData = (String[])inputList.get(i);
            String name = inputData[2];
            String value = inputData[3];
            paramsMap.put(name, value);
        }
        return paramsMap;
    }

    public static void main(String[] args) {
        List matchingStringsList = OiimHTMLHelper.extractFormElements(testString);
        String[] formData = (String[])matchingStringsList.get(0);
        String formElement = formData[0];
        System.out.println(formElement);
        Map attribsMap = OiimHTMLHelper.extractTagAttributes(formElement, ELEMENT_NAME_FORM);
        Iterator keySetIter = attribsMap.keySet().iterator();
        while (keySetIter.hasNext()) {
            String name = (String)keySetIter.next();
            String value = (String)attribsMap.get(name);
            System.out.println("name=:" + name + ":, value=:" + value + ":");
        }
        String[] matchingStrings = (String[])matchingStringsList.get(0);
        OiimHTMLHelper.extractInputElements(matchingStrings[0]);
    }

    static {
        ATTR_POSITIONS_MAP.put("formmethod", new Integer(1));
        ATTR_POSITIONS_MAP.put("formaction", new Integer(2));
        PATTERN_INPUT = Pattern.compile(REGEX_INPUT, 34);
        ATTR_POSITIONS_MAP.put("inputtype", new Integer(1));
        ATTR_POSITIONS_MAP.put("inputname", new Integer(2));
        ATTR_POSITIONS_MAP.put("inputvalue", new Integer(3));
        PATTERN_IMAGE = Pattern.compile(REGEX_IMAGE, 34);
        testString = "<td colspan=\"2\" height=\"25\" nowrap=\"nowrap\"><span class=\"bodycopy\">Enter your Single Sign-On user name and password.</span></td>                                         \n\n</tr>\n<Form  empty=\"\" Method =  \" POST\" name = LoginForm action=\"/sso/auth\" AutoComplete=\"off\" test=' ab\"c ' test2=\" a b'c \">\n<INPUT NAME=\"v\" value=\"v1.4\"  TYPE=\"hidden\" >\n<INPUT TYPE=\"hidden\" NAME=\"site2pstoretoken\" value=\"v1.2~DE70790A~B4483FDC70FCCEF9246386D131FFEACEE9E97B9DDBC0CFC2F78F6376B5124E13844EF22E14830ECCE8ED5DF92F9ACEEBFA7688175227E501938FAFC587D94949A766B7368CAFE28687AB22C06F14F15A08D2D9B31B9F3AF066D077AAF64369A353AA8338147EA69C696EF6DACD90D579E158C37E1CDC5F9CD9F002B88AE299D59E5C71734C0EE090F30B2CCA615F0055C27FC1D8D87AEA8533784B8257612D03796DFC599D9DE1EABD767816CDF79B53394569F1045B4CFEAEF23D1509E2DC0A5C1B93F25EE5FAEA857BECD0FFF90DA4\">\n<INPUT TYPE=\"hidden\" NAME=\"locale\" value=\"\">\n<INPUT TYPE=\"hidden\" NAME=\"appctx\" value=\"\">\n<tr>\n<td class=\"bodycopy\" align=\"right\" valign=\"middle\">Username&nbsp;&nbsp;</td>\n<td class=\"bodycopy\" align=\"left\" height=\"27\" valign=\"top\">\n<input name=\"ssousername\" size=\"20\" maxlength=\"80\" value=\"\" type=\"text\"></td>\n</tr>\n<tr>\n\n<td align=\"right\" height=\"27\" valign=\"middle\"> <span class=\"bodycopy\">Password&nbsp;&nbsp;</span> </td>\n<td class=\"bodycopy\" align=\"left\" height=\"27\" valign=\"top\">\n<input name=\"password\" value=\"\" size=\"20\" maxlength=\"255\" type=\"password\">\n<a href=\"javascript:doLogin(document.LoginForm);\" onmouseover=\"self.status='Press Go to Sign In'; return true\"> <img src=\"/sso_loginui/go_button.gif\" alt=\"Sign In\" align=\"middle\" border=\"0\"> </a> </td>\n</tr>\n</form>\n<tr>\n<td colspan=\"2\" height=\"43\"><a href=\"http://orion-dev.oracle.com:7778/sso/pages/change_password.jsp\" target=\"new\" class=\"bodylink\">Lost your password?</a></td>\n</tr>";
    }
}

