/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import HTTPClient.Request;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OiimHTTPHelper {
    private static final NVPair[] DEFAULT_HEADERS = new NVPair[2];

    private OiimHTTPHelper() {
    }

    public static void setHTTPHeaders(Request request) {
        OiimHTTPHelper.setHTTPHeaders(request, null);
    }

    public static void setHTTPHeaders(Request request, NVPair[] headers) {
        NVPair[] allHeaders;
        if (headers != null) {
            allHeaders = new NVPair[DEFAULT_HEADERS.length + headers.length];
            System.arraycopy(DEFAULT_HEADERS, 0, allHeaders, 0, DEFAULT_HEADERS.length);
            System.arraycopy(headers, 0, allHeaders, DEFAULT_HEADERS.length, headers.length);
        } else {
            allHeaders = DEFAULT_HEADERS;
        }
        request.setHeaders(allHeaders);
    }

    public static NVPair getFormURLEncodedContentType() {
        NVPair contentType = new NVPair("Content-Type", "application/x-www-form-urlencoded");
        return contentType;
    }

    public static void setDefaultHeaders(HTTPConnection conn) {
        conn.setDefaultHeaders(DEFAULT_HEADERS);
    }

    public static Map extractUriQueryParamsMap(String requestURI) throws URISyntaxException {
        URI uri = new URI(requestURI);
        String query = uri.getQuery();
        Map urlQueryParamsMap = OiimHTTPHelper.extractQueryParamsMap(query);
        return urlQueryParamsMap;
    }

    public static Map extractQueryParamsMap(String queryString) {
        HashMap<String, String> urlQueryParamsMap = new HashMap<String, String>();
        if (queryString == null || "".equals(queryString)) {
            return urlQueryParamsMap;
        }
        String[] queryParams = queryString.split("&");
        for (int i = 0; i < queryParams.length; ++i) {
            String[] paramData = queryParams[i].split("=");
            String paramName = paramData[0];
            String paramValue = "";
            if (paramData.length > 1) {
                paramValue = paramData[1];
            }
            urlQueryParamsMap.put(paramName, paramValue);
        }
        return urlQueryParamsMap;
    }

    public static NVPair[] getNVPairs(Map paramsMap) {
        NVPair[] nvPairs = new NVPair[]{};
        if (paramsMap != null && paramsMap.size() > 0) {
            nvPairs = new NVPair[paramsMap.size()];
            Iterator paramsMapIter = paramsMap.entrySet().iterator();
            int pos = 0;
            while (paramsMapIter.hasNext()) {
                Map.Entry entry = paramsMapIter.next();
                nvPairs[pos++] = new NVPair((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return nvPairs;
    }

    public static String encode(String str) {
        String outStr;
        if (str == null) {
            return null;
        }
        try {
            outStr = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid enc: UTF-8", e);
        }
        return outStr;
    }

    static {
        OiimHTTPHelper.DEFAULT_HEADERS[0] = new NVPair("Accept", "*/*");
        OiimHTTPHelper.DEFAULT_HEADERS[1] = new NVPair("User-Agent-Noversion", "Mozilla/4.0 (compatible; Windows NT 5.1) OracleEMAgentURLTiming/3.0");
    }
}

