/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.AuthorizationInfo;
import HTTPClient.HTTPConnection;
import HTTPClient.ParseException;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OiimHTTPProxyUtil {
    private String m_proxyHost;
    private int m_proxyPort;
    private String m_proxyRealm;
    private String m_proxyUser;
    private String m_proxyPwd;
    private String m_dontProxyFor;

    public OiimHTTPProxyUtil() {
        this.m_proxyHost = null;
        this.m_proxyPort = 80;
        this.m_proxyRealm = null;
        this.m_proxyUser = null;
        this.m_proxyPwd = null;
        this.m_dontProxyFor = null;
    }

    public OiimHTTPProxyUtil(String host, int port, String realm, String user, String passwd) {
        this.m_proxyHost = host;
        this.m_proxyPort = port;
        this.m_proxyRealm = realm;
        this.m_proxyUser = user;
        this.m_proxyPwd = passwd;
        this.m_dontProxyFor = null;
    }

    public OiimHTTPProxyUtil(String host, int port, String realm, String user, String passwd, String dontProxyFor) {
        this.m_proxyHost = host;
        this.m_proxyPort = port;
        this.m_proxyRealm = realm;
        this.m_proxyUser = user;
        this.m_proxyPwd = passwd;
        this.m_dontProxyFor = dontProxyFor;
    }

    public void setHost(String hostName) {
        this.m_proxyHost = hostName;
    }

    public String getHost() {
        return this.m_proxyHost;
    }

    public void setPort(int port) {
        this.m_proxyPort = port;
    }

    public int getPort() {
        return this.m_proxyPort;
    }

    public void setRealm(String realm) {
        this.m_proxyRealm = realm;
    }

    public String getRealm() {
        return this.m_proxyRealm;
    }

    public void setUser(String user) {
        this.m_proxyUser = user;
    }

    public String getUser() {
        return this.m_proxyUser;
    }

    public void setPassword(String pwd) {
        this.m_proxyPwd = pwd;
    }

    public String getPassword() {
        return this.m_proxyPwd;
    }

    public void setDontProxyFor(String dontProxyFor) {
        this.m_dontProxyFor = dontProxyFor;
    }

    public String getDontProxyFor() {
        return this.m_dontProxyFor;
    }

    public void set(String host, int port, String realm, String user, String passwd) {
        this.set(host, port, realm, user, passwd, null);
    }

    public void set(String host, int port, String realm, String user, String passwd, String dontProxyFor) {
        this.m_proxyHost = host;
        this.m_proxyPort = port;
        this.m_proxyRealm = realm;
        this.m_proxyUser = user;
        this.m_proxyPwd = passwd;
        this.m_dontProxyFor = null;
    }

    public static void setProxyInfo(OiimHTTPProxyUtil proxy) {
        if (proxy == null) {
            return;
        }
        OiimHTTPProxyUtil.setProxyInfo(proxy.getHost(), proxy.getPort(), proxy.getRealm(), proxy.getUser(), proxy.getPassword(), proxy.getDontProxyFor());
    }

    public static void setProxyInfo(String proxyHost, int proxyPort, String proxyRealm, String proxyUser, String proxyPwd, String dontProxyFor) {
        if (proxyHost != null) {
            HTTPConnection.setProxyServer((String)proxyHost, (int)proxyPort);
        }
        if (proxyUser != null && proxyPwd != null) {
            AuthorizationInfo.addBasicAuthorization((String)proxyHost, (int)proxyPort, (String)proxyRealm, (String)proxyUser, (String)proxyPwd);
        }
        if (dontProxyFor != null) {
            OiimHTTPProxyUtil.dontProxyFor(dontProxyFor);
        }
    }

    public static void dontProxyFor(String dontProxyFor) {
        if (dontProxyFor != null && dontProxyFor.trim().length() > 0) {
            try {
                if (dontProxyFor.indexOf(",") >= 0) {
                    StringTokenizer st = new StringTokenizer(dontProxyFor, ",");
                    int countTokens = st.countTokens();
                    String[] stmp = new String[countTokens];
                    for (int i = 0; i < countTokens; ++i) {
                        stmp[i] = st.nextToken().trim();
                    }
                    HTTPConnection.dontProxyFor((String[])stmp);
                } else {
                    HTTPConnection.dontProxyFor((String)dontProxyFor.trim());
                }
            }
            catch (ParseException e) {
                OiiolTextLogger.appendErrorText(e.getMessage());
            }
        }
    }
}

