/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.ProtocolNotSuppException;
import HTTPClient.https.Handler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OiimURLUtil {
    private static final BitSet _DONT_ENCODE_SET;
    private static final int _CASE_DIFF = 32;

    public static String encode(String s) {
        if (s == null) {
            return null;
        }
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, "UTF-8");
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (_DONT_ENCODE_SET.get(c)) {
                    out.append(c);
                    continue;
                }
                if ((char)c == '$' || (char)c == '=') {
                    out.append('$');
                    out.append(c);
                    continue;
                }
                try {
                    writer.write(c);
                    writer.flush();
                }
                catch (IOException e) {
                    buf.reset();
                    continue;
                }
                byte[] ba = buf.toByteArray();
                for (int j = 0; j < ba.length; ++j) {
                    out.append('%');
                    char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    out.append(ch);
                    ch = Character.forDigit(ba[j] & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    out.append(ch);
                }
                buf.reset();
            }
        }
        catch (IOException e) {
            OiiolTextLogger.appendErrorText(e.getMessage());
        }
        return out.toString();
    }

    public static final String decode(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        byte[] ba = new byte[s.length()];
        int idx = 0;
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        ba[idx] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        ++idx;
                        i += 2;
                    }
                    catch (NumberFormatException e) {
                        sb.append(c);
                    }
                    catch (IndexOutOfBoundsException e) {
                        sb.append(c);
                    }
                    continue block10;
                }
                default: {
                    try {
                        if (idx != 0) {
                            sb.append(new String(ba, 0, idx, "UTF-8"));
                            idx = 0;
                        }
                        sb.append(c);
                        continue block10;
                    }
                    catch (IOException e) {
                        OiiolTextLogger.appendErrorText(e.getMessage());
                    }
                }
            }
        }
        try {
            if (idx != 0) {
                sb.append(new String(ba, 0, idx, "UTF-8"));
                idx = 0;
            }
        }
        catch (IOException e) {
            OiiolTextLogger.appendErrorText(e.getMessage());
        }
        String result = sb.toString();
        return result;
    }

    public static URL getURL(String urlStr) throws MalformedURLException, ProtocolNotSuppException {
        URL retURL = null;
        if (urlStr.startsWith("http:")) {
            retURL = new URL(null, urlStr, (URLStreamHandler)new HTTPClient.http.Handler());
        } else if (urlStr.startsWith("https:")) {
            retURL = new URL(null, urlStr, (URLStreamHandler)new Handler());
        } else {
            throw new MalformedURLException("Unsupported protocol in \"" + urlStr + "\"");
        }
        return retURL;
    }

    public static URL getURL(String protocol, String host, int port, String file) throws MalformedURLException, ProtocolNotSuppException {
        URL retURL = null;
        if (protocol.equals("http")) {
            retURL = new URL(protocol, host, port, file, (URLStreamHandler)new HTTPClient.http.Handler());
        } else if (protocol.equals("https")) {
            retURL = new URL(protocol, host, port, file, (URLStreamHandler)new Handler());
        } else {
            throw new MalformedURLException("Unsupported protocol : \"" + protocol + "\"");
        }
        return retURL;
    }

    private OiimURLUtil() {
    }

    public static String getDestination(String pageName, Map pageProperties) {
        StringBuffer dest = new StringBuffer(100);
        if (pageName != null) {
            dest.append(pageName);
        }
        if (pageProperties != null && !pageProperties.isEmpty()) {
            dest.append('?');
            Iterator iter = pageProperties.keySet().iterator();
            String key = (String)iter.next();
            dest.append(key);
            dest.append('=');
            String val = (String)pageProperties.get(key);
            dest.append(OiimURLUtil.encode(val));
            while (iter.hasNext()) {
                dest.append('&');
                key = (String)iter.next();
                dest.append(key);
                dest.append('=');
                val = (String)pageProperties.get(key);
                dest.append(OiimURLUtil.encode(val));
            }
        }
        return dest.toString();
    }

    static {
        int i;
        _DONT_ENCODE_SET = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            _DONT_ENCODE_SET.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            _DONT_ENCODE_SET.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            _DONT_ENCODE_SET.set(i);
        }
        _DONT_ENCODE_SET.set(46);
        _DONT_ENCODE_SET.set(47);
    }
}

