/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepErrorDetails;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiod.OiiodISelector;
import oracle.sysman.oii.oiio.oiiod.OiiodPatchesNode;

public class OiiodDepPatchNode
extends OiiodDepNode
implements OiiodISelector {
    private OiiodPatchesNode m_oPatchesNode;
    private OiiodDepNode m_oParentNode;
    private Vector m_oDependeeNodes;

    public OiiodDepPatchNode(OiiiCompInvEntry invEntry, OiiodPatchesNode oPatchesNode) {
        super(invEntry);
        this.m_oPatchesNode = oPatchesNode;
        if (oPatchesNode != null) {
            this.m_oParentNode = oPatchesNode.getParentNode();
        }
        this.m_oDependeeNodes = new Vector();
    }

    public OiiodPatchesNode getPatchesNode() {
        return this.m_oPatchesNode;
    }

    public OiiodDepNode getParentNode() {
        return this.m_oParentNode;
    }

    public void addDependee(OiiodDepNode oNode) {
        if (this.m_oDependeeNodes.indexOf(oNode) == -1) {
            this.m_oDependeeNodes.addElement(oNode);
        }
    }

    public Vector getDependeeNodes() {
        return this.m_oDependeeNodes;
    }

    public void setDependeeNodes(Vector vChildren) {
        this.m_oDependeeNodes = vChildren;
    }

    public boolean select(Vector vMessages) {
        int nSize = this.m_oDependeeNodes.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepNode oDependee = (OiiodDepNode)this.m_oDependeeNodes.elementAt(i);
            if (oDependee instanceof OiiodDepPatchNode) {
                this.select((OiiodDepPatchNode)oDependee, vMessages);
                continue;
            }
            this.select(oDependee, vMessages);
        }
        return true;
    }

    public boolean isActiveSelectorPresent() {
        boolean bPresent = false;
        Vector vSelectors = this.getSelectors();
        int nSize = vSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodISelector oSelector = (OiiodISelector)vSelectors.elementAt(i);
            if (!oSelector.isEnforced() || !oSelector.isSelectedForInstall()) continue;
            bPresent = true;
            break;
        }
        return bPresent;
    }

    public boolean deselect(Vector vMessages) {
        int nSize = this.m_oDependeeNodes.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepNode oDependee = (OiiodDepNode)this.m_oDependeeNodes.elementAt(i);
            if (!(oDependee instanceof OiiodDepPatchNode)) continue;
            OiiodDepPatchNode oPatch = (OiiodDepPatchNode)oDependee;
            OiiodPatchesNode oPatchesNode = oPatch.getPatchesNode();
            oPatchesNode.callListeners(2);
        }
        return true;
    }

    public boolean equals(OiiiVersion oVersion) {
        return this.getVersion().equals(oVersion);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof OiiiVersion) {
            return this.equals((OiiiVersion)other);
        }
        return super.equals(other);
    }

    public boolean isSelected() {
        boolean bSelected = false;
        if (this.m_oPatchesNode == null) {
            return bSelected;
        }
        bSelected = this.m_oPatchesNode.isSelected() && this.m_oParentNode.isSelected();
        return bSelected;
    }

    public boolean isSelectedForInstall() {
        return this.isSelected();
    }

    public boolean isEnforced() {
        return this.m_oParentNode.isEnforced();
    }

    public void setSelected(boolean bSelect) {
    }

    public boolean canDeselect(OiiodDepErrorDetails vErrorMsgs) {
        return true;
    }

    public void callListeners(int nMessage) {
    }

    private boolean select(OiiodDepPatchNode oNode, Vector vMessages) {
        OiiodPatchesNode oPatchesNode = oNode.getPatchesNode();
        OiiiVersion oCurrent = oNode.getVersion();
        oPatchesNode.selectPatchLevel(null, oCurrent);
        return true;
    }

    private boolean select(OiiodDepNode oNode, Vector vMessages) {
        return true;
    }

    public boolean canParticipate() {
        return this.m_oParentNode.canParticipate();
    }

    public void print(String sTab) {
        int nSize = this.m_oDependeeNodes.size();
        System.out.println(sTab + "PATCH " + this.getVersion());
        System.out.println(sTab + "Contains " + nSize + " Dependee Patches");
        for (int i = 0; i < nSize; ++i) {
            OiiodDepPatchNode oPatch = (OiiodDepPatchNode)this.m_oDependeeNodes.elementAt(i);
            oPatch.print(sTab + "  ");
        }
    }
}

