/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiod.OiiodDepCountException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiod.OiiodDepErrorDetails;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngCmpListener;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepRuleObject;
import oracle.sysman.oii.oiio.oiiod.OiiodISelector;
import oracle.sysman.oii.oiio.oiiod.OiiodRuleSelector;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDepRuleComp;
import oracle.sysman.oii.oiis.OiisDepRuleProperty;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodDepRuleNode
implements OiiodIDepRuleObject,
OiiodISelector {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16384;
    private OiisDepRule m_oRuleId;
    private String m_oName;
    private int m_nRuleType;
    private OiiodDepNode m_oParentNode;
    private Vector m_oCompNodes;
    private Vector m_oRuleSelectors;
    private boolean m_bAsk;
    private boolean m_bExpandedByDefault;
    private Vector m_oUIListeners;

    public OiiodDepRuleNode(OiiodDepNode depNode, OiisDepRule depRule) {
        this.m_oRuleId = depRule;
        this.m_oName = depRule.getName();
        this.m_nRuleType = depRule.getType();
        this.m_oParentNode = depNode;
        this.m_bExpandedByDefault = true;
        this.m_oCompNodes = new Vector();
        this.m_oRuleSelectors = new Vector();
        this.m_oUIListeners = new Vector();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (super.equals(other)) {
            return true;
        }
        return other instanceof OiiodDepRuleNode && ((OiiodDepRuleNode)other).getInternalName().equals(this.getInternalName()) && ((OiiodDepRuleNode)other).getParentNode().equals(this.getParentNode());
    }

    public String getDisplayName() {
        if (this.getRuleType() == 1) {
            String sTag = OiixResourceBundle.getString("S_ONE_OR_MORE");
            return this.m_oName + sTag;
        }
        if (this.getRuleType() == 3) {
            this.m_oName = OiixResourceBundle.getString("S_REQUIRED_DEPS");
        }
        return this.m_oName;
    }

    public int getRuleType() {
        return this.m_nRuleType;
    }

    public String getInternalName() {
        return this.m_oRuleId.getInternalName();
    }

    public OiiodDepNode getParentNode() {
        return this.m_oParentNode;
    }

    public boolean isEnforced() {
        return this.m_oParentNode.isSelected();
    }

    public boolean canParticipate() {
        return this.m_oParentNode.canParticipate();
    }

    public boolean isSelected() {
        return true;
    }

    public boolean isSelectedForInstall() {
        return true;
    }

    public boolean isVisible() {
        if (this.getRuleType() == 3) {
            return false;
        }
        return this.m_bAsk;
    }

    public void setToBeAsked(boolean bAsk) {
        this.m_bAsk = bAsk;
    }

    public boolean isExpandedByDefault() {
        if (this.getRuleType() == 3 || !this.isVisible()) {
            this.m_bExpandedByDefault = false;
        }
        return this.m_bExpandedByDefault;
    }

    public void setExpandedByDefault(boolean bOpen) {
        this.m_bExpandedByDefault = bOpen;
    }

    public void addDepNode(OiiodDepNode oChild) {
        if (this.m_oCompNodes.indexOf(oChild) == -1) {
            this.m_oCompNodes.addElement(oChild);
        }
    }

    public Vector getDepNodes() {
        return this.m_oCompNodes;
    }

    public void setDepNodes(Vector vChildren) {
        this.m_oCompNodes = vChildren;
    }

    public void addRuleSelector(OiiodRuleSelector oChild) {
        if (this.m_oRuleSelectors.indexOf(oChild) == -1) {
            this.m_oRuleSelectors.addElement(oChild);
        }
    }

    public void setRuleSelectors(Vector vChildren) {
        this.m_oRuleSelectors = vChildren;
    }

    public Vector getChildren() {
        return this.m_oRuleSelectors;
    }

    public Vector getAllChildren() {
        return this.getChildren();
    }

    public Vector getVisibleChildren() {
        Vector v = null;
        if (this.isVisible()) {
            v = this.getChildren();
        } else {
            v = new Vector();
            int nSize = this.m_oRuleSelectors.size();
            for (int i = 0; i < nSize; ++i) {
                OiiodRuleSelector oSelector = (OiiodRuleSelector)this.m_oRuleSelectors.elementAt(i);
                Vector children = oSelector.getVisibleChildren();
                OiiodDepEngineHelper.mergeVect(v, children);
            }
        }
        return v;
    }

    public void resetAll() {
        this.m_oRuleSelectors = new Vector();
        this.m_oUIListeners = new Vector();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDescription() {
        return "";
    }

    public OiiiCompInstallID getCompInstallID() {
        return this.m_oParentNode.getCompInstallID();
    }

    public void addUIListener(OiiodIDepEngCmpListener listener) {
        this.m_oUIListeners.addElement(listener);
    }

    public Vector getCurrentSelections() throws OiiodDepCountException {
        Vector<OiiodRuleSelector> vCurSelections = new Vector<OiiodRuleSelector>();
        int nSize = this.m_oRuleSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodRuleSelector oChildNode = (OiiodRuleSelector)this.m_oRuleSelectors.elementAt(i);
            if (!oChildNode.isSelectedForInstall() && oChildNode.getCompNode().getCompStatus() != 5) continue;
            vCurSelections.addElement(oChildNode);
        }
        int nRuleType = this.getRuleType();
        switch (nRuleType) {
            case 1: {
                if (vCurSelections.size() != 0) break;
                throw new OiiodDepCountException(this.toString(), OiixResourceBundle.getString("S_ERR_ONE_OR_MORE"));
            }
            case 3: {
                if (vCurSelections.size() == nSize) break;
                throw new OiiodDepCountException(this.toString(), OiixResourceBundle.getString("S_ERR_REQUIRED"));
            }
        }
        return vCurSelections;
    }

    public void callListeners(int nMessage) {
        int nSize = this.m_oUIListeners.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodIDepEngCmpListener listener = (OiiodIDepEngCmpListener)this.m_oUIListeners.elementAt(i);
            listener.stateChanged(nMessage);
        }
    }

    public boolean anyChildSelectedInOneOrMoreRule() {
        if (this.getRuleType() != 1) {
            return false;
        }
        if (this.m_oCompNodes == null) {
            return false;
        }
        int nSize = this.m_oCompNodes.size();
        if (nSize == 0) {
            return false;
        }
        for (int i = 0; i < nSize; ++i) {
            OiiodDepNode oNode = (OiiodDepNode)this.m_oCompNodes.elementAt(i);
            if (!oNode.isSelectedAtDepModeApply()) continue;
            return true;
        }
        return false;
    }

    public Vector getOSPSelections() {
        Vector<OiiodRuleSelector> vSelectedComps = new Vector<OiiodRuleSelector>();
        OiisDepRuleProperty depRuleProp = this.m_oParentNode.getDepRuleProperty(this.getInternalName());
        Vector vComps = depRuleProp.getDepRuleComps();
        int nCompsSize = vComps.size();
        for (int j = 0; j < nCompsSize; ++j) {
            OiiiCompInstallID dependee;
            int nIndex;
            OiisDepRuleComp depRuleComp = (OiisDepRuleComp)vComps.elementAt(j);
            if (!depRuleComp.getSelected() || (nIndex = OiixVectorOps.vectIndexOf(this.m_oRuleSelectors, (Object)(dependee = depRuleComp.getComp()))) == -1) continue;
            OiiodRuleSelector oRuleSel = (OiiodRuleSelector)this.m_oRuleSelectors.elementAt(nIndex);
            vSelectedComps.addElement(oRuleSel);
        }
        return vSelectedComps;
    }

    public void setSelected(boolean bSelect) {
    }

    public boolean canDeselect(OiiodDepErrorDetails vErrorMsgs) {
        return true;
    }

    public void print(String sTab) {
        int nSize = this.m_oCompNodes.size();
        System.out.println(sTab + "Rule " + this.toString() + " Type " + this.m_oRuleId.getTypeString());
        System.out.println(sTab + "Contains " + nSize + " Components");
        for (int i = 0; i < nSize; ++i) {
            OiiodDepNode oNode = (OiiodDepNode)this.m_oCompNodes.elementAt(i);
            oNode.print(sTab + "  ");
        }
    }
}

