/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageAreaControl;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompStaging;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodStageDepGraph {
    private Vector m_graphObjs = null;
    private Hashtable m_IEsToGrObjs = null;
    private Hashtable m_IDsToGrObjsVect = null;
    private Hashtable m_IEsToRecDepsObjs = null;

    public void init(OiiiStageAreaControl stgAreaCtrl) throws IOException {
        OiiiStageCompInvEntry scie;
        int i;
        this.initMembers();
        OiiiStageInventory si = stgAreaCtrl.getStageInventory();
        Vector compsVect = si.getAllCompsVect(0);
        int numComps = compsVect.size();
        for (i = 0; i < numComps; ++i) {
            scie = (OiiiStageCompInvEntry)compsVect.elementAt(i);
            this.addGraphObjForEntry(scie);
        }
        for (i = 0; i < numComps; ++i) {
            scie = (OiiiStageCompInvEntry)compsVect.elementAt(i);
            Vector depComps = null;
            OiiiCompInstallID cid = scie.getCompInstallID();
            if (cid.getCompType() == 4) {
                String relLoc = OiixPathOps.concatPath(scie.getLocation(), "compIns.jar");
                String compJarLoc = stgAreaCtrl.genFileSysLoc(relLoc);
                OiisCompStaging cs = new OiisCompStaging();
                OiisCompJarLoader cjLoader = new OiisCompJarLoader(compJarLoc);
                try {
                    OiisPatchSetContents psConts = cjLoader.loadPSetContents();
                    depComps = psConts.getContainedPatches();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (cid.getCompType() == 2) {
                OiisPatchDeps patchDeps = ((OiiiStagePatchInvEntry)scie).getPatchDeps();
                depComps = patchDeps.getDependeeIDs();
            } else {
                OiisDeps deps = scie.getDeps();
                if (deps == null) {
                    String relLoc = OiixPathOps.concatPath(scie.getLocation(), "compIns.jar");
                    String compJarLoc = stgAreaCtrl.genFileSysLoc(relLoc);
                    OiisCompStaging cs = new OiisCompStaging();
                    OiisCompJarLoader cjLoader = new OiisCompJarLoader(compJarLoc);
                    cs.setCompJarLoader(cjLoader);
                    deps = cs.getDepInfo().getDeps();
                }
                depComps = deps.getAllDependees();
            }
            this.addDepsRelns(si, scie, depComps);
        }
    }

    public Vector getReferringEntries(Vector selEntries) {
        OiiodDepGraphObj grObj;
        Vector<OiiodDepGraphObj> graphObjs = new Vector<OiiodDepGraphObj>();
        Vector<OiiiStageCompInvEntry> intSelEntries = new Vector<OiiiStageCompInvEntry>();
        int numSels = selEntries.size();
        for (int i = 0; i < numSels; ++i) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)selEntries.elementAt(i);
            grObj = this.findGraphObjForEntry(scie);
            OiiiStageCompInvEntry intScie = grObj.getInvEntry();
            if (intSelEntries.contains(intScie)) continue;
            graphObjs.addElement(grObj);
            intSelEntries.addElement(intScie);
        }
        Vector refEntries = new Vector();
        numSels = intSelEntries.size();
        for (int i = 0; i < numSels; ++i) {
            grObj = (OiiodDepGraphObj)graphObjs.elementAt(i);
            this.addRefEntries(grObj, selEntries, refEntries);
        }
        return refEntries;
    }

    public Vector getDestageEntries(Vector selEntries) {
        this.clearAllMarks();
        Vector allGrObjs = new Vector();
        int vectSize = selEntries.size();
        for (int i = 0; i < vectSize; ++i) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)selEntries.elementAt(i);
            OiiodDepGraphObj grObj = this.findGraphObjForEntry(scie);
            OiixVectorOps.unionInPlace(allGrObjs, this.getAllRecursiveDependees(scie, this.m_IEsToRecDepsObjs));
            if (allGrObjs.contains(grObj)) continue;
            allGrObjs.addElement(grObj);
        }
        allGrObjs = this.sortGraphObjsList(allGrObjs, this.m_IEsToRecDepsObjs);
        Vector<OiiiStageCompInvEntry> destageEntries = new Vector<OiiiStageCompInvEntry>();
        int numGrObjs = allGrObjs.size();
        for (int i = 0; i < numGrObjs; ++i) {
            OiiodDepGraphObj grObj = (OiiodDepGraphObj)allGrObjs.elementAt(i);
            OiiiStageCompInvEntry objEntry = grObj.getInvEntry();
            boolean canDestage = selEntries.contains(objEntry);
            if (!canDestage && !objEntry.isTopLevel() && !grObj.shouldPreserve() && grObj.allReferencersMarked()) {
                canDestage = true;
            }
            if (!canDestage) continue;
            destageEntries.addElement(objEntry);
            grObj.setMarked(true);
        }
        return destageEntries;
    }

    public void setPreserveFlags(Vector invEntries, boolean preserveFlag) {
        int numEntries = invEntries.size();
        for (int i = 0; i < numEntries; ++i) {
            OiiiStageCompInvEntry entry = (OiiiStageCompInvEntry)invEntries.elementAt(i);
            OiiodDepGraphObj grObj = this.findGraphObjForEntry(entry);
            grObj.setPreserve(preserveFlag);
        }
    }

    public void clearPreserveFlags() {
        int numObjs = this.m_graphObjs.size();
        for (int i = 0; i < numObjs; ++i) {
            OiiodDepGraphObj obj = (OiiodDepGraphObj)this.m_graphObjs.elementAt(i);
            obj.setPreserve(false);
        }
    }

    private void initMembers() {
        this.m_graphObjs = new Vector();
        this.m_IEsToGrObjs = new Hashtable();
        this.m_IDsToGrObjsVect = new Hashtable();
        this.m_IEsToRecDepsObjs = new Hashtable();
    }

    private void addGraphObjForEntry(OiiiStageCompInvEntry entry) {
        String entHashStr = OiiodStageDepGraph.computeEntryHashString(entry);
        OiiodDepGraphObj grObj = (OiiodDepGraphObj)this.m_IEsToGrObjs.get(entHashStr);
        if (grObj == null) {
            grObj = new OiiodDepGraphObj(entry);
            this.m_graphObjs.addElement(grObj);
            this.m_IEsToGrObjs.put(entHashStr, grObj);
            String idHashStr = OiiodStageDepGraph.computeIDHashString(entry.getCompInstallID());
            Vector<OiiodDepGraphObj> grObjsVect = (Vector<OiiodDepGraphObj>)this.m_IDsToGrObjsVect.get(idHashStr);
            if (grObjsVect == null) {
                grObjsVect = new Vector<OiiodDepGraphObj>();
                this.m_IDsToGrObjsVect.put(idHashStr, grObjsVect);
            }
            grObjsVect.addElement(grObj);
        }
    }

    private OiiodDepGraphObj findGraphObjForEntry(OiiiStageCompInvEntry entry) {
        String entHashStr = OiiodStageDepGraph.computeEntryHashString(entry);
        return (OiiodDepGraphObj)this.m_IEsToGrObjs.get(entHashStr);
    }

    private Vector findGraphObjVectForID(OiiiCompInstallID cid) {
        String idHashStr = OiiodStageDepGraph.computeIDHashString(cid);
        return (Vector)this.m_IDsToGrObjsVect.get(idHashStr);
    }

    private void addDepsRelns(OiiiStageInventory stgInv, OiiiStageCompInvEntry scie, Vector depComps) {
        Vector entryPlats = scie.getPlatforms();
        OiiodDepGraphObj depdnt = this.findGraphObjForEntry(scie);
        int numDeps = depComps.size();
        for (int i = 0; i < numDeps; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)depComps.elementAt(i);
            Vector depEntries = stgInv.getCompatCompEntries2(cid, 0);
            int numDepEntries = depEntries.size();
            for (int j = 0; j < numDepEntries; ++j) {
                OiiiStageCompInvEntry depEntry = (OiiiStageCompInvEntry)depEntries.elementAt(j);
                Vector commonPlats = OiixVectorOps.intersect(depEntry.getPlatforms(), entryPlats);
                int compType = scie.getCompInstallID().getCompType();
                if (compType != 4 && commonPlats.isEmpty()) continue;
                OiiodDepGraphObj depdee = this.findGraphObjForEntry(depEntry);
                this.addGraphReln(depdnt, depdee);
            }
        }
    }

    private void addGraphReln(OiiodDepGraphObj depdnt, OiiodDepGraphObj depdee) {
        depdnt.addDependee(depdee);
        depdee.addReferencer(depdnt);
    }

    private void addRefEntries(OiiodDepGraphObj grObj, Vector existEntries, Vector refEntries) {
        Vector refDepObjs = grObj.getReferencers();
        int numRefs = refDepObjs.size();
        for (int i = 0; i < numRefs; ++i) {
            OiiodDepGraphObj refObj = (OiiodDepGraphObj)refDepObjs.elementAt(i);
            OiiiStageCompInvEntry refEntry = refObj.getInvEntry();
            if (existEntries.contains(refEntry) || refEntries.contains(refEntry)) continue;
            refEntries.addElement(refEntry);
            this.addRefEntries(refObj, existEntries, refEntries);
        }
    }

    private void clearAllMarks() {
        int numObjs = this.m_graphObjs.size();
        for (int i = 0; i < numObjs; ++i) {
            OiiodDepGraphObj grObj = (OiiodDepGraphObj)this.m_graphObjs.elementAt(i);
            grObj.setMarked(false);
        }
    }

    private Vector getAllRecursiveDependees(OiiiStageCompInvEntry scie, Hashtable recDepsMap) {
        String scieHashString = OiiodStageDepGraph.computeEntryHashString(scie);
        OiiodDepGraphObj grObj = this.findGraphObjForEntry(scie);
        Vector<OiiodDepGraphObj> recDepsHere = null;
        recDepsHere = (Vector<OiiodDepGraphObj>)recDepsMap.get(scieHashString);
        if (recDepsHere == null) {
            recDepsHere = new Vector<OiiodDepGraphObj>();
            recDepsMap.put(scieHashString, recDepsHere);
            Vector depsHere = grObj.getDependees();
            int numDeps = depsHere.size();
            for (int i = 0; i < numDeps; ++i) {
                OiiodDepGraphObj depGrObj = (OiiodDepGraphObj)depsHere.elementAt(i);
                OiiiStageCompInvEntry depEntry = depGrObj.getInvEntry();
                if (recDepsHere.contains(depGrObj)) continue;
                recDepsHere.addElement(depGrObj);
                String depEnHashString = OiiodStageDepGraph.computeEntryHashString(depEntry);
                Vector depRecDeps = (Vector)recDepsMap.get(depEnHashString);
                if (depRecDeps == null) {
                    depRecDeps = this.getAllRecursiveDependees(depEntry, recDepsMap);
                }
                OiixVectorOps.unionInPlace(recDepsHere, depRecDeps);
            }
        }
        return recDepsHere;
    }

    private Vector sortGraphObjsList(Vector graphObjs, Hashtable IEsToRecDepsObjs) {
        int vectSize = graphObjs.size();
        Vector retLst = (Vector)graphObjs.clone();
        for (int i = 0; i < vectSize - 1; ++i) {
            for (int j = i + 1; j < vectSize; ++j) {
                OiiodDepGraphObj ago = (OiiodDepGraphObj)retLst.elementAt(i);
                OiiodDepGraphObj bgo = (OiiodDepGraphObj)retLst.elementAt(j);
                String entryHashString = OiiodStageDepGraph.computeEntryHashString(bgo.getInvEntry());
                Vector deps = (Vector)IEsToRecDepsObjs.get(entryHashString);
                if (!deps.contains(ago)) continue;
                retLst.setElementAt(bgo, i);
                retLst.setElementAt(ago, j);
            }
        }
        return retLst;
    }

    private static String computeEntryHashString(OiiiStageCompInvEntry entry) {
        OiiiCompInstallID cid = entry.getCompInstallID();
        return cid.getName() + ";" + cid.getVersion().getVerString() + ";" + entry.getSaveTimeTag() + ";" + entry.getUnsavedChanges() + ";" + entry.getStageTimeTag();
    }

    private static String computeIDHashString(OiiiCompInstallID cid) {
        return cid.getName() + ";" + cid.getVersion().getVerString();
    }

    class OiiodDepGraphObj {
        private OiiiStageCompInvEntry m_invEntry;
        private Vector m_dependees;
        private Vector m_referencers;
        private boolean m_preserve;
        private boolean m_marked;

        public OiiodDepGraphObj(OiiiStageCompInvEntry invEntry) {
            this.m_invEntry = invEntry;
            this.m_dependees = new Vector();
            this.m_referencers = new Vector();
            this.m_preserve = false;
            this.m_marked = false;
        }

        public OiiiStageCompInvEntry getInvEntry() {
            return this.m_invEntry;
        }

        public boolean shouldPreserve() {
            return this.m_preserve;
        }

        public void setPreserve(boolean preserve) {
            this.m_preserve = preserve;
        }

        public boolean isMarked() {
            return this.m_marked;
        }

        public void setMarked(boolean marked) {
            this.m_marked = marked;
        }

        public void addDependee(OiiodDepGraphObj depdee) {
            this.m_dependees.addElement(depdee);
        }

        public void addReferencer(OiiodDepGraphObj depdnt) {
            this.m_referencers.addElement(depdnt);
        }

        public Vector getDependees() {
            return this.m_dependees;
        }

        public Vector getReferencers() {
            return this.m_referencers;
        }

        public boolean allReferencersMarked() {
            boolean allMarked = true;
            int numRefs = this.m_referencers.size();
            for (int i = 0; i < numRefs; ++i) {
                OiiodDepGraphObj ref = (OiiodDepGraphObj)this.m_referencers.elementAt(i);
                if (ref.isMarked()) continue;
                allMarked = false;
                break;
            }
            return allMarked;
        }

        public String toString() {
            return this.m_invEntry.toString();
        }
    }
}

