/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiof;

import java.io.File;
import java.io.IOException;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiiofNetworkFileLoader
extends OiiofFileLoader {
    private String sourceRoot;
    private boolean m_bFailedOnce = false;

    public OiiofNetworkFileLoader(String sourceRoot, String tempRoot) {
        super(true, tempRoot);
        this.sourceRoot = sourceRoot;
    }

    public String fetchImpl(String remoteLoc, String localLoc) throws IOException, OiifbCancelException {
        String retLoc = localLoc;
        String fromLoc = this.calcSrcPath(remoteLoc);
        if (!this.m_bFailedOnce) {
            if (localLoc == null) {
                retLoc = this.getTempLoc();
            }
            try {
                this.copyFile(fromLoc, retLoc);
            }
            catch (IOException e) {
                File f = new File(fromLoc);
                if (f.exists()) {
                    this.m_bFailedOnce = true;
                }
                this.releaseTempFile(retLoc);
                retLoc = fromLoc;
            }
        }
        if (this.m_bFailedOnce) {
            if (localLoc == null) {
                retLoc = fromLoc;
            } else {
                this.copyFile(fromLoc, localLoc);
                retLoc = localLoc;
            }
        }
        return retLoc;
    }

    private String calcSrcPath(String relPath) {
        return OiixPathOps.concatPath(this.sourceRoot, OiixPathOps.getStandardForm(relPath));
    }
}

