/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.BitSet;

class OiLogBlockHeader {
    private int m_numEntries;
    private int m_blockLength;
    private int m_startIndex;
    private long m_filePos;
    private boolean m_reversed = false;
    private BitSet m_undone;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 65536;

    OiLogBlockHeader(int startIndex, long filePos) {
        this.m_startIndex = startIndex;
        this.m_numEntries = 0;
        this.m_blockLength = 0;
        this.m_reversed = false;
        this.m_filePos = filePos;
        this.m_undone = new BitSet(25);
    }

    void setReversed(boolean rev) {
        this.m_reversed = rev;
    }

    boolean isReversed() {
        return this.m_reversed;
    }

    OiLogBlockHeader(byte[] byteArray) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        ObjectInputStream headerObjectStream = new ObjectInputStream(bais);
        this.m_startIndex = headerObjectStream.readInt();
        this.m_numEntries = headerObjectStream.readInt();
        this.m_blockLength = headerObjectStream.readInt();
        this.m_reversed = headerObjectStream.readBoolean();
        this.m_filePos = headerObjectStream.readLong();
        try {
            this.m_undone = (BitSet)headerObjectStream.readObject();
        }
        catch (ClassNotFoundException cne) {
            throw new IOException(cne.getMessage());
        }
        bais.close();
    }

    byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream headerObjectStream = new ObjectOutputStream(baos);
        headerObjectStream.writeInt(this.m_startIndex);
        headerObjectStream.writeInt(this.m_numEntries);
        headerObjectStream.writeInt(this.m_blockLength);
        headerObjectStream.writeBoolean(this.m_reversed);
        headerObjectStream.writeLong(this.m_filePos);
        headerObjectStream.writeObject(this.m_undone);
        headerObjectStream.flush();
        baos.close();
        return baos.toByteArray();
    }

    int getStartIndex() {
        return this.m_startIndex;
    }

    int getNumEntries() {
        return this.m_numEntries;
    }

    int getLastIndex() {
        return this.m_startIndex + this.m_numEntries - 1;
    }

    int getBlockLength() {
        return this.m_blockLength;
    }

    long getFilePos() {
        return this.m_filePos;
    }

    void markEntry(int relIndex) {
        this.m_undone.set(relIndex);
    }

    boolean isEntryMarked(int relIndex) {
        return this.m_undone.get(relIndex);
    }

    void writeHeader(RandomAccessFile raf) throws IOException {
        raf.seek(this.m_filePos);
        byte[] byteRep = this.toByteArray();
        raf.write(byteRep);
    }

    boolean isFull() {
        return this.m_numEntries >= 25 || this.m_blockLength >= 10240;
    }

    void addEntry(int entryLen) {
        if (!this.isFull()) {
            ++this.m_numEntries;
            this.m_blockLength += entryLen;
        }
    }

    int firstEntryAfter(int startIndex) {
        int retPos = -1;
        for (int i = startIndex + 1; i < this.m_numEntries; ++i) {
            if (this.m_undone.get(i)) continue;
            retPos = i;
            break;
        }
        return retPos;
    }

    int firstEntryBefore(int startIndex) {
        int retPos = -1;
        for (int i = startIndex - 1; i >= 0; --i) {
            if (this.m_undone.get(i)) continue;
            retPos = i;
            break;
        }
        return retPos;
    }
}

