/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.util.Vector;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;

class OiiolActionInputHandler
extends OixsElementHandler {
    Vector m_objects = new Vector();

    public OiiolActionInputHandler(String elemName) {
        super(elemName);
    }

    public void onStart(String name, AttributeList atts) {
        String sName = atts.getValue("NAME");
        boolean bSecure = this.getBooleanValue(atts, "SECURE");
        String sArgType = atts.getValue("TYPE");
        String sValue = atts.getValue("VAL");
        Object value = this.getArgValue(sValue, sArgType);
        String sLogValue = this.getLogValue(sValue, bSecure);
        String sRAW = atts.getValue("RAW");
        if (sRAW != null && sRAW.equalsIgnoreCase("T")) {
            this.m_objects.addElement(value);
        } else {
            OiilActionInputElement input = new OiilActionInputElement(sName, value, bSecure, sLogValue);
            this.m_objects.addElement(input);
        }
    }

    private Object getArgValue(String sValue, String sArgType) {
        String[] value = null;
        if (sArgType.equalsIgnoreCase(OiisDataTypes.STRING.getName())) {
            value = sValue;
        } else if (sArgType.equalsIgnoreCase(OiisDataTypes.BOOL.getName())) {
            value = Boolean.valueOf(sValue);
        } else if (sArgType.equalsIgnoreCase(OiisDataTypes.NUMBER.getName())) {
            value = Integer.valueOf(sValue);
        } else if (sArgType.equalsIgnoreCase(OiisDataTypes.STRINGLIST.getName())) {
            value = OiisDataTypes.getStringListObject(sValue);
        }
        return value;
    }

    public void setInputVector(Vector vObj) {
        this.m_objects = vObj;
    }

    private boolean getBooleanValue(AttributeList atts, String attName) {
        String sBooleanValue = atts.getValue(attName);
        return sBooleanValue.equals("T");
    }

    private String getLogValue(String sValue, boolean bSecure) {
        String sLogValue = null;
        if (bSecure && sValue.startsWith("%") && sValue.endsWith("%")) {
            sLogValue = sValue;
        }
        return sLogValue;
    }
}

