/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.awt.Frame;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifd.OiifdDeinstallPromptDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisIdentifierOps;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiiolActionLogEntry
implements Serializable,
OixsXMLizable {
    static final long serialVersionUID = -2583743409024695276L;
    private OiiiLibraryID m_lID;
    private String m_actionName;
    private Vector m_inputs;
    private Vector m_logObjects;
    private Vector m_backupObjects;
    private boolean m_installFlag;
    private boolean m_deinstallFlag;

    public OiiolActionLogEntry(OiiiLibraryID lid, String actionName, Vector inputs, Vector logObjects, Vector backupObjects) {
        this.m_lID = lid;
        this.m_actionName = actionName;
        this.m_inputs = inputs;
        this.m_logObjects = logObjects;
        this.m_backupObjects = backupObjects;
        this.m_installFlag = true;
        this.m_deinstallFlag = true;
    }

    public OiiolActionLogEntry(OiiiLibraryID lid, String actionName, Vector inputs, Vector logObjects, Vector backupObjects, boolean installFlag, boolean deinstallFlag) {
        this.m_lID = lid;
        this.m_actionName = actionName;
        this.m_inputs = inputs;
        this.m_logObjects = logObjects;
        this.m_backupObjects = backupObjects;
        this.m_installFlag = installFlag;
        this.m_deinstallFlag = deinstallFlag;
    }

    public OiiiLibraryID getLibraryID() {
        return this.m_lID;
    }

    public String getActionName() {
        return this.m_actionName;
    }

    public Vector getInputs() {
        return this.m_inputs;
    }

    public Vector getLogObjects() {
        return this.m_logObjects;
    }

    public Vector getBackupObjects() {
        return this.m_backupObjects;
    }

    public boolean getInstallFlag() {
        return this.m_installFlag;
    }

    public boolean getDeinstallFlag() {
        return this.m_deinstallFlag;
    }

    public String toString() {
        String retString = "[" + this.m_lID + ", " + this.m_actionName + ", ";
        try {
            retString = retString + this.m_inputs + ", ";
            retString = retString + this.m_logObjects + ", ";
            retString = retString + this.m_backupObjects + "]";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retString;
    }

    public void writeXML(PrintWriter p) throws IOException {
        this.writeDOMTree(p);
    }

    public XMLElement toXML() {
        return this.buildDOMTree();
    }

    protected XMLElement buildDOMTree() {
        XMLElement elemActionEntry = new XMLElement("ACTION");
        elemActionEntry.setAttribute("NAME", this.m_actionName);
        elemActionEntry.setAttribute("INSTALL", this.getInstallFlag() ? "T" : "F");
        elemActionEntry.setAttribute("DEINSTALL", this.getDeinstallFlag() ? "T" : "F");
        XMLElement elemLib = new XMLElement("LIB");
        elemLib.setAttribute("NAME", this.m_lID.getName());
        elemLib.setAttribute("VER", this.m_lID.getVersion().getVerString());
        elemLib.setAttribute("REP_VER", this.m_lID.getReplaceVersion().getVerString());
        elemLib.setAttribute("MIN_INST_VER", this.m_lID.getInstVer().getVerString());
        elemActionEntry.appendChild((Node)elemLib);
        XMLElement elemInputList = new XMLElement("INPUT_LIST");
        int size = this.m_inputs.size();
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement input = (OiilActionInputElement)this.m_inputs.elementAt(i);
            if (input.isImplicit()) continue;
            XMLElement elemInput = input.toXML();
            elemInputList.appendChild((Node)elemInput);
        }
        elemActionEntry.appendChild((Node)elemInputList);
        XMLElement elemLogObjList = new XMLElement("LOG_OBJ_LIST");
        size = this.m_logObjects.size();
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement inputElem;
            Object logObj = this.m_logObjects.elementAt(i);
            if (logObj instanceof OiilActionInputElement) {
                inputElem = (OiilActionInputElement)logObj;
                XMLElement elemLogObj = inputElem.toXML();
                elemLogObjList.appendChild((Node)elemLogObj);
                continue;
            }
            if (logObj instanceof String) {
                inputElem = new OiilActionInputElement("RAW_DATA", (String)logObj);
                XMLElement elemLogObj = inputElem.toXML();
                elemLogObj.setAttribute("RAW", "T");
                elemLogObjList.appendChild((Node)elemLogObj);
                continue;
            }
            if (!(logObj instanceof Vector)) continue;
            Vector logObjVect = (Vector)logObj;
            int nLogVectSize = logObjVect.size();
            XMLElement elemLogObjVect = new XMLElement("LOG_OBJECTS_VECTOR");
            for (int j = 0; j < nLogVectSize; ++j) {
                OiilActionInputElement inputElem2;
                Object inputObject = logObjVect.elementAt(j);
                if (inputObject instanceof OiilActionInputElement) {
                    inputElem2 = (OiilActionInputElement)inputObject;
                    XMLElement logObjVectItem = inputElem2.toXML();
                    elemLogObjVect.appendChild((Node)logObjVectItem);
                    continue;
                }
                inputElem2 = new OiilActionInputElement("RAW_DATA", inputObject);
                XMLElement elemLogObjItem = inputElem2.toXML();
                elemLogObjItem.setAttribute("RAW", "T");
                elemLogObjVect.appendChild((Node)elemLogObjItem);
            }
            elemLogObjList.appendChild((Node)elemLogObjVect);
        }
        elemActionEntry.appendChild((Node)elemLogObjList);
        return elemActionEntry;
    }

    protected void writeDOMTree(PrintWriter pw) throws IOException {
        XMLElement elemActionEntry = new XMLElement("ACTION");
        elemActionEntry.setAttribute("NAME", this.m_actionName);
        elemActionEntry.setAttribute("INSTALL", this.getInstallFlag() ? "T" : "F");
        elemActionEntry.setAttribute("DEINSTALL", this.getDeinstallFlag() ? "T" : "F");
        pw.println(OixsXMLOps.getStartTag(elemActionEntry));
        XMLElement elemLib = new XMLElement("LIB");
        elemLib.setAttribute("NAME", this.m_lID.getName());
        elemLib.setAttribute("VER", this.m_lID.getVersion().getVerString());
        elemLib.setAttribute("REP_VER", this.m_lID.getReplaceVersion().getVerString());
        elemLib.setAttribute("MIN_INST_VER", this.m_lID.getInstVer().getVerString());
        elemLib.print(pw);
        XMLElement elemInputList = new XMLElement("INPUT_LIST");
        pw.println(OixsXMLOps.getStartTag(elemInputList));
        int size = this.m_inputs.size();
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement input = (OiilActionInputElement)this.m_inputs.elementAt(i);
            if (input.isImplicit()) continue;
            XMLElement elemInput = input.toXML();
            elemInput.print(pw);
        }
        pw.println(OixsXMLOps.getEndTag(elemInputList));
        XMLElement elemLogObjList = new XMLElement("LOG_OBJ_LIST");
        pw.println(OixsXMLOps.getStartTag(elemLogObjList));
        size = this.m_logObjects.size();
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement inputElem;
            Object logObj = this.m_logObjects.elementAt(i);
            if (logObj instanceof OiilActionInputElement) {
                inputElem = (OiilActionInputElement)logObj;
                XMLElement elemLogObj = inputElem.toXML();
                elemLogObj.print(pw);
                continue;
            }
            if (logObj instanceof String) {
                inputElem = new OiilActionInputElement("RAW_DATA", (String)logObj);
                XMLElement elemLogObj = inputElem.toXML();
                elemLogObj.setAttribute("RAW", "T");
                elemLogObj.print(pw);
                continue;
            }
            if (!(logObj instanceof Vector)) continue;
            Vector logObjVect = (Vector)logObj;
            int nLogVectSize = logObjVect.size();
            XMLElement elemLogObjVect = new XMLElement("LOG_OBJECTS_VECTOR");
            pw.println(OixsXMLOps.getStartTag(elemLogObjVect));
            for (int j = 0; j < nLogVectSize; ++j) {
                OiilActionInputElement inputElem2;
                Object inputObject = logObjVect.elementAt(j);
                if (inputObject instanceof OiilActionInputElement) {
                    inputElem2 = (OiilActionInputElement)inputObject;
                    XMLElement logObjVectItem = inputElem2.toXML();
                    logObjVectItem.print(pw);
                    continue;
                }
                inputElem2 = new OiilActionInputElement("RAW_DATA", inputObject);
                XMLElement elemLogObjItem = inputElem2.toXML();
                elemLogObjItem.setAttribute("RAW", "T");
                elemLogObjItem.print(pw);
            }
            pw.println(OixsXMLOps.getEndTag(elemLogObjVect));
        }
        pw.println(OixsXMLOps.getEndTag(elemLogObjList));
        pw.println(OixsXMLOps.getEndTag(elemActionEntry));
    }

    public Vector getLogObjects(OiisCompContext oContext) {
        return this.getLogObjectsForDeinstall(oContext);
    }

    public Vector getLogObjectsForDeinstall(OiisCompContext oContext) {
        int nLogObjCount = this.m_logObjects.size();
        for (int i = 0; i < nLogObjCount; ++i) {
            OiilActionInputElement oElem;
            Object oValue;
            Object oLogObj = this.m_logObjects.elementAt(i);
            if (oLogObj instanceof Vector) {
                Vector vLogObj = (Vector)oLogObj;
                int nElemCount = vLogObj.size();
                for (int j = 0; j < nElemCount; ++j) {
                    OiilActionInputElement oElem2 = (OiilActionInputElement)vLogObj.elementAt(j);
                    Object oValue2 = oElem2.getObject();
                    if (!(oValue2 instanceof String)) continue;
                    String sValue = OiisIdentifierOps.instantiateString((String)oValue2, oContext);
                    oElem2.setObject(sValue);
                }
                continue;
            }
            if (!(oLogObj instanceof OiilActionInputElement) || !((oValue = (oElem = (OiilActionInputElement)oLogObj).getObject()) instanceof String)) continue;
            String sValue = OiisIdentifierOps.instantiateString((String)oValue, oContext);
            oElem.setObject(sValue);
        }
        return this.m_logObjects;
    }

    public Vector getInputsForDeinstall(OiisCompContext oContext) throws InterruptedException, InvocationTargetException {
        int size = this.m_inputs.size();
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement oInputElement = (OiilActionInputElement)this.m_inputs.elementAt(i);
            if (oInputElement.needsInputFromUser()) {
                this.getValueFromUser(oInputElement, oContext);
                continue;
            }
            Object oValue = oInputElement.getObject();
            if (oValue instanceof String) {
                String sValue = OiisIdentifierOps.instantiateString((String)oValue, oContext);
                oInputElement.setObject(sValue);
                continue;
            }
            if (!(oValue instanceof String[])) continue;
            String[] saValue = (String[])oValue;
            String[] newValue = new String[saValue.length];
            for (int j = 0; j < saValue.length; ++j) {
                newValue[j] = OiisIdentifierOps.instantiateString(saValue[j], oContext);
            }
            oInputElement.setObject(newValue);
        }
        return this.m_inputs;
    }

    private void getValueFromUser(OiilActionInputElement oInput, OiisCompContext oContext) throws InterruptedException, InvocationTargetException {
        String sSecureVal;
        String sSecureVarName = sSecureVal = oInput.getObject().toString();
        if (sSecureVal.startsWith("%") && sSecureVal.endsWith("%")) {
            sSecureVarName = sSecureVal.substring(1, sSecureVal.length() - 1);
        }
        String sPrompt = sSecureVarName;
        OiisVariable oVar = oContext.getVariable(sSecureVarName);
        String sVarType = OiisVariable.getTypeString(oVar.getType());
        if (oVar.getAdvice()) {
            oInput.setObject(oVar.getValue());
        } else {
            sPrompt = oVar.getDescription();
            InputDialog oDlg = new InputDialog(sVarType, sPrompt);
            SwingUtilities.invokeAndWait(oDlg);
            String sUserInput = oDlg.getUserInput();
            if (sUserInput != null && !sUserInput.trim().equals("")) {
                Object oValue = OiisDataTypes.getValueObject(sUserInput, sVarType);
                oInput.setObject(oValue);
                try {
                    oVar.setValue(oValue);
                    oVar.setAdvice(true);
                }
                catch (OiisVarSettingException ve) {
                    ve.printStackTrace();
                }
                catch (OiifbCancelException ve) {
                    ve.printStackTrace();
                }
            }
        }
    }

    private class InputDialog
    implements Runnable {
        private String m_sInput;
        private Frame m_oFrame = ((OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).getMainFrame();
        private String m_sType;
        private String m_sDesc;

        public InputDialog(String sType, String sDesc) {
            this.m_sType = sType;
            this.m_sDesc = sDesc;
        }

        public void run() {
            OiifdDeinstallPromptDlg oDlg = new OiifdDeinstallPromptDlg(this.m_oFrame, this.m_sType, this.m_sDesc);
            int nRet = oDlg.runDialog();
            this.m_sInput = nRet == 1 ? oDlg.getTextValue() : "";
        }

        public String getUserInput() {
            return this.m_sInput;
        }
    }
}

