/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolHandler;

public class OiiolFileHandler
extends StreamHandler
implements OiiolHandler {
    public static final int CONSOLE = 0;
    public static final int DELETE_OLD = 1;
    public static final int DO_NOTHING = 2;
    private String handlerName;
    private String logFileName;
    private OraMeteredStream meter;
    private String fileExtn;
    private int count = 1;
    private int limit = 0;
    private int limitExceeds = 2;
    private boolean bExceeds = false;
    private boolean bDoNothing = false;
    private File[] files;

    public OiiolFileHandler(String logFileName) throws IOException {
        this.handlerName = logFileName;
        this.logFileName = logFileName;
        this.openFiles();
    }

    public OiiolFileHandler(String logFileName, String extn, int limit, int count, int limitExceeds) throws IOException {
        this.handlerName = logFileName;
        this.logFileName = logFileName;
        this.fileExtn = extn;
        this.limit = limit;
        this.count = count;
        this.limitExceeds = limitExceeds;
        this.openFiles();
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogDir() {
        int idx = this.logFileName.lastIndexOf(File.separatorChar);
        return this.logFileName.substring(0, idx);
    }

    public int getMaxNumOfFiles() {
        return this.count;
    }

    public int getLogSizeLimit() {
        return this.limit;
    }

    public int getLimitExceeds() {
        return this.limitExceeds;
    }

    private void openFiles() throws IOException {
        this.files = new File[this.count];
        if (this.count > 1) {
            int idx = this.logFileName.lastIndexOf(this.fileExtn);
            String subStr = this.logFileName.substring(0, idx);
            for (int i = 0; i < this.count; ++i) {
                String filename = subStr + "_" + i + this.fileExtn;
                this.files[i] = new File(filename);
            }
        } else {
            this.files[0] = new File(this.logFileName);
        }
        this.open(this.files[0], true);
    }

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new OraMeteredStream(bout, len);
        this.setOutputStream(this.meter);
        this.logFileName = fname.getAbsolutePath();
    }

    private synchronized void rotate() {
        super.close();
        for (int i = this.count - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            }
            f1.renameTo(f2);
        }
        try {
            this.open(this.files[0], true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void publish(LogRecord record) {
        File f;
        if (!this.isLoggable(record)) {
            return;
        }
        if (this.bDoNothing && this.bExceeds) {
            return;
        }
        super.publish(record);
        this.flush();
        if (!this.bExceeds && this.limit > 0 && this.meter.written >= this.limit && (f = this.files[this.count - 1]).exists()) {
            this.bExceeds = true;
            if (this.limitExceeds == 2) {
                this.bDoNothing = true;
                return;
            }
            if (this.limitExceeds == 0) {
                BufferedOutputStream bout = new BufferedOutputStream(System.out);
                this.meter = new OraMeteredStream(bout, 0);
                this.setOutputStream(this.meter);
                return;
            }
        }
        if (!(this.limit <= 0 || this.meter.written < this.limit || this.bExceeds && this.limitExceeds != 1)) {
            this.rotate();
        }
    }

    private class OraMeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        OraMeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

