/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import oracle.sysman.oii.oiio.oiiol.OiiolConsoleHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolErrorManager;
import oracle.sysman.oii.oiio.oiiol.OiiolFileHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiio.oiiol.OiiolSimpleFormatter;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLFormatter;

public class OiiolLogger
extends Logger {
    public static final String LOG_PROPERTIES_FILE = "oiiollogger.properties";
    public static final String LOG_DIRECTORY = "Oiiol_Log_Directory";
    public static final String FILE_ROTATION_POLICY = "Log_File_Rotation_Count";
    public static final String FILE_MAX_SIZE = "Log_File_Max_Size";
    public static final String LOG_LEVEL = "oracle.installer.logLevel";
    public static final String PUT_TIMESTAMP = "oracle.installer.putTimestamp";
    public static final String DEBUG = "oracle.installer.debug";
    private static int LOG_FILE_SIZE = 2048;
    private static final String S_SEPERATOR = ": ";
    private static Properties loggerProperties = OiiolLoggerUtil.loadProperties("oiiollogger.properties");
    private static String s_logDir = System.getProperty("Oiiol_Log_Directory", "Logs");
    private static boolean b_putTimestamp = Boolean.getBoolean("oracle.installer.putTimestamp");
    private static OiiolLogger defaultLogger = null;
    private Hashtable hashHandlers = new Hashtable();
    public static final String SEVERE = "SEVERE";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    public static final String CONFIG = "CONFIG";
    public static final String FINE = "FINE";
    public static final String FINER = "FINER";
    public static final String FINEST = "FINEST";
    public static final String ALL = "ALL";
    public static final String BASIC = "BASIC";
    public static final String GENERAL = "GENERAL";
    public static final String DETAILED = "DETAILED";
    public static final String TRACE = "TRACE";
    public static final int LOG_SEVERE = -3;
    public static final int LOG_WARNING = -2;
    public static final int LOG_CONFIG = -1;
    public static final int LOG_INFO = 0;
    public static final int LOG_FINE = 1;
    public static final int LOG_FINER = 2;
    public static final int LOG_FINEST = 3;
    public static final String XML_FORMAT = "XML";
    public static final String SIMPLE_FORMAT = "SIMPLE";
    private static Level s_defaultLogLevel = Level.INFO;
    private static int s_nLogLevel = 0;

    protected OiiolLogger(String name, String resourceBundleName, boolean useParent) {
        super(name, resourceBundleName);
        String logLevelStr = System.getProperty("oracle.installer." + name + ".logLevel");
        Level logLevel = OiiolLogger.getLogLevel(logLevelStr);
        if (logLevel != null) {
            this.setLevel(logLevel);
        } else {
            this.setLevel(s_defaultLogLevel);
        }
        this.setUseParentHandlers(useParent);
        if (defaultLogger == null) {
            this.initLoggerServer();
        }
    }

    public static synchronized OiiolLogger getOiiolLogger(String name) {
        return OiiolLogger.getOiiolLogger(name, null);
    }

    public static synchronized OiiolLogger getOiiolLogger(String name, boolean useParent) {
        return OiiolLogger.getOiiolLogger(name, null, useParent);
    }

    public static synchronized OiiolLogger getOiiolLogger(String name, String resourceBundleName) {
        return OiiolLogger.getOiiolLogger(name, resourceBundleName, false);
    }

    public static synchronized OiiolLogger getOiiolLogger(String name, String resourceBundleName, boolean useParent) {
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.getLogger(name);
        if (result == null) {
            result = new OiiolLogger(name, resourceBundleName, useParent);
            manager.addLogger(result);
            result = manager.getLogger(name);
        } else if (!(result instanceof OiiolLogger)) {
            return null;
        }
        return (OiiolLogger)result;
    }

    public static int getLogLevel() {
        return s_nLogLevel;
    }

    public static void say(String what) {
        defaultLogger.log(Level.INFO, what);
    }

    public static void bark(String what) {
        defaultLogger.log(Level.SEVERE, what);
    }

    public static String getAvailableHandlers() {
        return "";
    }

    public void setHandlerLevel(String handlerName, Level level) {
        Handler handler = (Handler)this.hashHandlers.get(handlerName);
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public void stop() {
    }

    public void initLoggerServer() {
    }

    public static Level getLogLevel(String sLogLevel) {
        if (sLogLevel != null) {
            if ((sLogLevel = sLogLevel.trim()).equalsIgnoreCase(SEVERE)) {
                return Level.SEVERE;
            }
            if (sLogLevel.equalsIgnoreCase(WARNING)) {
                return Level.WARNING;
            }
            if (sLogLevel.equalsIgnoreCase(INFO) || sLogLevel.equalsIgnoreCase(BASIC)) {
                return Level.INFO;
            }
            if (sLogLevel.equalsIgnoreCase(CONFIG)) {
                return Level.CONFIG;
            }
            if (sLogLevel.equalsIgnoreCase(GENERAL) || sLogLevel.equalsIgnoreCase(FINE)) {
                return Level.FINE;
            }
            if (sLogLevel.equalsIgnoreCase(DETAILED) || sLogLevel.equalsIgnoreCase(FINER)) {
                return Level.FINER;
            }
            if (sLogLevel.equalsIgnoreCase(TRACE) || sLogLevel.equalsIgnoreCase(FINEST)) {
                return Level.FINEST;
            }
        }
        return null;
    }

    private static int getIntLogLevel(String sLogLevel) {
        if (sLogLevel != null) {
            if ((sLogLevel = sLogLevel.trim()).equalsIgnoreCase(SEVERE)) {
                return -3;
            }
            if (sLogLevel.equalsIgnoreCase(WARNING)) {
                return -2;
            }
            if (sLogLevel.equalsIgnoreCase(INFO) || sLogLevel.equalsIgnoreCase(BASIC)) {
                return 0;
            }
            if (sLogLevel.equalsIgnoreCase(CONFIG)) {
                return -1;
            }
            if (sLogLevel.equalsIgnoreCase(GENERAL) || sLogLevel.equalsIgnoreCase(FINE)) {
                return 1;
            }
            if (sLogLevel.equalsIgnoreCase(DETAILED) || sLogLevel.equalsIgnoreCase(FINER)) {
                return 2;
            }
            if (sLogLevel.equalsIgnoreCase(TRACE) || sLogLevel.equalsIgnoreCase(FINEST)) {
                return 3;
            }
        }
        return 0;
    }

    public static Level convertIntToLevel(int level) {
        Level logLevel;
        switch (level) {
            case 0x7FFFFFFF: {
                logLevel = Level.OFF;
                break;
            }
            case -3: {
                logLevel = Level.SEVERE;
                break;
            }
            case -2: {
                logLevel = Level.WARNING;
                break;
            }
            case -1: {
                logLevel = Level.CONFIG;
                break;
            }
            case 1: {
                logLevel = Level.FINE;
                break;
            }
            case 2: {
                logLevel = Level.FINER;
                break;
            }
            case 3: {
                logLevel = Level.FINEST;
                break;
            }
            default: {
                logLevel = Level.INFO;
            }
        }
        return logLevel;
    }

    public String addOiiolFileHandler(String dir, Level level, String format, boolean timestamp) {
        dir = dir == null ? s_logDir : dir;
        File par = new File(dir);
        par.mkdirs();
        Formatter formatter = new OiiolXMLFormatter();
        String ext = ".xml";
        if (SIMPLE_FORMAT.equals(format)) {
            formatter = new OiiolSimpleFormatter();
            ext = ".log";
        }
        String logFilePath = timestamp ? dir + File.separator + this.getName() + OiiolLoggerUtil.getTimeStamp() + ext : dir + File.separator + this.getName() + ext;
        return this._addOiiolFileHandler(logFilePath, level, formatter);
    }

    private String _addOiiolFileHandler(String logFilePath, Level level, Formatter formatter) {
        if (this.hashHandlers.get(logFilePath) != null) {
            return logFilePath;
        }
        OiiolFileHandler handler = null;
        try {
            handler = new OiiolFileHandler(logFilePath);
            if (level != null) {
                handler.setLevel(level);
            }
            handler.setFormatter(formatter);
            this.addHandler(handler);
            this.hashHandlers.put(handler.getHandlerName(), handler);
        }
        catch (IOException e) {
            System.err.println("OiiolLogger.addFileHandler:Error while adding file handler - " + logFilePath);
            System.err.println(e.toString());
            return null;
        }
        return handler.getHandlerName();
    }

    private String _addOiiolFileHandler(String logFilePath, Level level, Formatter formatter, String extn, int limit, int count, int limitExceeds) {
        if (this.hashHandlers.get(logFilePath) != null) {
            return logFilePath;
        }
        OiiolFileHandler handler = null;
        try {
            handler = new OiiolFileHandler(logFilePath, extn, limit, count, limitExceeds);
            if (level != null) {
                handler.setLevel(level);
            }
            handler.setFormatter(formatter);
            this.addHandler(handler);
            this.hashHandlers.put(handler.getHandlerName(), handler);
        }
        catch (IOException e) {
            System.err.println("OiiolLogger.addFileHandler:Error while adding file handler - " + logFilePath);
            System.err.println(e.toString());
            return null;
        }
        return handler.getHandlerName();
    }

    public String addOiiolConsoleHandler(Level level, String format) {
        Formatter formatter = new SimpleFormatter();
        if (XML_FORMAT.equals(format)) {
            formatter = new XMLFormatter();
        }
        if (this.hashHandlers.get("OiiolConsoleHandler") != null) {
            return "OiiolConsoleHandler";
        }
        OiiolConsoleHandler handler = null;
        handler = new OiiolConsoleHandler();
        if (level != null) {
            handler.setLevel(level);
        }
        handler.setFormatter(formatter);
        this.addHandler(handler);
        this.hashHandlers.put(handler.getHandlerName(), handler);
        return handler.getHandlerName();
    }

    public void removeHandler(String handlerName) {
        Handler handler = (Handler)this.hashHandlers.get(handlerName);
        if (handler != null) {
            this.removeHandler(handler);
        }
    }

    public Handler setLogLocationWithTimestamp(String dir, String file, String extension) {
        return this.setLogLoc(dir, file, extension, null, null, true);
    }

    public Handler setLogLocationWithTimestamp(String dir, String file, String extension, Level level, Formatter formatter) {
        return this.setLogLoc(dir, file, extension, level, formatter, true);
    }

    public Handler setLogLocationWithTimestamp(String dir, String file, String extension, Level level, Formatter formatter, int limit, int count, int limitExceeds) {
        return this.setLogLoc(dir, file, extension, level, formatter, true, limit, count, limitExceeds);
    }

    public Handler setLogLocation(String dir, String file, String extension) {
        return this.setLogLoc(dir, file, extension, null, null, false);
    }

    public Handler setLogLocation(String dir, String file, String extension, Level level, Formatter formatter) {
        return this.setLogLoc(dir, file, extension, level, formatter, false);
    }

    private Handler setLogLoc(String dir, String file, String extension, Level level, Formatter formatter, boolean timestamp) {
        return this.setLogLoc(dir, file, extension, level, formatter, timestamp, 0, 1, 2);
    }

    private Handler setLogLoc(String dir, String file, String extension, Level level, Formatter formatter, boolean timestamp, int limit, int count, int limitExceeds) {
        String string = dir = dir == null ? s_logDir : dir;
        if (file == null) {
            file = "installActions";
        }
        if (extension == null) {
            extension = ".log";
        }
        if (level == null) {
            level = Level.FINEST;
        }
        if (formatter == null) {
            formatter = new OiiolSimpleFormatter();
        }
        File par = new File(dir);
        par.mkdirs();
        String filePath = timestamp ? dir + File.separator + file + OiiolLoggerUtil.getTimeStamp() + extension : dir + File.separator + file + extension;
        String handlerName = this._addOiiolFileHandler(filePath, level, formatter, extension, limit, count, limitExceeds);
        Handler handler = null;
        if (handlerName != null) {
            handler = (Handler)this.hashHandlers.get(handlerName);
        }
        return handler;
    }

    public void resetLogger() {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            this.removeHandler(handler);
            handler.close();
        }
        this.hashHandlers.clear();
    }

    public static void resetLoggers() {
        Enumeration<String> enum_1 = LogManager.getLogManager().getLoggerNames();
        while (enum_1.hasMoreElements()) {
            String name = enum_1.nextElement();
            Logger logger = LogManager.getLogManager().getLogger(name);
            if (!(logger instanceof OiiolLogger)) continue;
            ((OiiolLogger)logger).resetLogger();
        }
    }

    public void flushHandlers() {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            handler.flush();
        }
    }

    public boolean isDiskSpaceSufficient() {
        Handler[] handlers = this.getHandlers();
        boolean retValue = true;
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (!(handler instanceof OiiolFileHandler) || OiiolLoggerUtil.isDiskSpaceSufficient(LOG_FILE_SIZE, ((OiiolFileHandler)handler).getLogDir())) continue;
            retValue = false;
        }
        return retValue;
    }

    public boolean checkError() {
        Handler[] handlers = this.getHandlers();
        boolean retValue = false;
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            ErrorManager errorManager = handler.getErrorManager();
            if (!(errorManager instanceof OiiolErrorManager) || !((OiiolErrorManager)errorManager).getErr()) continue;
            retValue = true;
            ((OiiolErrorManager)errorManager).setErr(false);
        }
        return retValue;
    }

    public void writeLogWithTimestamp(Level level, String message, Object[] params) {
        String sMessage = "";
        String timestamp = "";
        if (!b_putTimestamp) {
            Date dateNow = new Date();
            DateFormat df = DateFormat.getDateTimeInstance(3, 1);
            timestamp = df.format(dateNow);
        }
        sMessage = timestamp + S_SEPERATOR + message;
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (resourceBundle != null) {
            try {
                sMessage = resourceBundle.getString(message);
                if (!message.equalsIgnoreCase(sMessage)) {
                    sMessage = message + S_SEPERATOR + timestamp + S_SEPERATOR + sMessage;
                }
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        super.log(level, sMessage, params);
    }

    static {
        defaultLogger = OiiolLogger.getOiiolLogger("OiiolDefaultLogger", true);
        boolean debug = Boolean.getBoolean(DEBUG);
        if (debug) {
            s_defaultLogLevel = Level.FINEST;
            s_nLogLevel = 3;
            b_putTimestamp = true;
        } else {
            Level logLevel;
            s_nLogLevel = OiiolLogger.getIntLogLevel(System.getProperty(LOG_LEVEL, INFO));
            s_defaultLogLevel = logLevel = OiiolLogger.convertIntToLevel(s_nLogLevel);
        }
    }
}

