/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OiiolSimpleFormatter
extends Formatter {
    public static final String LOG_PROPERTIES_FILE = "oiiollogger.properties";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String PUT_TIMESTAMP = "oracle.installer.putTimestamp";
    public static final String DEBUG = "oracle.installer.debug";
    private static final String S_SEPERATOR = ": ";
    private static String s_lineSeparator = System.getProperty("line.separator");
    private static int FINE = Level.FINE.intValue();
    private static int FINEST = Level.FINEST.intValue();
    private static boolean b_putTimestamp = Boolean.getBoolean("oracle.installer.putTimestamp");

    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        String message = this.formatMessage(record);
        try {
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters.length != 0) {
                message = MessageFormat.format(message, parameters);
            }
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Level level = record.getLevel();
        if (!level.equals(Level.OFF)) {
            sb.append(record.getLevel().getLocalizedName());
            sb.append(S_SEPERATOR);
        }
        if (b_putTimestamp || level.intValue() <= FINEST) {
            Date dateNow = new Date();
            DateFormat df = DateFormat.getDateTimeInstance(3, 1);
            sb.append(df.format(dateNow));
            sb.append(S_SEPERATOR);
        }
        sb.append(message);
        sb.append(s_lineSeparator);
        return sb.toString();
    }

    static {
        boolean debug = Boolean.getBoolean(DEBUG);
        if (debug) {
            b_putTimestamp = true;
        }
    }
}

