/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolCopyLogInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolFileHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiiolTextLogger {
    private static String m_logLoc = null;
    private static String m_configLogLoc = null;
    private static String m_sSilentLogLoc = null;
    private static String m_logErrFile;
    private static String m_errLogLoc;
    private static boolean m_logErrorStart;
    private static OiiolLogger m_errLogger;
    private static OiiolLogger m_logger;
    private static String sTmpDir;
    private static OiiolLogger m_configLogger;
    private static OutputStream m_configFOS;
    private static PrintWriter m_memlogStream;
    private static PrintWriter m_dulogStream;
    private static PrintWriter m_timelogStream;
    private static boolean m_bValidate;
    private static Vector m_backUp;
    private static Vector m_configBackUp;
    private static int LOG_FILE_SIZE;
    private static String[] m_envVars;
    public static final String S_INSTALLACTIONS = "installActions";
    public static final String S_LOG_EXTN = ".log";
    private static String m_sLogName;
    private static String m_sMemLogName;
    private static String m_sDiskUsageLogName;
    private static String m_sTimeLogName;
    private static String m_sLogExtension;
    private static String m_cLogExtension;
    private static String m_sSilentErrLogName;
    private static String m_sSilentErrLogExtension;
    private static boolean m_bEnabled;
    private static boolean m_bConfigEnabled;
    private static String m_cLogName;
    public static String s_sConfigToolCommands;
    public static String s_sConfigToolFailedCommand;
    public static int LOG_WITHOUT_LEVEL;
    public static int LOG_SEVERE;
    public static int LOG_WARNING;
    public static int LOG_CONFIG;
    public static int LOG_BASIC;
    public static int LOG_GENERAL;
    public static int LOG_DETAILED;
    public static int LOG_TRACE;
    public static String STR_LOG_SEVERE;
    public static String STR_LOG_WARNING;
    public static String STR_LOG_CONFIG;
    public static String STR_LOG_BASIC;
    public static String STR_LOG_GENERAL;
    public static String STR_LOG_DETAILED;
    public static String STR_LOG_TRACE;
    public static String NEW_LINE;
    public static final String S_LINE = "-----------------------------------------------------------------------------";
    private static final String S_OUI_MSG_TAG = "OUI-";
    private static final String S_LOG_INFO_TAG = "S_LOG_INFO";
    private static int m_nLogLevel;
    private static String m_sLogLevel;
    private static List m_lCopyLogInfoObjs;
    private static Level m_oLevel;
    private static Formatter m_oFormatter;
    public static final String s_logLocRelToOH = "cfgtoollogs/oui/";
    public static final String s_invLogLoc = "logs/";

    public static void registerCopyLogInfo(OiiolCopyLogInfo copyInfo) {
        if (m_lCopyLogInfoObjs == null) {
            m_lCopyLogInfoObjs = new ArrayList();
        }
        m_lCopyLogInfoObjs.add(copyInfo);
    }

    public static synchronized void setLogLoc(String logDir) {
        try {
            OiiolTextLogger.setLogLoc(logDir, S_INSTALLACTIONS);
        }
        catch (IOException e) {
            if (m_logger == null) {
                m_logLoc = null;
            }
            e.printStackTrace();
        }
    }

    public static synchronized void setLogLoc(String logDir, String logName) throws IOException {
        OiiolTextLogger.setLogLoc(logDir, logName, S_LOG_EXTN);
    }

    public static synchronized String getLogDir() {
        return m_logLoc;
    }

    public static synchronized void setLogLoc(String logDir, String logName, String extension) throws IOException {
        OiiolTextLogger.setLogLoc(logDir, logName, extension, null, null);
    }

    public static synchronized void setLogLoc(String logDir, String logName, String extension, Level level, Formatter formatter) throws IOException {
        m_logLoc = logDir;
        m_sLogName = logName;
        m_sLogExtension = extension;
        m_oLevel = level;
        m_oFormatter = formatter;
        m_bEnabled = true;
        OiiolTextLogger.clearLog();
    }

    public static synchronized void setConfigLogLoc(String oraHome) throws IOException {
        if (oraHome == null || oraHome.length() == 0) {
            return;
        }
        m_configLogLoc = oraHome + File.separator + "cfgtoollogs";
        OiiolTextLogger.clearConfigLog();
    }

    public static synchronized void setSilentInstallErrLog(String loc) {
        String silentLogName = "silentInstall";
        OiiolTextLogger.setSilentInstallErrLog(loc, silentLogName);
    }

    public static synchronized void setSilentInstallErrLog(String loc, String logName) {
        String stLogName = logName + OiixUtilityOps.getSessionTimeStamp();
        OiiolTextLogger.setSilentInstallErrLog(loc, stLogName, S_LOG_EXTN);
    }

    public static synchronized void setSilentInstallErrLog(String logDir, String logName, String extension) {
        m_sSilentErrLogName = logName;
        m_sSilentErrLogExtension = extension;
        m_errLogLoc = logDir = OiixPathOps.getStandardForm(logDir);
        m_logErrFile = OiixPathOps.concatPath(logDir, logName + extension);
        m_logErrFile = OiixPathOps.getNativeForm(m_logErrFile);
        m_logErrorStart = false;
    }

    public static synchronized void setEnabled(boolean bEnabled) {
        m_bEnabled = bEnabled;
        OiiolTextLogger.setConfigLogEnabled(bEnabled);
    }

    public static synchronized boolean isEnabled() {
        return m_bEnabled;
    }

    public static void setConfigLogEnabled(boolean cEnabled) {
        m_bConfigEnabled = cEnabled;
    }

    public static boolean isConfigLogEnabled() {
        return m_bConfigEnabled;
    }

    public static OiiolLogger getTextLogger() {
        return m_logger;
    }

    public static void setTextLogger(OiiolLogger logger) {
        m_logger = logger;
    }

    public static OiiolLogger getConfigLogWriter() {
        return m_configLogger;
    }

    public static OutputStream getConfigLogStream() {
        return m_configFOS;
    }

    public static String getLogLevelStr(int logLevel) {
        String levelStr = NEW_LINE;
        for (int i = 0; i < logLevel; ++i) {
            levelStr = levelStr + "#";
        }
        if (logLevel > 0) {
            levelStr = levelStr + " ";
        }
        return levelStr;
    }

    public static StringBuffer StringArrayToStringBuf(String[] val) {
        StringBuffer sl = new StringBuffer(OiixFunctionOps.implodeList(val, ","));
        return sl;
    }

    public static String getBackUpLogFileName(String curFile) {
        String str = "";
        if (curFile != null) {
            try {
                FileInputStream is = new FileInputStream(curFile);
                BufferedReader f = new BufferedReader(new InputStreamReader(is));
                while ((str = f.readLine()).trim().equals("")) {
                }
                f.close();
                if (str == null) {
                    str = "";
                }
                if (!str.startsWith(m_sLogName) || !str.endsWith(m_sLogExtension)) {
                    File l = new File(curFile);
                    Date d = new Date(l.lastModified());
                    SimpleDateFormat s = new SimpleDateFormat(OiixResourceBundle.getString("S_DATE_FORMAT"));
                    str = m_sLogName + s.format(d) + m_sLogExtension;
                }
                if (m_logLoc != null) {
                    str = OiixPathOps.getNativeForm(m_logLoc + File.separatorChar + str.trim());
                    return str;
                }
            }
            catch (IOException f) {
                f.printStackTrace();
            }
        }
        return null;
    }

    public static String getLogFileName(String sLogName, String sTimeStamp, String sLogExtension) {
        String s = null;
        if (m_logLoc != null) {
            s = OiixPathOps.getNativeForm(m_logLoc + File.separatorChar + sLogName + sTimeStamp + sLogExtension);
            s.replace("\"" + File.separatorChar + File.separatorChar + "\"", "\"" + File.separatorChar + "\"");
        }
        return s;
    }

    public static void renameInstallActionsLog(String logLoc, String rename) {
        String src = OiixPathOps.getNativeForm(logLoc + File.separatorChar + m_sLogName + OiixUtilityOps.getSessionTimeStamp() + m_sLogExtension);
        if (new File(src).exists()) {
            String des = OiixPathOps.getNativeForm(logLoc + File.separatorChar + rename + OiixUtilityOps.getSessionTimeStamp() + m_sLogExtension);
            new File(src).renameTo(new File(des));
        }
    }

    public static String getCurLogFileName() {
        return OiiolTextLogger.getLogFileName(m_sLogName, OiixUtilityOps.getSessionTimeStamp(), m_sLogExtension);
    }

    private static String getCurConfigLogFileName() {
        String s = null;
        if (m_configLogLoc != null) {
            s = OiixPathOps.getNativeForm(m_configLogLoc + File.separatorChar + m_cLogName + OiixUtilityOps.getSessionTimeStamp() + m_cLogExtension);
        }
        return s;
    }

    public static String getConfigToolCommandsFileName() {
        String s = null;
        if (m_configLogLoc != null) {
            s = OiixPathOps.concatPath(m_configLogLoc, s_sConfigToolCommands);
            s = OiixPathOps.getNativeForm(s);
        }
        return s;
    }

    public static String getFailedConfigToolCommandsFileName() {
        String s = null;
        if (m_configLogLoc != null) {
            s = OiixPathOps.concatPath(m_configLogLoc, s_sConfigToolFailedCommand);
            s = OiixPathOps.getNativeForm(s);
        }
        return s;
    }

    public static String getMemoryLogFileName() {
        String s = null;
        if (m_logLoc != null) {
            s = OiixPathOps.getNativeForm(m_logLoc + File.separatorChar + m_sMemLogName + OiixUtilityOps.getSessionTimeStamp() + m_sLogExtension);
        }
        return s;
    }

    public static String getDiskUsageLogFileName() {
        String s = null;
        if (m_logLoc != null) {
            s = OiixPathOps.getNativeForm(m_logLoc + File.separatorChar + m_sDiskUsageLogName + OiixUtilityOps.getSessionTimeStamp() + m_sLogExtension);
        }
        return s;
    }

    public static String getTimeLogFileName() {
        String s = null;
        if (m_logLoc != null) {
            s = OiixPathOps.getNativeForm(m_logLoc + File.separatorChar + m_sTimeLogName + OiixUtilityOps.getSessionTimeStamp() + m_sLogExtension);
        }
        return s;
    }

    public static String getErrorLogFileName() {
        if (m_logErrFile == null) {
            String sPath = System.getProperty("oracle.installer.scratchPath");
            sPath = OiixPathOps.getStandardForm(sPath);
            sPath = OiixPathOps.getParentDir(sPath);
            m_errLogLoc = OiixPathOps.getNativeForm(sPath);
            sPath = OiixPathOps.concatPath(sPath, m_sSilentErrLogName + m_sSilentErrLogExtension);
            m_logErrFile = sPath = OiixPathOps.getNativeForm(sPath);
        }
        return m_logErrFile;
    }

    public static void clearLog() throws IOException {
        if (!m_bEnabled) {
            return;
        }
        if (m_logLoc != null) {
            if (m_logger != null) {
                m_logger.resetLogger();
            }
            if (m_memlogStream != null) {
                m_memlogStream.close();
                m_memlogStream = null;
            }
            if (m_dulogStream != null) {
                m_dulogStream.close();
                m_dulogStream = null;
            }
            if (m_timelogStream != null) {
                m_timelogStream.close();
                m_timelogStream = null;
            }
            if (m_errLogger != null) {
                m_errLogger.resetLogger();
            }
            OiiolTextLogger.initializeTextLog();
        }
    }

    public static void clearConfigLog() throws IOException {
        if (!m_bConfigEnabled) {
            return;
        }
        if (m_configLogLoc != null) {
            OiiolTextLogger.closeConfigLog();
        }
    }

    public static void closeLog() {
        if (m_logger != null) {
            m_logger.resetLogger();
        }
        if (m_memlogStream != null) {
            m_memlogStream.close();
            m_memlogStream = null;
        }
        if (m_dulogStream != null) {
            m_dulogStream.close();
            m_dulogStream = null;
        }
        if (m_timelogStream != null) {
            m_timelogStream.close();
            m_timelogStream = null;
        }
        if (m_errLogger != null) {
            m_errLogger.resetLogger();
        }
        OiiolTextLogger.closeConfigLog();
    }

    public static void closeConfigLog() {
        if (m_configLogger != null) {
            m_configLogger.resetLogger();
        }
        if (m_configFOS != null) {
            try {
                m_configFOS.close();
                m_configFOS = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static synchronized void initializeTextLog() throws IOException {
        OiiolTextLogger.initializeInstallActionLog();
        if (OiixDebug.PRINT_MEMORY) {
            OiiolTextLogger.initializeMemoryLog();
        }
        if (OiixDebug.PRINT_DISKUSAGE) {
            OiiolTextLogger.initializeDiskUsageLog();
        }
        if (OiixDebug.PRINT_TIME) {
            OiiolTextLogger.initializeTimeLog();
        }
    }

    private static synchronized void initializeMemoryLog() throws IOException {
        String curLogFileName = OiiolTextLogger.getMemoryLogFileName();
        File f = new File(curLogFileName);
        File par = new File(f.getParent());
        OiixFileOps.mkdirs(par);
        FileWriter fw = new FileWriter(curLogFileName);
        m_memlogStream = new PrintWriter((Writer)fw, true);
        OiixDebug.setMemoryLogFile(m_memlogStream);
        OiixDebug.printMemoryHdr();
    }

    private static synchronized void initializeDiskUsageLog() throws IOException {
        String curLogFileName = OiiolTextLogger.getDiskUsageLogFileName();
        File f = new File(curLogFileName);
        File par = new File(f.getParent());
        OiixFileOps.mkdirs(par);
        FileWriter fw = new FileWriter(curLogFileName);
        m_dulogStream = new PrintWriter((Writer)fw, true);
        OiixDebug.setDiskUsageLogFile(m_dulogStream);
        OiixDebug.initDiskUsageDebug();
    }

    private static synchronized void initializeTimeLog() throws IOException {
        String curLogFileName = OiiolTextLogger.getTimeLogFileName();
        File f = new File(curLogFileName);
        File par = new File(f.getParent());
        OiixFileOps.mkdirs(par);
        FileWriter fw = new FileWriter(curLogFileName, true);
        m_timelogStream = new PrintWriter((Writer)fw, true);
        OiixDebug.setTimeLogFile(m_timelogStream);
        OiixDebug.printTimeHdr();
    }

    private static synchronized void initializeInstallActionLog() throws IOException {
        String sPath;
        String curLogFileName = OiiolTextLogger.getCurLogFileName();
        File f = new File(curLogFileName);
        File par = new File(f.getParent());
        OiixFileOps.mkdirs(par);
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            try {
                OiipuUnixOps.changePermission(curLogFileName, 416);
                OiipuUnixOps.changePermission(f.getParent(), 504);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
        if ((m_logger = OiiolLogger.getOiiolLogger("OUI", null)) == null) {
            return;
        }
        m_logger.resetLogger();
        Handler handler = m_logger.setLogLocationWithTimestamp(m_logLoc, m_sLogName, m_sLogExtension, m_oLevel, m_oFormatter);
        if (handler == null) {
            return;
        }
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            try {
                OiipuUnixOps.changePermission(curLogFileName, 416);
                OiipuUnixOps.changePermission(f.getParent(), 504);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
        if ((sPath = System.getProperty("oracle.installer.scratchPath")) != null) {
            sPath = OiixPathOps.getStandardForm(sPath);
            sPath = OiixPathOps.getParentDir(sPath);
            sPath = OiixPathOps.concatPath(sPath, sTmpDir + OiixUtilityOps.getSessionTimeStamp());
            sPath = OiixPathOps.concatPath(sPath, m_sLogName + OiixUtilityOps.getSessionTimeStamp() + m_sLogExtension);
            sPath = OiixPathOps.getNativeForm(sPath);
            File ff = new File(sPath);
            boolean bContinueCopy = true;
            if (null != sPath && null != OiiolTextLogger.getCurLogFileName() && OiipgFileSystem.equalPathStrs(sPath, OiiolTextLogger.getCurLogFileName())) {
                bContinueCopy = false;
            }
            if (ff.exists() && bContinueCopy) {
                String s;
                FileInputStream is = new FileInputStream(sPath);
                BufferedReader fScratch = new BufferedReader(new InputStreamReader(is));
                while ((s = fScratch.readLine()) != null) {
                    m_logger.log(Level.INFO, s);
                }
                fScratch.close();
            }
        }
        m_logger.log(Level.INFO, OiixResourceBundle.getString("S_LOG_ENV_VARS") + NEW_LINE);
        for (int i = 0; i < m_envVars.length; ++i) {
            m_logger.log(Level.INFO, "\t" + m_envVars[i] + " = " + OiipgEnvironment.getEnv(m_envVars[i]) + NEW_LINE);
        }
        m_logger.log(Level.INFO, OiixResourceBundle.getString("S_LOG_USER_NAME") + System.getProperty("user.name") + NEW_LINE);
        if (m_backUp != null) {
            int nSize = m_backUp.size();
            for (int i = 0; i < nSize; ++i) {
                String sMessage = (String)m_backUp.elementAt(i);
                m_logger.log(Level.INFO, sMessage + NEW_LINE);
            }
        }
        m_logger.flushHandlers();
        m_backUp = null;
    }

    private static synchronized void initializeConfigLog() throws IOException {
        String curLogFileName = OiiolTextLogger.getCurConfigLogFileName();
        File f = new File(curLogFileName);
        File par = new File(f.getParent());
        OiixFileOps.mkdirs(par);
        m_configFOS = new FileOutputStream(curLogFileName);
        m_configLogger = OiiolLogger.getOiiolLogger("OUI-CONFIG", null);
        if (m_configLogger == null) {
            return;
        }
        m_configLogger.resetLogger();
        Handler handler = m_configLogger.setLogLocationWithTimestamp(m_configLogLoc, m_cLogName, m_cLogExtension);
        if (handler == null) {
            return;
        }
        if (m_configBackUp != null) {
            int nSize = m_configBackUp.size();
            for (int i = 0; i < nSize; ++i) {
                String sMessage = (String)m_configBackUp.elementAt(i);
                m_configLogger.log(Level.INFO, sMessage + NEW_LINE);
            }
        }
        m_configLogger.flushHandlers();
        m_configBackUp = null;
    }

    public static void appendText(String message) {
        OiiolTextLogger.appendText(message, LOG_BASIC);
    }

    private static String constructMessageFromIdArgs(String sMessageID, Object[] args) {
        String sMsg = null;
        sMsg = args != null ? OiixResourceBundle.getString(sMessageID, args) : OiixResourceBundle.getString(sMessageID);
        return sMsg;
    }

    public static void appendText(String sMessageID, Object[] args) {
        String sMsg = OiiolTextLogger.constructMessageFromIdArgs(sMessageID, args);
        OiiolTextLogger.appendText(sMsg, LOG_BASIC);
    }

    public static void appendText(String message, int logLevel) {
        if (logLevel != LOG_WITHOUT_LEVEL) {
            if (logLevel < -3 || logLevel > 3) {
                logLevel = 0;
            }
            if (logLevel > 0 && message != null && message.startsWith(S_OUI_MSG_TAG)) {
                logLevel = 0;
            }
        }
        OiiolTextLogger.appendTextImpl(m_logger, message, logLevel, false, m_bEnabled, false);
    }

    public static void appendRawText(String sText) {
        OiiolTextLogger.appendTextImpl(m_logger, sText, LOG_BASIC, true, m_bEnabled, false);
    }

    public static void writeToConfigLog(String sText) {
        if (m_configLogger == null) {
            try {
                OiiolTextLogger.initializeConfigLog();
            }
            catch (IOException e) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_CONFIG_LOG_INIT_ERROR", new Object[]{m_configLogLoc}), LOG_SEVERE);
                e.printStackTrace();
            }
        }
        OiiolTextLogger.appendTextImpl(m_configLogger, sText, LOG_CONFIG, false, m_bConfigEnabled, true);
    }

    public static void writeToConfigToolCommandsFile(String sText) throws IOException {
        boolean bErrorOccured = false;
        String sConfigCommandFileName = OiiolTextLogger.getConfigToolCommandsFileName();
        File configToolCmds = new File(sConfigCommandFileName);
        File parent = new File(configToolCmds.getParent());
        OiixFileOps.mkdirs(parent);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(configToolCmds));
            writer.println(sText);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            bErrorOccured = true;
        }
        if (bErrorOccured || writer.checkError()) {
            Object[] args = new Object[]{sConfigCommandFileName, OiiolTextLogger.getCurLogFileName()};
            String sExceptionString = OiixResourceBundle.getString("S_ERR_WRITE_SKIPPED_TOOLS_FILE", args);
            throw new IOException(sExceptionString);
        }
        writer.close();
        OiipgFileSystem.changePermission(sConfigCommandFileName, 492);
    }

    private static String convertIntToStr(int level) {
        String logLevel;
        switch (level) {
            case 0x7FFFFFFF: {
                logLevel = "";
                break;
            }
            case -3: {
                logLevel = STR_LOG_SEVERE;
                break;
            }
            case -2: {
                logLevel = STR_LOG_WARNING;
                break;
            }
            case -1: {
                logLevel = STR_LOG_CONFIG;
                break;
            }
            case 1: {
                logLevel = STR_LOG_GENERAL;
                break;
            }
            case 2: {
                logLevel = STR_LOG_DETAILED;
                break;
            }
            case 3: {
                logLevel = STR_LOG_TRACE;
                break;
            }
            default: {
                logLevel = STR_LOG_BASIC;
            }
        }
        return logLevel;
    }

    private static void appendTextImpl(OiiolLogger logger, String message, int logLevel, boolean bRaw, boolean isEnabled, boolean isConfigLog) {
        if (!isEnabled) {
            return;
        }
        if (logger != null && logger.isDiskSpaceSufficient()) {
            boolean bLogged = false;
            while (!bLogged) {
                if (!bRaw) {
                    Level level = OiiolLogger.convertIntToLevel(logLevel);
                    logger.log(level, message);
                } else {
                    logger.log(Level.INFO, message);
                }
                if (logger.checkError()) {
                    Handler handler;
                    if (logger.isDiskSpaceSufficient()) {
                        logger.resetLogger();
                        return;
                    }
                    logger.resetLogger();
                    if (isConfigLog) {
                        try {
                            m_configFOS = new FileOutputStream(OiiolTextLogger.getCurConfigLogFileName(), true);
                        }
                        catch (FileNotFoundException err) {
                            // empty catch block
                        }
                        m_configLogger = OiiolLogger.getOiiolLogger("OUI-CONFIG", null);
                        if (m_configLogger == null) {
                            return;
                        }
                        handler = m_configLogger.setLogLocationWithTimestamp(m_configLogLoc, m_cLogName, m_cLogExtension);
                        if (handler != null) continue;
                        return;
                    }
                    m_logger = OiiolLogger.getOiiolLogger("OUI", null);
                    if (m_logger == null) {
                        return;
                    }
                    handler = m_logger.setLogLocationWithTimestamp(m_logLoc, m_sLogName, m_sLogExtension);
                    if (handler != null) continue;
                    return;
                }
                bLogged = true;
            }
        } else {
            if (isConfigLog) {
                if (m_configBackUp == null) {
                    m_configBackUp = new Vector();
                }
                m_configBackUp.addElement(message);
            } else {
                if (m_backUp == null) {
                    m_backUp = new Vector();
                }
                m_backUp.addElement(message);
            }
            return;
        }
    }

    public static void appendException(Exception e) {
        if (!m_bEnabled) {
            return;
        }
        String message = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter p = new PrintWriter(bos);
            e.printStackTrace(p);
            p.flush();
            message = bos.toString();
            p.close();
            bos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        OiiolTextLogger.appendText(message, LOG_SEVERE);
    }

    public static void addSeparatorToLogFile() {
        if (!m_bEnabled) {
            return;
        }
        OiiolTextLogger.appendText(NEW_LINE + "******************************************", 0);
    }

    public static void appendErrorText(String message) {
        OiiolTextLogger.appendErrorText(message, true, LOG_WITHOUT_LEVEL);
    }

    public static void appendErrorText(String message, boolean writeToInstallActions) {
        OiiolTextLogger.appendErrorText(message, writeToInstallActions, LOG_WITHOUT_LEVEL);
    }

    public static void appendErrorText(String message, int loglevel) {
        OiiolTextLogger.appendErrorText(message, true, loglevel);
    }

    public static void appendErrorText(String message, boolean writeToInstallActions, int loglevel) {
        if (!m_bEnabled || message == null) {
            return;
        }
        Level level = OiiolLogger.convertIntToLevel(loglevel);
        if (!m_logErrorStart) {
            m_logErrFile = OiiolTextLogger.getErrorLogFileName();
            File ff = new File(m_logErrFile);
            File par = new File(ff.getParent());
            OiixFileOps.mkdirs(par);
            ff.delete();
            m_errLogger = OiiolLogger.getOiiolLogger("OUI-SILENT", null);
            if (m_errLogger == null) {
                return;
            }
            m_errLogger.resetLogger();
            Handler handler = m_errLogger.setLogLocation(m_errLogLoc, m_sSilentErrLogName, m_sSilentErrLogExtension);
            if (handler == null) {
                return;
            }
            OiiolFileHandler ofh = (OiiolFileHandler)handler;
            m_sSilentLogLoc = ofh.getLogFileName();
            if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
                try {
                    int retVal = OiipuUnixOps.changePermission(m_logErrFile, 416);
                    File f = new File(m_logErrFile);
                    OiipuUnixOps.changePermission(f.getParent(), 504);
                }
                catch (OiilNativeException natEx) {
                    natEx.printStackTrace();
                }
            }
            m_errLogger.log(level, m_sSilentErrLogName + m_sSilentErrLogExtension);
            m_errLogger.log(level, message);
            m_logErrorStart = true;
        } else {
            m_errLogger.log(level, message);
            if (writeToInstallActions) {
                OiiolTextLogger.appendText(message, loglevel);
            }
        }
    }

    public static void writeMessageToStdErr(String sMessage) {
        System.err.println(sMessage);
    }

    public static void writeMessageToConsole(String sMessage) {
        System.out.println(sMessage);
    }

    public static void writeMessageToConsole(String sMessageID, Object[] args) {
        String sMsg = OiiolTextLogger.constructMessageFromIdArgs(sMessageID, args);
        System.out.println(sMsg);
    }

    public static void writeToLogAndConsole(String sMessageID, Object[] args) {
        String sMsg = OiiolTextLogger.constructMessageFromIdArgs(sMessageID, args);
        OiiolTextLogger.writeToLogAndConsole(sMsg);
    }

    public static void writeToLogAndConsole(String sText) {
        OiiolTextLogger.appendText(sText);
        OiiolTextLogger.writeMessageToConsole(sText);
    }

    public static void writeLogWithTimeAndTrace(String sText, String sLogLevel) {
        if (m_logger != null) {
            Level logLevel = OiiolLogger.getLogLevel(sLogLevel);
            m_logger.writeLogWithTimestamp(logLevel, sText, null);
        } else {
            if (m_backUp == null) {
                m_backUp = new Vector();
            }
            m_backUp.addElement(OiiolTextLogger.getCurrentFormattedDateTime() + " : " + sText);
        }
    }

    public static int getLogLevel() {
        return m_nLogLevel;
    }

    public static String getLogLevelString() {
        return m_sLogLevel;
    }

    public static boolean isLogLevelTrace() {
        return m_nLogLevel == LOG_TRACE;
    }

    public static String getCurrentFormattedDateTime() {
        Date dateNow = new Date();
        DateFormat df = DateFormat.getDateTimeInstance(3, 1);
        return df.format(dateNow);
    }

    public static String getSilentInstallLogLoc() {
        return m_sSilentLogLoc;
    }

    public static void writePlugInCommands(String oraHomeLoc, String plugInCommands, boolean bFailed, boolean bOverwrite) throws IOException {
        String allToolcommandLog = null;
        allToolcommandLog = bFailed ? OiixPathOps.getStandardForm(oraHomeLoc) + "/" + "cfgtoollogs" + "/" + s_sConfigToolFailedCommand : OiixPathOps.getStandardForm(oraHomeLoc) + "/" + "cfgtoollogs" + "/" + s_sConfigToolCommands;
        boolean bErrorOccured = false;
        String sConfigCommandFileName = OiixPathOps.getNativeForm(allToolcommandLog);
        File configToolCmds = new File(sConfigCommandFileName);
        File parent = new File(configToolCmds.getParent());
        OiixFileOps.mkdirs(parent);
        if (!configToolCmds.exists()) {
            boolean bFileCreated = configToolCmds.createNewFile();
            OiiolTextLogger.appendText("Created a new file " + configToolCmds.getAbsolutePath());
        }
        OiixFileOps.createFileWithPermissions(configToolCmds.getAbsolutePath(), OiixCFOps.S_PERMS_FOR_CFW_DIR);
        Object[] sArgs = new String[]{OiicInstVersion.getCopyrightCurrentYear()};
        String sCommentForCopyRight = "# ";
        boolean bAddCopyRight = false;
        if (OiixPlatform.isPlatInGroup(-3, OiixPlatform.getCurrentPlatform())) {
            sCommentForCopyRight = "rem ";
        }
        String copyRightHeader = sCommentForCopyRight + OiixResourceBundle.getString("S_COPYRIGHT", sArgs) + "\n";
        if (bOverwrite && null != configToolCmds && configToolCmds.exists()) {
            OiiolTextLogger.appendText("Since the option is to overwrite the existing " + sConfigCommandFileName + " file, backing it up");
            String sBackupFilename = OiixFileOps.backUpFile(sConfigCommandFileName, sConfigCommandFileName + ".bak");
            OiiolTextLogger.appendText("The backed up file name is " + sBackupFilename);
            bAddCopyRight = true;
        }
        if (null != configToolCmds && !configToolCmds.exists()) {
            bAddCopyRight = true;
        }
        BufferedWriter writer = null;
        OiixFileOps.createFileWithPermissions(configToolCmds.getAbsolutePath(), "700");
        try {
            writer = new BufferedWriter(new FileWriter(configToolCmds, !bOverwrite));
            if (bAddCopyRight) {
                writer.write(copyRightHeader);
            }
            writer.write(plugInCommands);
            writer.flush();
        }
        catch (IOException e) {
            bErrorOccured = true;
        }
        if (bErrorOccured) {
            Object[] args = new Object[]{sConfigCommandFileName, OiiolTextLogger.getCurLogFileName()};
            String sExceptionString = OiixResourceBundle.getString("S_ERR_WRITE_SKIPPED_TOOLS_FILE", args);
            throw new IOException(sExceptionString);
        }
        writer.close();
    }

    public static void copyLogs() {
        if (m_lCopyLogInfoObjs != null) {
            int size = m_lCopyLogInfoObjs.size();
            for (int i = 0; i < size; ++i) {
                OiiolCopyLogInfo copyInfo = (OiiolCopyLogInfo)m_lCopyLogInfoObjs.get(i);
                String source = copyInfo.getSourceLoc();
                String dest = copyInfo.getDestLoc();
                String timestamp = copyInfo.getTimestamp();
                String nodename = copyInfo.getNodename();
                String sSourceDir = OiixPathOps.concatPath(OiixPathOps.getStandardForm(source), s_invLogLoc);
                String sDestDir = OiixPathOps.concatPath(OiixPathOps.getStandardForm(dest), s_logLocRelToOH);
                File f = new File(OiixPathOps.getNativeForm(dest));
                if (!f.exists()) continue;
                OiiolTextLogger.copyLogs(sSourceDir, sDestDir, timestamp, nodename);
            }
        }
    }

    public static void copyLogs(String sourceDir, String destinationDir) {
        String timestamp = OiixUtilityOps.getSessionTimeStamp();
        OiiolTextLogger.copyLogs(sourceDir, destinationDir, timestamp, null);
    }

    private static void copyLogs(String sourceDir, String destinationDir, String sTimestamp, String nodename) {
        block8: {
            try {
                String destDir = null;
                if (sourceDir != null && destinationDir != null) {
                    sourceDir = OiixPathOps.getStandardForm(sourceDir);
                    File f = new File(OiixPathOps.getNativeForm(destinationDir = OiixPathOps.getStandardForm(destinationDir)));
                    if (!f.exists()) {
                        OiixFileOps.mkdirs(f);
                    }
                    if (f.exists() && f.isDirectory()) {
                        destDir = destinationDir;
                    }
                }
                if (destDir != null) {
                    File fSrcLoc = new File(OiixPathOps.getNativeForm(sourceDir));
                    String[] listofFiles = fSrcLoc.list();
                    int nCount = listofFiles == null ? 0 : listofFiles.length;
                    String node = nodename == null ? "" : "." + nodename;
                    for (int i = 0; i < nCount; ++i) {
                        if (listofFiles[i].indexOf(sTimestamp) == -1) continue;
                        String source = OiixPathOps.getNativeForm(OiixPathOps.concatPath(sourceDir, listofFiles[i]));
                        String dest = OiixPathOps.getNativeForm(OiixPathOps.concatPath(destDir, listofFiles[i] + node));
                        if (OiiolTextLogger.getLogLevel() >= LOG_TRACE) {
                            System.out.println("copying " + source + " to " + dest);
                        }
                        OiixFileOps.copyFile(source, dest, true);
                    }
                }
            }
            catch (Exception err) {
                if (OiiolTextLogger.getLogLevel() < LOG_TRACE) break block8;
                System.out.println("Error in copying the logs from " + sourceDir + " to " + destinationDir);
            }
        }
    }

    static {
        m_logErrorStart = false;
        m_errLogger = null;
        m_logger = null;
        sTmpDir = "OraInstall";
        m_configLogger = null;
        m_configFOS = null;
        m_memlogStream = null;
        m_dulogStream = null;
        m_timelogStream = null;
        m_bValidate = false;
        m_backUp = null;
        m_configBackUp = null;
        LOG_FILE_SIZE = 2048;
        m_envVars = new String[]{"ORACLE_HOME", "PATH", "CLASSPATH"};
        m_sLogName = S_INSTALLACTIONS;
        m_sMemLogName = "memory";
        m_sDiskUsageLogName = "diskusage";
        m_sTimeLogName = "time";
        m_sLogExtension = S_LOG_EXTN;
        m_cLogExtension = S_LOG_EXTN;
        m_sSilentErrLogName = "silentInstall";
        m_sSilentErrLogExtension = S_LOG_EXTN;
        m_bEnabled = true;
        m_bConfigEnabled = true;
        m_cLogName = "configtools";
        s_sConfigToolCommands = "configToolAllCommands";
        s_sConfigToolFailedCommand = "configToolFailedCommands";
        LOG_WITHOUT_LEVEL = Integer.MAX_VALUE;
        LOG_SEVERE = -3;
        LOG_WARNING = -2;
        LOG_CONFIG = -1;
        LOG_BASIC = 0;
        LOG_GENERAL = 1;
        LOG_DETAILED = 2;
        LOG_TRACE = 3;
        STR_LOG_SEVERE = "SEVERE";
        STR_LOG_WARNING = "WARNING";
        STR_LOG_CONFIG = "CONFIG";
        STR_LOG_BASIC = "INFO";
        STR_LOG_GENERAL = "FINE";
        STR_LOG_DETAILED = "FINER";
        STR_LOG_TRACE = "FINEST";
        NEW_LINE = System.getProperty("line.separator");
        m_oLevel = null;
        m_oFormatter = null;
        m_nLogLevel = OiiolLogger.getLogLevel();
        m_sLogLevel = OiiolTextLogger.convertIntToStr(m_nLogLevel);
    }
}

