/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiio.oiiol.OiiolActionLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolInstallLogHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolLogManipulator;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiolXMLInstallLog
implements OiiolLogManipulator,
OixsXMLizable {
    String m_installLogFile;
    int m_nNumberOfEntries;
    Vector m_vActionEntries;
    SAXParser m_xmlParser;

    public OiiolXMLInstallLog(String sLogFile) {
        this.m_installLogFile = sLogFile;
        this.m_nNumberOfEntries = 0;
    }

    public String getLogFileName() {
        return this.m_installLogFile;
    }

    private void readEntries() throws IOException {
        try {
            Parser m_xmlParser = OixsXMLOps.createSAXParser();
            OiiolInstallLogHandler handlerInstallLog = new OiiolInstallLogHandler();
            FileReader fLogReader = new FileReader(this.m_installLogFile);
            BufferedReader bufferedLogReader = new BufferedReader(fLogReader);
            m_xmlParser.setDocumentHandler(handlerInstallLog);
            m_xmlParser.setErrorHandler(handlerInstallLog);
            m_xmlParser.parse(new InputSource(bufferedLogReader));
            bufferedLogReader.close();
            fLogReader.close();
            this.m_vActionEntries = handlerInstallLog.getActionEntries();
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public int getNumEntries() {
        return this.m_nNumberOfEntries;
    }

    public Enumeration getEntries() throws IOException {
        if (this.m_vActionEntries == null) {
            this.m_vActionEntries = new Vector(10, 10);
            this.readEntries();
        }
        return this.m_vActionEntries.elements();
    }

    public Enumeration getEntriesForDeinstall() throws IOException {
        if (this.m_vActionEntries == null) {
            this.m_vActionEntries = new Vector(10, 10);
            this.readEntries();
        }
        int nEntries = this.m_vActionEntries.size();
        Vector<OiiolActionLogEntry> vDeInstEntries = new Vector<OiiolActionLogEntry>(nEntries);
        for (int i = nEntries - 1; i >= 0; --i) {
            OiiolActionLogEntry oEntry = (OiiolActionLogEntry)this.m_vActionEntries.get(i);
            if (!oEntry.getDeinstallFlag()) continue;
            vDeInstEntries.add(oEntry);
        }
        return vDeInstEntries.elements();
    }

    public Enumeration getEntriesForInstall() throws IOException {
        if (this.m_vActionEntries == null) {
            this.m_vActionEntries = new Vector(10, 10);
            this.readEntries();
        }
        int nEntries = this.m_vActionEntries.size();
        Vector<OiiolActionLogEntry> vInstEntries = new Vector<OiiolActionLogEntry>(nEntries);
        for (int i = 0; i < nEntries; ++i) {
            OiiolActionLogEntry oEntry = (OiiolActionLogEntry)this.m_vActionEntries.get(i);
            if (!oEntry.getInstallFlag()) continue;
            vInstEntries.add(oEntry);
        }
        return vInstEntries.elements();
    }

    public void markCurrentEntry() throws IOException {
    }

    public void startWrite() throws IOException {
        File fLog = new File(this.m_installLogFile);
        String parentDir = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(this.m_installLogFile));
        File fParentDir = new File(parentDir);
        if (!fParentDir.exists()) {
            OiixFileOps.mkdirs(fParentDir);
        }
        FileWriter fileWriter = new FileWriter(fLog);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        printWriter.println(OixsXMLOps.createXMLDirective(true));
        printWriter.println(OixsXMLOps.getStandardHeader());
        printWriter.println("<ACTION_LIST>");
        printWriter.close();
        bufferedWriter.close();
        fileWriter.close();
    }

    public void close() throws IOException {
        FileWriter fileWriter = new FileWriter(this.m_installLogFile, true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        printWriter.print("</ACTION_LIST>");
        printWriter.close();
        bufferedWriter.close();
        fileWriter.close();
    }

    public void addEntry(OiiolActionLogEntry oEntry) throws IOException {
        this.writeLog(oEntry);
    }

    private void writeLog(OiiolActionLogEntry oEntry) throws IOException {
        FileWriter fileWriter = new FileWriter(this.m_installLogFile, true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        oEntry.writeXML(printWriter);
        printWriter.close();
        bufferedWriter.close();
        fileWriter.close();
    }

    public void writeXML(PrintWriter p) throws IOException {
        for (int i = 0; i < this.m_nNumberOfEntries; ++i) {
            OiiolActionLogEntry oEntry = (OiiolActionLogEntry)this.m_vActionEntries.elementAt(i);
            oEntry.writeXML(p);
        }
    }

    public XMLElement toXML() {
        XMLElement xmlElement = new XMLElement("ACTION_LIST");
        xmlElement.setAttribute("SIZE", new Integer(this.m_nNumberOfEntries).toString());
        for (int i = 0; i < this.m_nNumberOfEntries; ++i) {
            OiiolActionLogEntry oEntry = (OiiolActionLogEntry)this.m_vActionEntries.elementAt(i);
            xmlElement.appendChild((Node)oEntry.toXML());
        }
        return xmlElement;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("USAGE: OiiolXmlInstallLog <path to installlog.xml> [path to output file]");
            System.exit(0);
        }
        String sLogFile = args[0];
        String sOutFile = args[0] + ".out";
        if (args.length > 1) {
            sOutFile = args[1];
        }
        try {
            OiiolXMLInstallLog xmlInstallLog = new OiiolXMLInstallLog(sLogFile);
            PrintWriter printWriter = new PrintWriter(new FileWriter(sOutFile));
            Enumeration en = xmlInstallLog.getEntries();
            while (en.hasMoreElements()) {
                ((OiiolActionLogEntry)en.nextElement()).writeXML(printWriter);
            }
            printWriter.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

