/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiioz;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisInvalidValueException;
import oracle.sysman.oii.oiis.OiisValueValidator;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixIniParsingException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiiz.OiizResourceBundle;

public class OiiozResponseFile
implements OiisValueValidator {
    private final String DELIMS = "\n=?";
    private final int DELIM = 58;
    private final int NO_OF_ATTRIBUTES = 2;
    private final String INCLUDE_SECTION = "INCLUDE";
    private final String SESSION_SECTION = "SESSION";
    private final String TYPE_FORCED = "Forced";
    private final String TYPE_DEFAULT = "Default";
    private String m_sResponseFileName;
    private boolean m_bIncludeAdded;
    private OiixIniFile m_oIniFile;
    private OiiofFileLoader m_fileLoader;
    private String m_srcOffset;
    private boolean m_bfirstFetch = true;
    private OiisValueValidator m_valueValidator = null;

    public OiiozResponseFile(String dispFileName, OiiofFileLoader fileLoader, String srcOffset) throws IOException {
        this.init(dispFileName, fileLoader, srcOffset);
    }

    public OiiozResponseFile(String fileName, String sTempLocation) throws IOException {
        String stdFn = OiixPathOps.getStandardForm(fileName);
        String srcLoc = OiixPathOps.getParentDir(stdFn);
        String srcOff = OiixPathOps.getFileName(stdFn);
        String sTempLoc = sTempLocation;
        File f = new File(sTempLoc);
        OiixFileOps.mkdirs(f);
        if (srcLoc == null) {
            srcLoc = sTempLoc;
        }
        OiiofFileLoader fileLoader = OiiofFileLoaderFactory.createFileLoader(srcLoc, sTempLoc);
        this.init(stdFn, fileLoader, srcOff);
    }

    public OiiozResponseFile(String fileName) throws IOException {
        this(fileName, System.getProperty("oracle.installer.scratchPath"));
    }

    public OiiozResponseFile() {
        this.setValueValidator(this);
    }

    private void init(String dispFileName, OiiofFileLoader fileLoader, String srcOffset) throws IOException {
        this.m_sResponseFileName = dispFileName;
        this.m_fileLoader = fileLoader;
        this.m_srcOffset = srcOffset;
        try {
            String fileName = this.m_fileLoader.getLocalCopy(srcOffset);
            this.m_oIniFile = new OiixIniFile(fileName);
            this.m_oIniFile.readFile();
            String stdFn = OiixPathOps.getStandardForm(fileName);
            String srcLoc = OiixPathOps.getParentDir(stdFn);
            String srcOff = OiixPathOps.getFileName(stdFn);
            if (!srcOff.equalsIgnoreCase(srcOffset)) {
                new File(fileName).delete();
            }
        }
        catch (OiifbCancelException ie) {
            throw new IOException(ie.getMessage());
        }
        catch (OiixIniParsingException e) {
            throw new IOException(e.getMessage());
        }
        this.m_bIncludeAdded = false;
        this.m_bfirstFetch = true;
        this.setValueValidator(this);
    }

    private String getTempLoc() {
        return System.getProperty("oracle.installer.scratchPath");
    }

    public void setValueValidator(OiisValueValidator validator) {
        this.m_valueValidator = validator;
    }

    public String getResponseFileName() {
        return this.m_sResponseFileName;
    }

    public String getSrcOffset() {
        return this.m_srcOffset;
    }

    public OiiofFileLoader getFileLoader() {
        return this.m_fileLoader;
    }

    public boolean isIncludeFilesAdded() {
        return this.m_bIncludeAdded;
    }

    public boolean isVersion221() {
        if (this.m_oIniFile.getRSPVersion() == null) {
            return true;
        }
        return this.m_oIniFile.getRSPVersion().equals(OiiiVersion.getStandardForm(OiizResourceBundle.getString("S_RSP_VERSION_2.2.1")).toString());
    }

    public Vector getIncludedResponseFiles() {
        Vector v = null;
        if (this.m_oIniFile.getRSPVersion() != null && this.m_oIniFile.getRSPVersion().equals(OiiiVersion.getStandardForm(OiizResourceBundle.getString("S_RSP_VERSION_2.2.1")).toString())) {
            v = this.m_oIniFile.getIncludeFiles();
            if (v == null) {
                v = new Vector();
            }
            return v;
        }
        try {
            v = this.m_oIniFile.getVarsInSection("INCLUDE");
        }
        catch (IOException ioe) {
            System.err.println("getIncludedResponseFiles 1: Could not read response file " + this.m_sResponseFileName);
        }
        Vector<String> vIncludeFiles = new Vector<String>();
        if (v != null) {
            int nSize = v.size();
            for (int i = 0; i < nSize; ++i) {
                String profile;
                block8: {
                    String sVarName = (String)v.elementAt(i);
                    profile = null;
                    try {
                        profile = this.m_oIniFile.getProfileString("INCLUDE", sVarName, null);
                        if (profile.charAt(0) != '\"') break block8;
                        profile = profile.substring(1, profile.length() - 1);
                    }
                    catch (IOException ioe) {
                        System.err.println("getIncludedResponseFiles 2: Could not read response file " + this.m_sResponseFileName);
                        break;
                    }
                }
                if (profile == null) continue;
                vIncludeFiles.addElement(profile);
            }
        }
        this.m_bIncludeAdded = true;
        return vIncludeFiles;
    }

    public OiisAdvisedValue getValue(String varName, OiiiCompInstallID cid) {
        OiisAdvisedValue retval;
        block7: {
            String sectionName = "SESSION";
            retval = null;
            try {
                if (this.m_oIniFile.getRSPVersion() == null) break block7;
                if (!this.m_oIniFile.getRSPVersion().equals(OiiiVersion.getStandardForm(OiizResourceBundle.getString("S_RSP_VERSION_2.2.1")).toString())) {
                    if (cid != null) {
                        StringBuffer sb = new StringBuffer(cid.getName());
                        sb.append("_");
                        sb.append(cid.getVersion());
                        sectionName = new String(sb);
                    }
                    retval = this.getValue(sectionName, varName, null);
                    break block7;
                }
                sectionName = "DEFAULT_SECTION";
                retval = this.getValue(sectionName, varName, null);
                if (retval != null) {
                    return retval;
                }
                if (cid != null) {
                    String varName1 = cid.getName() + ":" + varName;
                    retval = this.getValue(sectionName, varName1, null);
                    if (retval != null) {
                        return retval;
                    }
                    String varName2 = cid.getName() + ":" + cid.getVersion().toString() + ":" + varName;
                    retval = this.getValue(sectionName, varName2, null);
                    return retval;
                }
                return null;
            }
            catch (OiisInvalidValueException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    public OiisAdvisedValue getValue(String sSection, String sVarName, Object hint) throws OiisInvalidValueException {
        OiisAdvisedValue retval = null;
        String profile = null;
        profile = this.m_oIniFile.getValue(sSection, sVarName);
        if (this.m_bfirstFetch) {
            Object[] sVal = new String[]{this.m_sResponseFileName};
            String sMsg = OiixResourceBundle.getString("S_RSP_INSTALL");
            sMsg = MessageFormat.format(sMsg, sVal);
            OiiolTextLogger.appendText(sMsg);
            this.m_bfirstFetch = false;
        }
        if (profile == null) {
            return retval;
        }
        if ((profile = profile.trim()).equals("") || profile.equalsIgnoreCase(OiixResourceBundle.getString("S_RSP_DEF_VAL2")) || profile.equalsIgnoreCase(OiixResourceBundle.getString("S_RSP_DEF_VAL1")) || profile.equalsIgnoreCase(OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_RSP_DEF_VAL1")) || profile.equalsIgnoreCase(OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_RSP_DEF_VAL2"))) {
            return retval;
        }
        retval = (OiisAdvisedValue)this.m_valueValidator.validateValue(sVarName, profile, hint);
        return retval;
    }

    public Object validateValue(String name, String value, Object hint) throws OiisInvalidValueException {
        Object oValue;
        String advice;
        OiisAdvisedValue retval;
        block12: {
            String sValue;
            String start;
            retval = null;
            String profile = value;
            advice = null;
            int ind = -1;
            if (profile.length() >= 6 && (start = profile.substring(0, 6)).equalsIgnoreCase("Forced") && (ind = profile.indexOf(58)) != -1) {
                advice = profile.substring(0, ind);
                advice = advice.trim();
            }
            if (advice == null && profile.length() >= 7 && (start = profile.substring(0, 7)).equalsIgnoreCase("Default") && (ind = profile.indexOf(58)) != -1) {
                advice = profile.substring(0, ind);
                advice = advice.trim();
            }
            if (advice == null) {
                advice = "Forced";
            }
            if ((sValue = profile.substring(ind + 1)) == null) {
                return retval;
            }
            sValue = sValue.trim();
            oValue = sValue;
            try {
                Integer iValue = Integer.valueOf(sValue);
                oValue = iValue;
            }
            catch (NumberFormatException nfe) {
                if (sValue.equalsIgnoreCase("true") || sValue.equalsIgnoreCase("false")) {
                    oValue = Boolean.valueOf(sValue);
                }
                if (sValue.length() > 0 && sValue.charAt(0) == '{') {
                    if (sValue.endsWith("}")) {
                        oValue = this.makeStringArray(sValue.substring(1, sValue.length() - 1));
                    }
                }
                if (sValue.startsWith("\"") && sValue.endsWith("\"")) {
                    if (sValue.length() != 1) {
                        oValue = sValue.substring(1, sValue.length() - 1);
                    }
                }
                if (sValue.startsWith("\"") && !sValue.endsWith("\"")) break block12;
                oValue = sValue;
            }
        }
        if (oValue == null) {
            return null;
        }
        retval = advice.equalsIgnoreCase("Forced") ? new OiisAdvisedValue(oValue, true) : new OiisAdvisedValue(oValue, false);
        return retval;
    }

    private String[] makeStringArray(String list) {
        String DELIMS = ",";
        StringTokenizer st = new StringTokenizer(list, ",");
        int numTokens = st.countTokens();
        String[] sArray = new String[numTokens];
        for (int i = 0; st.hasMoreTokens() && i < numTokens; ++i) {
            String elem = st.nextToken();
            if ((elem = elem.trim()).startsWith("\"") && elem.endsWith("\"")) {
                sArray[i] = elem.substring(1, elem.length() - 1);
                continue;
            }
            if (elem.startsWith("\"") && !elem.endsWith("\"")) {
                return null;
            }
            sArray[i] = elem;
        }
        return sArray;
    }

    public boolean equals(Object o) {
        if (o != null) {
            if (o instanceof OiiozResponseFile) {
                OiiozResponseFile other = (OiiozResponseFile)o;
                if (other.getResponseFileName().equals(this.getResponseFileName())) {
                    return true;
                }
            } else {
                return super.equals(o);
            }
        }
        return false;
    }

    public String toString() {
        return this.getResponseFileName();
    }
}

