/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiioz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofHTTPFileLoader;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiioz.OiiozResponseFile;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiozResponseFileManager {
    private Vector m_vResponseFiles = new Vector();
    private int m_nPrevIndex = 0;
    private boolean m_bVersion221;

    public void addResponseFile(String sFileName) throws IOException {
        File f;
        if (!(OiixPathOps.isHttpLocation(sFileName) || (f = new File(sFileName)).exists() && f.isFile())) {
            Object[] sArgs = new String[]{sFileName};
            String sMsg = OiixResourceBundle.getString("S_RSP_NOT_FOUND");
            sMsg = MessageFormat.format(sMsg, sArgs);
            OiiolTextLogger.appendText(sMsg);
            throw new FileNotFoundException(sMsg);
        }
        OiiozResponseFile oFile = new OiiozResponseFile(sFileName);
        if (this.m_vResponseFiles.size() == 0) {
            this.m_bVersion221 = oFile.isVersion221();
        }
        this.m_vResponseFiles.addElement(oFile);
    }

    public boolean isVersion221() {
        return this.m_bVersion221;
    }

    private void addIncludeFiles(OiiozResponseFile oFile) {
        Vector vIncludeFiles = oFile.getIncludedResponseFiles();
        Vector<OiiozResponseFile> vRespFiles = new Vector<OiiozResponseFile>();
        int nSize = vIncludeFiles.size();
        for (int i = 0; i < nSize; ++i) {
            String sFileName = (String)vIncludeFiles.elementAt(i);
            try {
                OiiozResponseFile oRspFile = null;
                if (this.isAbsolute(sFileName)) {
                    this.checkForConflictingLdrs(oFile, sFileName);
                    oRspFile = new OiiozResponseFile(sFileName);
                } else {
                    String incOffset = this.getIncOffset(oFile.getSrcOffset(), sFileName);
                    oRspFile = new OiiozResponseFile(sFileName, oFile.getFileLoader(), incOffset);
                }
                vRespFiles.addElement(oRspFile);
                continue;
            }
            catch (IOException ioe) {
                Object[] vals = new String[]{sFileName, oFile.getResponseFileName()};
                String errMsg = OiixResourceBundle.getString("S_MISSING_INC_FILE");
                System.err.println(MessageFormat.format(errMsg, vals));
                ioe.printStackTrace();
            }
        }
        this.m_vResponseFiles = OiixVectorOps.union(this.m_vResponseFiles, vRespFiles);
    }

    private boolean isAbsolute(String fileName) {
        return (fileName = OiixPathOps.getStandardForm(fileName)).startsWith("//") || fileName.startsWith("/") || fileName.length() > 5 && fileName.substring(0, 5).equalsIgnoreCase("http:") || Character.isLetter(fileName.charAt(0)) && fileName.charAt(1) == ':';
    }

    private String getIncOffset(String parOffset, String relFileName) {
        parOffset = OiixPathOps.getStandardForm(parOffset);
        String parDir = "";
        if (parOffset.indexOf(47) != -1) {
            parDir = OiixPathOps.getParentDir(parOffset);
        }
        return OiixPathOps.concatPath(parDir, relFileName);
    }

    private void checkForConflictingLdrs(OiiozResponseFile oRf, String fileName) {
        OiiofFileLoader fileLoader = oRf.getFileLoader();
        if (!fileName.substring(0, 5).equalsIgnoreCase("http:") && fileLoader instanceof OiiofHTTPFileLoader) {
            String httpSrc = ((OiiofHTTPFileLoader)fileLoader).getSourceRoot();
            String parOff = oRf.getSrcOffset();
            Object[] vals = new String[]{fileName, OiixPathOps.concatPath(httpSrc, parOff)};
            String errMsg = OiixResourceBundle.getString("S_NON_HTTP_ABS_ERR");
            System.out.println(MessageFormat.format(errMsg, vals));
        }
    }

    public OiisAdvisedValue getValue(String varName, OiiiCompInstallID cid, boolean bFirst) {
        OiisAdvisedValue oForcedValue = null;
        OiisAdvisedValue oDefValue = null;
        int nStart = 0;
        if (!bFirst) {
            nStart = this.m_nPrevIndex;
        }
        for (int i = nStart; i < this.m_vResponseFiles.size(); ++i) {
            OiiozResponseFile oFile = (OiiozResponseFile)this.m_vResponseFiles.elementAt(i);
            OiisAdvisedValue oValue = oFile.getValue(varName, cid);
            if (oValue != null) {
                if (oValue.getAdvice()) {
                    oForcedValue = oValue;
                    this.m_nPrevIndex = i + 1;
                    break;
                }
                if (oDefValue == null) {
                    oDefValue = oValue;
                }
            }
            if (oFile.isIncludeFilesAdded()) continue;
            this.addIncludeFiles(oFile);
        }
        if (oForcedValue == null) {
            this.m_nPrevIndex = 0;
            oForcedValue = oDefValue;
        }
        return oForcedValue;
    }
}

