/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInventoryException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiipgBootstrap {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 131072;
    public static final String WIN32_NATIVE_LOC = "bin\\win32";
    public static final String WIN64_NATIVE_LOC = "bin\\win64";
    public static final String SOLARIS_NATIVE_LOC = "bin/solaris";
    public static final String AIX_NATIVE_LOC = "bin/aix";
    public static final String DIGITAL_UNIX_NATIVE_LOC = "bin/decunix";
    public static final String LINUX_NATIVE_LOC = "bin/linux";
    public static final String HP_UX_NATIVE_LOC = "bin/hpunix";
    public static final String MAC_NATIVE_LOC = "bin/mac_osx";
    public static final String WIN32_NATIVE_NM = "oraInstaller.dll";
    public static final String UNIX_NATIVE_NM = "liboraInstaller";
    public static final String SHARED_NM = "oraInstaller";
    public static final String HKEY_LOCAL_MACHINE = "HKEY_LOCAL_MACHINE";
    public static final String ORACLE_KEY = "SOFTWARE\\ORACLE";
    public static final String DEFAULT_INVENTORY = "oraInventory";
    public static final String DEFAULT_INVENTORY_WIN32 = "Inventory";
    public static final String JAR_FILENAME = "OraInstaller.jar";
    public static final String WIN32_MSVCR71 = "msvcr71.dll";
    public static final String WIN64_MSVCRT = "msvcrt.dll";
    private static final String OUI_EXEC_UNIX = "runInstaller";
    private static final String OUI_EXEC_WINDOWS = "setup.exe";
    public static String S_UNIX_ROOT_SCRIPT_NAME = null;
    public static final String EXECFILE_SOL = "runInstaller";
    public static final String Z_OS_NATIVE_LOC = "bin/os390";
    public static String s_UnixGroup = null;
    public static final int s_curPlatformId = OiixPlatform.getCurrentPlatform();
    public static final int s_curPlatformGroup = OiixPlatform.getPlatGroup(s_curPlatformId);
    public static final String PLATFORM = "platform";

    public static String getOUIExecLoc(String sOUILoc) {
        String sOUIExecLoc = null;
        String sExecLoc = OiixPathOps.concatPath(sOUILoc, "bin");
        if (s_curPlatformGroup == -1) {
            sOUIExecLoc = OiixPathOps.concatPath(sExecLoc, "runInstaller");
        } else if (s_curPlatformGroup == -3) {
            sOUIExecLoc = OiixPathOps.concatPath(sExecLoc, OUI_EXEC_WINDOWS);
        }
        File f = new File(sOUIExecLoc);
        if (!f.exists()) {
            sExecLoc = OiixPathOps.concatPath(sExecLoc, PLATFORM);
            sExecLoc = OiixPathOps.concatPath(sExecLoc, OiixPlatform.getCurrentPlatformDirectoryName());
            if (s_curPlatformGroup == -1) {
                sOUIExecLoc = OiixPathOps.concatPath(sExecLoc, "runInstaller");
            } else if (s_curPlatformGroup == -3) {
                sOUIExecLoc = OiixPathOps.concatPath(sExecLoc, OUI_EXEC_WINDOWS);
            }
        }
        sOUIExecLoc = OiixPathOps.getNativeForm(sOUIExecLoc);
        return sOUIExecLoc;
    }

    private void initRootScriptName(String sInventoryLoc) {
        if (sInventoryLoc == null || sInventoryLoc.equals("")) {
            sInventoryLoc = System.getProperty("oracle.installer.ORACLE_HOME", "/tmp");
        }
        S_UNIX_ROOT_SCRIPT_NAME = sInventoryLoc + "/orainstRoot.sh";
    }

    public boolean ignoreLocChecks() {
        return s_curPlatformGroup == -1;
    }

    public static void loadNativeLib() {
        switch (s_curPlatformGroup) {
            case -1: {
                OiipuUnixOps.loadNativeLib();
            }
            case 197: {
                break;
            }
            case -3: {
                OiipwWin32NativeCalls.loadNativeLib();
                break;
            }
        }
    }

    public static boolean isNatLibExecNeeded() {
        boolean retVal = false;
        switch (s_curPlatformId) {
            case 2: 
            case 421: {
                retVal = true;
                break;
            }
            default: {
                retVal = false;
            }
        }
        return retVal;
    }

    public void setInventoryLoc(String invLoc) throws IOException {
        switch (s_curPlatformGroup) {
            case -1: {
                this.modifyUnixInstallFile(invLoc);
                break;
            }
            case -3: {
                this.setInstallerKey(invLoc);
                break;
            }
        }
    }

    public void updateInventoryLoc(OiicSessionInterfaceManager osim, String invLoc, String sUnixGroup) throws IOException {
        switch (s_curPlatformGroup) {
            case -1: {
                if (this.checkInvFile(invLoc, sUnixGroup)) break;
                this.writeInvLoc(osim, invLoc, sUnixGroup, null);
                break;
            }
            case -3: {
                try {
                    String dest = OiipwWin32NativeCalls.RegGetValue(HKEY_LOCAL_MACHINE, ORACLE_KEY, "inst_loc");
                    if (dest.equalsIgnoreCase(invLoc)) break;
                    this.setInstallerKey(invLoc);
                }
                catch (OiilNativeException e) {
                    this.setInstallerKey(invLoc);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean isCleanMachine() {
        bRet = false;
        switch (OiipgBootstrap.s_curPlatformGroup) {
            case -1: {
                fis = null;
                sFile = OiipgPropertyLoader.getUnixPtrFileLoc();
                fis = new FileInputStream(sFile);
                props = new Properties();
                props.load(fis);
                sInvLoc = (String)props.get("inventory_loc");
                if (sInvLoc != null && (sInvLoc == null || sInvLoc.trim().length() != 0)) ** GOTO lbl15
                bRet = true;
                ** GOTO lbl17
lbl15:
                // 1 sources

                bRet = false;
lbl17:
                // 2 sources

                var7_9 = null;
                if (fis == null) break;
                try {
                    fis.close();
                }
                catch (Exception exFis) {}
                break;
                {
                    catch (Exception e) {
                        bRet = true;
                        var7_10 = null;
                        if (fis == null) break;
                        try {
                            fis.close();
                        }
                        catch (Exception exFis) {}
                        break;
                    }
                }
                catch (Throwable var6_15) {
                    var7_11 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exFis) {
                            // empty catch block
                        }
                    }
                    throw var6_15;
                }
            }
            case -3: {
                dest = null;
                try {
                    dest = OiipwWin32NativeCalls.RegGetValue("HKEY_LOCAL_MACHINE", "SOFTWARE\\ORACLE", "inst_loc");
                    if (dest != null && dest.length() >= 0) {
                        bRet = false;
                        break;
                    }
                    bRet = true;
                    break;
                }
                catch (Exception exMs) {
                    bRet = true;
                }
            }
        }
        return bRet;
    }

    public void setInstallerKey(String destLoc) throws IOException {
        try {
            OiipwWin32NativeCalls.RegSetValue(HKEY_LOCAL_MACHINE, ORACLE_KEY, "inst_loc", destLoc);
        }
        catch (OiilNativeException e) {
            System.err.println("Error accessing the registry" + e);
            throw new IOException(OiixResourceBundle.getString("S_ERR_REG_ACCESS"));
        }
    }

    public void modifyUnixInstallFile(String destLoc) throws IOException {
        this.modifyUnixInstallFile(destLoc, null);
    }

    public void modifyUnixInstallFile(String destLoc, String unixPtrLoc) throws IOException {
        if (unixPtrLoc == null || unixPtrLoc.length() <= 0) {
            unixPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        }
        Properties sol_properties = new Properties();
        if (destLoc == null || destLoc.length() <= 0) {
            destLoc = this.getDefaultLocationFileLoc();
        }
        if (s_UnixGroup == null || s_UnixGroup.length() == 0) {
            s_UnixGroup = this.getCurrentActiveUserGroupName();
        }
        if (s_UnixGroup == null || s_UnixGroup.length() == 0) {
            s_UnixGroup = this.getCurrentUserGroupName();
        }
        s_UnixGroup = s_UnixGroup != null ? s_UnixGroup.trim() : "";
        sol_properties.put("inventory_loc", destLoc);
        sol_properties.put("inst_group", s_UnixGroup);
        String sDir = OiixPathOps.getParentDir(unixPtrLoc);
        File f = new File(sDir);
        OiixFileOps.mkdirs(f);
        FileOutputStream dout = new FileOutputStream(unixPtrLoc);
        sol_properties.save(dout, "Oracle Installer Location File Location");
        dout.close();
    }

    private boolean checkInvFile(String destLoc, String sUnixGroup) {
        boolean bRet = false;
        try {
            String sFile = OiipgPropertyLoader.getUnixPtrFileLoc();
            FileInputStream fis = new FileInputStream(sFile);
            Properties props = new Properties();
            props.load(fis);
            String sStr = (String)props.get("inventory_loc");
            String sGroup = (String)props.get("inst_group");
            if (sStr.equals(destLoc)) {
                bRet = true;
            }
            sUnixGroup = sUnixGroup.trim();
            if (sGroup != null) {
                if (!(sGroup = sGroup.trim()).equals(sUnixGroup) && sGroup.length() != 0 && sUnixGroup.length() != 0) {
                    bRet = false;
                }
            } else if (sUnixGroup.length() != 0) {
                bRet = false;
            }
        }
        catch (Exception e) {
            bRet = false;
        }
        return bRet;
    }

    public String getDefaultBaseIfExist() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                break;
            }
            case -1: {
                for (int i = 1; i <= 9; ++i) {
                    String path = "/u0" + i;
                    if (!new File(path).exists()) continue;
                    String testPath = path + File.separator + "app" + File.separator + OiixEnvironmentOps.ssgetUidNameux();
                    try {
                        OiipgFileSystem.checkWritablePath(testPath);
                        return testPath;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        return null;
    }

    public String getDefaultLocationFileLoc() {
        OiipgEnvironment pgE = new OiipgEnvironment();
        String sDir = OiipgEnvironment.getEnv("ORACLE_BASE");
        if (sDir != null && !sDir.equals("")) {
            sDir = OiixPathOps.getStandardForm(sDir);
            switch (s_curPlatformGroup) {
                case -3: {
                    sDir = OiixPathOps.concatPath(sDir, DEFAULT_INVENTORY_WIN32);
                    break;
                }
                case -1: {
                    sDir = OiixPathOps.concatPath(sDir, "..");
                    sDir = OiixPathOps.getUnexpandedCanonicalPath(sDir);
                    sDir = OiixPathOps.concatPath(sDir, DEFAULT_INVENTORY);
                }
            }
            sDir = OiixPathOps.getNativeForm(sDir);
        } else {
            if (s_curPlatformGroup == -3) {
                try {
                    sDir = OiipwWin32NativeCalls.GetProgramFilesDir();
                    if (!sDir.endsWith("\\")) {
                        sDir = sDir + "\\";
                    }
                    sDir = sDir + "Oracle\\" + DEFAULT_INVENTORY_WIN32;
                }
                catch (OiilNativeException e) {
                    e.printStackTrace();
                }
            }
            if (s_curPlatformGroup == -1) {
                String locationFileLoc = System.getProperty("oracle.installer.inventory_location");
                if (locationFileLoc == null) {
                    String defInvPtrLoc = null;
                    switch (OiixPlatform.getCurrentPlatform()) {
                        case 46: 
                        case 227: {
                            defInvPtrLoc = "/etc/oraInst.loc";
                            break;
                        }
                        case 198: 
                        case 610: {
                            defInvPtrLoc = "/etc/oraInst.loc";
                            break;
                        }
                        default: {
                            defInvPtrLoc = "/var/opt/oracle/oraInst.loc";
                        }
                    }
                    if (new File(defInvPtrLoc).exists()) {
                        try {
                            locationFileLoc = new OiipgPropertyLoader().getLocationFileLoc(defInvPtrLoc);
                            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEF_INV_LOC_DEV_INVPTRLOC", new String[]{defInvPtrLoc}));
                        }
                        catch (IOException e) {
                            locationFileLoc = null;
                        }
                    }
                    if (locationFileLoc == null) {
                        locationFileLoc = this.getDefaultBaseIfExist();
                        if (locationFileLoc != null) {
                            locationFileLoc = OiixPathOps.concatPath(locationFileLoc, "..");
                            locationFileLoc = OiixPathOps.getUnexpandedCanonicalPath(locationFileLoc);
                        } else {
                            locationFileLoc = System.getProperty("user.home");
                            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEF_INV_USER_HOME_DIR"));
                        }
                        locationFileLoc = OiixPathOps.getStandardForm(locationFileLoc);
                        locationFileLoc = OiixPathOps.directorify(locationFileLoc);
                        locationFileLoc = locationFileLoc + DEFAULT_INVENTORY;
                    }
                } else {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEF_INV_SESSION_VAR"));
                }
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEF_INV_LOCATION", new String[]{locationFileLoc}));
                sDir = locationFileLoc;
            }
        }
        return sDir;
    }

    public String getCurrentUserGroupName() {
        String v_strUser = System.getProperty("user.name");
        return OiixEnvironmentOps.ssgetCurrentGroupOfUserux(v_strUser);
    }

    public String getCurrentActiveUserGroupName() {
        String v_strUser = System.getProperty("user.name");
        return OiixEnvironmentOps.ssgetCurrentActiveUserGroupux(v_strUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showInventoryLocationDialog(OiicPullSession pSession) {
        boolean bRet = false;
        switch (s_curPlatformGroup) {
            case -3: {
                return bRet;
            }
            case -1: {
                if (pSession.isCloneMode()) return false;
                if (pSession.isSilentMode()) return false;
                return true;
            }
        }
        return bRet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getFirstWritableDrive() {
        String name = "";
        if (!OiixPlatform.isPlatInGroup(-3, s_curPlatformId)) return name;
        char[] c = new char[]{'c'};
        while (c[0] < 'z') {
            name = new String(c);
            name = name + ":" + File.separatorChar + DEFAULT_INVENTORY;
            File f = new File(name);
            try {
                if (f.exists() && f.isDirectory() && !f.canWrite()) return name;
            }
            catch (SecurityException se) {
                name = "";
                se.printStackTrace();
                c[0] = (char)(c[0] + '\u0001');
            }
        }
        return name;
    }

    public static String getNativeLibraryLoc() {
        String retLoc = null;
        switch (s_curPlatformGroup) {
            case -1: {
                switch (s_curPlatformId) {
                    case 453: {
                        retLoc = SOLARIS_NATIVE_LOC;
                    }
                    case 197: {
                        break;
                    }
                    case 610: {
                        retLoc = AIX_NATIVE_LOC;
                        break;
                    }
                    case 87: {
                        retLoc = DIGITAL_UNIX_NATIVE_LOC;
                        break;
                    }
                    case 46: {
                        retLoc = LINUX_NATIVE_LOC;
                        break;
                    }
                    case 421: {
                        retLoc = MAC_NATIVE_LOC;
                        break;
                    }
                    case 2: {
                        retLoc = HP_UX_NATIVE_LOC;
                    }
                    case 30: {
                        retLoc = Z_OS_NATIVE_LOC;
                    }
                }
                break;
            }
            case -3: {
                switch (s_curPlatformId) {
                    case 50: 
                    case 615: 
                    case 912: {
                        retLoc = WIN32_NATIVE_LOC;
                        break;
                    }
                    case 208: 
                    case 233: {
                        retLoc = WIN64_NATIVE_LOC;
                    }
                }
                break;
            }
        }
        return retLoc;
    }

    public static String getNativeLibraryExt() {
        String retName = null;
        switch (s_curPlatformId) {
            case 421: {
                retName = ".jnilib";
                break;
            }
            case 2: {
                retName = ".sl";
                break;
            }
            default: {
                retName = ".so";
            }
        }
        return retName;
    }

    public static String getNativeLibraryFileName() {
        String retName = null;
        switch (s_curPlatformGroup) {
            case -1: {
                retName = UNIX_NATIVE_NM + OiipgBootstrap.getNativeLibraryExt();
                break;
            }
            case -3: {
                retName = WIN32_NATIVE_NM;
                break;
            }
        }
        return retName;
    }

    public static String getSharedLibraryName() {
        return SHARED_NM;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeInvLoc(OiicSessionInterfaceManager osim, String locationFileLoc, String sUnixGroup, String[] nodeList) throws IOException {
        switch (s_curPlatformGroup) {
            case -1: {
                if (null != sUnixGroup) {
                    sUnixGroup = sUnixGroup.trim();
                }
                if (sUnixGroup == null || sUnixGroup.length() == 0) {
                    sUnixGroup = this.getCurrentActiveUserGroupName();
                }
                if (sUnixGroup == null || sUnixGroup.length() == 0) {
                    sUnixGroup = this.getCurrentUserGroupName();
                }
                s_UnixGroup = sUnixGroup = sUnixGroup != null ? sUnixGroup.trim() : "";
                String unixPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
                boolean chggrp = OiipgBootstrap.changeGroup(locationFileLoc);
                if (!chggrp) {
                    OiiolTextLogger.appendText("Can't chgrp " + locationFileLoc + " to " + s_UnixGroup);
                }
                OiipgBootstrap.setUnixPermissions(locationFileLoc, 504);
                if (!OiipgBootstrap.hasWritePermissions(unixPtrLoc) || !OiipgBootstrap.hasWritePermissions(locationFileLoc) || nodeList != null && nodeList.length > 0) {
                    String scrLoc = null;
                    try {
                        scrLoc = this.writeRootScript(unixPtrLoc, locationFileLoc);
                    }
                    catch (IOException ioe) {
                        Object[] arr = new String[]{S_UNIX_ROOT_SCRIPT_NAME};
                        String errmsg = OiixResourceBundle.getString("S_UNIX_SCRIPT_ERR");
                        OiiolTextLogger.writeMessageToConsole(MessageFormat.format(errmsg, arr));
                        throw new IOException(errmsg);
                    }
                    if (osim == null) {
                        Object[] args = new Object[]{scrLoc};
                        throw new IOException(OiixResourceBundle.getString("S_INV_SETUP_API_ERR", args));
                    }
                    if (!osim.performInvSetupRootOperations(nodeList)) {
                        throw new IOException("");
                    }
                } else {
                    if (!chggrp) {
                        try {
                            String scrLoc = this.writeRootScript(unixPtrLoc, locationFileLoc);
                            this.showGroupAlert(sUnixGroup);
                        }
                        catch (IOException ioe) {
                            Object[] arr = new String[]{S_UNIX_ROOT_SCRIPT_NAME};
                            String errmsg = OiixResourceBundle.getString("S_UNIX_SCRIPT_ERR");
                            OiiolTextLogger.writeMessageToConsole(MessageFormat.format(errmsg, arr));
                            throw new IOException(errmsg);
                        }
                    }
                    this.setInventoryLoc(locationFileLoc);
                    OiipgBootstrap.setUnixPermissions(unixPtrLoc, 420);
                }
                OiiiInstallAreaControl.writePlatformFile(locationFileLoc);
                return;
            }
        }
    }

    public static void setUnixGroup(String sUnixGroup) {
        s_UnixGroup = sUnixGroup;
    }

    public boolean isUnixGroupNeeded() {
        return s_curPlatformGroup == -1 ? !OiicPullSession.isSilentMode() : false;
    }

    public boolean isRepaintRequired() {
        return s_curPlatformGroup == -1;
    }

    public String writeRootScript(String inventoryPtrLoc, String inventoryLoc) throws IOException {
        int i;
        if (s_UnixGroup == null || s_UnixGroup.length() == 0) {
            s_UnixGroup = this.getCurrentActiveUserGroupName();
        }
        if (s_UnixGroup == null || s_UnixGroup.length() == 0) {
            s_UnixGroup = this.getCurrentUserGroupName();
        }
        s_UnixGroup = s_UnixGroup != null ? s_UnixGroup.trim() : "";
        String[] scriptLines = new String[]{"#!/bin/sh", "INVPTR=", "INVLOC=", "GRP=", "PTRDIR=\"`dirname $INVPTR`\";", OiixResourceBundle.getString("S_ROOTSH_INV_LOC_COM"), "if [ ! -d \"$PTRDIR\" ]; then", " $MKDIR -p $PTRDIR;", "fi", "$ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_INV_LOC") + "($INVPTR)\";", "$ECHO    inventory_loc=$INVLOC > $INVPTR", "$ECHO    inst_group=$GRP >> $INVPTR", "chmod 644 $INVPTR", OiixResourceBundle.getString("S_ROOTSH_INV_DIR_COM"), "if [ ! -d \"$INVLOC\" ];then", " $ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_INV_DIR") + "($INVLOC)\";", " $MKDIR -p $INVLOC;", "fi"};
        this.initRootScriptName(inventoryLoc);
        File f = new File(S_UNIX_ROOT_SCRIPT_NAME);
        f = new File(f.getParent());
        OiixFileOps.mkdirs(f);
        BufferedWriter scriptFile = new BufferedWriter(new FileWriter(S_UNIX_ROOT_SCRIPT_NAME));
        String line = scriptLines[0] + "\n";
        scriptFile.write(line, 0, line.length());
        line = "AWK=/bin/awk\n";
        scriptFile.write(line, 0, line.length());
        line = "CHMOD=/bin/chmod\n";
        scriptFile.write(line, 0, line.length());
        line = "CHGRP=/bin/chgrp\n";
        scriptFile.write(line, 0, line.length());
        line = "CP=/bin/cp\n";
        scriptFile.write(line, 0, line.length());
        line = "ECHO=/bin/echo\n";
        scriptFile.write(line, 0, line.length());
        line = "MKDIR=/bin/mkdir\n";
        scriptFile.write(line, 0, line.length());
        line = "RUID=`/usr/bin/id|$AWK -F\\( '{print $1}'|$AWK -F\\= '{print $2}'`\n";
        scriptFile.write(line, 0, line.length());
        line = "if [ ${RUID} != \"0\" ];then\n";
        scriptFile.write(line, 0, line.length());
        line = "   $ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_ISROOT") + "\"\n";
        scriptFile.write(line, 0, line.length());
        line = "   exit 1\n";
        scriptFile.write(line, 0, line.length());
        line = "fi\n";
        scriptFile.write(line, 0, line.length());
        line = inventoryPtrLoc;
        int indexInvLoc = line.lastIndexOf("/");
        line = line.substring(0, indexInvLoc);
        String line1 = "if [ -d \"" + line + "\" ]; then\n";
        scriptFile.write(line1, 0, line1.length());
        line1 = "$CHMOD 755 " + line + ";\n";
        scriptFile.write(line1, 0, line1.length());
        line1 = "else\n";
        scriptFile.write(line1, 0, line1.length());
        line1 = "$MKDIR -p " + line + ";\n";
        scriptFile.write(line1, 0, line1.length());
        line1 = "fi\n";
        scriptFile.write(line1, 0, line1.length());
        int beginInd = inventoryPtrLoc.lastIndexOf("/");
        int lengthInvPtr = inventoryPtrLoc.length();
        String invPtrFileLoc = inventoryLoc + inventoryPtrLoc.substring(beginInd, lengthInvPtr);
        String[] scriptLines3 = new String[]{"if [ -f \"" + invPtrFileLoc + "\" ]; then", "$CP " + invPtrFileLoc + " " + inventoryPtrLoc + ";", "$CHMOD 644 " + inventoryPtrLoc, "else", "fi", "$ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_CHMOD") + inventoryLoc + ".\n" + OiixResourceBundle.getString("S_ROOTSH_CHMOD_ADDING") + OiixResourceBundle.getString("S_ROOTSH_CHMOD_REMOVING") + "\";", "$CHMOD -R g+rw,o-rwx " + inventoryLoc + ";", "if [ $? != 0 ]; then", " $ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_CHMOD_ERR") + inventoryLoc + "\n" + OiixResourceBundle.getString("S_ROOTSH_CHMOD_ADDING") + "," + OiixResourceBundle.getString("S_ROOTSH_CHMOD_REMOVING") + OiixResourceBundle.getString("S_ROOTSH_FAILED") + "\";", "fi"};
        String[] scriptLines2 = new String[]{"$ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_CHGRP") + inventoryLoc + OiixResourceBundle.getString("S_ROOTSH_TO") + s_UnixGroup + ".\";", "$CHGRP -R " + s_UnixGroup + " " + inventoryLoc + ";", "if [ $? != 0 ]; then", " $ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_CHGRP_ERR") + inventoryLoc + OiixResourceBundle.getString("S_ROOTSH_TO") + s_UnixGroup + OiixResourceBundle.getString("S_ROOTSH_FAILED") + "\";", "fi"};
        for (i = 0; i < scriptLines3.length - 6; ++i) {
            line = scriptLines3[i] + "\n";
            scriptFile.write(line, 0, line.length());
        }
        line = scriptLines[1] + inventoryPtrLoc + "\n";
        scriptFile.write(line, 0, line.length());
        line = scriptLines[2] + inventoryLoc + "\n";
        scriptFile.write(line, 0, line.length());
        line = scriptLines[3] + s_UnixGroup + "\n";
        scriptFile.write(line, 0, line.length());
        for (i = 4; i < scriptLines.length; ++i) {
            line = scriptLines[i] + "\n";
            scriptFile.write(line, 0, line.length());
        }
        line = scriptLines3[scriptLines3.length - 6] + "\n";
        scriptFile.write(line, 0, line.length());
        line = scriptLines3[scriptLines3.length - 5] + "\n";
        scriptFile.write(line, 0, line.length());
        line = scriptLines3[scriptLines3.length - 4] + "\n";
        scriptFile.write(line, 0, line.length());
        line = scriptLines3[scriptLines3.length - 3] + "\n";
        scriptFile.write(line, 0, line.length());
        line = scriptLines3[scriptLines3.length - 2] + "\n";
        scriptFile.write(line, 0, line.length());
        line = scriptLines3[scriptLines3.length - 1] + "\n";
        scriptFile.write(line, 0, line.length());
        if (s_UnixGroup.length() > 0) {
            for (i = 0; i < scriptLines2.length; ++i) {
                line = scriptLines2[i] + "\n";
                scriptFile.write(line, 0, line.length());
            }
        }
        line = "$ECHO \"" + OiixResourceBundle.getString("S_ROOTSH_COMPLETE") + "\"" + "\n";
        scriptFile.write(line, 0, line.length());
        scriptFile.flush();
        scriptFile.close();
        OiipgBootstrap.setUnixPermissions(S_UNIX_ROOT_SCRIPT_NAME, 504);
        BufferedWriter invPtrFile = new BufferedWriter(new FileWriter(invPtrFileLoc));
        line = "inventory_loc=" + inventoryLoc + "\n";
        invPtrFile.write(line, 0, line.length());
        line = "inst_group=" + s_UnixGroup + "\n";
        invPtrFile.write(line, 0, line.length());
        invPtrFile.flush();
        invPtrFile.close();
        OiipgBootstrap.setUnixPermissions(invPtrFileLoc, 432);
        return S_UNIX_ROOT_SCRIPT_NAME;
    }

    public static boolean hasWritePermissions(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.canWrite()) {
                return true;
            }
        } else {
            String parent = file.getParent();
            if (parent != null) {
                return OiipgBootstrap.hasWritePermissions(parent);
            }
        }
        return false;
    }

    public static boolean changeGroup(String fname) {
        return s_UnixGroup == null || s_UnixGroup.length() == 0 || OiipuUnixOps.chgrp(fname, s_UnixGroup) == 0;
    }

    public static void setUnixPermissions(String destFile, int fmode) {
        boolean bError = false;
        String sErr = null;
        try {
            bError = OiipuUnixOps.chmod(destFile, fmode) != 0;
        }
        catch (OiilNativeException e) {
            Object[] args = new Object[]{destFile, Integer.toOctalString(fmode), e.getMessage()};
            sErr = OiixResourceBundle.getString("S_PERMISSIONS_NOT_SET", args);
        }
        if (bError) {
            if (sErr != null) {
                System.err.println(sErr);
            } else {
                System.err.println("Warning: Can't chmod " + destFile + " to " + Integer.toOctalString(fmode));
            }
        }
    }

    public void showGroupAlert(String groupName) {
        Object[] arr = new String[]{groupName, S_UNIX_ROOT_SCRIPT_NAME};
        String ga = OiixResourceBundle.getString("S_UNIX_GROUP_ERR");
        ga = MessageFormat.format(ga, arr);
        OiifmAlert.displayAlert(OiixResourceBundle.getString("S_CAUTION"), ga, 30, 1, 10);
    }

    public static String getInstRootSHNeededMsg() {
        String sMsg = null;
        OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
        sMsg = detectCluster.isClusterMode() ? OiixResourceBundle.getString("S_ROOTSH_NEEDED_CLUSTER", new Object[]{S_UNIX_ROOT_SCRIPT_NAME}) : OiixResourceBundle.getString("S_ROOTSH_NEEDED", new Object[]{S_UNIX_ROOT_SCRIPT_NAME});
        return sMsg;
    }

    public static String initScratchLoc(String sDirName) throws IOException {
        String sScratchPath = System.getProperty("oracle.installer.scratchPath");
        if (sScratchPath == null || sScratchPath.length() == 0) {
            String sTemp = OiipgEnvironment.getEnv("TEMP");
            if (sTemp == null || sTemp.length() == 0) {
                sTemp = OiipgEnvironment.getEnv("TMP");
            }
            if (sTemp == null || sTemp.length() == 0) {
                switch (s_curPlatformGroup) {
                    case -3: {
                        sTemp = "c:\\temp";
                        break;
                    }
                    default: {
                        sTemp = "/tmp";
                    }
                }
            }
            try {
                OiipgFileSystem.checkWritablePath(sTemp);
            }
            catch (OiipgPathException e) {
                String sMsg = OiixResourceBundle.getString("S_SCRATCHPATH_ERROR", new Object[]{sTemp});
                System.err.println(sMsg);
                throw new IOException(e.getMessage());
            }
            sScratchPath = OiixPathOps.concatPath(sTemp, sDirName + OiixUtilityOps.getSessionTimeStamp());
        }
        File fScratchPath = new File(sScratchPath);
        int i = 0;
        while (fScratchPath.exists()) {
            sScratchPath = sScratchPath + i;
            fScratchPath = new File(sScratchPath);
            ++i;
        }
        if (!fScratchPath.mkdirs()) {
            String sMsg = OiixResourceBundle.getString("S_SCRATCHPATH_ERROR", new Object[]{sScratchPath});
            throw new IOException(sMsg);
        }
        System.setProperty("oracle.installer.scratchPath", sScratchPath);
        return sScratchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean validateInvLocForSetup(String sInvLoc) throws OiiiInventoryException {
        block22: {
            boolean bCheck = new OiipgBootstrap().ignoreLocChecks();
            String string = sInvLoc = null != sInvLoc ? sInvLoc.trim() : "";
            if (sInvLoc.length() == 0) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_NULL_ERR");
                throw new OiiiInventoryException(sMsg, 4);
            }
            File f = new File(sInvLoc);
            try {
                block24: {
                    boolean bDelete;
                    File invFile;
                    boolean bRet;
                    block23: {
                        if (!f.exists()) break block24;
                        String sPath = OiixPathOps.concatPath(sInvLoc, "ContentsXML");
                        File fContentsXML = new File(sPath);
                        String useExistingInventory = System.getProperty("oracle.installer.useExistingInventory");
                        if (fContentsXML.exists() && fContentsXML.isDirectory() && !useExistingInventory.equalsIgnoreCase("true")) {
                            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEAN_MACHINE_WITH_EXISTING_DEFAULT_CENTRAL_INVENTORY", new Object[]{sInvLoc, sInvLoc});
                            throw new OiiiInventoryException(sMsg, 4);
                        }
                        if (!f.isDirectory()) {
                            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_INVALID_ERR");
                            throw new OiiiInventoryException(sMsg, 4);
                        }
                        if (!OiiiInstallAreaControl.readPlatformFile(sInvLoc)) {
                            Object[] obj = new Object[]{sInvLoc};
                            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_PLATFORM_ERR", obj);
                            throw new OiiiInventoryException(sMsg, 4);
                        }
                        if (bCheck) break block22;
                        bRet = true;
                        if (!sInvLoc.endsWith(File.separator)) {
                            sInvLoc = sInvLoc + File.separator;
                        }
                        invFile = new File(sInvLoc + "install.inventory");
                        bDelete = true;
                        if (invFile.exists()) {
                            bDelete = false;
                        }
                        FileOutputStream op = null;
                        op = new FileOutputStream(sInvLoc + "install.inventory", true);
                        OiiiInstallAreaControl.writePlatformFile(sInvLoc);
                        Object var13_19 = null;
                        try {
                            if (op != null) {
                                op.close();
                            }
                            break block23;
                        }
                        catch (IOException ie2) {
                            bRet = false;
                        }
                        break block23;
                        {
                            catch (IOException ie) {
                                bRet = false;
                                Object var13_20 = null;
                                try {
                                    if (op != null) {
                                        op.close();
                                    }
                                    break block23;
                                }
                                catch (IOException ie2) {
                                    bRet = false;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_21 = null;
                            try {
                                if (op != null) {
                                    op.close();
                                }
                            }
                            catch (IOException ie2) {
                                bRet = false;
                            }
                            throw throwable;
                        }
                    }
                    if (bDelete) {
                        invFile.delete();
                    }
                    if (!bRet) {
                        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_PERM_ERR");
                        throw new OiiiInventoryException(sMsg, 4);
                    }
                    break block22;
                }
                if (!OiixFileOps.mkdirs(f)) {
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_CREATE_ERR");
                    throw new OiiiInventoryException(sMsg, 4);
                }
            }
            catch (SecurityException se) {
                if (bCheck) break block22;
                se.printStackTrace();
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_PERM_ERR");
                throw new OiiiInventoryException(sMsg, 4);
            }
        }
        return true;
    }
}

