/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiipgCFSDriveCheck {
    private static OiipgCFSDriveCheck s_oCFSDriveChecker = null;
    private Vector m_vCFSDrives = null;
    private Vector m_vNonCFSDrives = null;
    private Vector m_vCFSPaths = null;
    private Vector m_vNonCFSPaths = null;
    private String[] m_asNodeArray = null;
    private String m_sLocalNode = null;
    private static String S_DEFAULT_INSTALL_LOC = "install";

    private OiipgCFSDriveCheck() {
        this.initialize();
    }

    public static OiipgCFSDriveCheck getCFSDriveChecker() {
        if (s_oCFSDriveChecker == null) {
            s_oCFSDriveChecker = new OiipgCFSDriveCheck();
        }
        return s_oCFSDriveChecker;
    }

    public static void dispose() {
        if (s_oCFSDriveChecker != null) {
            s_oCFSDriveChecker.disposeContents();
            s_oCFSDriveChecker = null;
        }
    }

    private void disposeContents() {
        this.m_vCFSDrives = null;
        this.m_vNonCFSDrives = null;
        this.m_vCFSPaths = null;
        this.m_vNonCFSPaths = null;
        this.m_asNodeArray = null;
        this.m_sLocalNode = null;
    }

    private void initialize() {
        OiicSessionInterfaceManager interfaceMgr;
        OiicInstallTimeSession instSession;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("CFSDriveChecker being initialzed.");
        }
        if ((instSession = (interfaceMgr = OiicSessionInterfaceManager.getInterfaceManager()).getSession()) != null) {
            String[] asExistingRemoteNodes;
            int i;
            String[] asRemoteNodes;
            OiisVariable oOHLoc;
            String invLoc = null;
            String ohLoc = null;
            OiisVariable oInvLoc = instSession.getSessionContext().getVariable("INVENTORY_LOCATION");
            if (oInvLoc != null) {
                invLoc = (String)oInvLoc.getValue();
            }
            if ((oOHLoc = instSession.getSessionContext().getVariable("ORACLE_HOME")) != null) {
                ohLoc = (String)oOHLoc.getValue();
            }
            OiisVariable oLocalNode = instSession.getSessionContext().getVariable("LOCAL_NODE");
            OiisVariable oRemoteNodes = instSession.getSessionContext().getVariable("REMOTE_NODES");
            OiisVariable oExistingRemoteNodes = instSession.getSessionContext().getVariable("EXISTING_REMOTE_NODES");
            ArrayList<String> oClusterNodes = new ArrayList<String>();
            if (oLocalNode != null) {
                this.m_sLocalNode = (String)oLocalNode.getValue();
                oClusterNodes.add(this.m_sLocalNode);
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText("Initializing CFSDriveChecker. Local Node:" + this.m_sLocalNode);
                }
            }
            if (oRemoteNodes != null && (asRemoteNodes = (String[])oRemoteNodes.getValue()) != null && asRemoteNodes.length > 0) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText("Initializing CFSDriveChecker. Remote Nodes:" + OiixFunctionOps.implodeList(asRemoteNodes, ","));
                }
                for (i = 0; i < asRemoteNodes.length; ++i) {
                    oClusterNodes.add(asRemoteNodes[i]);
                }
            }
            if (oExistingRemoteNodes != null && (asExistingRemoteNodes = (String[])oExistingRemoteNodes.getValue()) != null && asExistingRemoteNodes.length > 0) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText("Initializing CFSDriveChecker. Existing Remote Nodes:" + OiixFunctionOps.implodeList(asExistingRemoteNodes, ","));
                }
                for (i = 0; i < asExistingRemoteNodes.length; ++i) {
                    oClusterNodes.add(asExistingRemoteNodes[i]);
                }
            }
            if (oClusterNodes != null) {
                int numElems = oClusterNodes.size();
                this.m_asNodeArray = new String[numElems];
                for (i = 0; i < numElems; ++i) {
                    this.m_asNodeArray[i] = (String)oClusterNodes.get(i);
                }
            }
            if (ohLoc != null) {
                String sInstallOHLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(ohLoc, System.getProperty("oracle.installer.installDirLoc", S_DEFAULT_INSTALL_LOC)));
                boolean bIsShared = this.isDriveOnCFS(sInstallOHLoc);
                if (bIsShared) {
                    this.addCFSDriveToList(ohLoc);
                } else {
                    this.addNonCFSDriveToList(ohLoc);
                }
            }
        }
    }

    private Vector getCFSDrives() {
        return this.m_vCFSDrives;
    }

    private void addCFSDriveToList(String loc) {
        this.addVolumeToCFSDriveList(loc);
        this.addPathToCFSPathList(loc);
    }

    private void addPathToCFSPathList(String loc) {
        if (loc != null) {
            if (this.m_vCFSPaths == null) {
                this.m_vCFSPaths = new Vector(1);
            }
            this.addToList(loc, this.m_vCFSPaths);
        }
    }

    private void addPathToNonCFSPathList(String loc) {
        if (loc != null) {
            if (this.m_vNonCFSPaths == null) {
                this.m_vNonCFSPaths = new Vector(1);
            }
            this.addToList(loc, this.m_vNonCFSPaths);
        }
    }

    private void addVolumeToCFSDriveList(String loc) {
        if (loc != null) {
            if (this.m_vCFSDrives == null) {
                this.m_vCFSDrives = new Vector(1);
            }
            this.addToDriveList(loc, this.m_vCFSDrives);
        }
    }

    private void addVolumeToNonCFSDriveList(String loc) {
        if (loc != null) {
            if (this.m_vNonCFSDrives == null) {
                this.m_vNonCFSDrives = new Vector(1);
            }
            this.addToDriveList(loc, this.m_vNonCFSDrives);
        }
    }

    private void addToList(String loc, Vector vList) {
        if (!OiipgFileSystem.isCaseSensitive()) {
            loc = loc.toLowerCase();
        }
        if (!vList.contains(loc = OiixPathOps.getStandardForm(loc))) {
            vList.addElement(loc);
        }
    }

    private void addToDriveList(String loc, Vector vList) {
        OiipgFileSystem system = new OiipgFileSystem();
        String sVolName = system.getVolumeName(loc);
        this.addToList(sVolName, vList);
    }

    private Vector getNonCFSDrives() {
        return this.m_vNonCFSDrives;
    }

    private void addNonCFSDriveToList(String loc) {
        this.addVolumeToNonCFSDriveList(loc);
        this.addPathToNonCFSPathList(loc);
    }

    public static boolean isDriveOnCFS(String[] nodeList, String sLocalNode, String path) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Calling isDriveOnCFS:" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + path);
        }
        if (!OiipgDetectCluster.isClusterEnabled()) {
            OiiolTextLogger.appendText("Cluster mode is disabled:Drive is considered to be on on CFS by default");
            return true;
        }
        if (sLocalNode == null && nodeList != null && nodeList.length > 1) {
            sLocalNode = nodeList[0];
        }
        boolean bShared = OiipgCFSDriveCheck.isSharedPath(nodeList, sLocalNode, path);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Calling isDriveOnCFS:" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + path + ":returning " + bShared);
        }
        return OiipgCFSDriveCheck.isSharedPath(nodeList, sLocalNode, path);
    }

    public boolean isDriveOnCFS(String path) {
        String sVolName = null;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Calling isDriveOnCFS:" + path);
        }
        if (!OiipgDetectCluster.isClusterEnabled()) {
            OiiolTextLogger.appendText("Cluster mode is disabled:Drive is considered to be on on CFS by default");
            return true;
        }
        File fPath = new File(path);
        sVolName = fPath.isDirectory() ? path : fPath.getParent();
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("In isDriveOnCFS() : sVolName :" + sVolName, OiiolTextLogger.LOG_DETAILED);
        }
        if (sVolName == null) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS() : sVolName :" + sVolName + ":returning false", OiiolTextLogger.LOG_DETAILED);
            }
            return false;
        }
        sVolName = OiixPathOps.getStandardForm(sVolName);
        if (this.isPathOnCFS(sVolName = OiixPathOps.directorify(sVolName))) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS()/isPathOnCFS : sVolName :" + sVolName + ":returning true", OiiolTextLogger.LOG_DETAILED);
            }
            return true;
        }
        if (this.isPathOnNonCFS(sVolName)) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS()/isPathOnNonCFS : sVolName :" + sVolName + ":returning false", OiiolTextLogger.LOG_DETAILED);
            }
            return false;
        }
        if (this.isPathOnCFSDrive(sVolName)) {
            this.addPathToCFSPathList(sVolName);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS()/isPathOnCFSDrive : sVolName :" + sVolName + ":returning true", OiiolTextLogger.LOG_DETAILED);
            }
            return true;
        }
        if (this.isPathOnNonCFSDrive(sVolName)) {
            this.addPathToNonCFSPathList(sVolName);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS()/isPathOnNonCFSDrive : sVolName :" + sVolName + ":returning false", OiiolTextLogger.LOG_DETAILED);
            }
            return false;
        }
        if (this.m_asNodeArray != null && this.m_asNodeArray.length > 1 && this.m_sLocalNode != null) {
            try {
                String sNativeVolName = OiixPathOps.getNativeForm(sVolName);
                OiiolTextLogger.appendErrorText("sNativeVolName:" + sNativeVolName);
                OiiolTextLogger.appendErrorText("m_asNodeArray:" + OiixFunctionOps.implodeList(this.m_asNodeArray, ","));
                OiiolTextLogger.appendErrorText("m_sLocalNode:" + this.m_sLocalNode);
                if (Cluster.isSharedPath((String)sNativeVolName, (String[])this.m_asNodeArray, (String)this.m_sLocalNode)) {
                    this.addCFSDriveToList(sVolName);
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("In isDriveOnCFS()/isSharedPath : sVolName :" + sVolName + ":returning true", OiiolTextLogger.LOG_DETAILED);
                    }
                    return true;
                }
                this.addNonCFSDriveToList(sVolName);
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                    OiiolTextLogger.appendText("In isDriveOnCFS()/isSharedPath : sVolName :" + sVolName + ":returning false", OiiolTextLogger.LOG_DETAILED);
                }
                return false;
            }
            catch (SharedDeviceException e) {
                e.printStackTrace();
            }
            catch (InvalidNodeListException e) {
                e.printStackTrace();
            }
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("In isDriveOnCFS() : sVolName :" + sVolName + ":returning false", OiiolTextLogger.LOG_DETAILED);
        }
        return false;
    }

    private static boolean isSharedPath(String[] asNodeList, String sLocalNode, String sPath) {
        boolean bDriveOnCFS = false;
        if (asNodeList != null && asNodeList.length > 1 && sLocalNode != null) {
            try {
                String sNativeVolName = OiixPathOps.getNativeForm(sPath);
                bDriveOnCFS = Cluster.isSharedPath((String)sNativeVolName, (String[])asNodeList, (String)sLocalNode);
            }
            catch (SharedDeviceException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
            catch (InvalidNodeListException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
        }
        return bDriveOnCFS;
    }

    private boolean isPathOnCFS(String path) {
        return this.isPathInList(path, this.m_vCFSPaths);
    }

    private boolean isPathOnNonCFS(String path) {
        return this.isPathInList(path, this.m_vNonCFSPaths);
    }

    private boolean isPathOnCFSDrive(String path) {
        return this.isPathInDriveList(path, this.m_vCFSDrives);
    }

    private boolean isPathOnNonCFSDrive(String path) {
        return this.isPathInDriveList(path, this.m_vNonCFSDrives);
    }

    private boolean isPathInDriveList(String path, Vector vList) {
        OiipgFileSystem system = new OiipgFileSystem();
        String volName = system.getVolumeName(path);
        boolean bPathInList = false;
        if (vList != null) {
            if (!OiipgFileSystem.isCaseSensitive()) {
                path = path.toLowerCase();
            }
            bPathInList = vList.contains(path);
        }
        return bPathInList;
    }

    private boolean isPathInList(String path, Vector vList) {
        boolean bPathInList = false;
        if (vList != null) {
            for (int i = 0; i < vList.size() && !bPathInList; ++i) {
                String sPath = (String)vList.elementAt(i);
                if (!OiipgFileSystem.isCaseSensitive()) {
                    path = path.toLowerCase();
                }
                if (!path.startsWith(sPath)) continue;
                bPathInList = true;
            }
        }
        return bPathInList;
    }
}

