/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterwareInfo;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiipgCRSClusterwareInfo
extends OiipgClusterwareInfo {
    private String m_CRSLocation = null;
    private OiiiCompInstallID m_compID = null;
    private Boolean m_obCluster = null;

    OiipgCRSClusterwareInfo(OiiiCompInstallID compID) {
        this.m_compID = compID;
    }

    OiipgCRSClusterwareInfo(String sCRSLocation) {
        this.m_CRSLocation = sCRSLocation;
    }

    public boolean isCluster() {
        if (this.m_obCluster == null) {
            this.m_obCluster = OiixUtilityOps.booleanValueOf(this.isClusterImpl());
        }
        return this.m_obCluster;
    }

    protected boolean isClusterImpl() {
        this.m_CRSLocation = this.getClusterwareLocation();
        boolean bClusterDetect = false;
        try {
            bClusterDetect = !ClusterInfo.isLocalOnly((Version)new Version());
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1110", new String[]{String.valueOf(bClusterDetect)}));
        }
        catch (ClusterInfoException oCie) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25035", new String[]{oCie.getMessage()}));
        }
        if (this.m_CRSLocation == null) {
            if (!bClusterDetect) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1100", new String[]{this.m_compID.getName(), this.m_compID.getVersion().toString()}));
                return false;
            }
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1111", new String[]{this.m_compID.getName(), this.m_compID.getVersion().toString()}));
            return false;
        }
        if (this.m_compID != null) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1101", new String[]{this.m_compID.getName(), this.m_compID.getVersion().toString(), this.m_CRSLocation}));
        } else {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1109", new String[]{this.m_CRSLocation}));
        }
        try {
            ClusterInfo cInfo = new ClusterInfo(this.m_CRSLocation);
            long lStart = 0L;
            long lEnd = 0L;
            if (OiixDebug.PRINT_TIME) {
                lStart = System.currentTimeMillis();
            }
            this.m_nodeNames = cInfo.getNodeNames();
            OiiolTextLogger.appendText("List of nodes returned by the clusterware:" + OiixFunctionOps.implodeList(this.m_nodeNames, ","), OiiolTextLogger.LOG_DETAILED);
            if (OiixDebug.PRINT_TIME) {
                lEnd = System.currentTimeMillis();
                OiixDebug.printTimeMsg("Time to get node list from ClusterInfo", lEnd - lStart, lEnd);
            }
            if (OiixDebug.PRINT_TIME) {
                lStart = System.currentTimeMillis();
            }
            this.m_localNodeName = cInfo.getLocalNodeName();
            OiiolTextLogger.appendText("Local node returned by the clusterware:" + this.m_localNodeName, OiiolTextLogger.LOG_DETAILED);
            if (OiixDebug.PRINT_TIME) {
                lEnd = System.currentTimeMillis();
                OiixDebug.printTimeMsg("Time to get local node name from ClusterInfo", lEnd - lStart, lEnd);
            }
        }
        catch (ClusterInfoException e) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1105"));
            return false;
        }
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1106"));
        return true;
    }

    private String computeCRSLocation() {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inv = null;
        if (iac != null) {
            inv = iac.getInstallInventory();
        }
        if (inv != null) {
            Vector oracleHomes = inv.getHomes();
            int numHomes = oracleHomes.size();
            for (int i = 0; i < numHomes; ++i) {
                int homeIndex;
                OiiiInstallCompInvEntry compEntry;
                OiiiOracleHomeInfo oHome = (OiiiOracleHomeInfo)oracleHomes.elementAt(i);
                if (!oHome.isCRSHome() || (compEntry = (OiiiInstallCompInvEntry)inv.getCompatCompEntry(this.m_compID, homeIndex = oHome.getIndex())) == null) continue;
                return oHome.getLocation();
            }
        }
        return null;
    }

    String getActiveVersion() {
        String sVersion = null;
        try {
            ClusterInfo cInfo = new ClusterInfo(this.m_CRSLocation);
            sVersion = cInfo.getCRSActiveVersionString();
        }
        catch (ClusterInfoException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
        }
        return sVersion;
    }

    String getSoftwareVersion(String sNodeName) {
        String sVersion = null;
        if (sNodeName != null) {
            try {
                ClusterInfo cInfo = new ClusterInfo(this.m_CRSLocation);
                sVersion = cInfo.getCRSSoftwareVersionString(sNodeName);
            }
            catch (ClusterInfoException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
        }
        return sVersion;
    }

    protected String getVirtualHostName(String sNodeName) {
        String sVirtualHostName = null;
        if (sNodeName != null) {
            try {
                ClusterInfo cInfo = new ClusterInfo(this.m_CRSLocation);
                sVirtualHostName = cInfo.getNodeVIP(sNodeName);
            }
            catch (ClusterInfoException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
        }
        return sVirtualHostName;
    }

    protected String getPrivateNodeName(String sNodeName) {
        String sPrivateNodeName = null;
        if (sNodeName != null) {
            try {
                ClusterInfo cInfo = new ClusterInfo(this.m_CRSLocation);
                sPrivateNodeName = cInfo.getOraclePrivateName(sNodeName);
                if (sPrivateNodeName == null && this.isVendorClusterwarePresent()) {
                    sPrivateNodeName = ClusterInfo.getPrivateNodeName((String)sNodeName);
                }
            }
            catch (ClusterInfoException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
        }
        return sPrivateNodeName;
    }

    protected String getClusterwareLocation() {
        if (this.m_CRSLocation == null) {
            long lStart = 0L;
            long lEnd = 0L;
            if (OiixDebug.PRINT_TIME) {
                lStart = System.currentTimeMillis();
            }
            this.m_CRSLocation = this.computeCRSLocation();
            if (OiixDebug.PRINT_TIME) {
                lEnd = System.currentTimeMillis();
                OiixDebug.printTimeMsg("Time to compute CRS location", lEnd - lStart, lEnd);
            }
        }
        return this.m_CRSLocation;
    }

    public String getClusterName() {
        try {
            ClusterwareInfo cwInfo = new ClusterwareInfo();
            return cwInfo.getClusterName(this.m_CRSLocation);
        }
        catch (InstallException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
            return null;
        }
    }

    public boolean isDependentOnASM(String dbUniqueName) {
        try {
            ClusterwareInfo cwInfo = new ClusterwareInfo();
            return cwInfo.isDependentOnASM(this.m_CRSLocation, dbUniqueName);
        }
        catch (InstallException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
            return false;
        }
    }

    public boolean isDependentOnASM(String dbUniqueName, String nodeName) {
        try {
            ClusterwareInfo cwInfo = new ClusterwareInfo();
            return cwInfo.isDependentOnASM(this.m_CRSLocation, nodeName, dbUniqueName);
        }
        catch (InstallException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
            return false;
        }
    }
}

