/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiipgClusterInvSetup {
    private static String[] m_nodeList = null;
    public static boolean m_bNeedInvSetup = false;

    public boolean needInvSetup(String[] nodeNames) {
        m_nodeList = nodeNames;
        Vector<String> nodeList = new Vector<String>(1);
        int i = 0;
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (platGroup == -1) {
            for (i = 0; i < nodeNames.length; ++i) {
                try {
                    if (OiipgClusterOps.fileExistsOnNode(nodeNames[i], OiipgPropertyLoader.getUnixPtrFileLoc())) continue;
                    nodeList.addElement(nodeNames[i]);
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    nodeList.addElement(nodeNames[i]);
                }
            }
            this.setNodesForInvSetup(nodeList);
        } else if (platGroup == -3) {
            String mainKey = "HKEY_LOCAL_MACHINE\\Software\\oracle";
            String subKey = "inst_loc";
            for (i = 0; i < nodeNames.length; ++i) {
                try {
                    String tempValue = OiipwClusterWindowsOps.getRegStringDataOnNode(mainKey, subKey, nodeNames[i]);
                    if (tempValue != null && tempValue.length() != 0) continue;
                    nodeList.addElement(nodeNames[i]);
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    nodeList.addElement(nodeNames[i]);
                }
            }
        }
        if (nodeList != null && nodeList.size() > 0) {
            this.setNodesForInvSetup(nodeList);
            return true;
        }
        return false;
    }

    public String[] getNodesForInvSetup() {
        return m_nodeList;
    }

    private void setNodesForInvSetup(Vector nodeList) {
        m_nodeList = OiixVectorOps.vect2StrArr(nodeList);
    }

    public void setupInventoryOnNodes(OiicSessionContext session, String[] nodeList) throws OiipgRemoteOpsException, OiilNativeException {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        if (platGroup == -1) {
            OiisVariable oInvLoc = session.getVariable("INVENTORY_LOCATION");
            String invLoc = (String)oInvLoc.getValue();
            OiisVariable oUNIXGrp = session.getVariable("UNIX_GROUP_NAME");
            String group = null;
            if (oUNIXGrp != null) {
                group = (String)oUNIXGrp.getValue();
            }
            Object file = null;
            try {
                OiipgBootstrap pbs = new OiipgBootstrap();
                pbs.writeInvLoc(interfaceManager, invLoc, group, nodeList);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        } else if (platGroup == -3) {
            String mainKey = "HKEY_LOCAL_MACHINE";
            String subKey = "Software\\oracle";
            try {
                String regData = OiipwWin32NativeCalls.RegGetValue(mainKey, subKey, "inst_loc");
                OiipwClusterWindowsOps.registrySetValue(mainKey, subKey, "inst_loc", regData, nodeList);
            }
            catch (OiipgRemoteOpsException e) {
                String nodeListStr = OiixFunctionOps.implodeList(nodeList, ",");
                Object[] obj = new String[]{mainKey + "\\" + subKey, nodeListStr};
                String logMesg = OiixResourceBundle.getString("S_CLUSTER_SET_REGISTRY_ERROR", obj);
                throw new OiipgRemoteOpsException(logMesg, e);
            }
            catch (OiilNativeException ne) {
                String nodeListStr = OiixFunctionOps.implodeList(nodeList, ",");
                Object[] obj = new String[]{mainKey + "\\" + subKey, nodeListStr};
                String logMesg = OiixResourceBundle.getString("S_CLUSTER_GET_REGISTRY_ERROR", obj);
                throw new OiilNativeException(logMesg);
            }
        }
    }

    public static boolean validateClusterInventorySetup(String scriptLoc, String[] nodesForInvSetup) {
        if (nodesForInvSetup != null) {
            for (int i = 0; i < nodesForInvSetup.length; ++i) {
                try {
                    if (!OiipgClusterOps.fileExistsOnNode(nodesForInvSetup[i], OiipgPropertyLoader.getUnixPtrFileLoc())) {
                        return false;
                    }
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
        }
        return true;
    }

    public static String[] getCleanMachines(String[] nodes) {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        ArrayList<String> oCleanMachines = new ArrayList<String>();
        String sInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
        if (sInvPtrLoc != null) {
            Properties sysProps = System.getProperties();
            sysProps.remove("oracle.installer.invPtrLoc");
            OiipgPropertyLoader.setUnixPtrFileLocFromSysProps();
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (platGroup == -1) {
                try {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("Checking node:" + nodes[i] + " for file:" + OiipgPropertyLoader.getUnixPtrFileLoc());
                    }
                    if (!OiipgClusterOps.fileExistsOnNode(nodes[i], OiipgPropertyLoader.getUnixPtrFileLoc())) {
                        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                            OiiolTextLogger.appendText("File does not exist. Assuming a clean machine.");
                        }
                        oCleanMachines.add(nodes[i]);
                        continue;
                    }
                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
                    OiiolTextLogger.appendText("File exists. Assuming a valid inventory location.");
                }
                catch (OiipgRemoteOpsException e) {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                        OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
                        OiiolTextLogger.appendText("Assuming a clean machine on node:" + nodes[i]);
                    }
                    oCleanMachines.add(nodes[i]);
                }
                continue;
            }
            if (platGroup != -3) continue;
            try {
                String sInvLoc = OiipgClusterInvSetup.getInventoryLocationOnNodew32(nodes[i]);
                continue;
            }
            catch (OiipgRemoteOpsException e) {
                oCleanMachines.add(nodes[i]);
            }
        }
        if (sInvPtrLoc != null) {
            System.setProperty("oracle.installer.invPtrLoc", sInvPtrLoc);
        }
        return OiixVectorOps.list2StrArr(oCleanMachines);
    }

    private static String getInventoryLocationOnNodeUnix(String sNode) throws OiipgRemoteOpsException, IOException {
        String oraInstLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        if (!OiipgClusterOps.fileExistsOnNode(sNode, oraInstLoc)) {
            return null;
        }
        String oraInstLocDest = OiipgClusterInvSetup.constructOraInstLocDest(oraInstLoc);
        OiipgClusterOps.transferFileFromNode(sNode, oraInstLoc, oraInstLocDest);
        return new OiipgPropertyLoader().getLocationFileLoc(oraInstLocDest);
    }

    private static String constructOraInstLocDest(String oraInstLoc) {
        oraInstLoc = OiixPathOps.getFileName(oraInstLoc);
        String oraInstLocOnLocal = System.getProperty("oracle.installer.scratchPath");
        oraInstLocOnLocal = OiixPathOps.directorify(oraInstLocOnLocal);
        oraInstLocOnLocal = oraInstLocOnLocal + oraInstLoc;
        return oraInstLocOnLocal;
    }

    private static String getInventoryLocationOnNodew32(String sNode) throws OiipgRemoteOpsException {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (platGroup == -1) {
            return null;
        }
        if (platGroup == -3) {
            String mainKey = "HKEY_LOCAL_MACHINE";
            String subKey = "Software\\oracle";
            String key1 = "HKEY_LOCAL_MACHINE\\Software\\oracle";
            return OiipwClusterWindowsOps.getRegStringDataOnNode("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE", "inst_loc", sNode);
        }
        return null;
    }

    public static String getInventoryLocationOnNode(String sNode) {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (platGroup == -1) {
            try {
                return OiipgClusterInvSetup.getInventoryLocationOnNodeUnix(sNode);
            }
            catch (OiipgRemoteOpsException e) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
                }
                return null;
            }
            catch (IOException e) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
                }
                return null;
            }
        }
        if (platGroup == -3) {
            try {
                return OiipgClusterInvSetup.getInventoryLocationOnNodew32(sNode);
            }
            catch (OiipgRemoteOpsException e) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
                }
                return null;
            }
        }
        return null;
    }

    public static String[] performInventoryPermissionsTestOnNodes(String sDefInvLoc, OiicClusterInstallInfo clusterInfo, String[] nodes) throws OiipgRemoteOpsException {
        return nodes;
    }
}

