/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiipgClusterLogger {
    private PrintWriter m_pwFile = null;
    private PrintWriter m_pwDir = null;
    private PrintWriter m_pwRem = null;
    private PrintWriter m_pwRemDir = null;
    private PrintWriter m_pwEx = null;
    private static OiipgClusterLogger s_clusterLogger = null;
    private static final String SEPARATOR = "|";
    private static final String SESSION_SEPARATOR = "*******  " + OiixUtilityOps.getSessionTimeStamp() + "  *******";
    private String m_sCopyListFile = null;
    private String m_sRmListFile = null;
    private String m_sRmDirListFile = null;
    private String m_sDirListFile = null;
    private String m_sExcludeListFile = null;
    private String m_sFileToExclude = null;
    public static final String COPY_FILE_NAME = "installCopyFile.lst";
    public static final String DIR_FILE_NAME = "installDirFile.lst";
    public static final String RM_FILE_NAME = "installRemoveFile.lst";
    public static final String RMDIR_FILE_NAME = "installRemoveDirFile.lst";
    public static final String EXCLUDE_FILE_NAME = "installExcludeFile.lst";
    public static final String scratchPath = System.getProperty("oracle.installer.scratchPath");
    private static final int S_DEFAULT_STACK_TRACE_LINES = 5;

    private OiipgClusterLogger() {
        OiipgFileSystem fileSystem = new OiipgFileSystem();
        String tmpScratchPath = fileSystem.directorify(scratchPath);
        this.m_sCopyListFile = tmpScratchPath + COPY_FILE_NAME;
        this.m_sRmListFile = tmpScratchPath + RM_FILE_NAME;
        this.m_sRmDirListFile = tmpScratchPath + RMDIR_FILE_NAME;
        this.m_sDirListFile = tmpScratchPath + DIR_FILE_NAME;
        this.m_sExcludeListFile = tmpScratchPath + EXCLUDE_FILE_NAME;
        this.initWriters();
    }

    public static OiipgClusterLogger getClusterLogger() {
        if (s_clusterLogger == null) {
            s_clusterLogger = new OiipgClusterLogger();
        }
        return s_clusterLogger;
    }

    public String getRmdirListFile() {
        return this.m_sRmDirListFile;
    }

    public String getCopyListFile() {
        return this.m_sCopyListFile;
    }

    public String getRemoveListFile() {
        return this.m_sRmListFile;
    }

    public String getDirListFile() {
        return this.m_sDirListFile;
    }

    public String getExcludeListFile() {
        return this.m_sExcludeListFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void changeRelToAbs(String filename, String ohPath) {
        String filenameBackup;
        block13: {
            filenameBackup = filename + ".bak";
            if (!this.backupListFiles(filename, filenameBackup)) {
                return;
            }
            PrintWriter rmWriter = null;
            BufferedReader rmReader = null;
            try {
                rmWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(filename)), true);
                rmReader = new BufferedReader(new FileReader(filenameBackup));
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
                return;
            }
            String rmfileName = null;
            while ((rmfileName = rmReader.readLine()) != null) {
                File file = new File(rmfileName);
                if (file.isAbsolute()) {
                    String newrmfileName = this.removeTrailingDots(rmfileName);
                    if (newrmfileName == null || newrmfileName.equals("")) continue;
                    rmWriter.println(newrmfileName);
                    continue;
                }
                String standardOHPath = OiixPathOps.getStandardForm(ohPath);
                rmfileName = OiixPathOps.getNativeForm(standardOHPath = OiixPathOps.directorify(standardOHPath) + OiixPathOps.getStandardForm(rmfileName));
                String newrmfileName = this.removeTrailingDots(rmfileName);
                if (newrmfileName == null || newrmfileName.equals("")) continue;
                rmWriter.println(newrmfileName);
            }
            Object var11_12 = null;
            try {
                rmWriter.close();
                rmReader.close();
            }
            catch (IOException e2) {
                OiiolTextLogger.appendException(e2);
            }
            break block13;
            {
                catch (IOException e) {
                    OiiolTextLogger.appendException(e);
                    Object var11_13 = null;
                    try {
                        rmWriter.close();
                        rmReader.close();
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    rmWriter.close();
                    rmReader.close();
                }
                catch (IOException e2) {
                    OiiolTextLogger.appendException(e2);
                }
                throw throwable;
            }
        }
        this.deleteFile(filenameBackup);
    }

    public void updateListFiles(String path) {
        this.closeWriters();
        this.filterListFiles(this.getCopyListFile(), this.getDirListFile(), path);
        this.changeRelToAbs(this.getRemoveListFile(), path);
        this.changeRelToAbs(this.getRmdirListFile(), path);
        this.changeRelToAbs(this.getExcludeListFile(), path);
        String racFilesLoc = System.getProperty("oracle.installer.racFilesLoc");
        if (racFilesLoc != null) {
            this.appendFilesToOH(racFilesLoc);
        } else {
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            String clusterDirPath = iac.getOHClusterLoc(path);
            File clusterDir = new File(clusterDirPath);
            if (!clusterDir.exists()) {
                clusterDir.mkdirs();
            }
            this.appendFilesToOH(clusterDirPath);
        }
    }

    public void copyFilesToCentralInv() {
        try {
            String sLogDir = OiiolTextLogger.getLogDir();
            String[] dstFileNames = new String[]{COPY_FILE_NAME, DIR_FILE_NAME, RM_FILE_NAME, RMDIR_FILE_NAME, EXCLUDE_FILE_NAME};
            String[] srcFileNames = new String[]{this.getCopyListFile(), this.getDirListFile(), this.getRemoveListFile(), this.getRmdirListFile(), this.getExcludeListFile()};
            String sTimestamp = "." + OiixUtilityOps.getSessionTimeStamp();
            for (int i = 0; i < dstFileNames.length; ++i) {
                String sDestFile = OiixPathOps.concatPath(sLogDir, dstFileNames[i] + sTimestamp);
                OiixFileOps.copyFile(srcFileNames[i], sDestFile, true, true);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5006", args));
        }
        catch (OiifbCancelException e) {
            Object[] args = new String[]{e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5006", args));
        }
    }

    public void resetListFiles() {
        this.closeWriters();
        this.deleteFile(this.getCopyListFile());
        this.deleteFile(this.getRemoveListFile());
        this.deleteFile(this.getRmdirListFile());
        this.deleteFile(this.getDirListFile());
        this.deleteFile(this.getExcludeListFile());
    }

    private void deleteFile(String fileName) {
        File file = new File(fileName);
        file.delete();
    }

    public void updateExcludeListFileForHomeInv(String homeLoc) {
        File exFile = new File(this.getExcludeListFile());
        String ohPropFileLoc = OiixPathOps.getNativeForm(OiiiInstallAreaControl.getOHPropertiesFileLoc(homeLoc));
        this.getExclListWriter().println(ohPropFileLoc);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText(" Updated exclude list file " + this.getExcludeListFile() + " with configtoollogs/cfgfw directory", OiiolTextLogger.LOG_DETAILED);
        }
    }

    public void updateExcludeListFileForConfig(String homeLoc) {
        File exFile = new File(this.getExcludeListFile());
        String configLogsLoc = OiixPathOps.getNativeForm(OiiiInstallAreaControl.getConfigToolLogsLoc(homeLoc));
        this.getExclListWriter().println(configLogsLoc);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText(" Updated exclude list file " + this.getExcludeListFile() + " with oraclehomeproperties.xml", OiiolTextLogger.LOG_DETAILED);
        }
    }

    private boolean backupListFiles(String fileName, String fileNameBackup) {
        boolean couldRename = OiixFileOps.rename(fileName, fileNameBackup);
        Object[] args = new String[]{fileName, fileNameBackup};
        if (!couldRename) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35070", args), OiiolTextLogger.LOG_WARNING);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void filterListFiles(String copyFileName, String dirFileName, String ohPath) {
        String dirFileNameBackup;
        String copyFileNameBackup;
        block21: {
            BufferedReader dirReader;
            PrintWriter dirWriter;
            BufferedReader copyReader;
            PrintWriter copyWriter;
            block20: {
                String standardOHPath;
                File file;
                copyFileNameBackup = copyFileName + ".bak";
                if (!this.backupListFiles(copyFileName, copyFileNameBackup)) {
                    return;
                }
                dirFileNameBackup = dirFileName + ".bak";
                if (!this.backupListFiles(dirFileName, dirFileNameBackup)) {
                    return;
                }
                copyWriter = null;
                copyReader = null;
                dirWriter = null;
                dirReader = null;
                try {
                    copyWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(copyFileName)), true);
                    copyReader = new BufferedReader(new FileReader(copyFileNameBackup));
                    dirWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(dirFileName)), true);
                    dirReader = new BufferedReader(new FileReader(dirFileNameBackup));
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException(e);
                    return;
                }
                String fileName = null;
                while ((fileName = copyReader.readLine()) != null) {
                    file = new File(fileName);
                    if (file.isAbsolute()) {
                        if (file.isFile()) {
                            copyWriter.println(fileName);
                            continue;
                        }
                        if (!file.isDirectory()) continue;
                        dirWriter.println(fileName);
                        continue;
                    }
                    standardOHPath = OiixPathOps.getStandardForm(ohPath);
                    fileName = OiixPathOps.getNativeForm(standardOHPath = OiixPathOps.directorify(standardOHPath) + OiixPathOps.getStandardForm(fileName));
                    file = new File(fileName);
                    if (file.isFile()) {
                        copyWriter.println(fileName);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    dirWriter.println(fileName);
                }
                while ((fileName = dirReader.readLine()) != null) {
                    file = new File(fileName);
                    if (file.isAbsolute()) {
                        if (file.isDirectory()) {
                            dirWriter.println(fileName);
                            continue;
                        }
                        if (!file.isFile()) continue;
                        copyWriter.println(fileName);
                        continue;
                    }
                    standardOHPath = OiixPathOps.getStandardForm(ohPath);
                    fileName = OiixPathOps.getNativeForm(standardOHPath = OiixPathOps.directorify(standardOHPath) + OiixPathOps.getStandardForm(fileName));
                    file = new File(fileName);
                    if (file.isDirectory()) {
                        dirWriter.println(fileName);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    copyWriter.println(fileName);
                }
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) break block20;
                OiiolTextLogger.appendText(" Filtered list files " + copyFileName + " and " + dirFileName + "  to remove non-existing files and directories", OiiolTextLogger.LOG_DETAILED);
            }
            Object var14_15 = null;
            try {
                copyWriter.close();
                copyReader.close();
                dirWriter.close();
                dirReader.close();
            }
            catch (IOException e2) {
                OiiolTextLogger.appendException(e2);
            }
            break block21;
            {
                catch (IOException e) {
                    OiiolTextLogger.appendException(e);
                    Object var14_16 = null;
                    try {
                        copyWriter.close();
                        copyReader.close();
                        dirWriter.close();
                        dirReader.close();
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    copyWriter.close();
                    copyReader.close();
                    dirWriter.close();
                    dirReader.close();
                }
                catch (IOException e2) {
                    OiiolTextLogger.appendException(e2);
                }
                throw throwable;
            }
        }
        this.deleteFile(copyFileNameBackup);
        this.deleteFile(dirFileNameBackup);
    }

    private void appendFilesToOH(String path) {
        this.appendFilesToOH(this.getRemoveListFile(), path);
        this.appendFilesToOH(this.getRmdirListFile(), path);
        this.appendFilesToOH(this.getDirListFile(), path);
        this.appendFilesToOH(this.getCopyListFile(), path);
        this.appendFilesToOH(this.getExcludeListFile(), path);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText(" Appended list files to OH", OiiolTextLogger.LOG_DETAILED);
        }
    }

    private void appendFilesToOH(String appendFile, String path) {
        String appendFileCanonicalPath = null;
        try {
            appendFileCanonicalPath = OiixPathOps.getCanonicalPath(appendFile);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
            return;
        }
        String appendFileName = OiixPathOps.getFileName(appendFileCanonicalPath);
        OiipgFileSystem filesystem = new OiipgFileSystem();
        String origFile = filesystem.directorify(path) + appendFileName;
        try {
            OiixFileOps.appendLine(origFile, SESSION_SEPARATOR);
            OiixFileOps.appendFile(origFile, appendFile);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    public void logCopyListFile(String listFile) throws IOException {
        PrintWriter pw = this.getCopyFileWriter();
        if (listFile != null && new File(listFile).exists() && pw != null) {
            OiixFileOps.appendFilePw(pw, listFile);
        }
    }

    public static void logCopyFiles(String[] fileNames) {
        OiipgClusterLogger.getClusterLogger().logCopyFilesImpl(fileNames);
    }

    private void logCopyFilesImpl(String[] fileNames) {
        PrintWriter pw;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            String msg = "logCopyFilesImpl::";
            for (int i = 0; i < fileNames.length; ++i) {
                msg = msg + fileNames[i] + ", ";
            }
            OiipgClusterLogger.writeStackTraceToLog(msg, OiiolTextLogger.LOG_TRACE);
        }
        if ((pw = this.getCopyFileWriter()) != null) {
            for (int j = 0; j < fileNames.length; ++j) {
                pw.println(fileNames[j]);
            }
        }
    }

    public static void logCopyFile(String fileName) {
        OiipgClusterLogger.getClusterLogger().logCopyFileImpl(fileName);
    }

    private void logCopyFileImpl(String fileName) {
        PrintWriter pw;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            String msg = "logCopyFileImpl::";
            msg = msg + fileName;
            OiipgClusterLogger.writeStackTraceToLog(msg, OiiolTextLogger.LOG_TRACE);
        }
        if ((pw = this.getCopyFileWriter()) != null) {
            pw.println(fileName);
        }
    }

    public static void logJarFiles(String destRoot, String[] fileNames) {
        OiipgClusterLogger.getClusterLogger().logJarFilesImpl(destRoot, fileNames);
    }

    private void logJarFilesImpl(String destRoot, String[] fileNames) {
        PrintWriter pw;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            String msg = "logJarFilesImpl::destRoot = " + destRoot + " fileNames=";
            for (int i = 0; i < fileNames.length; ++i) {
                msg = msg + fileNames[i] + ", ";
            }
            OiipgClusterLogger.writeStackTraceToLog(msg, OiiolTextLogger.LOG_TRACE);
        }
        if ((pw = this.getCopyFileWriter()) != null) {
            for (int j = 0; j < fileNames.length; ++j) {
                fileNames[j] = destRoot + fileNames[j];
                pw.println(fileNames[j]);
            }
        }
    }

    public static void logDirCommands(String dirName) {
        OiipgClusterLogger.getClusterLogger().logDirCommandsImpl(dirName);
    }

    private void logDirCommandsImpl(String dirName) {
        PrintWriter pw;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            String msg = "logDirCommandsImpl::";
            msg = msg + dirName;
            OiipgClusterLogger.writeStackTraceToLog(msg, OiiolTextLogger.LOG_TRACE);
        }
        if ((pw = this.getDirListWriter()) != null) {
            pw.println(dirName);
        }
    }

    public static void logRecursiveDirCommands(String dirName) {
        OiipgClusterLogger.getClusterLogger().logRecursiveDirCommandsImpl(dirName);
    }

    private void logRecursiveDirCommandsImpl(String dirName) {
        PrintWriter pw;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            String msg = "logRecursiveDirCommandsImpl::";
            msg = msg + dirName;
            OiipgClusterLogger.writeStackTraceToLog(msg, OiiolTextLogger.LOG_TRACE);
        }
        if ((pw = this.getDirListWriter()) != null) {
            pw.println(dirName);
        }
    }

    public static void logRmdirCommands(String dirName) {
        OiipgClusterLogger.getClusterLogger().logRmdirCommandsImpl(dirName);
    }

    private void logRmdirCommandsImpl(String dirName) {
        PrintWriter pw;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            String msg = "logRmdirCommandsImpl::";
            msg = msg + dirName;
            OiipgClusterLogger.writeStackTraceToLog(msg, OiiolTextLogger.LOG_TRACE);
        }
        if ((pw = this.getRemDirWriter()) != null) {
            pw.println(dirName);
        }
    }

    public static void logMoveFiles(String source, String destination) {
        OiipgClusterLogger.getClusterLogger().logCopyFileImpl(destination);
        OiipgClusterLogger.getClusterLogger().logRmfileCommandsImpl(source);
        OiipgClusterLogger.getClusterLogger().logCopyFileImpl(source);
    }

    public void logRmListFile(String listFile) throws IOException {
        PrintWriter pw = this.getRemListWriter();
        if (listFile != null && new File(listFile).exists() && pw != null) {
            OiixFileOps.appendFilePw(pw, listFile);
        }
    }

    public void logRmdirListFile(String listFile) throws IOException {
        PrintWriter pw = this.getRemDirWriter();
        if (listFile != null && new File(listFile).exists() && pw != null) {
            OiixFileOps.appendFilePw(pw, listFile);
        }
    }

    public void logDirListFile(String listFile, String excludeFile) throws IOException {
        PrintWriter pw = this.getDirListWriter();
        if (listFile != null && new File(listFile).exists() && pw != null) {
            OiixFileOps.appendFilePw(pw, listFile);
        }
        this.updateExcludeListFromFile(excludeFile);
    }

    public void updateExcludeListFromFile(String sFile) throws IOException {
        File oFile;
        if (sFile != null && (oFile = new File(sFile)).exists() && oFile.isFile()) {
            OiixFileOps.appendFilePw(this.getExclListWriter(), sFile);
        }
    }

    public static void logRecursiveRmdirCommands(String dirName) {
        OiipgClusterLogger.getClusterLogger().logRecursiveRmdirCommandsImpl(dirName);
    }

    private void logRecursiveRmdirCommandsImpl(String dirName) {
        this.logRmdirCommandsImpl(dirName);
    }

    public static void logRmfileCommands(String fileName) {
        OiipgClusterLogger.getClusterLogger().logRmfileCommandsImpl(fileName);
    }

    private void logRmfileCommandsImpl(String fileName) {
        PrintWriter pw;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            String msg = "logRmfileCommandsImpl::";
            msg = msg + fileName;
            OiipgClusterLogger.writeStackTraceToLog(msg, OiiolTextLogger.LOG_TRACE);
        }
        if ((pw = this.getRemListWriter()) != null) {
            pw.println(fileName);
        }
    }

    private String removeTrailingDots(String path) {
        if (path.endsWith("/.") || path.equals(".")) {
            if (path.length() <= 2) {
                return "";
            }
            String newPath = path.substring(0, path.length() - 2);
            return newPath;
        }
        return path;
    }

    public static void dispose() {
        s_clusterLogger = null;
    }

    public void finalize() {
        this.closeWriters();
    }

    private void closeWriters() {
        if (this.m_pwFile != null) {
            this.m_pwFile.close();
            this.m_pwFile = null;
        }
        if (this.m_pwDir != null) {
            this.m_pwDir.close();
            this.m_pwDir = null;
        }
        if (this.m_pwRem != null) {
            this.m_pwRem.close();
            this.m_pwRem = null;
        }
        if (this.m_pwRemDir != null) {
            this.m_pwRemDir.close();
            this.m_pwRemDir = null;
        }
        if (this.m_pwEx != null) {
            this.m_pwEx.close();
            this.m_pwEx = null;
        }
    }

    private PrintWriter getCopyFileWriter() {
        if (this.m_pwFile == null) {
            try {
                this.m_pwFile = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.getCopyListFile(), true)), true);
            }
            catch (IOException e) {
                this.m_pwFile = null;
            }
        }
        return this.m_pwFile;
    }

    private PrintWriter getDirListWriter() {
        if (this.m_pwDir == null) {
            try {
                this.m_pwDir = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.getDirListFile(), true)), true);
            }
            catch (IOException e) {
                this.m_pwDir = null;
            }
        }
        return this.m_pwDir;
    }

    private PrintWriter getRemListWriter() {
        if (this.m_pwRem == null) {
            try {
                this.m_pwRem = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.getRemoveListFile(), true)), true);
            }
            catch (IOException e) {
                this.m_pwRem = null;
            }
        }
        return this.m_pwRem;
    }

    private PrintWriter getRemDirWriter() {
        if (this.m_pwRemDir == null) {
            try {
                this.m_pwRemDir = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.getRmdirListFile(), true)), true);
            }
            catch (IOException e) {
                this.m_pwRemDir = null;
            }
        }
        return this.m_pwRemDir;
    }

    private PrintWriter getExclListWriter() {
        if (this.m_pwEx == null) {
            try {
                this.m_pwEx = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.getExcludeListFile(), true)), true);
            }
            catch (IOException e) {
                this.m_pwEx = null;
            }
        }
        return this.m_pwEx;
    }

    private void initWriters() {
        this.getCopyFileWriter();
        this.getDirListWriter();
        this.getRemListWriter();
        this.getRemDirWriter();
        this.getExclListWriter();
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("installCopyFile is " + this.getCopyListFile(), OiiolTextLogger.LOG_DETAILED);
            OiiolTextLogger.appendText("installDirFile is " + this.getDirListFile(), OiiolTextLogger.LOG_DETAILED);
            OiiolTextLogger.appendText("installRemFile is " + this.getRemoveListFile(), OiiolTextLogger.LOG_DETAILED);
            OiiolTextLogger.appendText("installRmdirFile is " + this.getRmdirListFile(), OiiolTextLogger.LOG_DETAILED);
            OiiolTextLogger.appendText("installExFile is " + this.getExcludeListFile(), OiiolTextLogger.LOG_DETAILED);
        }
    }

    private static void writeStackTraceToLog(String msg, int logLevel) {
        Throwable t = new Throwable(msg);
        OiiolTextLogger.appendText(msg, logLevel);
        StackTraceElement[] stack = t.getStackTrace();
        int noOfOutLines = Integer.getInteger("oracle.installer.stackTraceLines", 5);
        noOfOutLines = Math.min(noOfOutLines, stack.length);
        for (int i = 0; i < noOfOutLines; ++i) {
            OiiolTextLogger.appendText(stack[i].toString(), logLevel);
        }
    }
}

