/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgInvalidLinkException;
import oracle.sysman.oii.oiip.oiipg.OiipgLinkAccessException;
import oracle.sysman.oii.oiip.oiipg.OiipgMethodUnsupportedOnPlatformException;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.osd.unix.OiipuFileSystemInformation;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiipgFileSystem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 131072;

    public static String getWindowsShortFileName(String path) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                return OiipwWin32NativeCalls.getShortFileName(path);
            }
        }
        return path;
    }

    public static void setPermissions(String sFile, String sPerms) throws IOException {
        int nPerm;
        if (sPerms == null || sFile == null) {
            return;
        }
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        try {
            nPerm = OiipgFileSystem.getPermissions(sPerms);
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{sFile, sPerms};
            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INCORRECT_PERMISSIONS_SPECIFIED", args));
        }
        catch (IOException e) {
            Object[] args = new Object[]{sFile, sPerms};
            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INCORRECT_PERMISSIONS_SPECIFIED", args));
        }
        switch (curPlatGroup) {
            case -1: {
                try {
                    OiipuUnixOps.chmod(sFile, nPerm);
                    break;
                }
                catch (OiilNativeException e) {
                    throw new IOException(OiipgFileSystem.getPermissionErrorMessage(e.getMessage(), sFile, sPerms));
                }
            }
            case -3: {
                try {
                    OiipwWin32NativeCalls.chmod(sFile, nPerm);
                    break;
                }
                catch (OiilNativeException e) {
                    throw new IOException(OiipgFileSystem.getPermissionErrorMessage(e.getMessage(), sFile, sPerms));
                }
            }
        }
    }

    public static int chown(String sFile, String sOwner, String sGroup) throws IOException {
        if (sFile == null) {
            return 0;
        }
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                if (sOwner == null && sGroup == null) break;
                try {
                    return OiipuUnixOps.chown(sFile, sOwner, sGroup);
                }
                catch (OiilNativeException e) {
                    throw new IOException(OiipgFileSystem.getOwnerErrorMessage(e.getMessage(), sFile, sOwner, sGroup));
                }
            }
        }
        return 0;
    }

    public String getMaxFreeVolume() {
        Vector vols = this.getAllFixedVolumeNames();
        if (vols == null) {
            return null;
        }
        int size = vols.size();
        if (size == 0) {
            return null;
        }
        String maxFreeDrive = (String)vols.elementAt(0);
        long maxFree = this.getVolumeFreeSpace(maxFreeDrive);
        for (int i = 1; i < size; ++i) {
            String currentVol = (String)vols.elementAt(i);
            long free = this.getVolumeFreeSpace(currentVol);
            if (free <= maxFree) continue;
            maxFree = free;
            maxFreeDrive = currentVol;
        }
        return maxFreeDrive;
    }

    public String getDefHomeLocation(String location) {
        String defHomeDrive = System.getProperty("user.home", "");
        String defHomeLoc = location;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        String sOracleBase = OiixEnvironmentOps.getEnv("ORACLE_BASE");
        if (sOracleBase != null && sOracleBase.trim().length() > 0) {
            defHomeDrive = sOracleBase;
        } else {
            switch (curPlatGroup) {
                case -3: {
                    defHomeDrive = this.getMaxFreeVolume();
                    if (defHomeDrive == null) {
                        defHomeDrive = "c:";
                    }
                    defHomeDrive = defHomeDrive.replace('\\', '/');
                    defHomeLoc = defHomeLoc.replace('\\', '/');
                    break;
                }
            }
        }
        defHomeDrive = OiixPathOps.getStandardForm(defHomeDrive);
        defHomeLoc = OiixPathOps.getStandardForm(defHomeLoc);
        defHomeLoc = OiixPathOps.concatPath(defHomeDrive, defHomeLoc);
        defHomeLoc = OiixPathOps.getNativeForm(defHomeLoc);
        return defHomeLoc;
    }

    public String getDefBaseLocation() {
        String defHomeDrive = System.getProperty("user.home", "");
        String defHomeLoc = "app" + File.separator + System.getProperty("user.name", "");
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                defHomeDrive = this.getMaxFreeVolume();
                if (defHomeDrive == null) {
                    defHomeDrive = "c:";
                }
                defHomeDrive = defHomeDrive.replace('\\', '/');
                defHomeLoc = defHomeLoc.replace('\\', '/');
                break;
            }
        }
        defHomeDrive = OiixPathOps.getStandardForm(defHomeDrive);
        defHomeLoc = OiixPathOps.getStandardForm(defHomeLoc);
        defHomeLoc = OiixPathOps.concatPath(defHomeDrive, defHomeLoc);
        defHomeLoc = OiixPathOps.getNativeForm(defHomeLoc);
        return defHomeLoc;
    }

    public static boolean isCaseSensitive() {
        boolean caseSensitive = false;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                caseSensitive = true;
                break;
            }
            default: {
                caseSensitive = false;
            }
        }
        return caseSensitive;
    }

    public boolean areLocsSame(String loc1, String loc2) {
        return OiipgFileSystem.equalPathStrs(loc1, loc2);
    }

    public String directorify(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separatorChar;
        }
        return path;
    }

    public String getVolumeName(String path) {
        String sPath = new String(OiixPathOps.getNativeForm(path));
        sPath = this.directorify(sPath);
        String volume = null;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                int nIndex = sPath.indexOf(File.separatorChar);
                if (nIndex == -1) {
                    volume = sPath.toUpperCase() + File.separatorChar;
                    break;
                }
                volume = sPath.substring(0, nIndex + 1).toUpperCase();
                break;
            }
            case -1: {
                try {
                    sPath = OiixPathOps.getCanonicalPath(sPath);
                }
                catch (IOException e) {
                    // empty catch block
                }
                String[] list = new String[]{};
                try {
                    list = OiipuUnixOps.ssGetVolList();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sPath = sPath.trim();
                if (!sPath.startsWith("" + File.separatorChar)) {
                    sPath = File.separatorChar + sPath;
                }
                if (!sPath.endsWith("" + File.separatorChar)) {
                    sPath = sPath + File.separatorChar;
                }
                Vector<String> matchList = new Vector<String>();
                int size = list.length;
                for (int i = 0; i < size; ++i) {
                    String vName = new String(list[i]);
                    if (vName.equals("/")) continue;
                    if (!vName.endsWith("" + File.separatorChar)) {
                        vName = vName + File.separatorChar;
                    }
                    if (!sPath.startsWith(vName)) continue;
                    matchList.addElement(list[i]);
                }
                String vol = "";
                for (int i = 0; i < matchList.size(); ++i) {
                    String elem = (String)matchList.elementAt(i);
                    if (elem.length() <= vol.length()) continue;
                    vol = (String)matchList.elementAt(i);
                }
                volume = new String(vol);
                if (volume.length() != 0) break;
                volume = "/";
                break;
            }
        }
        return volume;
    }

    private static void tokenPathValidation(String sProdHome, String DELIMS, String NOTALLOWEDCHARS) throws OiipgPathException {
        StringTokenizer st = new StringTokenizer(sProdHome, DELIMS);
        int numTokens = st.countTokens();
        while (st.hasMoreTokens()) {
            String elem = st.nextToken();
            StringTokenizer st1 = new StringTokenizer(elem, NOTALLOWEDCHARS);
            if (st1.hasMoreTokens()) {
                String pathPortion = st1.nextToken();
                if (pathPortion.length() == elem.length()) continue;
                throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_INVALID"), OiipgPathException.INVALID_PATH);
            }
            throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_INVALID"), OiipgPathException.INVALID_PATH);
        }
    }

    public static String validatePathUnix(String sProdHome) throws OiipgPathException {
        if (sProdHome.length() < 1) {
            throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_INVALID"), OiipgPathException.INVALID_PATH);
        }
        if (sProdHome.charAt(0) != '/') {
            throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_INVALID"), OiipgPathException.INVALID_PATH);
        }
        if (sProdHome.length() == 1) {
            return sProdHome;
        }
        sProdHome = OiixPathOps.unEscape(sProdHome);
        sProdHome = OiixPathOps.getUnexpandedCanonicalPath(sProdHome);
        String sPath = sProdHome.substring(1);
        String DELIMS = "/";
        String NOTALLOWEDCHARS = "/*?\"<>|:";
        OiipgFileSystem.tokenPathValidation(sPath, DELIMS, NOTALLOWEDCHARS);
        return sProdHome;
    }

    public static String validatePathW32(String sProdHome) throws OiipgPathException {
        if (sProdHome.length() < 2) {
            throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_INVALID"), OiipgPathException.INVALID_PATH);
        }
        if (!Character.isLetter(sProdHome.charAt(0)) || sProdHome.charAt(1) != ':') {
            throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_INVALID"), OiipgPathException.INVALID_PATH);
        }
        if (sProdHome.length() == 2) {
            return sProdHome;
        }
        sProdHome = OiixPathOps.unEscape(sProdHome);
        sProdHome = OiixPathOps.getUnexpandedCanonicalPath(sProdHome);
        String sPath = sProdHome.substring(2);
        String DELIMS = "\\";
        String NOTALLOWEDCHARS = "/*?\"<>|:";
        OiipgFileSystem.tokenPathValidation(sPath, DELIMS, NOTALLOWEDCHARS);
        return sProdHome;
    }

    public static String validatePath(String sProdHome) throws OiipgPathException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (sProdHome == null) {
            throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_EMPTY"), OiipgPathException.EMPTY_PATH);
        }
        if ((sProdHome = sProdHome.trim()).equals("")) {
            throw new OiipgPathException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_EMPTY"), OiipgPathException.EMPTY_PATH);
        }
        switch (curPlatGroup) {
            case -3: {
                sProdHome = OiipgFileSystem.validatePathW32(sProdHome);
                break;
            }
            case -1: {
                sProdHome = OiipgFileSystem.validatePathUnix(sProdHome);
                break;
            }
        }
        return sProdHome;
    }

    public static String checkWritablePath(String sProdHome) throws OiipgPathException {
        File f = new File(sProdHome = OiipgFileSystem.validatePath(sProdHome));
        if (!f.exists()) {
            try {
                String sExistPath = OiixFileOps.createDirForDest(sProdHome);
                if (!f.exists()) {
                    throw new IOException("");
                }
                OiixFileOps.recdelete(sExistPath, sProdHome);
            }
            catch (Exception ie) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_PERM");
                Object[] obj = new String[]{sProdHome};
                sMsg = MessageFormat.format(sMsg, obj);
                throw new OiipgPathException(sMsg, OiipgPathException.PERM_PATH);
            }
        }
        FileOutputStream oStream = null;
        String sTestFileName = sProdHome + File.separator + "$$$1$$.$$$";
        File tempFile = new File(sTestFileName);
        try {
            oStream = new FileOutputStream(tempFile);
        }
        catch (IOException ie) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATH_PERM");
            Object[] obj = new String[]{sProdHome};
            sMsg = MessageFormat.format(sMsg, obj);
            throw new OiipgPathException(sMsg, OiipgPathException.PERM_PATH);
        }
        try {
            if (oStream != null) {
                oStream.close();
            }
        }
        catch (IOException ie) {
            // empty catch block
        }
        if (tempFile.exists()) {
            tempFile.delete();
        }
        return sProdHome;
    }

    public static boolean isSpaceAvailable(long needed, String location) {
        long avilable;
        OiipgFileSystem pgFS = new OiipgFileSystem();
        String sVolume = pgFS.getVolumeName(location);
        boolean bAvailable = true;
        if (sVolume != null && (avilable = pgFS.getVolumeFreeSpace(sVolume)) <= needed) {
            bAvailable = false;
        }
        return bAvailable;
    }

    public static boolean mkdirs(String location, String sOwner, String sGroup) throws IOException, OiifbCancelException {
        boolean bSetGroup;
        boolean bSetOwner;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        boolean bRet = true;
        boolean bl = bSetOwner = sOwner != null && !sOwner.equals("");
        if (!bSetOwner) {
            sOwner = "";
        }
        boolean bl2 = bSetGroup = sGroup != null && !sGroup.equals("");
        if (!bSetGroup) {
            sGroup = "";
        }
        block2 : switch (curPlatGroup) {
            case -1: {
                File parentdir;
                String str = location;
                Vector<String> vCreateDir = new Vector<String>(5, 5);
                while (str != null && !(parentdir = new File(str)).exists()) {
                    vCreateDir.addElement(str);
                    str = parentdir.getParent();
                }
                int nSize = vCreateDir.size();
                int i = nSize - 1;
                while (i >= 0) {
                    String sLocation = (String)vCreateDir.elementAt(i);
                    try {
                        int iRetVal = OiipuUnixOps.ssMkDir(sLocation, bSetOwner, sOwner, bSetGroup, sGroup);
                        if (iRetVal == -1) {
                            bRet = false;
                            break block2;
                        }
                    }
                    catch (OiilNativeException e) {
                        Object[] args;
                        String sErr = e.getMessage();
                        if (sErr.equalsIgnoreCase("S_UNABLE_TO_CREATE_DIR")) {
                            File f1 = new File(location);
                            String sParent = f1.getParent();
                            try {
                                OiipgFileSystem.checkWritablePath(sParent);
                                OiixFileOps.validateDiskSpace(0L, location);
                                continue;
                            }
                            catch (OiipgPathException e1) {
                                Object[] args2 = new Object[]{location, sParent};
                                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UNABLE_TO_CREATE_DIR_READ_ONLY", args2));
                            }
                        }
                        if (sErr.startsWith("S_OWNER")) {
                            sErr = OiipgFileSystem.getOwnerErrorMessage(sErr, location, sOwner, sGroup);
                            args = new Object[]{sErr};
                            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UNABLE_TO_SET_DIR_PROPS", args));
                        }
                        args = new Object[]{location, sOwner, sGroup, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", e.getMessage())};
                        throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UNABLE_TO_SET_DIR_PROPS_GEN", args));
                    }
                    --i;
                }
                break;
            }
            default: {
                File f = new File(location);
                OiipgFileSystem.mkdirs(f);
                if (f.exists()) break;
                Object[] args = new Object[]{location};
                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UNABLE_TO_CREATE_DIR_GEN", args));
            }
        }
        return bRet;
    }

    public static boolean mkdirs(File fPath) {
        if (fPath.exists()) {
            return false;
        }
        if (fPath.mkdir()) {
            return true;
        }
        String parent = fPath.getParent();
        File fParent = new File(parent);
        return parent != null && OiipgFileSystem.mkdirs(fParent) && fPath.mkdir();
    }

    public DirectoryDrive[] getDirectoryDrives() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                return null;
            }
            case -3: {
                return this.getW32Drives();
            }
        }
        return null;
    }

    public String[] getAllVolumeNames() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                return this.getUnixVolumeNames();
            }
            case -3: {
                return this.getW32VolumeNames();
            }
        }
        return new String[0];
    }

    public Vector getAllFixedVolumeNames() {
        Vector<String> fixedDrives = new Vector<String>();
        String[] allDrives = this.getAllVolumeNames();
        for (int i = 0; i < allDrives.length; ++i) {
            if (this.getVolumeType(allDrives[i]) != 3) continue;
            fixedDrives.addElement(allDrives[i]);
        }
        return fixedDrives;
    }

    public Vector getAllFixedOrRemoteVolumeNames() {
        Vector<String> drives = new Vector<String>();
        String[] allDrives = this.getAllVolumeNames();
        for (int i = 0; i < allDrives.length; ++i) {
            int type = this.getVolumeType(allDrives[i]);
            if (type != 3 && type != 4) continue;
            drives.addElement(allDrives[i]);
        }
        return drives;
    }

    public int getVolumeType(String driveName) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                return 3;
            }
            case -3: {
                return this.getW32VolumeType(driveName);
            }
        }
        return -1;
    }

    public long getVolumeTotalSpace(String driveName) {
        File f = new File(driveName);
        if (f.exists()) {
            long totalSpace = f.getTotalSpace();
            return totalSpace;
        }
        return -1L;
    }

    public static boolean ignoreCaseInPath() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                return false;
            }
            case -3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isParentDirOf(File fParent, File fChild) {
        if (!fParent.isDirectory()) {
            return false;
        }
        File f = null;
        try {
            fParent = fParent.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        for (f = fChild.getCanonicalFile(); f != null; f = f.getParentFile()) {
            if (!f.equals(fParent)) continue;
            return true;
        }
        return false;
    }

    public static String getPathAsDirectory(String sPath) {
        File fPath = new File(sPath);
        String sRet = null;
        if (!fPath.isAbsolute()) {
            return sPath;
        }
        int curPlatGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        switch (curPlatGroup) {
            case -3: {
                sRet = sPath.replace(':', '_');
                break;
            }
            default: {
                sRet = sPath;
            }
        }
        return sRet;
    }

    public static boolean equalPathStrs(String loc1, String loc2) {
        boolean retVal = false;
        if (loc1 != null && loc2 != null) {
            try {
                File l1 = new File(loc1);
                File l2 = new File(loc2);
                String loc1Path = OiixPathOps.getFileCanonicalPath(loc1);
                String loc2Path = OiixPathOps.getFileCanonicalPath(loc2);
                if (OiipgFileSystem.isCaseSensitive()) {
                    return loc1Path.equals(loc2Path);
                }
                return loc1Path.equalsIgnoreCase(loc2Path);
            }
            catch (Exception e) {
                System.err.println("Error in equalPathStrs :" + e.getMessage());
            }
        }
        return retVal;
    }

    public long getVolumeFreeSpace(String driveName) {
        File f = new File(driveName);
        if (f.exists()) {
            long freeSpace = f.getUsableSpace();
            return freeSpace;
        }
        return -1L;
    }

    public static String getTempLoc() {
        return System.getProperty("oracle.installer.scratchPath");
    }

    private DirectoryDrive[] getW32Drives() {
        try {
            String[] dStrings = OiipwWin32NativeCalls.GetLogicalDrives();
            DirectoryDrive[] drives = new DirectoryDrive[dStrings.length];
            for (int i = 0; i < dStrings.length; ++i) {
                drives[i] = new DirectoryDrive(dStrings[i] + ":\\", "");
            }
            return drives;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] getW32VolumeNames() {
        try {
            return OiipwWin32NativeCalls.GetAllDrives();
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    private int getW32VolumeType(String driveName) {
        try {
            return OiipwWin32NativeCalls.GetDriveTypeInfo(driveName);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private long getW32VolumeTotalSpace(String driveName) {
        return this.getVolumeTotalSpace(driveName);
    }

    private long getW32VolumeFreeSpace(String driveName) {
        return this.getVolumeFreeSpace(driveName);
    }

    public static void clearInfo() {
        OiipuFileSystemInformation.clearDiskInfo();
    }

    private String[] getUnixVolumeNames() {
        try {
            String[] list = new String[]{};
            try {
                list = OiipuUnixOps.ssGetVolList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return list;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    private long getUnixVolumeTotalSpace(String volName) {
        return this.getVolumeTotalSpace(volName);
    }

    private long getUnixVolumeFreeSpace(String volName) {
        return this.getVolumeFreeSpace(volName);
    }

    public static void registerFileToDelete(File f) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                try {
                    OiipwWin32NativeCalls.registerFileToDelete(f.getCanonicalPath());
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    private static String getOwnerErrorMessage(String sErr, String sFile, String sOwner, String sGroup) {
        String sErrID = sOwner == null || sOwner.equals("") ? "S_OWNERSHIP_ERROR_GRP" : (sGroup == null || sGroup.equals("") ? "S_OWNERSHIP_ERROR_OWNER" : "S_OWNERSHIP_ERROR_OWNER_GRP");
        Object[] args = new Object[]{sFile, sOwner, sGroup, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sErr)};
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sErrID, args);
    }

    private static String getPermissionErrorMessage(String sErr, String sFile, String sPerms) {
        Object[] args = new Object[]{sFile, sPerms, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sErr)};
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PERMISSIONS_NOT_SET", args);
    }

    private static int getPermissions(String filePermissions) throws NumberFormatException, IOException {
        int nPerm = 420;
        if (filePermissions == null) {
            filePermissions = "0644";
        } else if ((filePermissions = filePermissions.trim()).length() == 0) {
            filePermissions = "0644";
        }
        Integer numPerm = Integer.valueOf(filePermissions, 8);
        nPerm = numPerm;
        return nPerm;
    }

    public static int setPermissionsLike(String sSrc, String sDestn) throws IOException {
        int retVal = 0;
        if (sSrc != null && OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            int nPerm = OiipgFileSystem.getPermission(sSrc);
            retVal = OiipgFileSystem.changePermission(sDestn, nPerm);
        }
        return retVal;
    }

    public static int changeGroup(String fileName, String group) {
        int retVal = 0;
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            retVal = OiipuUnixOps.chgrp(fileName, group);
        }
        return retVal;
    }

    public static int changeOwnerAndGroup(String fileName, String owner, String group) {
        int retVal = 0;
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            try {
                retVal = OiipuUnixOps.changeOwnerAndGroup(fileName, owner, group);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
        return retVal;
    }

    public static int changePermission(String fileName, int nFilePerm) {
        int retVal = 0;
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            try {
                retVal = OiipuUnixOps.changePermission(fileName, nFilePerm &= 0x1FF);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
        return retVal;
    }

    public static int getPermission(String fileName) {
        int retVal = 0;
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            try {
                retVal = OiipuUnixOps.getPermission(fileName);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
        return retVal;
    }

    public static int sysFunction(String command) {
        int retVal = 0;
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
            try {
                retVal = OiipuUnixOps.sysFunction(command);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
        return retVal;
    }

    public static int compareDllVersions(String file1, String file2) throws OiilNativeException {
        String dll1 = OiipgFileSystem.getDllVersion(file1);
        String dll2 = OiipgFileSystem.getDllVersion(file2);
        StringTokenizer tk1 = new StringTokenizer(dll1, ".");
        StringTokenizer tk2 = new StringTokenizer(dll2, ".");
        Integer i1 = null;
        Integer i2 = null;
        int compare = 0;
        while (tk1.hasMoreTokens() || tk2.hasMoreTokens()) {
            i1 = new Integer(tk1.nextToken());
            compare = i1.compareTo(i2 = new Integer(tk2.nextToken()));
            if (compare == 0) continue;
            return compare;
        }
        if (tk1.hasMoreTokens()) {
            return 1;
        }
        if (tk2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public static String getDllVersion(String sFilename) throws OiilNativeException {
        return OiipwWin32NativeCalls.getDllVersion(sFilename);
    }

    public static String getFixedDllVersion(String sFilename) throws OiilNativeException {
        return OiipwWin32NativeCalls.getFixedDllVersion(sFilename);
    }

    public static boolean isFileInUse(String sFilename) throws OiilNativeException {
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
            return OiipwWin32NativeCalls.isFileInUse(sFilename);
        }
        return false;
    }

    public static int createLink(String source, String dest) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.createLinkFunction(source, dest);
        }
        Object[] args = new String[]{"createLink", "UNIX"};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static int touchFile(String filename) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.touchFileFunction(filename);
        }
        Object[] args = new String[]{"touchFile", "UNIX"};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static int executeMakeFile(String command, String logFile) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.executeMakeFile(command, logFile);
        }
        Object[] args = new String[]{"executeMakeFile", "UNIX"};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static int deleteLink(String linkPath) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.deleteLink(linkPath);
        }
        Object[] args = new String[]{"deleteLink", "UNIX"};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static boolean linkExists(String linkPath) throws OiipgInvalidLinkException, OiipgLinkAccessException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            try {
                return OiipuUnixOps.linkExists(linkPath);
            }
            catch (OiilNativeException e) {
                String sErr = e.getMessage();
                if (sErr.equals("S_LINK_SYSTEM_EINVAL")) {
                    throw new OiipgInvalidLinkException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sErr));
                }
                throw new OiipgLinkAccessException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sErr));
            }
        }
        Object[] args = new String[]{"linkExists", "UNIX"};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static boolean validLinkExists(String linkPath) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.validLinkExists(linkPath);
        }
        Object[] args = new String[]{"validLinkExists", "UNIX"};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static void main(String[] args) {
        OiipgFileSystem fs = new OiipgFileSystem();
        Runtime rt = Runtime.getRuntime();
        for (int i = 0; i < new Integer(args[0]); ++i) {
            long freeMem1 = rt.freeMemory();
            long totMem1 = rt.totalMemory();
            System.err.println(i + ":" + freeMem1 + ":" + totMem1 + ":" + (totMem1 - freeMem1));
            String[] vol = fs.getUnixVolumeNames();
            for (int j = 0; j < vol.length; ++j) {
                System.out.println(vol[j] + ":" + fs.getVolumeFreeSpace(vol[j]));
                System.out.println(vol[j] + ":" + fs.getVolumeTotalSpace(vol[j]));
            }
            vol = null;
            long freeMem2 = rt.freeMemory();
            long totMem2 = rt.totalMemory();
            System.err.println(i + ":" + freeMem2 + ":" + totMem2 + ":" + (totMem2 - freeMem2));
        }
        System.exit(0);
    }
}

