/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryHelper;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageArchiveInfo;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiip.oiipg.OiipgRegistryException;
import oracle.sysman.oii.oiip.osd.unix.OiipuReadOratab;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiipgOracleHomes {
    public static final String O_HOME_FOLDER_PREFIX = "Oracle";
    private static final int HOME_32_SYNC_SUCCESS = 1;
    private static final int HOME_32_SYNC_FAILURE = 2;
    private static final int HOME_32_SAME_AS_OUI = 3;
    private static final String NLS_LANG_VALUE = "NA";
    private static boolean m_bUpdateReg = false;
    private static boolean m_bRemoteOp = false;
    private static String[] m_RegHomeLocs = null;
    public static final int S_OLD_STYLE_KEYS = 1;
    public static final int S_10G_STYLE_KEYS = 2;
    public static final int S_NO_KEYS = 0;
    public static final String HKLM = "HKEY_LOCAL_MACHINE";
    public static final String SW_ORACLE_HOME_KEY_PREFIX = "SOFTWARE\\ORACLE\\KEY_";
    public static final String SW_ORACLE_HOME = "SOFTWARE\\ORACLE\\HOME";
    public static final String SW_ORACLE_ALL_ID = "SOFTWARE\\ORACLE\\ALL_HOMES\\ID";
    public static final String PATH = "PATH";
    public static final String NAME = "NAME";
    public static final String ORACLE_HOME = "ORACLE_HOME";
    public static final String ORACLE_HOME_NAME = "ORACLE_HOME_NAME";
    public static final String ORACLE_GROUP_NAME = "ORACLE_GROUP_NAME";
    public static String[] sNodeArray = null;

    public static String[] getOsdOracleHomePaths() throws OiilNativeException {
        return null;
    }

    public static String getOratabLocation() {
        return OiipuReadOratab.getOratabLocation();
    }

    public static Vector getOsdOracleHomeInfo() throws OiilNativeException {
        Object[] homesList = null;
        String[] homesNames = null;
        Vector<OiiiOracleHomeInfo> homeInfoList = new Vector<OiiiOracleHomeInfo>();
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                try {
                    OiipuReadOratab rOratab = new OiipuReadOratab();
                    Vector homes = rOratab.getAllOracleHomes();
                    Vector<String> vORCAHomes = new Vector<String>(homes.size());
                    for (int i = 0; i < homes.size(); ++i) {
                        String sHomeLoc = (String)homes.elementAt(i);
                        if (!OiiiInventoryHelper.isORCAHome(sHomeLoc)) continue;
                        vORCAHomes.addElement(sHomeLoc);
                    }
                    homesList = new String[vORCAHomes.size()];
                    vORCAHomes.copyInto(homesList);
                }
                catch (Exception e) {}
                break;
            }
            case -3: {
                String subKey;
                String key;
                try {
                    homesList = OiipwWin32NativeCalls.GetAllOracleHomes();
                    homesNames = OiipwWin32NativeCalls.GetAllOracleHomeNames();
                }
                catch (OiilNativeException e) {
                    // empty catch block
                }
                if (homesList != null || !OiipwWin32NativeCalls.RegKeyExists(key = HKLM, subKey = "Software\\Oracle")) break;
                String inst32HomePath = OiipwWin32NativeCalls.RegGetValue(key, subKey, ORACLE_HOME);
                homesList = new String[]{inst32HomePath};
                homesNames = new String[]{"DEFAULT_HOME"};
                break;
            }
        }
        if (homesList != null) {
            for (int i = 0; i < homesList.length; ++i) {
                OiiiOracleHomeInfo inf = new OiiiOracleHomeInfo(i, homesList[i], 0);
                if (homesNames != null) {
                    inf.setName(homesNames[i]);
                }
                homeInfoList.addElement(inf);
            }
        }
        return homeInfoList;
    }

    private static int Sync32OracleHome(String sNewHomePath) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                String key = HKLM;
                String subKey = "Software\\Oracle";
                try {
                    if (OiipwWin32NativeCalls.RegKeyExists(key, subKey)) {
                        String inst32HomePath = OiipwWin32NativeCalls.RegGetValue(key, subKey, ORACLE_HOME);
                        inst32HomePath = inst32HomePath.trim();
                        boolean ret = OiipgOracleHomes.createFirstOracleHomeEntry(inst32HomePath, "DEFAULT_HOME");
                        String homeGroup = OiipwWin32NativeCalls.RegGetValue(key, subKey, ORACLE_GROUP_NAME);
                        if (!OiipgOracleHomes.checkCluster()) {
                            OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle\\HOME0", ORACLE_GROUP_NAME, homeGroup);
                            OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle\\HOME0", "NLS_LANG", NLS_LANG_VALUE);
                        } else {
                            String[] asNodes = OiipgOracleHomes.getRemoteNodes();
                            OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle\\HOME0", ORACLE_GROUP_NAME, homeGroup, asNodes);
                            OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle\\HOME0", "NLS_LANG", NLS_LANG_VALUE, asNodes);
                        }
                        if (inst32HomePath.equalsIgnoreCase(sNewHomePath)) {
                            return 3;
                        }
                        OiipgOracleHomes.setHomeCounters("Software\\Oracle\\HOME0");
                        if (ret) {
                            return 1;
                        }
                        return 2;
                    }
                    break;
                }
                catch (OiilNativeException e) {
                    return 2;
                }
            }
        }
        return 2;
    }

    public static void syncAllHomes() throws OiilNativeException {
        String key = HKLM;
        String subKey = "Software\\Oracle";
        if (OiipwWin32NativeCalls.RegKeyExists(key, subKey + "\\ALL_HOMES")) {
            String sInst32HomePath = null;
            String sInst32HomeName = null;
            try {
                sInst32HomePath = OiipwWin32NativeCalls.RegGetValue(key, "Software\\Oracle", ORACLE_HOME);
                sInst32HomeName = OiipgOracleHomes.getHomeName(sInst32HomePath);
                if (sInst32HomeName == null) {
                    sInst32HomeName = OiipgOracleHomes.getUniqueHomeName("DEFAULT_HOME");
                    OiipgOracleHomes.createOracleHomeEntry(sInst32HomePath, sInst32HomeName);
                    OiipgOracleHomes.setInst32Home(sInst32HomePath, sInst32HomeName);
                    m_bRemoteOp = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                String sDefaultHomeName = OiipwWin32NativeCalls.RegGetValue(key, subKey + "\\ALL_HOMES", "DEFAULT_HOME");
                if (sInst32HomeName != null) {
                    if (!OiipgOracleHomes.checkCluster()) {
                        OiipwWin32NativeCalls.RegSetValue(key, subKey + "\\ALL_HOMES", "DEFAULT_HOME", sInst32HomeName);
                    } else {
                        OiipgOracleHomes.RegSetValueOnNodes(key, subKey + "\\ALL_HOMES", "DEFAULT_HOME", sInst32HomeName, OiipgOracleHomes.getRemoteNodes());
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!OiipwWin32NativeCalls.RegKeyExists(key, subKey)) {
            if (!OiipgOracleHomes.checkCluster()) {
                OiipwWin32NativeCalls.RegCreateKey(key, subKey);
            } else {
                OiipgOracleHomes.RegCreateKeyOnNodes(key, subKey, OiipgOracleHomes.getRemoteNodes());
            }
        }
    }

    private static boolean createFirstOracleHomeEntry(String sHomePath, String sHomeName) throws OiilNativeException {
        String key = HKLM;
        String subKey = "Software\\Oracle\\ALL_HOMES";
        Integer homeNumber = new Integer(0);
        if (!OiipgOracleHomes.checkCluster()) {
            OiipwWin32NativeCalls.RegCreateKey(key, subKey);
            OiipwWin32NativeCalls.RegSetValue(key, subKey, "HOME_COUNTER", homeNumber.toString());
        } else {
            String[] asNodes = OiipgOracleHomes.getRemoteNodes();
            OiipgOracleHomes.RegCreateKeyOnNodes(key, subKey, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, "HOME_COUNTER", homeNumber.toString(), asNodes);
        }
        boolean bRetValue = OiipgOracleHomes.createOracleHomeEntry(sHomePath, sHomeName);
        if (bRetValue) {
            OiipgOracleHomes.setInst32Home(sHomePath, sHomeName);
        }
        return bRetValue;
    }

    public static boolean createOracleHomeEntry(String sHomePath, String sHomeName) {
        if (OiixOraparam.createOldStyleRegEntries()) {
            return OiipgOracleHomes.createOldStyleOracleHomeEntry(sHomePath, sHomeName);
        }
        return true;
    }

    public static boolean create10gStyleOracleHomeEntry(String sHomePath, String sHomeName) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            try {
                String key = HKLM;
                String subKey = OiipgOracleHomes.form10gStyleHomeKey(sHomeName);
                if (!OiipgOracleHomes.checkCluster()) {
                    if (OiipgOracleHomes.get10gStyleHomeKey(sHomeName) == null) {
                        OiipwWin32NativeCalls.RegCreateKey(key, subKey);
                    }
                    OiipwWin32NativeCalls.RegSetValue(key, subKey, ORACLE_HOME, sHomePath);
                    OiipwWin32NativeCalls.RegSetValue(key, subKey, ORACLE_HOME_NAME, sHomeName);
                } else {
                    String[] asNodes = OiipgOracleHomes.getRemoteNodes();
                    OiipgOracleHomes.RegCreateKeyOnNodes(key, subKey, asNodes);
                    OiipgOracleHomes.RegSetValueOnNodes(key, subKey, ORACLE_HOME_NAME, sHomeName, asNodes);
                    OiipgOracleHomes.RegSetValueOnNodes(key, subKey, ORACLE_HOME, sHomePath, asNodes);
                }
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean createOldStyleOracleHomeEntry(String sHomePath, String sHomeName) {
        Object homesList = null;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                try {
                    try {
                        String homePath = OiipgOracleHomes.getHomePathFromOldStyleRegistry(sHomeName);
                        if (homePath != null && !OiipgOracleHomes.checkCluster() && homePath.equalsIgnoreCase(sHomePath)) {
                            String sInst32HomePath = OiipgOracleHomes.getInst32HomePath();
                            if (sInst32HomePath == null) {
                                OiipgOracleHomes.setInst32Home(sHomePath, sHomeName);
                            }
                            OiipgOracleHomes.updateHomeCounter();
                            return true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!OiipgOracleHomes.checkCluster()) {
                        m_bRemoteOp = true;
                    } else if (!m_bRemoteOp) {
                        return true;
                    }
                    String key = HKLM;
                    if (!OiipwWin32NativeCalls.RegKeyExists(key, "Software\\Oracle\\ALL_HOMES")) {
                        int ret32 = OiipgOracleHomes.Sync32OracleHome(sHomePath);
                        if (ret32 == 2) {
                            return OiipgOracleHomes.createFirstOracleHomeEntry(sHomePath, sHomeName);
                        }
                        if (ret32 == 3) {
                            return true;
                        }
                    }
                    String homeCounter = null;
                    try {
                        OiipgOracleHomes.updateHomeCounter();
                        homeCounter = OiipwWin32NativeCalls.RegGetValue(key, "Software\\Oracle\\ALL_HOMES", "HOME_COUNTER");
                    }
                    catch (Exception e) {
                        homeCounter = "0";
                    }
                    Integer homeNumber = null;
                    homeNumber = new Integer(homeCounter);
                    if (OiipgOracleHomes.checkCluster()) {
                        homeNumber = new Integer(Integer.parseInt(homeCounter) - 1);
                    }
                    String subKey = "Software\\Oracle\\ALL_HOMES\\ID" + homeNumber;
                    if (!OiipgOracleHomes.checkCluster()) {
                        OiipwWin32NativeCalls.RegCreateKey(key, subKey);
                        m_bUpdateReg = false;
                        OiipwWin32NativeCalls.RegSetValue(key, subKey, NAME, sHomeName);
                        OiipwWin32NativeCalls.RegSetValue(key, subKey, PATH, sHomePath);
                        OiipwWin32NativeCalls.RegSetValue(key, subKey, "NLS_LANG", NLS_LANG_VALUE);
                    } else {
                        String[] asNodes = OiipgOracleHomes.getRemoteNodes();
                        OiipgOracleHomes.setInst32Home(sHomeName, sHomePath);
                        OiipgOracleHomes.RegCreateKeyOnNodes(key, subKey, asNodes);
                        OiipgOracleHomes.RegSetValueOnNodes(key, subKey, NAME, sHomeName, asNodes);
                        OiipgOracleHomes.RegSetValueOnNodes(key, subKey, PATH, sHomePath, asNodes);
                        OiipgOracleHomes.RegSetValueOnNodes(key, subKey, "NLS_LANG", NLS_LANG_VALUE, asNodes);
                    }
                    subKey = "Software\\ORACLE\\HOME" + homeNumber;
                    OiipgOracleHomes.createHomeNumberKey(subKey, sHomeName, sHomePath, homeNumber);
                    OiipgOracleHomes.updateHomeCounter();
                    String sInst32HomePath = OiipgOracleHomes.getInst32HomePath();
                    if (sInst32HomePath != null) break;
                    OiipgOracleHomes.setInst32Home(sHomePath, sHomeName);
                    break;
                }
                catch (OiilNativeException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    public static void createHomeNumberKey(String subKey, String sHomeName, String sHomePath, int nHomeNumber) throws OiilNativeException {
        String key = HKLM;
        if (!OiipgOracleHomes.checkCluster()) {
            OiipwWin32NativeCalls.RegCreateKey(key, subKey);
            OiipwWin32NativeCalls.RegSetValue(key, subKey, "ID", new Integer(nHomeNumber).toString());
            OiipwWin32NativeCalls.RegSetValue(key, subKey, ORACLE_GROUP_NAME, OiipgOracleHomes.formHomeGroupName(sHomeName));
            OiipwWin32NativeCalls.RegSetValue(key, subKey, ORACLE_HOME_NAME, sHomeName);
            OiipwWin32NativeCalls.RegSetValue(key, subKey, ORACLE_HOME, sHomePath);
            OiipwWin32NativeCalls.RegSetValue(key, subKey, "NLS_LANG", NLS_LANG_VALUE);
        } else {
            String[] asNodes = OiipgOracleHomes.getRemoteNodes();
            OiipgOracleHomes.RegCreateKeyOnNodes(key, subKey, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, "ID", new Integer(nHomeNumber - 1).toString(), asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, ORACLE_GROUP_NAME, OiipgOracleHomes.formHomeGroupName(sHomeName), asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, ORACLE_HOME_NAME, sHomeName, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, ORACLE_HOME, sHomePath, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, "NLS_LANG", NLS_LANG_VALUE, asNodes);
        }
    }

    public static String formHomeGroupName(String oHome) {
        return "Oracle - " + oHome;
    }

    private static void updateHomeCounter() {
        String sKey = HKLM;
        String sSubKey = "Software\\Oracle\\ALL_HOMES";
        try {
            String[] idKeys = OiipwWin32NativeCalls.RegGetAllSubkeys(sKey, sSubKey);
            int nMaxID = 0;
            if (idKeys != null) {
                for (int i = 0; i < idKeys.length; ++i) {
                    String sID = idKeys[i];
                    Integer nID = new Integer(sID = sID.substring(2));
                    if (nID + 1 <= nMaxID) continue;
                    nMaxID = nID + 1;
                }
            }
            if (!OiipgOracleHomes.checkCluster()) {
                OiipwWin32NativeCalls.RegSetValue(sKey, sSubKey, "HOME_COUNTER", new Integer(nMaxID).toString());
            } else {
                OiipgOracleHomes.RegSetValueOnNodes(sKey, sSubKey, "HOME_COUNTER", new Integer(nMaxID).toString(), OiipgOracleHomes.getRemoteNodes());
            }
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void setHomeCounters(String sHomeKey) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            if (sHomeKey == null) {
                return;
            }
            Object homeCounter = null;
            String key = HKLM;
            if (!sHomeKey.startsWith(SW_ORACLE_HOME_KEY_PREFIX)) {
                String homeNum = sHomeKey.substring(sHomeKey.length() - 1, sHomeKey.length());
                Integer lastHomeNumber = new Integer(homeNum);
                try {
                    if (!OiipgOracleHomes.checkCluster()) {
                        OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle\\ALL_HOMES", "LAST_HOME", lastHomeNumber.toString());
                    } else {
                        OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle\\ALL_HOMES", "LAST_HOME", lastHomeNumber.toString(), OiipgOracleHomes.getRemoteNodes());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!m_bUpdateReg) {
                    return;
                }
                m_bUpdateReg = false;
            }
        }
    }

    public static String setHomeGroupName(String homeName) throws OiilNativeException {
        String homeKey = OiipgOracleHomes.getHomeKey(homeName);
        if (homeKey == null) {
            return null;
        }
        String sFolderName = OiipgOracleHomes.formHomeGroupName(homeName);
        if (!OiipgOracleHomes.checkCluster()) {
            OiipwWin32NativeCalls.RegSetValue(HKLM, homeKey, ORACLE_GROUP_NAME, sFolderName);
        } else {
            OiipgOracleHomes.RegSetValueOnNodes(HKLM, homeKey, ORACLE_GROUP_NAME, sFolderName, OiipgOracleHomes.getRemoteNodes());
        }
        return sFolderName;
    }

    public static String getHomeGroupName(String homeName) throws OiilNativeException {
        String homeKey = OiipgOracleHomes.getHomeKey(homeName);
        if (homeKey == null) {
            return null;
        }
        String groupName = OiipwWin32NativeCalls.RegGetValue(HKLM, homeKey, ORACLE_GROUP_NAME);
        return groupName;
    }

    public static String getHomeName(String sHomePath) throws OiilNativeException {
        String[] homePaths = null;
        String[] homeNames = null;
        int curPlat = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlat);
        homePaths = OiipgOracleHomes.getAllHomes();
        homeNames = OiipgOracleHomes.getAllHomeNames();
        for (int i = 0; i < homePaths.length; ++i) {
            if (!homePaths[i].equalsIgnoreCase(sHomePath)) continue;
            return homeNames[i];
        }
        return null;
    }

    private static String getHomePathFromOldStyleRegistry(String sHomeName) throws OiilNativeException {
        String[] homePaths = null;
        String[] homeNames = null;
        int curPlat = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlat);
        homePaths = OiipwWin32NativeCalls.GetAllOracleHomes();
        homeNames = OiipwWin32NativeCalls.GetAllOracleHomeNames();
        for (int i = 0; i < homeNames.length; ++i) {
            if (!homeNames[i].equalsIgnoreCase(sHomeName)) continue;
            return homePaths[i];
        }
        return null;
    }

    public static String getHomePath(String sHomeName) throws OiilNativeException {
        String[] homePaths = null;
        String[] homeNames = null;
        int curPlat = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlat);
        homePaths = OiipgOracleHomes.getAllHomes();
        homeNames = OiipgOracleHomes.getAllHomeNames();
        for (int i = 0; i < homeNames.length; ++i) {
            if (!homeNames[i].equalsIgnoreCase(sHomeName)) continue;
            return homePaths[i];
        }
        return null;
    }

    public static String getHomeKey(String sHomeName) throws OiilNativeException {
        String sKey = OiipgOracleHomes.get10gStyleHomeKey(sHomeName);
        if (sKey == null) {
            sKey = OiipgOracleHomes.getOldStyleHomeKey(sHomeName);
        }
        return sKey;
    }

    public static String get10gStyleHomeKey(String sHomeName) throws OiilNativeException {
        String sNewStyleKey = OiipgOracleHomes.form10gStyleHomeKey(sHomeName);
        if (!OiipgOracleHomes.isKeyPresent(sNewStyleKey)) {
            return null;
        }
        return sNewStyleKey;
    }

    private static String form10gStyleHomeKey(String sHomeName) throws OiilNativeException {
        return SW_ORACLE_HOME_KEY_PREFIX + sHomeName;
    }

    public static String getOldStyleHomeKey(String sHomeName) throws OiilNativeException {
        try {
            String[] homeKeys = OiipwWin32NativeCalls.GetAllOracleHomeKeys();
            String[] homeNames = OiipwWin32NativeCalls.GetAllOracleHomeNames();
            String key = null;
            for (int i = 0; i < homeNames.length; ++i) {
                if (!sHomeName.equalsIgnoreCase(homeNames[i])) continue;
                key = homeKeys[i];
            }
            if (key == null) {
                return null;
            }
            String id = "ID";
            String homeNumber = key.substring(id.length(), key.length());
            return "Software\\ORACLE\\HOME" + homeNumber;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isKeyPresent(String subkey) throws OiilNativeException {
        String key = HKLM;
        return OiipwWin32NativeCalls.RegKeyExists(key, subkey);
    }

    public static String getHomeServiceName(String sHomeName) throws OiilNativeException {
        if (sHomeName == null) {
            throw new OiilNativeException(OiixResourceBundle.getString("S_ERR_OHNAME_NULL"));
        }
        return sHomeName;
    }

    public static String getUniqueHomeName(String nameHint) throws OiilNativeException {
        String[] homeNames = OiipwWin32NativeCalls.GetAllOracleHomeNames();
        int count = 1;
        boolean bUnique = false;
        String uniqueName = nameHint;
        while (!bUnique) {
            uniqueName = nameHint + count;
            bUnique = true;
            for (int i = 0; i < homeNames.length; ++i) {
                if (!homeNames[i].equalsIgnoreCase(uniqueName)) continue;
                bUnique = false;
                break;
            }
            ++count;
        }
        return uniqueName;
    }

    public static String[] getAllOracleHomeNames() throws OiilNativeException {
        String[] homeNames = null;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        int nHomeType = 0;
        homeNames = OiipgOracleHomes.getHomeNamesFromInventory(nHomeType);
        switch (curPlatGroup) {
            case -1: {
                break;
            }
            case -3: {
                String[] regHomeNames = OiipwWin32NativeCalls.GetAllOracleHomeNames();
                homeNames = OiixVectorOps.getUnionOfStringLists(regHomeNames, homeNames);
            }
        }
        return homeNames;
    }

    private static String[] getHomeNamesFromInventory(int nHomeType) {
        Object[] homeNames = null;
        OiiiInstallInventory installInv = null;
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        if (invAreaControl != null) {
            installInv = invAreaControl.getInstallInventory();
        }
        if (installInv != null) {
            Vector<String> names = new Vector<String>(5, 5);
            Vector existingHomes = installInv.getHomes(nHomeType);
            int size = existingHomes.size();
            for (int i = 0; i < size; ++i) {
                OiiiOracleHomeInfo ohInfo = (OiiiOracleHomeInfo)existingHomes.elementAt(i);
                names.addElement(ohInfo.getName());
            }
            homeNames = new String[names.size()];
            names.copyInto(homeNames);
        }
        return homeNames;
    }

    public static String[] getAllOracleHomes() throws OiilNativeException {
        String[] sHomeLocs = null;
        int nCurPlatId = OiixPlatform.getCurrentPlatform();
        int nCurPlatGroup = OiixPlatform.getPlatGroup(nCurPlatId);
        int nHomeType = 0;
        sHomeLocs = OiipgOracleHomes.getHomesFromInventory(nHomeType);
        switch (nCurPlatGroup) {
            case -1: {
                break;
            }
            case -3: {
                m_RegHomeLocs = OiipwWin32NativeCalls.GetAllOracleHomes();
                sHomeLocs = OiixVectorOps.getUnionOfStringLists(m_RegHomeLocs, sHomeLocs);
            }
        }
        return sHomeLocs;
    }

    public static String[] getHomesFromRegistry() {
        return m_RegHomeLocs;
    }

    private static String[] getHomesFromInventory(int nHomeType) {
        Object[] homes = null;
        OiiiInstallInventory installInv = null;
        OiiiInstallAreaControl installAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        if (installAreaControl != null) {
            installInv = installAreaControl.getInstallInventory();
        }
        if (installInv != null) {
            Vector existingHomes = installInv.getHomes(nHomeType);
            int size = existingHomes.size();
            Vector<String> vHomes = new Vector<String>(size);
            for (int i = 0; i < size; ++i) {
                OiiiOracleHomeInfo ohInfo = (OiiiOracleHomeInfo)existingHomes.elementAt(i);
                vHomes.addElement(ohInfo.getLocation());
            }
            homes = new String[vHomes.size()];
            vHomes.copyInto(homes);
        }
        return homes;
    }

    public static String[] getAllHomes() throws OiilNativeException {
        String[] OracleHomes = OiipgOracleHomes.getAllOracleHomes();
        String[] Appltops = OiipgOracleHomes.getAllAppltops();
        String[] homes = new String[OracleHomes.length + Appltops.length];
        System.arraycopy(OracleHomes, 0, homes, 0, OracleHomes.length);
        int i = 0;
        int j = OracleHomes.length;
        while (i < Appltops.length) {
            homes[j] = Appltops[i];
            ++i;
            ++j;
        }
        return homes;
    }

    private static String[] getAllHomeNames() throws OiilNativeException {
        String[] OracleHomeNames = OiipgOracleHomes.getAllOracleHomeNames();
        String[] AppltopNames = OiipgOracleHomes.getAllAppltopNames();
        String[] homeNames = new String[OracleHomeNames.length + AppltopNames.length];
        System.arraycopy(OracleHomeNames, 0, homeNames, 0, OracleHomeNames.length);
        int i = 0;
        int j = OracleHomeNames.length;
        while (i < AppltopNames.length) {
            homeNames[j] = AppltopNames[i];
            ++i;
            ++j;
        }
        return homeNames;
    }

    public static String[] getAllAppltops() {
        return OiipgOracleHomes.getHomesFromInventory(1);
    }

    public static String[] getAllAppltopNames() {
        return OiipgOracleHomes.getHomeNamesFromInventory(1);
    }

    private static void setInst32Home(String sHomePath, String sHomeName) throws OiilNativeException {
        String key = HKLM;
        String subKey = "Software\\Oracle\\ALL_HOMES";
        String sAPIPath = null;
        sAPIPath = sHomePath.endsWith("\\") ? sHomePath + "dbs" : sHomePath + "\\dbs";
        if (!OiipgOracleHomes.checkCluster()) {
            OiipwWin32NativeCalls.RegSetValue(key, subKey, "DEFAULT_HOME", sHomeName);
            OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle\\", ORACLE_HOME, sHomePath);
            OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle\\", ORACLE_HOME_NAME, sHomeName);
            OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle\\", "API", sAPIPath);
            OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle\\", ORACLE_GROUP_NAME, OiipgOracleHomes.formHomeGroupName(sHomeName));
        } else {
            String[] asNodes = OiipgOracleHomes.getRemoteNodes();
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, "DEFAULT_HOME", sHomeName, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle\\", ORACLE_HOME, sHomePath, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle\\", ORACLE_HOME_NAME, sHomeName, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle\\", "API", sAPIPath, asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle\\", ORACLE_GROUP_NAME, OiipgOracleHomes.formHomeGroupName(sHomeName), asNodes);
            OiipgOracleHomes.RegSetValueOnNodes(key, subKey, "DEFAULT_HOME", sHomeName, asNodes);
        }
        String sInst32NLS_LANG = OiipgOracleHomes.getInst32NLS_LANG();
        if (sInst32NLS_LANG == null) {
            if (!OiipgOracleHomes.checkCluster()) {
                OiipwWin32NativeCalls.RegSetValue(key, "Software\\Oracle", "NLS_LANG", NLS_LANG_VALUE);
            } else {
                OiipgOracleHomes.RegSetValueOnNodes(key, "Software\\Oracle", "NLS_LANG", NLS_LANG_VALUE, OiipgOracleHomes.getRemoteNodes());
            }
        }
    }

    private static String getInst32HomePath() {
        String sInst32HomePath = null;
        String sKey = HKLM;
        try {
            sInst32HomePath = OiipwWin32NativeCalls.RegGetValue(sKey, "Software\\Oracle\\", ORACLE_HOME);
        }
        catch (OiilNativeException oiilNativeException) {
            // empty catch block
        }
        return sInst32HomePath;
    }

    private static String getInst32NLS_LANG() {
        String sInst32NLS_LANG = null;
        String sKey = HKLM;
        try {
            sInst32NLS_LANG = OiipwWin32NativeCalls.RegGetValue(sKey, "Software\\Oracle", "NLS_LANG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sInst32NLS_LANG;
    }

    public static OiiiOracleHomeInfo getMatchingHome(String homeName) {
        OiiiOracleHomeInfo installedHome = null;
        OiiiInstallInventory installInv = null;
        OiiiInstallAreaControl installAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        if (installAreaControl != null) {
            installInv = installAreaControl.getInstallInventory();
        }
        if (installInv != null) {
            installedHome = installInv.getHomeWithName(homeName);
        }
        return installedHome;
    }

    public static Object getComponentInstallTypeName(OiisCompInstallation compInstall) {
        OiiiCompInstallID cid = compInstall.getCompInstallID();
        if (cid.getCompType() == 4 || cid.getCompType() == 2) {
            return "";
        }
        return compInstall.getDepModeName();
    }

    public static String getGroupLocation(String groupName, OiicPullSession installSession, OiisCompInstallation compInstallation) {
        OiiiCompInstallID myID = compInstallation.getCompInstallID();
        OiiiSourceAccess sAccess = installSession.getSourceAccess();
        String sourceRoot = sAccess.getSourceRoot();
        OiiiStageCompInvEntry scie = sAccess.getStageInventory().getStageCompInvEntry(myID);
        String groupsLoc = scie.getGroupFilesLoc();
        OiiiStageInventory stageInv = sAccess.getStageInventory();
        OiiiStageCompInvEntry sc = stageInv.getStageCompInvEntry(myID);
        OiiiStageArchiveInfo sai = sc.getStageArchiveInfo();
        boolean stageArchive = sai != null ? sai.isArchiveForPlat(OiixPlatform.getCurrentPlatform()) : true;
        OiisFileGroup fg = compInstallation.getFileMap().getFileGroup(groupName);
        if (fg == null) {
            return null;
        }
        boolean grpArchive = !stageArchive ? false : fg.isGroupArchived();
        if (!grpArchive) {
            String groupRelLoc = fg.getGroupLocation();
            String groupAbsoLoc = OiixPathOps.concatPath(groupsLoc, "Expanded");
            groupAbsoLoc = OiixPathOps.concatPath(groupAbsoLoc, groupRelLoc);
            return OiixPathOps.concatPath(sourceRoot, groupAbsoLoc);
        }
        return OiixPathOps.concatPath(sourceRoot, groupsLoc);
    }

    public static String getInventoryLocation(OiicPullSession installSession) {
        OiicSessionContext context = installSession.getSessionContext();
        OiisVariable oVar = context.getVariable("INVENTORY_LOCATION");
        return (String)oVar.getValue();
    }

    private static String findProductLocation(String name, String startVersion, String endVersion, Vector vCompIds, OiicPullSession oSession, boolean bCompatible) {
        if (vCompIds == null) {
            return null;
        }
        int nSize = vCompIds.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInstallID compID = (OiiiCompInstallID)vCompIds.elementAt(i);
            if (!compID.getName().equals(name)) continue;
            OiiiVersion version = compID.getVersion();
            OiiiVersion lowestVal = new OiiiVersion(startVersion);
            OiiiVersion greatestVal = new OiiiVersion(endVersion);
            if (!version.equals(lowestVal) && !version.equals(greatestVal) && (!version.laterThan(lowestVal) || !greatestVal.laterThan(version)) && (!bCompatible || !version.laterThan(greatestVal) || !greatestVal.equals(compID.getReplaceVersion()) && !greatestVal.laterThan(compID.getReplaceVersion()))) continue;
            OiisCompInstallation inst = oSession.getCompInstall(compID);
            OiisProdHomeVar oVar = inst.getProdHome();
            String sProdHome = (String)oVar.getValue();
            if (sProdHome == null || sProdHome.length() == 0) {
                OiisVariable oOH = inst.getContext().getVariable(ORACLE_HOME);
                sProdHome = (String)oOH.getValue();
            }
            return sProdHome;
        }
        return null;
    }

    public static String getProductHome(String name, String startVersion, String endVersion, OiicPullSession oSession, Boolean isCompatible) {
        OiicSessionPlan plan;
        OiiodDepEngine oDepEngine = oSession.getDepEngine();
        Vector vCompIds = oDepEngine.getCompsToInstall();
        String sLocation = OiipgOracleHomes.findProductLocation(name, startVersion, endVersion, vCompIds, oSession, isCompatible);
        if (sLocation == null && (plan = oSession.getSessionPlan()) != null) {
            vCompIds = plan.getCompIdAdditions(50);
            sLocation = OiipgOracleHomes.findProductLocation(name, startVersion, endVersion, vCompIds, oSession, isCompatible);
        }
        if (sLocation == null) {
            int nAppltopIndex;
            int nOhIndex;
            OiiiInstallAreaControl instArea = OiiiInstallAreaControl.getInstallAreaControl();
            OiiiInstallInventory areaInv = instArea.getInstallInventory();
            OiiiInstallCompInvEntry entry = areaInv.findCompInRange(nOhIndex = oSession.getOHIndex(), name, startVersion, endVersion);
            if (entry == null && (nAppltopIndex = oSession.getAppltopIndex()) != 0) {
                entry = areaInv.findCompInRange(nAppltopIndex, name, startVersion, endVersion);
            }
            if (entry != null) {
                if (!isCompatible.booleanValue()) {
                    if (!entry.getCompInstallID().getVersion().laterThan(new OiiiVersion(endVersion))) {
                        sLocation = entry.getProdHomeLoc();
                    }
                } else {
                    sLocation = entry.getProdHomeLoc();
                }
            }
        }
        return sLocation;
    }

    public static String getSourceLocation(OiicPullSession installSession) {
        return (String)installSession.getSessionVarValue("FROM_LOCATION");
    }

    private static void RegCreateKeyOnNodes(String sKey, String sSubKey, String[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        try {
            for (int i = 0; i < nodes.length; ++i) {
                ClusterWindows clusterWindows = new ClusterWindows(4);
                clusterWindows.createRegKeyOnNode(sKey, sSubKey, nodes[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void RegSetValueOnNodes(String sKey, String sSubKey, String Value, String Data, String[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        String Path2 = sKey + "\\" + sSubKey;
        try {
            for (int i = 0; i < nodes.length; ++i) {
                ClusterWindows clusterWindows = new ClusterWindows(4);
                clusterWindows.setRegValueOnNode(Path2, Value, Data, nodes[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getHomeRegNumberFromName(String sHomeName) throws OiilNativeException {
        String[] homeKeys = OiipwWin32NativeCalls.GetAllOracleHomeKeys();
        String[] homeNames = OiipwWin32NativeCalls.GetAllOracleHomeNames();
        String key = null;
        for (int i = 0; i < homeNames.length; ++i) {
            if (!sHomeName.equalsIgnoreCase(homeNames[i])) continue;
            key = homeKeys[i];
        }
        if (key == null) {
            return -1;
        }
        String id = "ID";
        String homeNumber = key.substring(id.length(), key.length());
        int nID = -1;
        try {
            nID = Integer.parseInt(homeNumber);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return nID;
    }

    private static int getHomeRegNumberFromPath(String sHomePath) throws OiilNativeException {
        String[] homeKeys = OiipwWin32NativeCalls.GetAllOracleHomeKeys();
        String[] homes = OiipwWin32NativeCalls.GetAllOracleHomes();
        String key = null;
        for (int i = 0; i < homes.length; ++i) {
            if (!sHomePath.equalsIgnoreCase(homes[i])) continue;
            key = homeKeys[i];
        }
        if (key == null) {
            return -1;
        }
        String id = "ID";
        String homeNumber = key.substring(id.length(), key.length());
        int nID = -1;
        try {
            nID = Integer.parseInt(homeNumber);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return nID;
    }

    public static void updateHomePath(String sHomeName, String sHomePath) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                OiipgOracleHomes.updateHomePathWin32(sHomeName, sHomePath);
            }
        }
    }

    private static void updateHomePathWin32(String sHomeName, String sHomePath) throws OiilNativeException {
        String sHomeKey = OiipgOracleHomes.get10gStyleHomeKey(sHomeName);
        if (OiipgOracleHomes.get10gStyleHomeKey(sHomeName) != null) {
            OiipwWin32NativeCalls.RegSetValue(HKLM, sHomeKey, PATH, sHomePath);
        } else {
            int nNumber = OiipgOracleHomes.getHomeRegNumberFromName(sHomeName);
            if (nNumber < 0) {
                return;
            }
            OiipwWin32NativeCalls.RegSetValue(HKLM, SW_ORACLE_ALL_ID + nNumber, PATH, sHomePath);
            OiipwWin32NativeCalls.RegSetValue(HKLM, SW_ORACLE_HOME + nNumber, ORACLE_HOME, sHomePath);
        }
    }

    public static void updateHomeName(String sOldHomeName, String sHomePath, String sHomeName) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                OiipgOracleHomes.updateHomeNameWin32(sOldHomeName, sHomePath, sHomeName);
            }
        }
    }

    private static void updateHomeNameWin32(String sOldHomeName, String sHomePath, String sHomeName) throws OiilNativeException {
        String sOldHomeKey = OiipgOracleHomes.get10gStyleHomeKey(sOldHomeName);
        String sHomeKey = OiipgOracleHomes.form10gStyleHomeKey(sHomeName);
        if (sOldHomeKey != null) {
            OiipwWin32NativeCalls.RegSetValue(HKLM, sOldHomeKey, ORACLE_HOME_NAME, sHomeName);
            OiipwWin32NativeCalls.RegCopyKey(HKLM, sOldHomeKey, HKLM, sHomeKey);
            OiipwWin32NativeCalls.RegDeleteKey(HKLM, sOldHomeKey);
        } else {
            int nNumber = OiipgOracleHomes.getHomeRegNumberFromPath(sHomePath);
            if (nNumber < 0) {
                return;
            }
            OiipwWin32NativeCalls.RegSetValue(HKLM, SW_ORACLE_ALL_ID + nNumber, NAME, sHomeName);
            OiipwWin32NativeCalls.RegSetValue(HKLM, SW_ORACLE_HOME + nNumber, ORACLE_HOME_NAME, sHomeName);
        }
    }

    public static void removeHome(String sHomePath, String sHomeName) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                OiipgOracleHomes.removeHomeWin32(sHomePath, sHomeName);
            }
        }
    }

    private static void removeHomeWin32(String sHomePath, String sHomeName) throws OiilNativeException {
        String sHomeKey = OiipgOracleHomes.get10gStyleHomeKey(sHomeName);
        if (sHomeKey != null) {
            OiipwWin32NativeCalls.RegDeleteKey(HKLM, sHomeKey);
        } else {
            int nNumber = OiipgOracleHomes.getHomeRegNumberFromPath(sHomePath);
            if (nNumber < 0) {
                return;
            }
            OiipwWin32NativeCalls.RegDeleteKey(HKLM, SW_ORACLE_ALL_ID + nNumber);
            OiipwWin32NativeCalls.RegDeleteKey(HKLM, SW_ORACLE_HOME + nNumber);
        }
    }

    private static boolean checkCluster() {
        OiisVariable oClusterNodes;
        OiicSessionInterfaceManager interfaceMgr = OiicSessionInterfaceManager.getInterfaceManager();
        OiicInstallTimeSession instSession = interfaceMgr.getSession();
        boolean bCluster = false;
        if (instSession != null && (sNodeArray = (String[])(oClusterNodes = instSession.getSessionContext().getVariable("CLUSTER_NODES")).getValue()) != null && sNodeArray.length > 1) {
            bCluster = true;
        }
        return bCluster;
    }

    private static String create10gStyleRegKeys(String oracleHomeNameStr, String oracleHomeString) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        String homeKey = null;
        if (curPlatGroup == -3) {
            OiipgOracleHomes.create10gStyleOracleHomeEntry(oracleHomeString, oracleHomeNameStr);
            homeKey = OiipgOracleHomes.get10gStyleHomeKey(oracleHomeNameStr);
        }
        return homeKey;
    }

    private static String createOldStyleRegKeys(String oracleHomeNameStr, String oracleHomeString) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        String homeKey = null;
        if (curPlatGroup == -3) {
            homeKey = OiipgOracleHomes.getOldStyleHomeKey(oracleHomeNameStr);
            if (homeKey == null) {
                OiipgOracleHomes.createOldStyleOracleHomeEntry(oracleHomeString, oracleHomeNameStr);
                homeKey = OiipgOracleHomes.getOldStyleHomeKey(oracleHomeNameStr);
            } else if (!OiipgOracleHomes.isKeyPresent(homeKey)) {
                int idx = homeKey.toLowerCase().lastIndexOf("home");
                String sHomeNumber = homeKey.substring(idx + "home".length());
                Integer homeNumber = new Integer(sHomeNumber);
                int nHomeNumber = homeNumber;
                String hName = OiipgOracleHomes.getHomeName(oracleHomeString);
                OiipgOracleHomes.createHomeNumberKey(homeKey, hName, oracleHomeString, nHomeNumber);
            }
        }
        return homeKey;
    }

    private static int getRegKeyType(String sHomeName) {
        int iKeyType = 0;
        String sKey = null;
        try {
            sKey = OiipgOracleHomes.get10gStyleHomeKey(sHomeName);
        }
        catch (OiilNativeException e) {
            // empty catch block
        }
        if (sKey == null) {
            try {
                sKey = OiipgOracleHomes.getOldStyleHomeKey(sHomeName);
            }
            catch (OiilNativeException oiilNativeException) {
                // empty catch block
            }
            iKeyType = sKey == null ? 0 : 1;
        } else {
            iKeyType = 2;
        }
        return iKeyType;
    }

    public static void setupRegEntriesAndContext(OiisVariableOwner sessionContext, boolean bDefOldStyleRegEntries) throws IOException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            OiisVariable ohomeVar = sessionContext.getVariable(ORACLE_HOME_NAME);
            String oracleHomeNameStr = (String)ohomeVar.getValue();
            OiisVariable ohomeLoc = sessionContext.getVariable(ORACLE_HOME);
            String oracleHomeString = (String)ohomeLoc.getValue();
            String homeKey = "";
            String homeFolder = "";
            String homeService = "";
            int iKeyType = OiipgOracleHomes.getRegKeyType(oracleHomeNameStr);
            boolean bOldStyleRegEntries = iKeyType == 1 || iKeyType == 0 && bDefOldStyleRegEntries;
            try {
                if (bOldStyleRegEntries) {
                    homeKey = OiipgOracleHomes.createOldStyleRegKeys(oracleHomeNameStr, oracleHomeString);
                    try {
                        homeFolder = OiipgOracleHomes.getHomeGroupName(oracleHomeNameStr);
                    }
                    catch (OiilNativeException ne) {
                        homeFolder = OiipgOracleHomes.setHomeGroupName(oracleHomeNameStr);
                    }
                } else {
                    homeKey = OiipgOracleHomes.form10gStyleHomeKey(oracleHomeNameStr);
                    homeFolder = OiipgOracleHomes.formHomeGroupName(oracleHomeNameStr);
                }
                homeService = oracleHomeNameStr;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            try {
                ohomeVar = sessionContext.getVariable("ORACLE_HOME_KEY");
                ohomeVar.setValue(homeKey, true);
                ohomeVar = sessionContext.getVariable("ORACLE_HOME_FOLDER");
                ohomeVar.setValue(homeFolder, true);
                ohomeVar = sessionContext.getVariable("ORACLE_HOME_SERVICE");
                ohomeVar.setValue(homeService, true);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public static void setup10gStyleRegEntriesOnNodes(String sSubKey, String[] asRegEntries, String[] asRegValues, String[] asNodeList) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            String sKey = HKLM;
            OiipwClusterWindowsOps.regCreateKey(sKey, sSubKey, asNodeList);
            for (int i = 0; i < asRegEntries.length; ++i) {
                OiipwClusterWindowsOps.regSetValue(sKey, sSubKey, asRegEntries[i], asRegValues[i], asNodeList);
            }
        }
    }

    public static boolean is10gRegistrySetupRequired(String sHomeName) {
        boolean b10gRegSetupRequired = false;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            int iKeyType = OiipgOracleHomes.getRegKeyType(sHomeName);
            b10gRegSetupRequired = iKeyType == 2 || iKeyType == 0 && !OiixOraparam.createOldStyleRegEntries();
        }
        return b10gRegSetupRequired;
    }

    public static boolean anyVersionOfProductInstalled(String name, OiicPullSession installSession) {
        int nAppltopIndex;
        if (installSession.isCloneMode()) {
            return false;
        }
        OiiiInstallAreaControl instArea = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory areaInv = instArea.getInstallInventory();
        OiiiInstallCompInvEntry entry = areaInv.findCompInRange(installSession.getOHIndex(), name, null, null);
        if (entry == null && (nAppltopIndex = installSession.getAppltopIndex()) != 0) {
            entry = areaInv.findCompInRange(nAppltopIndex, name, null, null);
        }
        return entry != null;
    }

    public static boolean isProductInstalled(String ohLoc, String name, String startVersion, String endVersion, OiicPullSession installSession, Boolean isCompatible) {
        OiiiInstallCompInvEntry entry;
        OiiiInstallAreaControl instArea = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory areaInv = instArea.getInstallInventory();
        if (ohLoc != null) {
            Vector ohList = areaInv.getHomes();
            int index = OiiiOracleHomeInfo.getOHIndex(ohList, ohLoc);
            if (index == -1) {
                return false;
            }
            if (installSession.isCloneMode() && index == installSession.getOHIndex()) {
                return false;
            }
            entry = areaInv.findCompInRange(index, name, startVersion, endVersion);
        } else {
            int nAppltopIndex;
            int nOhIndex = installSession.getOHIndex();
            entry = areaInv.findCompInRange(nOhIndex, name, startVersion, endVersion);
            if (entry == null && (nAppltopIndex = installSession.getAppltopIndex()) != 0) {
                entry = areaInv.findCompInRange(nAppltopIndex, name, startVersion, endVersion);
            }
        }
        if (!isCompatible.booleanValue() && entry != null && entry.getCompInstallID().getVersion().laterThan(new OiiiVersion(endVersion))) {
            entry = null;
        }
        return entry != null;
    }

    public static void setup10gStyleRegEntries(String sSubKey, String[] asRegEntries, String[] asRegValues) throws OiipgRegistryException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            String sKey = HKLM;
            try {
                OiipwWin32NativeCalls.RegCreateKey(sKey, sSubKey);
            }
            catch (OiilNativeException e) {
                Object[] args = new String[]{sKey + "\\" + sSubKey};
                throw new OiipgRegistryException("OUI-7000", OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-7000", args));
            }
            ArrayList<String> oUncreatedKeys = new ArrayList<String>(asRegEntries.length);
            for (int i = 0; i < asRegEntries.length; ++i) {
                try {
                    OiipwWin32NativeCalls.RegSetValue(sKey, sSubKey, asRegEntries[i], asRegValues[i]);
                    continue;
                }
                catch (OiilNativeException e) {
                    oUncreatedKeys.add(sKey + "\\" + sSubKey + "\\" + asRegEntries[i] + "=" + asRegValues[i]);
                }
            }
            if (oUncreatedKeys.size() > 0) {
                String[] asUncreatedKeys = OiixVectorOps.list2StrArr(oUncreatedKeys);
                String sUncreatedKeysStr = OiixFunctionOps.implodeList(asUncreatedKeys, System.getProperty("line.separator", "\n"));
                Object[] args = new String[]{sUncreatedKeysStr};
                throw new OiipgRegistryException("OUI-7000", OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-7000", args));
            }
        }
    }

    public static void validateHomeWithRegEntries(OiiiOracleHomeInfo newHome) throws IOException {
        block5: {
            int curPlatId = OiixPlatform.getCurrentPlatform();
            int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
            if (curPlatGroup == -3) {
                try {
                    String s = null;
                    s = OiipgOracleHomes.getHomeName(newHome.getLocation());
                    if (s != null && !s.equalsIgnoreCase(newHome.getName())) {
                        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_DUP_OH_NAME");
                        throw new IOException(sMsg);
                    }
                    s = OiipgOracleHomes.getHomePath(newHome.getName());
                    if (s != null && !s.equalsIgnoreCase(newHome.getLocation())) {
                        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_DUP_OH_PATH");
                        throw new IOException(sMsg);
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof IOException)) break block5;
                    throw (IOException)e;
                }
            }
        }
    }

    private static String[] getRemoteNodes() {
        OiicSessionInterfaceManager interfaceMgr = OiicSessionInterfaceManager.getInterfaceManager();
        OiicInstallTimeSession instSession = interfaceMgr.getSession();
        String[] remoteNodeArray = null;
        if (instSession != null) {
            remoteNodeArray = (String[])instSession.getSessionContext().getVarValue("REMOTE_NODES");
        }
        return remoteNodeArray;
    }
}

