/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiipgPropertyLoader {
    public static final String LOCATION_FILE_NAME = "oraInstaller.properties";
    public static final String HKEY_LOCAL_MACHINE = "HKEY_LOCAL_MACHINE";
    public static final String ORACLE_KEY = "SOFTWARE\\ORACLE";
    public static final String LOCVALUE = "inst_loc";
    public static final String HKEY_CURRENT_USER = "HKEY_CURRENT_USER";
    public static final String ENVIRONMENT_KEY = "Environment";
    public static final String PATH_VALUE = "Path";
    private static String s_unixPtrFileLoc = OiipgPropertyLoader.initUnixPtrFileLoc();
    public static final String UNIX_LOCATION_FILE_LOC = "inventory_loc";
    public static final String UNIX_GROUP_PTR = "inst_group";
    public static final String SOL_PROPERTIES_HEADER = "Oracle Installer Location File Location";
    public static final String ORACLE_WOW64_KEY = "SOFTWARE\\WOW6432NODE\\ORACLE";
    private static final String OUI_INVPTRLOC = "OUI_INVPTRLOC";
    private static boolean s_bWOW64 = false;
    public static final String KEY_INSTVER = "instver";
    public static final String KEY_INSTLOC = "inst_loc";
    public static final String KEY_SCRATCHPATH = "oracle.installer.scratchPath";
    public static final String KEY_NATIVE_EXTRACTDIR = "oracle.installer.NatLibDir";
    public static final String KEY_LOGLOC = "oracle.installer.log_loc";
    public static final String KEY_LIBLOC = "oracle.installer.lib_loc";
    private static final String m_propHeader = "Oracle Installer Properties";
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 131072;

    public static void setWOW64(boolean flag) {
        s_bWOW64 = flag;
    }

    public static boolean getWOW64() {
        return s_bWOW64;
    }

    private static String initUnixPtrFileLoc() {
        String ptrLoc = System.getProperty("oracle.installer.invPtrLoc");
        String loc = "";
        if (ptrLoc != null) {
            loc = ptrLoc;
        } else {
            ptrLoc = OiipgEnvironment.getEnv(OUI_INVPTRLOC);
            if (ptrLoc != null && !ptrLoc.trim().equals("")) {
                loc = ptrLoc;
            } else {
                switch (OiixPlatform.getCurrentPlatform()) {
                    case 46: 
                    case 227: {
                        loc = "/etc/oraInst.loc";
                        break;
                    }
                    case 198: 
                    case 610: {
                        loc = "/etc/oraInst.loc";
                        break;
                    }
                    default: {
                        loc = "/var/opt/oracle/oraInst.loc";
                    }
                }
            }
        }
        return loc;
    }

    public static void setUnixPtrFileLocFromSysProps() {
        s_unixPtrFileLoc = OiipgPropertyLoader.initUnixPtrFileLoc();
    }

    public static String getUnixPtrFileLoc() {
        return s_unixPtrFileLoc;
    }

    public Properties loadInstallerProperties(String invLoc) throws IOException {
        Properties retProp = null;
        try {
            if (invLoc != null) {
                retProp = new Properties();
                FileInputStream fis = new FileInputStream(invLoc + File.separatorChar + LOCATION_FILE_NAME);
                retProp.load(fis);
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            retProp = null;
        }
        return retProp;
    }

    public String getLocationFileLoc(String oraInstLoc) throws IOException {
        String locFileLoc = null;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                locFileLoc = this.getWin32PropLoc();
                break;
            }
            case -1: {
                locFileLoc = this.getUnixPropLoc(oraInstLoc);
                break;
            }
        }
        return locFileLoc;
    }

    public String getLocationFileLoc() throws IOException {
        return this.getLocationFileLoc(null);
    }

    private String getWin32PropLoc() throws IOException {
        String directory = null;
        String sKey = ORACLE_KEY;
        try {
            boolean retVal;
            if (s_bWOW64) {
                if (OiixPlatform.getCurrentPlatform() == 208 || OiixPlatform.getCurrentPlatform() == 233) {
                    sKey = ORACLE_WOW64_KEY;
                } else {
                    throw new IOException(OiixResourceBundle.getString("S_WOW64_REGISTRY_ACCESS_ERROR"));
                }
            }
            if (retVal = OiipwWin32NativeCalls.RegKeyExists(HKEY_LOCAL_MACHINE, sKey)) {
                directory = OiipwWin32NativeCalls.RegGetValue(HKEY_LOCAL_MACHINE, sKey, "inst_loc");
            }
        }
        catch (OiilNativeException e) {
            String sMsg = OiixResourceBundle.getString("S_ERR_INST_LOC_REG_ENTRY");
            String sInvKey = "HKEY_LOCAL_MACHINE\\" + sKey + "\\" + "inst_loc";
            Object[] arg = new String[]{sInvKey};
            sMsg = MessageFormat.format(sMsg, arg);
            throw new IOException(sMsg);
        }
        return directory;
    }

    private String getUnixPropLoc(String oraInstLoc) throws IOException {
        File f;
        String directory = null;
        if (oraInstLoc == null) {
            oraInstLoc = s_unixPtrFileLoc;
        }
        if ((f = new File(oraInstLoc)).exists()) {
            try {
                FileInputStream din = new FileInputStream(oraInstLoc);
                Properties sol_properties = new Properties();
                sol_properties.load(din);
                din.close();
                directory = sol_properties.getProperty(UNIX_LOCATION_FILE_LOC);
            }
            catch (IOException ioe) {
                String sMsg = OiixResourceBundle.getString("S_ERR_INV_PTR_FILE");
                Object[] arg = new String[]{s_unixPtrFileLoc};
                sMsg = MessageFormat.format(sMsg, arg);
                throw new IOException(sMsg);
            }
        }
        return directory;
    }

    private Properties getUnixProps() throws IOException {
        File f = new File(s_unixPtrFileLoc);
        Properties sol_properties = new Properties();
        if (f.exists()) {
            FileInputStream din = new FileInputStream(s_unixPtrFileLoc);
            sol_properties.load(din);
            din.close();
        }
        return sol_properties;
    }

    public String getUnixGroup() {
        String sGroup = "";
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -1) {
            Properties props = null;
            try {
                props = this.getUnixProps();
            }
            catch (IOException e) {
                return "";
            }
            sGroup = props.getProperty(UNIX_GROUP_PTR);
            if (sGroup == null) {
                sGroup = "";
            }
        }
        return sGroup;
    }

    public static OiiiVersion getPropertiesInstVer(Properties properties) {
        if (properties == null) {
            return null;
        }
        String ver = properties.getProperty(KEY_INSTVER);
        if (ver == null) {
            return null;
        }
        return new OiiiVersion(ver);
    }

    public static void setPropertiesInstVer(Properties properties, String ver) throws NullPointerException {
        if (ver == null) {
            return;
        }
        if (properties == null) {
            properties = new Properties();
        }
        properties.put(KEY_INSTVER, ver);
    }

    public static String getPropertiesInstLoc(Properties properties) {
        if (properties == null) {
            return null;
        }
        return properties.getProperty("inst_loc");
    }

    public static void setPropertiesInstLoc(Properties properties, String loc) {
        if (loc == null) {
            return;
        }
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("inst_loc", loc);
    }

    public static String getPropertiesLogLoc(Properties properties) {
        if (properties == null) {
            return null;
        }
        return properties.getProperty(KEY_LOGLOC);
    }

    public static void setPropertiesLogLoc(Properties properties, String loc) {
        if (loc == null) {
            return;
        }
        if (properties == null) {
            properties = new Properties();
        }
        properties.put(KEY_LOGLOC, loc);
    }

    public static String getPropertiesLibLoc(Properties properties) {
        if (properties == null) {
            return null;
        }
        return properties.getProperty(KEY_LIBLOC);
    }

    public static void setPropertiesLibLoc(Properties properties, String loc) {
        if (loc == null) {
            return;
        }
        if (properties == null) {
            properties = new Properties();
        }
        properties.put(KEY_LIBLOC, loc);
    }

    public static String getPropertiesScratchPath(Properties properties) {
        if (properties == null) {
            return null;
        }
        return properties.getProperty(KEY_SCRATCHPATH);
    }

    public static void setPropertiesScratchPath(Properties properties, String loc) {
        if (loc == null) {
            return;
        }
        properties.put(KEY_SCRATCHPATH, loc);
    }

    public static String getPropertiesNativeExtractDir(Properties properties) {
        return properties.getProperty(KEY_NATIVE_EXTRACTDIR);
    }

    public static void setPropertiesNativeExtractDir(Properties properties, String loc) {
        if (loc == null) {
            return;
        }
        properties.put(KEY_NATIVE_EXTRACTDIR, loc);
    }

    public static boolean isSamePath(String loc1, String loc2) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                if (loc1.equalsIgnoreCase(loc2)) {
                    return true;
                }
            }
            case 2: 
            case 46: 
            case 87: 
            case 110: 
            case 197: 
            case 211: 
            case 421: 
            case 453: 
            case 610: {
                if (!loc1.trim().equals(loc2)) break;
                return true;
            }
        }
        return false;
    }
}

