/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.IOException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;

public class OiipgSpawn {
    String[] m_errMsg = new String[this.m_numKnownErr];
    private int m_numKnownErr = 4;
    private static String key = "HKEY_LOCAL_MACHINE";
    private static String subKey = "SOFTWARE\\Classes";
    private String S_EXTN_HTM = ".htm";
    private String S_EXTN_HTML = ".html";
    private String S_EXTN_TXT = ".txt";
    private String S_MOZILLA = "mozilla";
    private String S_NETSCAPE = "netscape";
    private String S_VIM = "vim";

    public OiipgSpawn() {
        this.m_errMsg[0] = OiixResourceBundle.getString("S_ERR_SPAWN_CMD");
        this.m_errMsg[1] = OiixResourceBundle.getString("S_ERR_SPAWN_PATH");
        this.m_errMsg[2] = OiixResourceBundle.getString("S_ERR_SPAWN_DIR");
        this.m_errMsg[3] = OiixResourceBundle.getString("S_ERR_SPAWN_EXE");
    }

    public static String getAssociatedCommand(String sFileName) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        String sCommand = sFileName;
        block0 : switch (curPlatGroup) {
            case -1: {
                break;
            }
            case -3: {
                switch (curPlatId) {
                    case 50: 
                    case 208: 
                    case 233: 
                    case 615: 
                    case 912: {
                        int lastIndex = sFileName.lastIndexOf(".");
                        if (lastIndex != -1) {
                            String sValue;
                            String sExt = sFileName.substring(lastIndex, sFileName.length());
                            if ((sExt = sExt.trim()).endsWith("\"")) {
                                sExt = sExt.substring(0, sExt.length() - 1);
                                sExt = sExt.trim();
                            }
                            if ((sValue = OiipwWin32NativeCalls.RegGetValue(key, subKey + "\\" + sExt, "")) == null || (sCommand = OiipwWin32NativeCalls.RegGetValue(key, subKey + "\\" + sValue + "\\shell\\open\\command", "")) == null) break block0;
                            if ((sCommand = OiipwWin32NativeCalls.expandEnvironmentStrings(sCommand)).indexOf("\"%1\"") == -1 && sCommand.indexOf("%1") == -1) {
                                sCommand = sCommand + " " + sFileName;
                                break;
                            }
                            sCommand = OiixFunctionOps.replaceStr(sCommand, "\"%1\"", sFileName);
                            sCommand = OiixFunctionOps.replaceStr(sCommand, "%1", sFileName);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
        }
        return sCommand;
    }

    public String modifyCmdLine(String cmdLine) {
        String retLine = cmdLine;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        String shellCmd = "cmd /c ";
        block0 : switch (curPlatGroup) {
            case -3: {
                switch (curPlatId) {
                    case 50: 
                    case 615: {
                        shellCmd = "command /c ";
                    }
                    case 208: 
                    case 233: 
                    case 912: {
                        String sCmdLine = cmdLine.trim();
                        if (sCmdLine.startsWith("\"") && sCmdLine.endsWith("\"")) {
                            sCmdLine = sCmdLine.substring(1, sCmdLine.length() - 1);
                            sCmdLine = sCmdLine.trim();
                        }
                        retLine = shellCmd + cmdLine;
                        break block0;
                    }
                }
                break;
            }
        }
        return retLine;
    }

    public void asyncExec(String cmdLine) throws IOException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                try {
                    new OiixSpawner().execute(cmdLine);
                    break;
                }
                catch (OiixSpawnException se) {
                    throw new IOException(se.getMessage());
                }
            }
            case -3: {
                OiipwWin32NativeCalls.asyncExec(cmdLine);
                break;
            }
        }
    }

    public boolean checkForErr(String input) {
        for (int i = 0; i < this.m_numKnownErr; ++i) {
            if (!this.m_errMsg[i].regionMatches(true, 0, input, 0, 30)) continue;
            return true;
        }
        return false;
    }

    public String getFileViewer(String sFileName) {
        String sViewer = null;
        String sCurPlat = OiixPlatform.getPlatformCommonName(OiixPlatform.getCurrentPlatform());
        if (sFileName.endsWith(this.S_EXTN_HTM) || sFileName.endsWith(this.S_EXTN_HTML)) {
            sViewer = sCurPlat.equalsIgnoreCase(OiixPlatform.getPlatformCommonName(453)) ? this.S_NETSCAPE : (sCurPlat.equalsIgnoreCase(OiixPlatform.getPlatformCommonName(46)) ? this.S_MOZILLA : null);
        } else if (sFileName.endsWith(this.S_EXTN_TXT)) {
            sViewer = sCurPlat.equalsIgnoreCase(OiixPlatform.getPlatformCommonName(453)) || sCurPlat.equalsIgnoreCase(OiixPlatform.getPlatformCommonName(46)) ? this.S_VIM : null;
        }
        return sViewer;
    }
}

