/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterwareInfo;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiipgVendorClusterwareInfo
extends OiipgClusterwareInfo {
    private String m_sLsnodesLoc = null;

    OiipgVendorClusterwareInfo() {
    }

    public boolean isCluster() {
        if (this.isVendorCluster()) {
            String lsnodesLoc;
            Version ver92 = Version.get92Version();
            this.m_sLsnodesLoc = lsnodesLoc = this.getClusterwareLocation();
            try {
                ClusterInfo clsInfo = new ClusterInfo(lsnodesLoc, ver92);
                this.m_nodeNames = clsInfo.getNodeNames();
                OiiolTextLogger.appendText("List of nodes returned by the clusterware:" + OiixFunctionOps.implodeList(this.m_nodeNames, ","), OiiolTextLogger.LOG_BASIC);
                this.m_localNodeName = clsInfo.getLocalNodeName();
                OiiolTextLogger.appendText("Local node returned by the clusterware:" + this.m_localNodeName, OiiolTextLogger.LOG_BASIC);
            }
            catch (ClusterInfoException ce) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1104", new String[]{ce.getMessage()}));
                OiiolTextLogger.appendException((Exception)((Object)ce));
                return false;
            }
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1108"));
            return true;
        }
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1107"));
        return false;
    }

    private boolean isVendorCluster() {
        boolean bCluster = false;
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (platGroup == -1) {
            bCluster = Cluster.isVendorCluster();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("Clusterware checking for vendor clusterware:" + bCluster);
            }
        } else if (platGroup == -3) {
            String mainKey = "HKEY_LOCAL_MACHINE";
            String subKey = "Software\\oracle\\osd9i";
            try {
                bCluster = OiipwWin32NativeCalls.RegKeyExists(mainKey, subKey);
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                    OiiolTextLogger.appendText("Clusterware checking registry:" + mainKey + "\\" + subKey + " for vendor clusterware:" + bCluster);
                }
            }
            catch (Exception e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
        return bCluster;
    }

    public String[] getNodeNames() {
        return this.m_nodeNames;
    }

    protected String getLocalNodeName() {
        return this.m_localNodeName;
    }

    protected String getVirtualHostName(String sNodeName) {
        String sVirtualHostName = null;
        Version ver92 = Version.get92Version();
        try {
            ClusterInfo clsInfo = new ClusterInfo(this.m_sLsnodesLoc, ver92);
            sVirtualHostName = clsInfo.getNodeVIP(sNodeName);
        }
        catch (ClusterInfoException ce) {
            OiiolTextLogger.appendException((Exception)((Object)ce));
        }
        return sVirtualHostName;
    }

    protected String getPrivateNodeName(String sNodeName) {
        String sPrivateNodeName = null;
        if (sNodeName != null) {
            try {
                sPrivateNodeName = ClusterInfo.getPrivateNodeName((String)sNodeName);
            }
            catch (ClusterInfoException e) {
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
        }
        return sPrivateNodeName;
    }

    protected String getClusterwareLocation() {
        String sOUILoc = null;
        String retString = null;
        if (System.getProperty("oracle.installer.oui_loc") != null) {
            retString = System.getProperty("oracle.installer.oui_loc") + File.separator + "bin";
        } else {
            sOUILoc = File.separator + "oui" + File.separator + "bin";
            retString = System.getProperty("oracle.installer.scratchPath") + sOUILoc;
        }
        return retString;
    }

    public static ClusterInfo getClusterInfo() throws ClusterInfoException {
        Version ver92 = Version.get92Version();
        String lsnodesLoc = new OiipgVendorClusterwareInfo().getClusterwareLocation();
        return new ClusterInfo(lsnodesLoc, ver92);
    }
}

