/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.osd.unix;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiipuReadOratab {
    public static String m_sOraTabLocation = OiipuReadOratab.initOratabLoc();
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 262144;

    private static String initOratabLoc() {
        String loc = "";
        switch (OiixPlatform.getCurrentPlatform()) {
            case 173: 
            case 421: 
            case 453: {
                loc = "/var/opt/oracle/oratab";
                break;
            }
            case 2: 
            case 87: 
            case 197: 
            case 211: 
            case 601: 
            case 610: 
            case 913: {
                loc = "/etc/oratab";
                break;
            }
            case 46: {
                loc = "/etc/oratab";
                break;
            }
            default: {
                loc = "/var/opt/oracle/oratab";
            }
        }
        return loc;
    }

    public static String getOratabLocation() {
        return m_sOraTabLocation;
    }

    public Vector getAllOracleHomes() throws FileNotFoundException, IOException {
        String oratabLine;
        FileInputStream fis = new FileInputStream(m_sOraTabLocation);
        BufferedInputStream bis = new BufferedInputStream(fis, 1024);
        Vector<String> homeValues = new Vector<String>();
        while ((oratabLine = this.readNextLine(bis)) != null) {
            String tmpVal = this.parseOraTabLine(oratabLine);
            if (tmpVal == null) continue;
            tmpVal = tmpVal.trim();
            boolean add = true;
            for (int i = 0; i < homeValues.size(); ++i) {
                String val = (String)homeValues.elementAt(i);
                if (!val.equals(tmpVal)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            homeValues.addElement(tmpVal);
        }
        bis.close();
        for (int i = 0; i < homeValues.size(); ++i) {
        }
        return homeValues;
    }

    String parseOraTabLine(String tabLine) {
        String retVal = null;
        if ((tabLine = tabLine.trim()).length() < 1) {
            return null;
        }
        if (tabLine.startsWith("#")) {
            return null;
        }
        int firstColon = tabLine.indexOf(58);
        if (firstColon == -1) {
            return null;
        }
        if (tabLine.length() < firstColon + 1) {
            return null;
        }
        int lastColon = tabLine.indexOf(":", firstColon + 1);
        if (lastColon == -1) {
            lastColon = tabLine.length();
        }
        retVal = tabLine.substring(firstColon + 1, lastColon);
        return retVal;
    }

    String readNextLine(BufferedInputStream bis) throws IOException {
        StringBuffer oratabBuf = new StringBuffer();
        boolean bLineEnd = false;
        while (!bLineEnd) {
            int ich = bis.read();
            char ch = (char)ich;
            if (ich == -1) break;
            if (ch == '\n' || ch == '\r') {
                bLineEnd = true;
                oratabBuf.append(' ');
                continue;
            }
            oratabBuf.append(ch);
        }
        if (oratabBuf.length() == 0) {
            return null;
        }
        return oratabBuf.toString();
    }

    public static void main(String[] args) {
        try {
            OiipuReadOratab rrgs = new OiipuReadOratab();
            Vector homes = rrgs.getAllOracleHomes();
            System.out.println("Homes FOUND HOME: " + homes.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

