/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.osd.unix;

import java.io.IOException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiipuUnixOps {
    private static String[] s_slVolList = null;

    public native int getUserId();

    public static native int chmod(String var0, int var1) throws OiilNativeException;

    public static native int chgrp(String var0, String var1);

    public static native int chown(String var0, String var1, String var2) throws OiilNativeException;

    public static native void asyncExec(String var0) throws IOException;

    public static native String getenv(String var0);

    public static native void setenv(String var0);

    public static String[] ssGetVolList() throws OiilNativeException {
        if (s_slVolList == null) {
            s_slVolList = OiipuUnixOps.ssGetVolumeList();
        }
        return s_slVolList;
    }

    public static native boolean ssAreInterfacesPrivate(String[] var0) throws OiilNativeException;

    public static native String[] ssGetNetworkInterfaceList() throws OiilNativeException;

    private static native String[] ssGetVolumeList() throws OiilNativeException;

    public static native int changeOwnerAndGroup(String var0, String var1, String var2) throws OiilNativeException;

    public static native int changePermission(String var0, int var1) throws OiilNativeException;

    public static native int getPermission(String var0) throws OiilNativeException;

    public static native int sysFunctionEnglish(String var0) throws OiilNativeException;

    public static native int sysFunction(String var0) throws OiilNativeException;

    public static native int ssMkDir(String var0, boolean var1, String var2, boolean var3, String var4) throws OiilNativeException;

    public static void loadNativeLib() {
        boolean bLibLocSpecified;
        String ouiLoc;
        String sFileName = OiipgBootstrap.getNativeLibraryFileName();
        String sLibraryName = OiipgBootstrap.getSharedLibraryName();
        String sLibPath = System.getProperty("oracle.installer.library_loc");
        if ((null == sLibPath || sLibPath.equals("")) && null != (ouiLoc = System.getProperty("oracle.installer.oui_loc")) && !ouiLoc.equals("")) {
            ouiLoc = OiixPathOps.getStandardForm(ouiLoc);
            sLibPath = OiixPathOps.concatPath(ouiLoc, "lib");
            sLibPath = OiixPathOps.concatPath(sLibPath, OiixPlatform.getCurrentPlatformDirectoryName());
        }
        boolean bl = bLibLocSpecified = sLibPath != null && !sLibPath.equals("");
        if (bLibLocSpecified) {
            try {
                sLibPath = OiixPathOps.getAbsolutePath(sLibPath);
                String toLoad = OiixPathOps.concatPath(sLibPath, sFileName);
                toLoad = OiixPathOps.getAbsolutePath(toLoad);
                System.load(toLoad);
            }
            catch (UnsatisfiedLinkError e) {
                bLibLocSpecified = false;
                e.printStackTrace();
            }
        }
        if (!bLibLocSpecified) {
            System.loadLibrary(sLibraryName);
        }
    }

    public static native String getCurrentWorkingDir() throws OiilNativeException;

    public static native int changeDir(String var0) throws OiilNativeException;

    public static native int createLinkFunction(String var0, String var1);

    public static native int touchFileFunction(String var0);

    public static native int executeMakeFile(String var0, String var1);

    public static native int deleteLink(String var0);

    public static native boolean linkExists(String var0) throws OiilNativeException;

    public static native boolean validLinkExists(String var0);

    public static native String[] getUnixGroups();

    public static native String ssgetCurrentGroupOfUserux(String var0);

    public static native int ssgetUidux();

    public static native String ssgetUidNameux();

    public static native String ssgetCurrentActiveUserGroupux(String var0);

    public static native long ssGetTotalPhysicalMemoryux();

    public static native long ssGetAvailablePhysicalMemoryux();

    public static void main(String[] args) {
        if (args.length < 1) {
            OiipuUnixOps.printUsage();
        } else {
            try {
                String command = args[0];
                if (command.equals("-df")) {
                    String[] volList = OiipuUnixOps.ssGetVolumeList();
                    for (int i = 0; i < volList.length; ++i) {
                        System.out.println("Volume : " + volList[i]);
                    }
                }
                if (command.equals("-spawn")) {
                    OiipuUnixOps.asyncExec(args[1]);
                } else if (command.equals("-getUserID")) {
                    System.out.println("UserID :: " + new OiipuUnixOps().getUserId());
                } else if (command.equals("-chmod")) {
                    OiipuUnixOps.chmod(args[1], new Integer(args[2]));
                } else if (command.equals("-chgrp")) {
                    OiipuUnixOps.chgrp(args[1], args[2]);
                } else {
                    OiipuUnixOps.printUsage();
                }
            }
            catch (Exception e) {
                System.err.println("Exception occurred ::");
                e.printStackTrace();
                OiipuUnixOps.printUsage();
            }
        }
        System.out.println(OiipuUnixOps.getenv("PATH"));
    }

    private static void printUsage() {
        System.out.println("Usage :: java oracle.sysman.oii.oiip.oiipu.OiipuUnixOps <operation> [<operation args>]");
        System.out.println("  where <operation> [<operation flags>] is one of :");
        System.out.println("    -spawn <Cmd line>");
        System.out.println("    -getUserID");
        System.out.println("    -chmod <filename> <permissions>");
        System.out.println("    -chgrp <filename> <group>");
    }

    static {
        OiipuUnixOps.loadNativeLib();
    }
}

